# Texture Viewer 

An image viewer for anyone related to computer graphics.

## Credits

### Texture Viewer Developers
- Felix Bruell
- Johannes Jendersie
- Maximilian Bason

### Icons
- App Icon made by [Smashicons](https://www.flaticon.com/authors/smashicons) from https://www.flaticon.com/
- Other Icons were taken from the Visual Studio Image Library

### Libraries
- libpng: png format [Website](http://www.libpng.org/pub/png/libpng.html)
- g-truc/gli: dds and ktx [Github](https://github.com/g-truc/gli)
- KhronosGroup/KTX-Software: ktx2 [Github](https://github.com/KhronosGroup/KTX-Software)
- Compressonator: block compression formats for dds/ktx [Github](https://github.com/GPUOpen-Tools/Compressonator)
- nothings/stb: bmp, jpg and hdr formats [Github](https://github.com/nothings/stb)
- tinyexr: exr format [Github](https://github.com/syoyo/tinyexr)
- sharpdx: c# directx wrapper [Website](http://sharpdx.org/)
- lunet-io/markdig: c# markdown processor [Github](https://github.com/lunet-io/markdig)
- zlib: compression library (used by libpng) [Website](https://www.zlib.net/)

### Algorithms
- Structural Similarity (SSIM): [Paper](https://www.cns.nyu.edu/pub/eero/wang03-reprint.pdf), [Website](https://ece.uwaterloo.ca/~z70wang/research/ssim/)
- Rapid, Detail-Preserving Image Downscaling: [Paper](https://www.gcc.tu-darmstadt.de/home/proj/dpid/index.en.jsp)

### Other
- Descriptions for luminance, luma and lightness inspired by: [Color FAQ](http://homepages.inf.ed.ac.uk/rbf/CVonline/LOCAL_COPIES/POYNTON1/ColorFAQ.html)

