/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer;

import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.VertexGeometry;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.GeometryProxy;

public abstract class VertexGeometryProxy
extends GeometryProxy {
    protected abstract void onVerticesFormatAndLengthChange(int var1, int var2);

    protected abstract void onVerticesVertexPositionChange(int var1, double var2, double var4, double var6);

    protected abstract void onVerticesVertexNormalChange(int var1, double var2, double var4, double var6);

    protected abstract void onVerticesVertexDiffuseColorChange(int var1, float var2, float var3, float var4, float var5);

    protected abstract void onVerticesVertexSpecularHighlightColorChange(int var1, float var2, float var3, float var4, float var5);

    protected abstract void onVerticesVertexTextureCoordinate0Change(int var1, float var2, float var3);

    protected abstract void onVerticesBeginChange();

    protected abstract void onVerticesEndChange();

    protected abstract void onVertexLowerBoundChange(int var1);

    protected abstract void onVertexUpperBoundChange(int var1);

    private void onVerticesChange(Vertex3d[] vertices) {
        if (vertices != null) {
            if (vertices.length > 0) {
                if (vertices[0] != null) {
                    int format = vertices[0].getFormat();
                    this.onVerticesFormatAndLengthChange(format, vertices.length);
                    this.onVerticesBeginChange();
                    for (int i = 0; i < vertices.length; ++i) {
                        Vertex3d vertex = vertices[i];
                        if (vertex.position != null) {
                            this.onVerticesVertexPositionChange(i, vertex.position.x, vertex.position.y, vertex.position.z);
                        }
                        if (vertex.normal != null) {
                            this.onVerticesVertexNormalChange(i, vertex.normal.x, vertex.normal.y, vertex.normal.z);
                        }
                        if (vertex.diffuseColor != null) {
                            this.onVerticesVertexDiffuseColorChange(i, vertex.diffuseColor.red, vertex.diffuseColor.green, vertex.diffuseColor.blue, vertex.diffuseColor.alpha);
                        }
                        if (vertex.specularHighlightColor != null) {
                            this.onVerticesVertexSpecularHighlightColorChange(i, vertex.specularHighlightColor.red, vertex.specularHighlightColor.green, vertex.specularHighlightColor.blue, vertex.specularHighlightColor.alpha);
                        }
                        if (vertex.textureCoordinate0 == null) continue;
                        this.onVerticesVertexTextureCoordinate0Change(i, vertex.textureCoordinate0.x, vertex.textureCoordinate0.y);
                    }
                    this.onVerticesEndChange();
                }
            } else {
                this.onVerticesFormatAndLengthChange(0, 0);
                this.onVerticesBeginChange();
                this.onVerticesEndChange();
            }
        } else {
            this.onVerticesFormatAndLengthChange(0, 0);
            this.onVerticesBeginChange();
            this.onVerticesEndChange();
        }
    }

    protected void changed(Property property, Object value) {
        if (property == VertexGeometry.VERTICES_PROPERTY) {
            this.onVerticesChange((Vertex3d[])value);
        } else if (property == VertexGeometry.VERTEX_LOWER_BOUND_PROPERTY) {
            this.onVertexLowerBoundChange((Integer)value);
        } else if (property == VertexGeometry.VERTEX_UPPER_BOUND_PROPERTY) {
            this.onVertexUpperBoundChange((Integer)value);
        } else {
            super.changed(property, value);
        }
    }
}

