/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer;

import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.TextureMap;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.ElementProxy;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;

public abstract class TextureMapProxy
extends ElementProxy {
    protected abstract void onImageChange(int[] var1, int var2, int var3);

    protected abstract void onFormatChange(int var1);

    private void onImageChange(Image image) {
        if (image != null) {
            ImageObserver io = new ImageObserver(){

                public boolean imageUpdate(Image image, int infoflags, int x, int y, int width, int height) {
                    return true;
                }
            };
            while (image.getWidth(io) == -1 || image.getWidth(io) == -1) {
                Thread.yield();
            }
            int width = image.getWidth(io);
            int height = image.getHeight(io);
            int[] pixels = new int[width * height];
            PixelGrabber pg = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("interrupted waiting for pixels");
            }
            if ((pg.getStatus() & 0x80) != 0) {
                throw new RuntimeException("image fetch aborted or errored");
            }
            this.onImageChange(pixels, width, height);
        } else {
            this.onImageChange(null, 0, 0);
        }
    }

    protected void changed(Property property, Object value) {
        if (property == TextureMap.IMAGE_PROPERTY) {
            this.onImageChange((Image)value);
        } else if (property == TextureMap.FORMAT_PROPERTY) {
            this.onFormatChange((Integer)value);
        } else {
            super.changed(property, value);
        }
    }
}

