/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer;

import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.FullscreenDisplayMode;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.HeavyweightOnscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.RenderTargetAdapter;
import java.awt.Canvas;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

public abstract class RenderCanvas
extends Canvas
implements ComponentListener,
HierarchyListener {
    private int m_nativeInstance;
    private HeavyweightOnscreenRenderTarget m_heavyweightOnscreenRenderTarget;

    protected abstract void createNativeInstance(RenderTargetAdapter var1);

    protected abstract void releaseNativeInstance();

    protected abstract void onOverlappedDisplayModeChange();

    protected abstract void onFullscreenDisplayModeChange(FullscreenDisplayMode var1);

    protected abstract boolean swapBuffers();

    protected RenderCanvas(HeavyweightOnscreenRenderTarget heavyweightOnscreenRenderTarget) {
        this.createNativeInstance(heavyweightOnscreenRenderTarget.getAdapter());
        this.m_heavyweightOnscreenRenderTarget = heavyweightOnscreenRenderTarget;
        this.addComponentListener(this);
        this.onSetVisibility(this.isShowing());
        try {
            this.addHierarchyListener(this);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        this.addKeyListener(new KeyAdapter(){});
    }

    protected void finalize() throws Throwable {
        this.releaseNativeInstance();
        super.finalize();
    }

    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        Container parent = this.getParent();
        if (parent != null) {
            parent.dispatchEvent(e);
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void addNotify() {
        super.addNotify();
        this.onSetVisibility(this.isShowing());
    }

    public void removeNotify() {
        super.removeNotify();
        this.onSetVisibility(this.isShowing());
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        this.m_heavyweightOnscreenRenderTarget.markDirty();
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.onSetVisibility(false);
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.m_heavyweightOnscreenRenderTarget.markSizeDirty();
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.onSetVisibility(true);
    }

    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        this.onSetVisibility(this.isShowing());
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    private void onSetVisibility(boolean b) {
        block0: {
            if (!b) break block0;
            this.m_heavyweightOnscreenRenderTarget.markSizeDirty();
        }
    }
}

