/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer;

import edu.cmu.cs.stage3.alice.scenegraph.renderer.DisplayMode;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.StandardDisplayMode;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.FullscreenDisplayMode;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.OnscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.RenderCanvas;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.Renderer;
import java.awt.Component;
import java.awt.Dimension;

public class HeavyweightOnscreenRenderTarget
extends OnscreenRenderTarget
implements edu.cmu.cs.stage3.alice.scenegraph.renderer.HeavyweightOnscreenRenderTarget {
    private DisplayMode m_displayMode = null;
    private RenderCanvas m_renderCanvas = null;
    private boolean m_isSizeDirty = true;

    protected HeavyweightOnscreenRenderTarget(Renderer renderer) {
        super(renderer);
        this.m_renderCanvas = renderer.createRenderCanvas(this);
    }

    public Component getAWTComponent() {
        return this.m_renderCanvas;
    }

    public void markSizeDirty() {
        this.m_isSizeDirty = true;
        this.markDirty();
    }

    public DisplayMode getDisplayMode() {
        return this.m_displayMode;
    }

    public void setDisplayMode(DisplayMode displayMode) {
        if (this.m_displayMode != displayMode) {
            this.m_displayMode = displayMode;
            if (this.m_displayMode == null) {
                displayMode = StandardDisplayMode.OVERLAPPED_WINDOW_MODE;
            }
            if (displayMode == StandardDisplayMode.OVERLAPPED_WINDOW_MODE) {
                this.m_renderCanvas.onOverlappedDisplayModeChange();
            } else if (displayMode == StandardDisplayMode.FULLSCREEN_MODE) {
                this.m_renderCanvas.onFullscreenDisplayModeChange(null);
            } else if (displayMode instanceof FullscreenDisplayMode) {
                this.m_renderCanvas.onFullscreenDisplayModeChange((FullscreenDisplayMode)displayMode);
            } else {
                throw new RuntimeException("unhandled value".concat(String.valueOf(String.valueOf(displayMode))));
            }
            this.markDirty();
        }
    }

    protected boolean isGoodToGo() {
        return super.isGoodToGo() && this.m_renderCanvas != null && this.m_renderCanvas.isShowing() && this.m_renderCanvas.isVisible();
    }

    public void commitAnyPendingChanges() {
        super.commitAnyPendingChanges();
        if (this.m_isSizeDirty) {
            Dimension size = this.m_renderCanvas.getSize();
            this.getAdapter().setDesiredSize(size.width, size.height);
            this.m_isSizeDirty = false;
        }
    }

    public void update() {
        if (this.isGoodToGo() && this.m_renderCanvas.swapBuffers()) {
            this.onUpdate();
        }
    }

    public Dimension getSize(Dimension rv) {
        super.getSize(rv);
        this.getAdapter().setDesiredSize(rv.width, rv.height);
        return rv;
    }
}

