/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer;

import edu.cmu.cs.stage3.alice.scenegraph.Element;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.AbstractProxyRenderer;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.ElementProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.Renderer;
import edu.cmu.cs.stage3.math.Sphere;
import java.util.Enumeration;
import java.util.Vector;
import javax.vecmath.Vector3d;

public abstract class GeometryProxy
extends ElementProxy {
    private static Vector s_changed = new Vector();

    protected abstract void onBoundChange(double var1, double var3, double var5, double var7);

    private Geometry getSceneGraphGeometry() {
        return (Geometry)this.getSceneGraphElement();
    }

    protected boolean listenToBoundChanges() {
        return ((Renderer)this.getRenderer()).requiresBoundListening();
    }

    public void initialize(Element sgElement, AbstractProxyRenderer renderer) {
        super.initialize(sgElement, renderer);
        if (this.listenToBoundChanges()) {
            this.onBoundChange();
        }
    }

    public void onBoundChange() {
        if (!s_changed.contains((Object)this)) {
            s_changed.addElement(this);
        }
    }

    static void updateBoundChanges() {
        if (s_changed.size() > 0) {
            Enumeration enumeration = s_changed.elements();
            while (enumeration.hasMoreElements()) {
                GeometryProxy geometryProxy = (GeometryProxy)((Object)enumeration.nextElement());
                Sphere sphere = geometryProxy.getSceneGraphGeometry().getBoundingSphere();
                double x = Double.NaN;
                double y = Double.NaN;
                double z = Double.NaN;
                double radius = Double.NaN;
                if (sphere != null) {
                    Vector3d center = sphere.getCenter();
                    if (center != null) {
                        x = center.x;
                        y = center.y;
                        z = center.z;
                    }
                    radius = sphere.getRadius();
                }
                geometryProxy.onBoundChange(x, y, z, radius);
            }
            s_changed.removeAllElements();
        }
    }
}

