/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer;

import edu.cmu.cs.stage3.alice.scenegraph.renderer.DisplayMode;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.DisplayDevice;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.FullscreenDisplayMode;

public abstract class DisplayDriver
implements edu.cmu.cs.stage3.alice.scenegraph.renderer.DisplayDriver {
    private int m_nativeInstance = 0;
    private DisplayMode[] m_displayModes = null;
    private edu.cmu.cs.stage3.alice.scenegraph.renderer.DisplayDevice[] m_displayDevices = null;

    protected abstract int getDisplayDeviceCount();

    protected abstract int getDisplayDeviceNativeInstanceAt(int var1);

    protected abstract int getFullscreenDisplayModeCount();

    protected abstract int getFullscreenDisplayModeNativeInstanceAt(int var1);

    public abstract String getDescription();

    public abstract String getName();

    protected abstract DisplayDevice createDisplayDevice(int var1);

    protected abstract FullscreenDisplayMode createFullscreenDisplayMode(int var1);

    protected DisplayDriver(int nativeInstance) {
        this.m_nativeInstance = nativeInstance;
    }

    public DisplayMode[] getDisplayModes() {
        if (this.m_displayModes == null) {
            int modeCount = this.getFullscreenDisplayModeCount();
            this.m_displayModes = new DisplayMode[modeCount];
            for (int i = 0; i < modeCount; ++i) {
                int modeID = this.getFullscreenDisplayModeNativeInstanceAt(i);
                this.m_displayModes[i] = this.createFullscreenDisplayMode(modeID);
            }
        }
        return this.m_displayModes;
    }

    public edu.cmu.cs.stage3.alice.scenegraph.renderer.DisplayDevice[] getDisplayDevices() {
        if (this.m_displayDevices == null) {
            int deviceCount = this.getDisplayDeviceCount();
            this.m_displayDevices = new DisplayDevice[deviceCount];
            for (int i = 0; i < deviceCount; ++i) {
                int deviceID = this.getDisplayDeviceNativeInstanceAt(i);
                this.m_displayDevices[i] = this.createDisplayDevice(deviceID);
            }
        }
        return this.m_displayDevices;
    }

    public edu.cmu.cs.stage3.alice.scenegraph.renderer.DisplayDevice getFirstDevice(boolean isHardwareAccelerated) {
        edu.cmu.cs.stage3.alice.scenegraph.renderer.DisplayDevice[] displayDevices = this.getDisplayDevices();
        for (int i = 0; i < displayDevices.length; ++i) {
            if (displayDevices[i].isHardwareAccelerated() != isHardwareAccelerated) continue;
            return displayDevices[i];
        }
        return null;
    }

    public DisplayMode getFirstMode(int width, int height, int depth, int refreshRate) {
        DisplayMode[] displayModes = this.getDisplayModes();
        for (int i = 0; i < displayModes.length; ++i) {
            if (displayModes[i].getWidth() != width || displayModes[i].getHeight() != height || displayModes[i].getDepth() != depth || refreshRate != -1 && refreshRate != displayModes[i].getRefreshRate()) continue;
            return displayModes[i];
        }
        return null;
    }

    public String toString() {
        return this.getDescription();
    }
}

