/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer;

import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.Element;
import edu.cmu.cs.stage3.alice.scenegraph.FillingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.ShadingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.TextureMap;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.ElementProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.TextureMapProxy;

public abstract class AppearanceProxy
extends ElementProxy {
    protected abstract void onAmbientColorChange(double var1, double var3, double var5, double var7);

    protected abstract void onDiffuseColorChange(double var1, double var3, double var5, double var7);

    protected abstract void onFillingStyleChange(int var1);

    protected abstract void onShadingStyleChange(int var1);

    protected abstract void onOpacityChange(double var1);

    protected abstract void onSpecularHighlightColorChange(double var1, double var3, double var5, double var7);

    protected abstract void onSpecularHighlightExponentChange(double var1);

    protected abstract void onEmissiveColorChange(double var1, double var3, double var5, double var7);

    protected abstract void onDiffuseColorMapChange(TextureMapProxy var1);

    protected abstract void onOpacityMapChange(TextureMapProxy var1);

    protected abstract void onEmissiveColorMapChange(TextureMapProxy var1);

    protected abstract void onSpecularHighlightColorMapChange(TextureMapProxy var1);

    protected abstract void onBumpMapChange(TextureMapProxy var1);

    protected abstract void onDetailMapChange(TextureMapProxy var1);

    protected void changed(Property property, Object value) {
        if (property == Appearance.AMBIENT_COLOR_PROPERTY) {
            Color color = (Color)value;
            if (color == null) {
                color = ((Appearance)this.getSceneGraphElement()).getDiffuseColor();
            }
            if (color != null) {
                this.onAmbientColorChange(color.red, color.green, color.blue, color.alpha);
            } else {
                this.onAmbientColorChange(0.0, 0.0, 0.0, 0.0);
            }
        } else if (property == Appearance.DIFFUSE_COLOR_PROPERTY) {
            Color color = (Color)value;
            if (color != null) {
                this.onDiffuseColorChange(color.red, color.green, color.blue, color.alpha);
            } else {
                this.onDiffuseColorChange(0.0, 0.0, 0.0, 0.0);
            }
            if (((Appearance)this.getSceneGraphElement()).getAmbientColor() == null) {
                this.changed(Appearance.AMBIENT_COLOR_PROPERTY, color);
            }
        } else if (property == Appearance.FILLING_STYLE_PROPERTY) {
            int i;
            if (value.equals(FillingStyle.SOLID)) {
                i = 4;
            } else if (value.equals(FillingStyle.WIREFRAME)) {
                i = 2;
            } else if (value.equals(FillingStyle.POINTS)) {
                i = 1;
            } else {
                throw new RuntimeException();
            }
            this.onFillingStyleChange(i);
        } else if (property == Appearance.SHADING_STYLE_PROPERTY) {
            int i;
            if (value == null || value.equals(ShadingStyle.NONE)) {
                i = 0;
            } else if (value.equals(ShadingStyle.FLAT)) {
                i = 1;
            } else if (value.equals(ShadingStyle.SMOOTH)) {
                i = 2;
            } else {
                throw new RuntimeException();
            }
            this.onShadingStyleChange(i);
        } else if (property == Appearance.OPACITY_PROPERTY) {
            this.onOpacityChange((Double)value);
        } else if (property == Appearance.SPECULAR_HIGHLIGHT_COLOR_PROPERTY) {
            Color color = (Color)value;
            if (color != null) {
                this.onSpecularHighlightColorChange(color.red, color.green, color.blue, color.alpha);
            } else {
                this.onSpecularHighlightColorChange(0.0, 0.0, 0.0, 0.0);
            }
        } else if (property == Appearance.SPECULAR_HIGHLIGHT_EXPONENT_PROPERTY) {
            this.onSpecularHighlightExponentChange((Double)value);
        } else if (property == Appearance.EMISSIVE_COLOR_PROPERTY) {
            Color color = (Color)value;
            if (color != null) {
                this.onEmissiveColorChange(color.red, color.green, color.blue, color.alpha);
            } else {
                this.onEmissiveColorChange(0.0, 0.0, 0.0, 0.0);
            }
        } else if (property == Appearance.DIFFUSE_COLOR_MAP_PROPERTY) {
            this.onDiffuseColorMapChange((TextureMapProxy)this.getProxyFor((Element)((TextureMap)value)));
        } else if (property == Appearance.OPACITY_MAP_PROPERTY) {
            this.onOpacityMapChange((TextureMapProxy)this.getProxyFor((Element)((TextureMap)value)));
        } else if (property == Appearance.EMISSIVE_COLOR_MAP_PROPERTY) {
            this.onEmissiveColorMapChange((TextureMapProxy)this.getProxyFor((Element)((TextureMap)value)));
        } else if (property == Appearance.SPECULAR_HIGHLIGHT_COLOR_MAP_PROPERTY) {
            this.onSpecularHighlightColorMapChange((TextureMapProxy)this.getProxyFor((Element)((TextureMap)value)));
        } else if (property == Appearance.BUMP_MAP_PROPERTY) {
            this.onBumpMapChange((TextureMapProxy)this.getProxyFor((Element)((TextureMap)value)));
        } else if (property == Appearance.DETAIL_MAP_PROPERTY) {
            this.onDetailMapChange((TextureMapProxy)this.getProxyFor((Element)((TextureMap)value)));
        } else {
            super.changed(property, value);
        }
    }
}

