/*
 * Decompiled with CFR 0.152.
 */
package ui;

import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.TextureMap;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Vector3;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3d;
import ui.Model;
import vrml.ImageData;
import vrml.VrmlAppearance;
import vrml.VrmlCoordinate;
import vrml.VrmlImageTexture;
import vrml.VrmlIndexedFaceSet;
import vrml.VrmlMaterial;
import vrml.VrmlNormal;
import vrml.VrmlObj;
import vrml.VrmlShape;
import vrml.VrmlTextureCoordinate;
import vrml.VrmlTransform;

public class VrmlConv {
    private static final String NAME_BODY = "a";
    private static final String NAME_SEPARATOR = "_";
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyz";
    private static final String FILE_ENCODING = "utf8";
    private static final String VRML_HEADER = "#VRML V2.0 utf8";
    private static final int VRML_SCALING = 100;
    private static final boolean COMPRESS = true;
    private static final String FILEBASE_IMAGE = "t";
    private static final String IMAGE_FORMAT = "jpg";
    private static final String FILEEXT_IMAGE = ".jpg";

    public static VrmlTransform toVrml(Model model, Vector images, long tm) {
        IndexedTriangleArray modelITA = model.modelITA;
        int[] indices = modelITA.getIndices();
        int count = indices.length / 3;
        int[] coordIndexes = new int[count * 4];
        int i = 0;
        int j = 0;
        while (i < count * 4) {
            coordIndexes[i] = indices[j++];
            coordIndexes[i + 2] = indices[j++];
            coordIndexes[i + 1] = indices[j++];
            coordIndexes[i + 3] = -1;
            i += 4;
        }
        Vertex3d[] vertices = modelITA.getVertices();
        Point3d[] coords = new Point3d[vertices.length];
        int i2 = 0;
        while (i2 < vertices.length) {
            coords[i2] = new Point3d(vertices[i2].position);
            coords[i2].z = -coords[i2].z;
            coords[i2].scale(100.0);
            ++i2;
        }
        Vector<Vector3d> normals = new Vector<Vector3d>();
        int[] normalIndexes = new int[coordIndexes.length];
        int i3 = 0;
        while (i3 < coordIndexes.length) {
            if (coordIndexes[i3] == -1) {
                normalIndexes[i3] = -1;
            } else {
                Vector3d normal = vertices[coordIndexes[i3]].normal;
                int pos = normals.indexOf(normal);
                if (pos == -1) {
                    normals.add(normal);
                    normalIndexes[i3] = normals.size() - 1;
                } else {
                    normalIndexes[i3] = pos;
                }
            }
            ++i3;
        }
        Vector<Vector3d> revised_normals = new Vector<Vector3d>();
        int i4 = 0;
        while (i4 < normals.size()) {
            Vector3d normal = (Vector3d)normals.get(i4);
            normal = new Vector3d(normal);
            normal.z = -normal.z;
            revised_normals.add(normal);
            ++i4;
        }
        normals = revised_normals;
        Vector<TexCoord2f> texCoords = new Vector<TexCoord2f>();
        int[] texCoordIndexes = new int[coordIndexes.length];
        int i5 = 0;
        while (i5 < coordIndexes.length) {
            if (coordIndexes[i5] == -1) {
                texCoordIndexes[i5] = -1;
            } else {
                TexCoord2f texCoord = vertices[coordIndexes[i5]].textureCoordinate0;
                int pos = texCoords.indexOf(texCoord);
                if (pos == -1) {
                    texCoords.add(texCoord);
                    texCoordIndexes[i5] = texCoords.size() - 1;
                } else {
                    texCoordIndexes[i5] = pos;
                }
            }
            ++i5;
        }
        VrmlCoordinate vcoord = new VrmlCoordinate(coords);
        VrmlNormal vnorm = new VrmlNormal(normals.toArray(new Vector3d[normals.size()]));
        VrmlTextureCoordinate vtexcoord = new VrmlTextureCoordinate(texCoords.toArray(new TexCoord2f[texCoords.size()]));
        VrmlIndexedFaceSet geo = new VrmlIndexedFaceSet(vcoord, vnorm, vtexcoord, coordIndexes, normalIndexes, texCoordIndexes);
        VrmlImageTexture imageTexture = null;
        TextureMap textureMap = model.modelTexture;
        if (textureMap != null) {
            Image image = textureMap.getImage();
            BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
            Graphics2D g = bi.createGraphics();
            g.drawImage(image, 0, 0, null);
            String filename = VrmlConv.addImageData(bi, images, tm);
            imageTexture = new VrmlImageTexture();
            imageTexture.setUrl(filename);
        }
        VrmlMaterial mater = new VrmlMaterial();
        Appearance modelAppearance = model.modelAppearance;
        Color color = modelAppearance.getDiffuseColor();
        mater.setDiffuseColor((double)color.getRed(), (double)color.getGreen(), (double)color.getBlue());
        color = modelAppearance.getSpecularHighlightColor();
        mater.setSpecularColor((double)color.getRed(), (double)color.getGreen(), (double)color.getBlue());
        color = modelAppearance.getEmissiveColor();
        mater.setEmissiveColor((double)color.getRed(), (double)color.getGreen(), (double)color.getBlue());
        VrmlAppearance appear = new VrmlAppearance(mater, imageTexture);
        VrmlShape shape = new VrmlShape(appear, geo);
        VrmlTransform trans = new VrmlTransform();
        Transformable modelVehicle = model.modelVehicle;
        Matrix44 matrix = modelVehicle.getTransformation(null);
        Vector3 pos = matrix.getPosition();
        pos.scale(100.0);
        pos.z = -pos.z;
        trans.setTranslation(new double[]{pos.x, pos.y, pos.z});
        AxisAngle4d ax = VrmlConv.calcRotationRight(matrix);
        trans.setRotation(new double[]{ax.x, ax.y, ax.z, ax.angle});
        trans.appendChild((VrmlObj)shape);
        int i6 = 0;
        while (i6 < model.childrenModels.size()) {
            Model child = (Model)model.childrenModels.get(i6);
            VrmlTransform childTrans = VrmlConv.toVrml(child, images, tm);
            trans.appendChild((VrmlObj)childTrans);
            ++i6;
        }
        return trans;
    }

    public static boolean saveToVrml(Model model, String dir, String filename) {
        Vector images = new Vector();
        long tm = System.currentTimeMillis();
        VrmlTransform trans = VrmlConv.toVrml(model, images, tm);
        int i = 0;
        while (i < images.size()) {
            ImageData id = (ImageData)images.get(i);
            if (!VrmlConv.saveImage(id.getImage(), dir + id.getFilename())) {
                return false;
            }
            ++i;
        }
        VrmlConv.setName(trans);
        return VrmlConv.saveVrml((VrmlObj)trans, dir + filename);
    }

    public static boolean saveVrml(VrmlObj obj, String filename) {
        boolean result = false;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, FILE_ENCODING));
            PrintWriter pw = new PrintWriter(bw);
            pw.println(VRML_HEADER);
            pw.println();
            obj.outputVrml(pw, "");
            pw.flush();
            result = true;
        }
        catch (Exception e) {
            System.out.println("Error in VrmlConv.saveVrml()" + e.getMessage());
            e.printStackTrace();
            result = false;
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return result;
    }

    private static AxisAngle4d calcRotationRight(Matrix44 matrix) {
        Matrix44 delta = matrix;
        double k1 = delta.getItem(1, 2) - delta.getItem(2, 1);
        double k2 = delta.getItem(2, 0) - delta.getItem(0, 2);
        double k3 = delta.getItem(0, 1) - delta.getItem(1, 0);
        double base = Math.sqrt(k1 * k1 + k2 * k2 + k3 * k3);
        double theta = Math.acos((delta.getItem(0, 0) + delta.getItem(1, 1) + delta.getItem(2, 2) - 1.0) / 2.0);
        if (base != 0.0 && !Double.isNaN(theta) && theta != 0.0) {
            AxisAngle4d ax = new AxisAngle4d(k1 / base, k2 / base, k3 / base, theta);
            Quat4d quat = new Quat4d();
            quat.set(ax);
            quat.w = -quat.w;
            ax.set(quat);
            ax.z = -ax.z;
            return ax;
        }
        return new AxisAngle4d(0.0, 0.0, 0.0, 0.0);
    }

    private static String addImageData(BufferedImage bi, Vector vector, long tm) {
        String filename = FILEBASE_IMAGE + tm + vector.size() + FILEEXT_IMAGE;
        vector.add(new ImageData(filename, bi));
        return filename;
    }

    private static void setName(VrmlTransform trans) {
        String name = trans.getName();
        if (name == null || name.equals("")) {
            trans.setName(NAME_BODY);
            name = NAME_BODY;
        }
        VrmlObj[] children = trans.getChildren();
        int i = 0;
        int index = 0;
        while (i < children.length) {
            if (children[i] instanceof VrmlTransform) {
                children[i].setName(VrmlConv.makeName(name, index++));
                VrmlConv.setName((VrmlTransform)children[i]);
            }
            ++i;
        }
    }

    private static boolean saveImage(BufferedImage image, String filename) {
        boolean result = false;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            boolean ret = ImageIO.write((RenderedImage)image, IMAGE_FORMAT, bos);
            bos.flush();
            result = true;
        }
        catch (Exception e) {
            System.out.println("Error in VrmlConv.saveImage()" + e.getMessage());
            result = false;
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return result;
    }

    private static String makeName(String parent, int index) {
        String name = "";
        int radix = ALPHABET.length();
        do {
            name = ALPHABET.charAt(index % radix) + name;
        } while ((index /= radix) > 0);
        if (parent == null) {
            parent = "";
        }
        return parent + NAME_SEPARATOR + name;
    }
}

