/*
 * Decompiled with CFR 0.152.
 */
package ui;

import edu.cmu.cs.stage3.math.Vector3;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.util.Vector;
import javax.vecmath.Vector3d;
import ui.JaliceTeddy;

public class Util {
    public static Vector3 rotate(Vector3 v, double angle, Vector3 normal) {
        normal = Vector3.normalizeV((Vector3d)normal);
        Vector3 n1 = Vector3.crossProduct((Vector3d)normal, (Vector3d)v);
        Vector3 n0 = Vector3.crossProduct((Vector3d)n1, (Vector3d)normal);
        Vector3 dz = Vector3.subtract((Vector3d)v, (Vector3d)n0);
        Vector3 n = Vector3.add((Vector3d)Vector3.multiply((Vector3d)n0, (double)Math.cos(Math.PI * angle / 180.0)), (Vector3d)Vector3.multiply((Vector3d)n1, (double)Math.sin(Math.PI * angle / 180.0)));
        return Vector3.add((Vector3d)n, (Vector3d)dz);
    }

    public static Vector appendVector(Vector vector0, Vector vector1) {
        int size = vector1.size();
        int i = 0;
        while (i < size) {
            vector0.addElement(vector1.elementAt(i));
            ++i;
        }
        return vector0;
    }

    public static Image duplicateImage(Image source_image) {
        int width = source_image.getWidth(null);
        int height = source_image.getHeight(null);
        Image new_image = JaliceTeddy.jaliceFrame.createImage(width, height);
        Graphics g = new_image.getGraphics();
        g.drawImage(source_image, 0, 0, null);
        g.dispose();
        return new_image;
    }

    public static Vector reverseVector(Vector vector) {
        Vector new_vector = new Vector();
        int size = vector.size();
        int i = 0;
        while (i < size) {
            new_vector.addElement(vector.elementAt(size - i - 1));
            ++i;
        }
        return new_vector;
    }

    public static Vector intersectionVector(Vector a, Vector b) {
        Vector new_vector = new Vector();
        int i = 0;
        while (i < b.size()) {
            if (a.contains(b.elementAt(i))) {
                new_vector.addElement(b.elementAt(i));
            }
            ++i;
        }
        return new_vector;
    }

    public static double get_stroke_length(Vector stroke) {
        double l = 0.0;
        Point p = (Point)stroke.elementAt(0);
        int i = 1;
        while (i < stroke.size()) {
            Point q = (Point)stroke.elementAt(i);
            l += Math.sqrt((q.x - p.x) * (q.x - p.x) + (q.y - p.y) * (q.y - p.y));
            p = q;
            ++i;
        }
        return l;
    }

    public static Vector duplicateVector(Vector vector) {
        return (Vector)vector.clone();
    }

    public static Vector connectVector(Vector vector0, Vector vector1) {
        Vector new_vector = Util.duplicateVector(vector0);
        int size = vector1.size();
        int i = 0;
        while (i < size) {
            new_vector.addElement(vector1.elementAt(i));
            ++i;
        }
        return new_vector;
    }

    public static boolean equivalentVector(Vector v0, Vector v1) {
        if (v0.size() != v1.size()) {
            return false;
        }
        int i = 0;
        while (i < v0.size()) {
            Object a = v0.elementAt(i);
            if (!v1.contains(a)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int mod(int n, int m) {
        while (n < 0 || n >= m) {
            if (n >= m) {
                n -= m;
            }
            if (n >= 0) continue;
            n += m;
        }
        return n;
    }

    public static double signedAngle180(Vector3 v0, Vector3 v1, Vector3 normal) {
        double cos = Vector3.dotProduct((Vector3d)v0, (Vector3d)v1) / (v0.getLength() * v1.getLength());
        double angle = 180.0 * Math.acos(cos) / Math.PI;
        Vector3 n = Vector3.crossProduct((Vector3d)v0, (Vector3d)v1);
        if (Vector3.dotProduct((Vector3d)n, (Vector3d)normal) > 0.0) {
            return angle;
        }
        return -angle;
    }

    public static double angle180(Vector3 v0, Vector3 v1) {
        double cos = Vector3.dotProduct((Vector3d)v0, (Vector3d)v1) / (v0.getLength() * v1.getLength());
        double angle = 180.0 * Math.acos(cos) / Math.PI;
        return angle;
    }

    public static boolean isSubsetVector(Vector a, Vector b) {
        int i = 0;
        while (i < a.size()) {
            if (!b.contains(a.elementAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void printVector(Vector vector) {
        int size = vector.size();
        int i = 0;
        while (i < size) {
            System.out.print("," + vector.elementAt(i));
            ++i;
        }
        System.out.println("");
    }
}

