/*
 * Decompiled with CFR 0.152.
 */
package ui;

import edu.cmu.cs.stage3.math.Vector3;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.vecmath.Vector3d;
import ui.JaliceTeddy;
import ui.Model;
import ui.PlaySound;
import ui.SyncEvent;

public class ToolPanel
extends Panel
implements MouseListener,
SyncEvent {
    public static int current_brush;
    public static int prev_brush;
    private JaliceTeddy jaliceTeddy;
    static ToolPanel toolPanel;
    public static final int CHISEL = 0;
    public static final int BRUSH = 1;
    public static final int FLOOD = 2;
    public static final int DUNK = 3;
    public static final int EYEDROP = 4;
    public static final int LASER = 5;
    public static final int UNDO = 6;
    public static final int CAMERA = 7;
    public static final int END = 8;
    private final Vector3[][] preset_orientation = new Vector3[][]{{new Vector3(0.0, 0.0, 1.0), new Vector3(0.0, 1.0, 0.0)}, {new Vector3(-1.0, 0.0, 0.0), new Vector3(0.0, 1.0, 0.0)}, {new Vector3(0.0, 0.0, -1.0), new Vector3(0.0, 1.0, 0.0)}, {new Vector3(1.0, 0.0, 0.0), new Vector3(0.0, 1.0, 0.0)}, {new Vector3(0.0, -1.0, 0.0), new Vector3(0.0, 0.0, 1.0)}, {new Vector3(0.0, 1.0, 0.0), new Vector3(0.0, 0.0, -1.0)}, {new Vector3(0.0, 0.0, 1.0), new Vector3(0.0, 1.0, 0.0)}};
    Image buffered_image;
    Cursor[] cursors;
    public static Cursor zoomCursor;
    private boolean[] button_pressed = new boolean[8];
    private int startX;
    public static String[] sounds;
    public Image zoomarrow;
    Image image;

    protected void paint_image(Graphics g) {
        if (this.image != null) {
            int imageWidth = this.image.getWidth(this);
            int imageHeight = this.image.getHeight(this);
            g.drawImage(this.image, 0, 0, imageWidth, imageHeight, this);
        }
    }

    public void processEvent(Object object) {
        MouseEvent event = (MouseEvent)object;
        if (event.getID() == 501) {
            this.mousePressed_main(event);
        } else if (event.getID() == 502) {
            this.mouseReleased_main(event);
        }
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        JaliceTeddy.jaliceFrame.enqueueEvent(this, event);
    }

    public void paint_main(Graphics g) {
        g.setColor(Color.gray);
        int i = 0;
        while (i < 8) {
            if (this.button_pressed[i]) {
                g.fill3DRect(i * 50, 0, 50, 50, false);
            } else {
                g.fill3DRect(i * 50, 0, 50, 50, true);
            }
            ++i;
        }
        this.paint_image(g);
    }

    public void mousePressed_main(MouseEvent event) {
        this.startX = event.getX();
        int n = this.startX / 50;
        if (n == 0) {
            if (current_brush == 0) {
                return;
            }
            this.jaliceTeddy.stop_painter();
            this.set_brush(n);
            this.repaint();
        } else if (n <= 5) {
            boolean success;
            if (current_brush == 0 && !(success = this.jaliceTeddy.start_painter())) {
                return;
            }
            if (current_brush != 4) {
                prev_brush = current_brush;
            }
            if (n != current_brush && (current_brush == 1 || current_brush == 5)) {
                this.jaliceTeddy.painter.flush_strokes();
            }
            this.set_brush(n);
        } else if (n == 7) {
            PlaySound.play("camera.wav");
            this.button_pressed[n] = true;
            this.repaint();
        } else if (n == 6) {
            if (!this.jaliceTeddy.undoable()) {
                return;
            }
            PlaySound.play("undo.wav");
            this.jaliceTeddy.undo();
            this.button_pressed[n] = true;
            this.repaint();
        }
    }

    ToolPanel(JaliceTeddy jaliceTeddy) {
        this.jaliceTeddy = jaliceTeddy;
        toolPanel = this;
        this.image = this.loadImage("images\\tools.gif");
        this.addMouseListener(this);
        this.button_pressed[1] = true;
        this.init_cursors();
    }

    public void mouseReleased(MouseEvent event) {
        JaliceTeddy.jaliceFrame.enqueueEvent(this, event);
    }

    public void paint(Graphics g) {
        if (this.buffered_image == null) {
            this.buffered_image = this.createImage(this.image.getWidth(null), this.image.getHeight(null));
        }
        Graphics bg = this.buffered_image.getGraphics();
        this.paint_main(bg);
        bg.dispose();
        g.drawImage(this.buffered_image, 0, 0, null);
        super.paint(g);
    }

    public void mouseReleased_main(MouseEvent event) {
        int n = this.startX / 50;
        if (n == 6) {
            this.button_pressed[n] = false;
        } else if (n == 7) {
            this.button_pressed[n] = false;
            this.camera();
            this.repaint();
        }
    }

    protected Image loadImage(String pathname) {
        Image image = this.getToolkit().getImage(pathname);
        if (image != null) {
            MediaTracker mt = new MediaTracker(this);
            try {
                mt.addImage(image, 0);
                mt.waitForAll();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        return image;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void init_cursors() {
        this.cursors = new Cursor[6];
        Point[] hotSpots = new Point[]{new Point(4, 26), new Point(6, 27), new Point(8, 31), new Point(6, 27), new Point(1, 31)};
        Dimension d = Toolkit.getDefaultToolkit().getBestCursorSize(50, 50);
        this.cursors[0] = Cursor.getDefaultCursor();
        int i = 1;
        while (i <= 5) {
            Image cursor_image = this.loadImage("images\\cursor" + (i - 1) + ".gif");
            Point hotSpot = hotSpots[i - 1];
            this.cursors[i] = Toolkit.getDefaultToolkit().createCustomCursor(cursor_image, hotSpot, "");
            ++i;
        }
        Image cursor_image = this.loadImage("images\\zoom.gif");
        Point hotSpot = new Point(15, 15);
        zoomCursor = Toolkit.getDefaultToolkit().createCustomCursor(cursor_image, hotSpot, "");
    }

    static {
        sounds = new String[]{"lock.wav", "click.wav", "cyu.wav", "bloop.wav", "piro.wav", "laser.wav"};
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 50);
    }

    private boolean equal_orientation(Vector3[] a, Vector3[] b) {
        return a[0].x == b[0].x && a[0].y == b[0].y && a[0].z == b[0].z && a[1].x == b[1].x && a[1].y == b[1].y && a[1].z == b[1].z;
    }

    public void set_brush(int brush) {
        PlaySound.play(sounds[brush]);
        current_brush = brush;
        int i = 0;
        while (i <= 5) {
            this.button_pressed[i] = i == current_brush;
            ++i;
        }
        JaliceTeddy.jaliceFrame.setCursor(this.cursors[current_brush]);
        this.repaint();
    }

    public void enableUndo() {
        this.button_pressed[6] = false;
        this.repaint();
    }

    public void disableUndo() {
        this.button_pressed[6] = true;
        this.repaint();
    }

    public void camera() {
        if (this.jaliceTeddy.painting) {
            this.jaliceTeddy.painter.flush_strokes();
            this.jaliceTeddy.painter.recover_permanent_texturemap();
        }
        Model model = (Model)JaliceTeddy.models.elementAt(0);
        Vector3[] current_orientation = model.modelVehicle.getOrientation(null);
        Vector3[] target_orientation = new Vector3[]{new Vector3(0.0, 0.0, 1.0), new Vector3(0.0, 1.0, 0.0)};
        int i = 0;
        while (i < 6) {
            if (this.equal_orientation(this.preset_orientation[i], current_orientation)) {
                target_orientation = this.preset_orientation[i + 1];
                break;
            }
            ++i;
        }
        model.modelVehicle.setOrientation((Vector3d)target_orientation[0], (Vector3d)target_orientation[1], null);
        if (this.jaliceTeddy.painting) {
            this.jaliceTeddy.painter.store_permanent_modelVertices();
            this.jaliceTeddy.painter.render_temporary_texturemap();
            this.jaliceTeddy.painter.associate_temporary_texturemap();
        }
    }
}

