/*
 * Decompiled with CFR 0.152.
 */
package ui;

import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.FillingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.ShadingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.math.Vector3;
import java.util.Vector;
import javax.vecmath.Vector3d;
import ui.Model;
import ui.Util;

public class SurfaceLine {
    Model model;
    Vector face_indices;
    Vector positions;
    Vector normals;
    Color color;
    public static final Color RED = Color.RED;
    public static final Color GREEN = new Color(0.1, 0.6, 0.2);
    Vector3 center = null;
    Visual lineVisual;
    int size;
    public final int DIV = 8;
    public final double RADIUS = 0.014;
    public final double WIDTH = 0.01;

    public void addPoint(Vector3 pos, int n) {
        this.positions.addElement(pos);
        this.face_indices.addElement(new Integer(n));
    }

    public void addPoint(Vector3 pos, Vector3 normal) {
        this.positions.addElement(pos);
        this.normals.addElement(normal);
    }

    public Visual lineVisual() {
        Vector3 vec1;
        Vector3 p2;
        Vector3 up;
        this.lineVisual = new Visual();
        this.size = this.positions.size() - 1;
        Vector total_vertices = new Vector();
        Vector<Integer> total_indices = new Vector<Integer>();
        Vector3 p0 = this.getPosition(0);
        Vector3 p1 = this.getPosition(1);
        Vector3 vec0 = Vector3.subtract((Vector3d)p1, (Vector3d)p0);
        if (Vector3.crossProduct((Vector3d)vec0, (Vector3d)(up = Vector3.X_AXIS)).getLength() == 0.0) {
            up = Vector3.Y_AXIS;
        }
        Vector3 cross0 = Vector3.crossProduct((Vector3d)vec0, (Vector3d)up);
        cross0.normalize();
        Vector3 cross1 = Vector3.crossProduct((Vector3d)vec0, (Vector3d)cross0);
        cross1.normalize();
        this.add_ring(p0, cross0, cross1, total_vertices);
        int i = 1;
        while (i < this.size) {
            p0 = this.getPosition(i - 1);
            p1 = this.getPosition(i);
            p2 = this.getPosition(i + 1);
            vec0 = Vector3.subtract((Vector3d)p1, (Vector3d)p0);
            vec1 = Vector3.subtract((Vector3d)p2, (Vector3d)p1);
            cross1 = Vector3.add((Vector3d)Vector3.crossProduct((Vector3d)vec0, (Vector3d)cross0), (Vector3d)Vector3.crossProduct((Vector3d)vec1, (Vector3d)cross0));
            cross1.normalize();
            cross0 = Vector3.add((Vector3d)Vector3.crossProduct((Vector3d)cross1, (Vector3d)vec0), (Vector3d)Vector3.crossProduct((Vector3d)cross1, (Vector3d)vec1));
            cross0.normalize();
            this.add_ring(p1, cross0, cross1, total_vertices);
            ++i;
        }
        p0 = this.getPosition(this.size - 2);
        p1 = this.getPosition(this.size - 1);
        p2 = this.getPosition(this.size);
        vec1 = Vector3.subtract((Vector3d)p2, (Vector3d)p1);
        if (vec1.x == 0.0 && vec1.y == 0.0 && vec1.z == 0.0) {
            System.out.println("isNaN in SurfaceLine ");
            vec1 = Vector3.subtract((Vector3d)p2, (Vector3d)p0);
        }
        cross1 = Vector3.crossProduct((Vector3d)vec1, (Vector3d)cross0);
        cross1.normalize();
        cross0 = Vector3.crossProduct((Vector3d)cross1, (Vector3d)vec1);
        cross0.normalize();
        this.add_ring(p2, cross0, cross1, total_vertices);
        i = 0;
        while (i < this.size) {
            int j = 0;
            while (j < 8) {
                total_indices.addElement(new Integer(i * 8 + Util.mod(j, 8)));
                total_indices.addElement(new Integer(i * 8 + Util.mod(j + 1, 8)));
                total_indices.addElement(new Integer((i + 1) * 8 + Util.mod(j, 8)));
                total_indices.addElement(new Integer(i * 8 + Util.mod(j + 1, 8)));
                total_indices.addElement(new Integer((i + 1) * 8 + Util.mod(j + 1, 8)));
                total_indices.addElement(new Integer((i + 1) * 8 + Util.mod(j, 8)));
                ++j;
            }
            ++i;
        }
        Vertex3d[] lineVertices = new Vertex3d[total_vertices.size()];
        int[] lineIndices = new int[total_indices.size()];
        int i2 = 0;
        while (i2 < total_vertices.size()) {
            lineVertices[i2] = (Vertex3d)total_vertices.elementAt(i2);
            ++i2;
        }
        i2 = 0;
        while (i2 < total_indices.size()) {
            lineIndices[i2] = (Integer)total_indices.elementAt(i2);
            ++i2;
        }
        IndexedTriangleArray lineArray = new IndexedTriangleArray();
        lineArray.setVertices(lineVertices);
        lineArray.setIndices(lineIndices);
        this.lineVisual.setGeometry((Geometry)lineArray);
        Appearance lineAppearance = new Appearance();
        this.lineVisual.setFrontFacingAppearance(lineAppearance);
        lineAppearance.setAmbientColor(this.color);
        lineAppearance.setEmissiveColor(this.color);
        lineAppearance.setDiffuseColor(this.color);
        lineAppearance.setShadingStyle(ShadingStyle.SMOOTH);
        lineAppearance.setFillingStyle(FillingStyle.SOLID);
        return this.lineVisual;
    }

    public void add_ring(Vector3 p, Vector3 cross0, Vector3 cross1, Vector vertices) {
        int j = 0;
        while (j < 8) {
            double angle = Math.PI * 2 * (double)j / 8.0;
            double x = Math.cos(angle);
            double y = Math.sin(angle);
            Vector3 normal = Vector3.add((Vector3d)Vector3.multiply((Vector3d)cross0, (double)x), (Vector3d)Vector3.multiply((Vector3d)cross1, (double)y));
            Vector3 v0 = Vector3.add((Vector3d)p, (Vector3d)Vector3.multiply((Vector3d)normal, (double)0.014));
            vertices.addElement(this.createVertex(v0, normal));
            ++j;
        }
    }

    public SurfaceLine(Model model, Color color) {
        this.model = model;
        this.face_indices = new Vector();
        this.positions = new Vector();
        this.normals = new Vector();
        this.color = color;
    }

    public Vector3 getCenter() {
        this.center = new Vector3();
        double total_length = 0.0;
        Vector3 prev = this.getPosition(this.size - 1);
        int i = 0;
        while (i < this.size) {
            Vector3 next = this.getPosition(i);
            double l = Vector3.subtract((Vector3d)next, (Vector3d)prev).getLength();
            Vector3 v = Vector3.multiply((Vector3d)Vector3.add((Vector3d)next, (Vector3d)prev), (double)0.5);
            this.center = Vector3.add((Vector3d)this.center, (Vector3d)Vector3.multiply((Vector3d)v, (double)l));
            total_length += l;
            prev = next;
            ++i;
        }
        this.center = Vector3.multiply((Vector3d)this.center, (double)(1.0 / total_length));
        return this.center;
    }

    public Vector3 getNormal(int i) {
        return (Vector3)this.normals.elementAt(i);
    }

    public Vector3 getNormal() {
        if (this.center == null) {
            this.center = this.getCenter();
        }
        Vector3 normal = new Vector3();
        Vector3 prev = this.getPosition(this.size - 1);
        int i = 0;
        while (i < this.size) {
            Vector3 next = this.getPosition(i);
            Vector3 vec0 = Vector3.subtract((Vector3d)prev, (Vector3d)this.center);
            Vector3 vec1 = Vector3.subtract((Vector3d)next, (Vector3d)this.center);
            normal = Vector3.add((Vector3d)normal, (Vector3d)Vector3.crossProduct((Vector3d)vec1, (Vector3d)vec0));
            prev = next;
            ++i;
        }
        normal.normalize();
        return normal;
    }

    public Vertex3d createVertex(Vector3 v, Vector3 normal) {
        Vertex3d vertex = new Vertex3d(19);
        vertex.position.set(v.x, v.y, v.z);
        vertex.normal.set(normal.x, normal.y, normal.z);
        return vertex;
    }

    public Vector3 getPosition(int i) {
        return (Vector3)this.positions.elementAt(i);
    }

    public void delete() {
        this.lineVisual.setParent(null);
    }

    public int getFaceIndex(int i) {
        return (Integer)this.face_indices.elementAt(i);
    }
}

