/*
 * Decompiled with CFR 0.152.
 */
package ui;

import edu.cmu.cs.stage3.alice.scenegraph.renderer.OffscreenRenderTarget;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import ui.Buttons;
import ui.JaliceFrame;
import ui.JaliceTeddy;

public class Snapshot
extends Frame {
    TextField text2 = new TextField("128", 8);
    TextField text3 = new TextField("128", 8);
    TextField text5 = new TextField("image", 8);
    Label label2 = new Label("Width  (pixels)");
    Label label3 = new Label("Height (pixels)");
    Label label5 = new Label("File Name");

    public Snapshot() {
        this.setWidgets();
        ((Component)this).setSize(250, 130);
        this.show();
    }

    public void go() {
        JaliceFrame jaliceFrame = JaliceTeddy.jaliceFrame;
        int WIDTH = new Integer(this.text2.getText());
        int HEIGHT = new Integer(this.text3.getText());
        String filename = this.text5.getText();
        jaliceFrame.renderTarget.setUpdateIsAutomatic(false);
        OffscreenRenderTarget offscreenRenderTarget = jaliceFrame.renderer.createOffscreenRenderTarget();
        offscreenRenderTarget.addCamera(jaliceFrame.camera);
        offscreenRenderTarget.setSize(WIDTH, HEIGHT);
        offscreenRenderTarget.clearAndRenderOffscreen();
        Image offscreenImage = offscreenRenderTarget.getOffscreenImage();
        BufferedImage bufferedImage = new BufferedImage(WIDTH, HEIGHT, 1);
        Graphics g = bufferedImage.getGraphics();
        g.drawImage(offscreenImage, 0, 0, null);
        g.dispose();
        File file = new File(filename + ".png");
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException e) {
            System.out.println("" + e);
        }
        jaliceFrame.renderTarget.setUpdateIsAutomatic(true);
    }

    public void buttonPressed(String name) {
        if (name.equals("cancel")) {
            this.hide();
        } else if (name.equals("GO")) {
            this.go();
            this.hide();
        }
    }

    public void setWidgets() {
        this.setTitle("Export Bitmap Image");
        this.label2.setAlignment(1);
        this.label3.setAlignment(1);
        this.label5.setAlignment(1);
        this.setLayout(new GridLayout(4, 2));
        this.add(this.label2);
        this.add(this.text2);
        this.add(this.label3);
        this.add(this.text3);
        this.add(this.label5);
        this.add(this.text5);
        MyButton button = new MyButton("GO");
        this.add(button);
        MyButton cancelButton = new MyButton("cancel");
        this.add(cancelButton);
    }

    class MyButton
    extends Button {
        MyButton(String label) {
            Snapshot.this.getClass();
            this.setFont(Buttons.font);
            this.setLabel(label);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    Snapshot.this.buttonPressed(MyButton.this.getLabel());
                }
                {
                    MyButton.this.getClass();
                }
            });
        }
    }
}

