/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import ui.SliderCallback;

public class Slider {
    public SliderCallback target;
    public boolean active = false;
    public double val = 0.5;
    public Rectangle knob_rect = new Rectangle();
    public Rectangle rail_rect = new Rectangle();
    public Rectangle bbox = new Rectangle();
    public boolean dragging;
    public final int X_POS = -200;
    public final int Y_POS = -50;
    public final int WIDTH = 180;
    public final int HEIGHT = 40;
    public final int RAIL_HEIGHT = 8;
    public final int KNOB_WIDTH = 12;
    public final int KNOB_HEIGHT = 24;

    public void disactivate() {
        this.active = false;
    }

    public boolean mousePressed(Point p) {
        if (!this.active || !this.bbox.contains(p)) {
            this.dragging = false;
            return false;
        }
        this.dragging = true;
        return true;
    }

    public boolean mouseDragged(Point p) {
        if (!this.dragging) {
            return false;
        }
        this.val = 1.0 * (double)(p.x - this.rail_rect.x) / 180.0;
        if (this.val < 0.0) {
            this.val = 0.0;
        }
        if (this.val > 1.0) {
            this.val = 1.0;
        }
        return true;
    }

    Slider() {
    }

    public void paint(Graphics g, Dimension panel) {
        if (!this.active) {
            return;
        }
        this.bbox = new Rectangle(panel.width + -200 - 12, panel.height + -50, 204, 40);
        g.setColor(Color.gray);
        this.rail_rect = new Rectangle(panel.width + -200, panel.height + -50 + 20 - 4, 180, 8);
        g.drawRoundRect(this.rail_rect.x, this.rail_rect.y, this.rail_rect.width, this.rail_rect.height, 5, 5);
        this.knob_rect = new Rectangle(panel.width + -200 + (int)(180.0 * this.val) - 6, panel.height + -50 + 20 - 12, 12, 24);
        g.draw3DRect(this.knob_rect.x, this.knob_rect.y, this.knob_rect.width, this.knob_rect.height, true);
    }

    public boolean mouseReleased(Point p) {
        if (!this.dragging) {
            return false;
        }
        this.target.sliderCallback(this.val);
        this.dragging = false;
        return true;
    }

    public void activate(SliderCallback target) {
        this.active = true;
        this.target = target;
        this.val = 0.5;
    }
}

