/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;

class SecondaryColorAxesCanvas
extends Canvas {
    private float primaryValue = 1.0f;
    private float valueX = 1.0f;
    private float valueY = 1.0f;
    private int state = 1;
    private Image image;

    public float getValueX() {
        return this.valueX;
    }

    public void setValueX(float v) {
        if (this.valueX != v) {
            this.valueX = v;
            this.repaint();
        }
    }

    public void setState(int v) {
        if (this.state != v) {
            this.state = v;
            this.image = null;
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    SecondaryColorAxesCanvas() {
    }

    public void update(Graphics g) {
        if (this.image == null) {
            ColorModel cm = ColorModel.getRGBdefault();
            Dimension size = this.getSize();
            this.image = this.getToolkit().createImage(new MemoryImageSource(size.width, size.height, cm, this.generatePixels(size.width, size.height), 0, size.width));
        }
        g.drawImage(this.image, 0, 0, this);
        int x = (int)(this.valueX * (float)this.image.getWidth(this));
        int y = (int)((1.0f - this.valueY) * (float)this.image.getHeight(this));
        int radius = 4;
        int diameter = radius * 2;
        g.setColor(Color.black);
        g.drawOval(x - radius - 1, y - radius - 1, diameter + 2, diameter + 2);
        g.setColor(Color.white);
        g.drawOval(x - radius, y - radius, diameter, diameter);
    }

    int[] generatePixels(int w, int h) {
        int[] pixels = new int[w * h];
        int p = 0;
        int j = 0;
        while (j < h) {
            int i = 0;
            while (i < w) {
                Color color;
                float x = (float)i / (float)w;
                float y = 1.0f - (float)j / (float)h;
                switch (this.state) {
                    case 0: {
                        color = Color.getHSBColor(this.primaryValue, x, y);
                        break;
                    }
                    case 1: {
                        color = Color.getHSBColor(x, this.primaryValue, y);
                        break;
                    }
                    case 2: {
                        color = Color.getHSBColor(x, y, this.primaryValue);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                pixels[p++] = color.getRGB();
                ++i;
            }
            ++j;
        }
        return pixels;
    }

    public float getValueY() {
        return this.valueY;
    }

    public void setValueY(float v) {
        if (this.valueY != v) {
            this.valueY = v;
            this.repaint();
        }
    }

    public void setPrimaryValue(float v) {
        if (v != this.primaryValue) {
            this.primaryValue = v;
            this.image = null;
            this.repaint();
        }
    }
}

