/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;

class PrimaryColorAxisCanvas
extends Canvas {
    private float value = 1.0f;
    private float secondaryValueX = 1.0f;
    private float secondaryValueY = 1.0f;
    private int state = 1;
    private Image image;
    private Polygon leftTriangle;
    private Polygon rightTriangle;

    void setState(int v) {
        if (this.state != v) {
            this.state = v;
            this.image = null;
            this.repaint();
        }
    }

    float getValue() {
        return this.value;
    }

    void setValue(float v) {
        this.value = v;
        this.repaint();
    }

    PrimaryColorAxisCanvas() {
        int[] xpoints = new int[3];
        int[] ypoints = new int[3];
        xpoints[0] = 1;
        xpoints[1] = 11;
        xpoints[2] = 1;
        ypoints[0] = -4;
        ypoints[1] = 0;
        ypoints[2] = 4;
        this.leftTriangle = new Polygon(xpoints, ypoints, 3);
        xpoints[0] = -1;
        xpoints[1] = -11;
        xpoints[2] = -1;
        ypoints[0] = -4;
        ypoints[1] = 0;
        ypoints[2] = 4;
        this.rightTriangle = new Polygon(xpoints, ypoints, 3);
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    public void update(Graphics g) {
        Dimension size = this.getSize();
        int width = size.width - 24;
        int height = size.height - 24;
        if (this.image == null) {
            ColorModel cm = ColorModel.getRGBdefault();
            this.image = this.getToolkit().createImage(new MemoryImageSource(width, height, cm, this.generatePixels(width, height), 0, width));
        }
        g.drawImage(this.image, 12, 12, this);
        g.setColor(Color.lightGray);
        g.draw3DRect(12, 12, width, height, false);
        g.fillRect(0, 0, 12, size.height);
        g.fillRect(size.width - 11, 0, size.width, size.height);
        g.setColor(Color.black);
        int yOffset = (int)((1.0f - this.value) * (float)height) + 12;
        this.leftTriangle.translate(0, yOffset);
        g.drawPolygon(this.leftTriangle);
        this.leftTriangle.translate(0, -yOffset);
        this.rightTriangle.translate(size.width, yOffset);
        g.drawPolygon(this.rightTriangle);
        this.rightTriangle.translate(-size.width, -yOffset);
    }

    int[] generatePixels(int w, int h) {
        int[] pixels = new int[w * h];
        int p = 0;
        int j = 0;
        while (j < h) {
            Color color;
            float v = 1.0f - (float)j / (float)h;
            switch (this.state) {
                case 0: {
                    color = Color.getHSBColor(v, 1.0f, 1.0f);
                    break;
                }
                case 1: {
                    color = Color.getHSBColor(this.secondaryValueX, v, this.secondaryValueY);
                    break;
                }
                case 2: {
                    color = Color.getHSBColor(this.secondaryValueX, this.secondaryValueY, v);
                    break;
                }
                default: {
                    return null;
                }
            }
            int rgb = color.getRGB();
            int i = 0;
            while (i < w) {
                pixels[p++] = rgb;
                ++i;
            }
            ++j;
        }
        return pixels;
    }

    void setSecondaryValues(float x, float y) {
        this.secondaryValueX = x;
        this.secondaryValueY = y;
        if (this.state != 0) {
            this.image = null;
            this.repaint();
        }
    }
}

