/*
 * Decompiled with CFR 0.152.
 */
package ui;

import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.FillingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.ShadingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.math.Vector3;
import java.awt.Point;
import javax.vecmath.Vector3d;
import ui.Model;

public class Patch {
    Vector3[] coords;
    final double RADIUS = 0.02;
    Color COLOR = new Color(0.1, 0.8, 0.1, 1.0);
    public static Patch patch;
    Transformable ballVehicle;
    Visual ballVisual;
    Appearance ballAppearance;
    Transformable scene;
    public static IndexedTriangleArray ballITA;

    Patch(Vector3[] coords) {
        this.coords = coords;
    }

    public IndexedTriangleArray createITA(double radius) {
        ballITA = new IndexedTriangleArray();
        Vector3[] normals = new Vector3[this.coords.length];
        int i = 0;
        while (i < this.coords.length / 3) {
            Vector3 v0 = this.coords[i * 3];
            Vector3 v1 = this.coords[i * 3 + 1];
            Vector3 v2 = this.coords[i * 3 + 2];
            Vector3 normal = Vector3.crossProduct((Vector3d)Vector3.subtract((Vector3d)v1, (Vector3d)v0), (Vector3d)Vector3.subtract((Vector3d)v2, (Vector3d)v0));
            normal.normalize();
            normals[i * 3] = normal;
            normals[i * 3 + 1] = normal;
            normals[i * 3 + 2] = normal;
            ++i;
        }
        Vertex3d[] ballVertices = new Vertex3d[this.coords.length];
        int i2 = 0;
        while (i2 < this.coords.length) {
            ballVertices[i2] = new Vertex3d(19);
            ballVertices[i2].position.set(this.coords[i2].x, this.coords[i2].y, this.coords[i2].z);
            ballVertices[i2].normal.set(normals[i2].x, normals[i2].y, normals[i2].z);
            ++i2;
        }
        int[] ballIndices = new int[this.coords.length];
        int i3 = 0;
        while (i3 < this.coords.length) {
            ballIndices[i3] = i3;
            ++i3;
        }
        ballITA.setVertices(ballVertices);
        ballITA.setIndices(ballIndices);
        return ballITA;
    }

    public void removeFromScenegraph() {
        if (this.ballVehicle != null) {
            this.ballVehicle.setParent(null);
        }
    }

    public void setGeometry(double radius) {
        ballITA = this.createITA(radius);
        this.ballVisual.setGeometry((Geometry)ballITA);
        this.ballAppearance.setDiffuseColor(this.COLOR);
    }

    public Transformable getVehicle() {
        return this.ballVehicle;
    }

    public void addToScenegraph(Transformable parent) {
        this.scene = parent;
        this.createBallVisual();
        this.ballVehicle = new Transformable();
        this.ballVisual.setParent((Container)this.ballVehicle);
        this.ballVehicle.setParent((Container)parent);
    }

    public static void click(Point p, Model pickedModel) {
        if (patch != null) {
            patch.delete();
        }
        Vector3[] vs = pickedModel.pick_patch(p);
        patch = new Patch(vs);
        patch.addToScenegraph(pickedModel.modelVehicle);
    }

    public void delete() {
        this.ballVehicle.setParent(null);
    }

    public void createBallVisual() {
        this.ballVisual = new Visual();
        this.ballAppearance = new Appearance();
        this.ballVisual.setFrontFacingAppearance(this.ballAppearance);
        this.ballAppearance.setFillingStyle(FillingStyle.SOLID);
        this.ballAppearance.setShadingStyle(ShadingStyle.SMOOTH);
        this.setGeometry(0.02);
    }
}

