/*
 * Decompiled with CFR 0.152.
 */
package ui;

import VisualNumerics.math.DoubleMatrix;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.TextureMap;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.OffscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.PickInfo;
import edu.cmu.cs.stage3.math.Vector3;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.PixelGrabber;
import java.util.Vector;
import javax.vecmath.Point3d;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import teddy.Graphics2;
import teddy.Vector2;
import ui.BrushPanel;
import ui.EventHandler;
import ui.JaliceFrame;
import ui.JaliceTeddy;
import ui.Model;
import ui.Plane;
import ui.PlaySound;
import ui.Stroke;
import ui.ToolPanel;

public class Painter
implements EventHandler {
    JaliceTeddy jaliceTeddy;
    JaliceFrame jaliceFrame;
    Panel panel;
    Dimension screen_size;
    TextureMap modelTexture;
    Image temporaryTextureImage;
    public static final int W = 512;
    Vector permanent_uvs;
    public Vector painted_strokes;
    public Vector painted_stroke;
    public OffscreenRenderTarget offscreenRenderTarget;
    public edu.cmu.cs.stage3.alice.scenegraph.Color FULL_LIGHT = new edu.cmu.cs.stage3.alice.scenegraph.Color(1.0, 1.0, 1.0);
    Vector3[][] stored_vertices;
    ViewPanel viewPanel;
    public static Painter painter;
    Visual pickedVisual;
    Transformable pickedVehicle;
    Model pickedModel;
    static int operation_status;
    final int NONE = 0;
    final int PAINTING = 1;
    final int ROTATING = 2;
    final int SLIDING = 3;
    final int ZOOMING = 5;
    Point prev_p;

    public Vector3 local_coords_to_offscreen_coords(Vector3 localPt, ReferenceFrame targetVehicle) {
        Vector3 cameraPt = targetVehicle.transformTo((Vector3d)localPt, (ReferenceFrame)this.jaliceFrame.cameraVehicle);
        return new Vector3((Tuple3d)this.offscreenRenderTarget.transformFromCameraToViewport((Vector3d)cameraPt, this.jaliceFrame.camera));
    }

    public void open() {
        this.store_permanent_modelVertices();
        this.render_temporary_texturemap();
        this.associate_temporary_texturemap();
    }

    public void componentResized(ComponentEvent componentEvent) {
        Dimension size = this.jaliceFrame.getSize();
        if (size.width > 520) {
            size.width = 520;
        }
        if (size.height > 651) {
            size.height = 651;
        }
        ((Component)this.jaliceFrame).setSize(size.width, size.height);
        this.recover_permanent_texturemap();
        this.render_temporary_texturemap();
        this.associate_temporary_texturemap();
    }

    public static void set_uv_coords(Vertex3d[] modelVertices, int[] modelIndices) {
        Painter.set_uv_coords_front_back(modelVertices, modelIndices);
    }

    public static void set_uv_coords_spherical(Vertex3d[] modelVertices, int[] modelIndices) {
        Painter.set_uv_coords_spherical_main(modelVertices);
        Painter.set_uv_coords_spherical_seam(modelVertices, modelIndices);
    }

    public void undo() {
        if (this.painted_strokes != null) {
            this.painted_strokes = null;
            this.recover_permanent_texturemap();
            this.render_temporary_texturemap();
            this.associate_temporary_texturemap();
            return;
        }
        this.jaliceTeddy.undo.popUndo();
        this.recover_permanent_texturemap();
        this.render_temporary_texturemap();
        this.associate_temporary_texturemap();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        switch (operation_status) {
            case 1: {
                if (ToolPanel.current_brush == 5) {
                    PlaySound.stop("laser.wav");
                }
                this.finish_painting_on_temporary_texture();
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                this.store_permanent_modelVertices();
                this.render_temporary_texturemap();
                PlaySound.play("camera.wav");
                this.associate_temporary_texturemap();
                break;
            }
        }
        operation_status = 0;
        JaliceTeddy.jaliceFrame.repaint();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void eyedrop(Point p) {
        PlaySound.play("piro.wav");
        this.pickedVisual = this.jaliceTeddy.pickVisual(p.x, p.y);
        this.pickedModel = this.jaliceTeddy.pickModel(this.pickedVisual);
        int[] pixels = new int[1];
        PixelGrabber pg = new PixelGrabber(this.temporaryTextureImage, p.x, p.y, 1, 1, pixels, 0, 1);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            return;
        }
        int pixel = pixels[0];
        int alpha = pixel >> 24 & 0xFF;
        int red = pixel >> 16 & 0xFF;
        int green = pixel >> 8 & 0xFF;
        int blue = pixel & 0xFF;
        BrushPanel.color = new Color(red, green, blue);
        ToolPanel.toolPanel.set_brush(ToolPanel.prev_brush);
        BrushPanel.static_repaint();
    }

    public void paintOverlay(Graphics g) {
    }

    public void deflate() {
        int i = 0;
        while (i < JaliceTeddy.models.size()) {
            Model model = (Model)JaliceTeddy.models.elementAt(i);
            Vertex3d[] v = model.modelITA.getVertices();
            int j = 0;
            while (j < v.length) {
                v[j].position.x = this.stored_vertices[i][j].x;
                v[j].position.y = this.stored_vertices[i][j].y;
                v[j].position.z = this.stored_vertices[i][j].z;
                ++j;
            }
            model.modelITA.setVertices(v);
            ++i;
        }
    }

    public static void set_uv_coords_spherical_main(Vertex3d[] modelVertices) {
        Vector3 center = Painter.get_center(modelVertices);
        int i = 0;
        while (i < modelVertices.length) {
            Vertex3d v = modelVertices[i];
            Vector3 vector = Vector3.subtract((Vector3d)new Vector3((Tuple3d)v.position), (Vector3d)center);
            double x = vector.getItem(0);
            double y = vector.getItem(1);
            double z = vector.getItem(2);
            double theta = Math.atan2(z, -x);
            double phai = Math.atan2(Math.sqrt(x * x + z * z), y);
            v.textureCoordinate0.set((float)((theta + Math.PI) / (Math.PI * 2)), (float)(phai / Math.PI));
            ++i;
        }
    }

    public void recover_permanent_texturemap() {
        int i = 0;
        while (i < JaliceTeddy.models.size()) {
            Model model = (Model)JaliceTeddy.models.elementAt(i);
            model.modelAppearance.setDiffuseColorMap(model.modelTexture);
            this.set_uvs(model, (Vector)this.permanent_uvs.elementAt(i));
            ++i;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public static void set_uv_coords_front_only(Vertex3d[] modelVertices, int[] modelIndices) {
        Vertex3d[] v;
        double min_x = -1.0;
        double min_y = -1.0;
        double max_x = -1.0;
        double max_y = -1.0;
        int i = 0;
        while (i < modelVertices.length) {
            v = modelVertices[i].position;
            if (min_x == -1.0 || v.x < min_x) {
                min_x = v.x;
            }
            if (min_y == -1.0 || v.y < min_y) {
                min_y = v.y;
            }
            if (max_x == -1.0 || v.x > max_x) {
                max_x = v.x;
            }
            if (max_y == -1.0 || v.y > max_y) {
                max_y = v.y;
            }
            ++i;
        }
        i = 0;
        while (i < modelIndices.length / 3) {
            v = new Vertex3d[]{modelVertices[modelIndices[i * 3]], modelVertices[modelIndices[i * 3 + 1]], modelVertices[modelIndices[i * 3 + 2]]};
            boolean front_facing = Painter.front_facing(v[0].position, v[1].position, v[2].position);
            int j = 0;
            while (j < 3) {
                if (front_facing) {
                    float x = (float)((v[j].position.x - min_x) / (max_x - min_x));
                    float y = (float)((v[j].position.y - min_y) / (max_y - min_y));
                    v[j].textureCoordinate0 = new TexCoord2f(x, y);
                } else {
                    v[j].textureCoordinate0 = new TexCoord2f(0.0f, 0.0f);
                }
                ++j;
            }
            ++i;
        }
    }

    public void painting_on_temporary_texture(Point p, Point prev_p) {
        Graphics g = JaliceTeddy.jaliceFrame.renderTarget.getGraphics(this.modelTexture);
        g.setColor(BrushPanel.color);
        Graphics2.drawWideLine((Graphics)g, (int)p.x, (int)p.y, (int)prev_p.x, (int)prev_p.y, (double)(BrushPanel.radius * 2));
        g.dispose();
        Graphics g2 = this.temporaryTextureImage.getGraphics();
        g2.setColor(BrushPanel.color);
        Graphics2.drawWideLine((Graphics)g2, (int)p.x, (int)p.y, (int)prev_p.x, (int)prev_p.y, (double)(BrushPanel.radius * 2));
        g2.dispose();
        this.show_viewPanel();
        prev_p.x = p.x;
        prev_p.y = p.y;
        this.painted_stroke.addElement(p);
    }

    public static Point pick_texture_bitmap_coords(Model model, Point p) {
        PickInfo pickInfo = JaliceTeddy.jaliceFrame.renderTarget.pick(p.x, p.y, true, true);
        if (pickInfo.getCount() == 0) {
            return null;
        }
        Vector3d v = pickInfo.getLocalPosition(0);
        int index = pickInfo.getSubElement(0);
        int[] indices = model.modelITA.getIndices();
        Vertex3d[] vertices = model.modelITA.getVertices();
        Vertex3d a = vertices[indices[index * 3]];
        Vertex3d b = vertices[indices[index * 3 + 1]];
        Vertex3d c = vertices[indices[index * 3 + 2]];
        Vector3 a0 = JaliceTeddy.jaliceFrame.local_coords_to_screen_coords(new Vector3((Tuple3d)a.position), (ReferenceFrame)model.modelVehicle);
        Vector3 b0 = JaliceTeddy.jaliceFrame.local_coords_to_screen_coords(new Vector3((Tuple3d)b.position), (ReferenceFrame)model.modelVehicle);
        Vector3 c0 = JaliceTeddy.jaliceFrame.local_coords_to_screen_coords(new Vector3((Tuple3d)c.position), (ReferenceFrame)model.modelVehicle);
        c0.z = 0.0;
        b0.z = 0.0;
        a0.z = 0.0;
        Vector3 vec0 = Vector3.subtract((Vector3d)b0, (Vector3d)a0);
        Vector3 vec1 = Vector3.subtract((Vector3d)c0, (Vector3d)a0);
        Vector3 vec = Vector3.subtract((Vector3d)new Vector3((double)p.x, (double)p.y, 0.0), (Vector3d)a0);
        double s = 0.0;
        double t = 0.0;
        try {
            double[][] A = new double[][]{{vec0.x, vec1.x}, {vec0.y, vec1.y}};
            double[] B = new double[]{vec.x, vec.y};
            double[] X = DoubleMatrix.solve((double[][])A, (double[])B);
            s = X[0];
            t = X[1];
        }
        catch (Exception e) {
            System.out.println("" + e);
        }
        double x = (double)a.textureCoordinate0.x + (double)(b.textureCoordinate0.x - a.textureCoordinate0.x) * s + (double)(c.textureCoordinate0.x - a.textureCoordinate0.x) * t;
        double y = (double)a.textureCoordinate0.y + (double)(b.textureCoordinate0.y - a.textureCoordinate0.y) * s + (double)(c.textureCoordinate0.y - a.textureCoordinate0.y) * t;
        int width = model.modelTexture.getImage().getWidth(null);
        return new Point((int)((double)width * x), (int)((double)width * y));
    }

    public Vector get_uvs(Model model) {
        Vector<float[]> uvs = new Vector<float[]>();
        Vertex3d[] modelVertices = model.modelITA.getVertices();
        int i = 0;
        while (i < modelVertices.length) {
            Vertex3d v = modelVertices[i];
            float[] uv = new float[]{v.textureCoordinate0.x, v.textureCoordinate0.y};
            uvs.addElement(uv);
            ++i;
        }
        return uvs;
    }

    public void set_uvs(Model model, Vector uvs) {
        Vertex3d[] modelVertices = model.modelITA.getVertices();
        int i = 0;
        while (i < modelVertices.length) {
            Vertex3d v = modelVertices[i];
            float[] uv = (float[])uvs.elementAt(i);
            v.textureCoordinate0.set(uv[0], uv[1]);
            ++i;
        }
        model.modelITA.setVertices(modelVertices);
    }

    public int get_model_index(Model model) {
        int i = 0;
        while (i < JaliceTeddy.models.size()) {
            if (JaliceTeddy.models.elementAt(i) == model) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void dunk(Point p) {
        if (painter != null) {
            painter.dunk_main(p);
        }
    }

    public void store_permanent_modelVertices() {
        this.permanent_uvs = new Vector();
        int i = 0;
        while (i < JaliceTeddy.models.size()) {
            Model model = (Model)JaliceTeddy.models.elementAt(i);
            this.permanent_uvs.addElement(this.get_uvs(model));
            ++i;
        }
    }

    public void close() {
        this.flush_strokes();
        this.recover_permanent_texturemap();
    }

    public static float x_to_u(double x) {
        return (float)((x + 0.5) / 512.0);
    }

    public static void paintStroke(Vector stroke, Model model) {
        Graphics g = JaliceTeddy.jaliceFrame.renderTarget.getGraphics(model.modelTexture);
        g.setColor(BrushPanel.color);
        Point prev_p = (Point)stroke.elementAt(0);
        int i = 1;
        while (i < stroke.size()) {
            Point p = (Point)stroke.elementAt(i);
            Point a = Painter.pick_texture_bitmap_coords(model, prev_p);
            Point b = Painter.pick_texture_bitmap_coords(model, p);
            if (a != null && b != null) {
                Graphics2.drawWideLine((Graphics)g, (int)a.x, (int)a.y, (int)b.x, (int)b.y, (double)BrushPanel.radius);
            }
            prev_p = p;
            ++i;
        }
        g.dispose();
    }

    public void flood(Point p) {
        PlaySound.play("cyu.wav");
        this.pickedVisual = this.jaliceTeddy.pickVisual(p.x, p.y);
        if (this.pickedVisual == null) {
            JaliceFrame.BACKGROUND_COLOR = new edu.cmu.cs.stage3.alice.scenegraph.Color(BrushPanel.color);
            this.jaliceFrame.background.setColor(JaliceFrame.BACKGROUND_COLOR);
            return;
        }
        this.jaliceTeddy.undo.pushUndo_painting();
        this.pickedModel = this.jaliceTeddy.pickModel(this.pickedVisual);
        Point a = this.get_position_in_packedTexture(this.pickedModel, p);
        Graphics2.floodFill((Image)this.pickedModel.modelTexture.getImage(), (Point)a, (Color)BrushPanel.color);
        this.pickedModel.modelTexture.touchImage();
        this.pickedModel.packedTexture.repaint_viewPanel();
        ToolPanel.toolPanel.set_brush(1);
        this.flush_strokes();
        this.recover_permanent_texturemap();
        this.render_temporary_texturemap();
        this.associate_temporary_texturemap();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        operation_status = 0;
        Point p = mouseEvent.getPoint();
        if ((mouseEvent.getModifiers() & 4) != 0 || (mouseEvent.getModifiers() & 1) != 0 || p.x > this.jaliceFrame.awtComponent.getSize().width - 20) {
            this.flush_strokes();
            this.recover_permanent_texturemap();
            this.pickedVisual = this.jaliceTeddy.pickVisual(p.x, p.y);
            if (p.x > this.jaliceFrame.awtComponent.getSize().width - 20) {
                operation_status = 5;
            } else if (this.pickedVisual != null) {
                operation_status = 2;
                this.pickedVehicle = (Transformable)this.pickedVisual.getParent();
                this.pickedModel = this.jaliceTeddy.pickModel(this.pickedVisual);
            } else {
                operation_status = 3;
                Plane plane = new Plane(new Vector3(0.0, 0.0, 0.0), new Vector3(0.0, 0.0, 1.0));
                Vector3 pos = plane.project(mouseEvent.getPoint());
                this.pickedModel = this.jaliceTeddy.find_nearest_model(pos);
                if (this.pickedModel != null) {
                    this.pickedModel = this.pickedModel.getRootModel();
                    this.pickedVehicle = this.pickedModel.modelVehicle;
                }
            }
        } else {
            if (ToolPanel.current_brush == 4) {
                this.eyedrop(p);
                return;
            }
            if (ToolPanel.current_brush == 2) {
                this.flood(p);
                return;
            }
            if (ToolPanel.current_brush == 3) {
                Painter.dunk(p);
                return;
            }
            if (ToolPanel.current_brush == 5) {
                PlaySound.loop("laser.wav");
            }
            operation_status = 1;
            this.start_painting_on_temporary_texture(p);
            this.pickedVisual = this.jaliceTeddy.pickVisual(p.x, p.y);
            this.pickedModel = this.jaliceTeddy.pickModel(this.pickedVisual);
        }
        this.prev_p = mouseEvent.getPoint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point p = mouseEvent.getPoint();
        switch (operation_status) {
            case 1: {
                if (!(Vector2.distance((Point)this.prev_p, (Point)p) > 1.0)) break;
                this.painting_on_temporary_texture(p, this.prev_p);
                break;
            }
            case 2: {
                this.jaliceTeddy.rotate(this.pickedVehicle, p, this.prev_p);
                break;
            }
            case 5: {
                this.jaliceTeddy.zooming(p, this.prev_p);
                break;
            }
            case 3: {
                this.jaliceTeddy.slide(this.pickedVehicle, p, this.prev_p);
                break;
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    Painter(JaliceTeddy jaliceTeddy) {
        this.jaliceTeddy = jaliceTeddy;
        this.jaliceFrame = JaliceTeddy.jaliceFrame;
        painter = this;
    }

    public void inflate() {
        this.stored_vertices = new Vector3[JaliceTeddy.models.size()][];
        int i = 0;
        while (i < JaliceTeddy.models.size()) {
            Model model = (Model)JaliceTeddy.models.elementAt(i);
            Vector3 p = JaliceTeddy.jaliceFrame.screen_coords_to_local_coords(new Point(0, 0), (ReferenceFrame)model.modelVehicle);
            Vector3 q = JaliceTeddy.jaliceFrame.screen_coords_to_local_coords(new Point(1, 0), (ReferenceFrame)model.modelVehicle);
            double scale = Vector3.subtract((Vector3d)p, (Vector3d)q).getLength() * 0.5;
            Vertex3d[] v = model.modelITA.getVertices();
            this.stored_vertices[i] = new Vector3[v.length];
            int j = 0;
            while (j < v.length) {
                this.stored_vertices[i][j] = new Vector3(v[j].position.x, v[j].position.y, v[j].position.z);
                v[j].position.x += v[j].normal.x * scale;
                v[j].position.y += v[j].normal.y * scale;
                v[j].position.z += v[j].normal.z * scale;
                ++j;
            }
            model.modelITA.setVertices(v);
            ++i;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public static float y_to_v(double y) {
        return (float)((511.5 - y) / 512.0);
    }

    public void keyTyped(KeyEvent e) {
    }

    public void finish_painting_on_temporary_texture() {
        int index = 0;
        while (index < this.painted_stroke.size()) {
            Point p = (Point)this.painted_stroke.elementAt(index);
            Model model = this.jaliceTeddy.pickModel(p.x, p.y);
            if (model != null) break;
            ++index;
        }
        if (index == this.painted_stroke.size()) {
            return;
        }
        Stroke trimmed_stroke = new Stroke(BrushPanel.radius);
        while (index < this.painted_stroke.size()) {
            Point p = (Point)this.painted_stroke.elementAt(index);
            trimmed_stroke.addElement(p);
            ++index;
        }
        trimmed_stroke.remove_short_edges();
        if (this.painted_strokes == null) {
            this.painted_strokes = new Vector();
        }
        this.painted_strokes.addElement(trimmed_stroke);
    }

    public void associate_temporary_texturemap() {
        this.jaliceFrame.renderTarget.setUpdateIsAutomatic(false);
        if (this.modelTexture == null) {
            this.modelTexture = new TextureMap();
        }
        this.modelTexture.setImage(this.temporaryTextureImage);
        this.modelTexture.touchImage();
        int i = 0;
        while (i < JaliceTeddy.models.size()) {
            Model model = (Model)JaliceTeddy.models.elementAt(i);
            model.modelAppearance.setDiffuseColorMap(this.modelTexture);
            this.set_uv(model);
            ++i;
        }
        this.jaliceFrame.renderTarget.setUpdateIsAutomatic(true);
        this.screen_size = this.jaliceFrame.awtComponent.getSize();
    }

    public Vector3 get_offscreen_coords(Vertex3d v, Transformable vehicle) {
        Vector3 localPt = new Vector3(v.position.x, v.position.y, v.position.z);
        return this.local_coords_to_offscreen_coords(localPt, (ReferenceFrame)vehicle);
    }

    public void render_temporary_texturemap() {
        if (this.offscreenRenderTarget == null) {
            this.offscreenRenderTarget = this.jaliceFrame.renderer.createOffscreenRenderTarget();
            this.offscreenRenderTarget.addCamera(this.jaliceFrame.camera);
        }
        Dimension d = this.jaliceFrame.awtComponent.getSize();
        this.offscreenRenderTarget.setSize(d.width, d.height);
        this.jaliceFrame.renderTarget.setUpdateIsAutomatic(false);
        this.jaliceFrame.background.setColor(new edu.cmu.cs.stage3.alice.scenegraph.Color(((Model)JaliceTeddy.models.elementAt((int)0)).dunk_color));
        this.jaliceFrame.ambientLight.setColor(this.FULL_LIGHT);
        this.jaliceFrame.sunLight.setColor(this.FULL_LIGHT);
        this.offscreenRenderTarget.clearAndRenderOffscreen();
        Image offscreenImage = this.offscreenRenderTarget.getOffscreenImage();
        if (this.temporaryTextureImage == null) {
            this.temporaryTextureImage = this.jaliceFrame.awtComponent.createImage(512, 512);
        }
        Graphics g = this.temporaryTextureImage.getGraphics();
        g.drawImage(offscreenImage, 0, 0, null);
        g.dispose();
        this.jaliceFrame.sunLight.setColor(JaliceFrame.SUN_COLOR);
        this.jaliceFrame.ambientLight.setColor(JaliceFrame.AMBIENT_COLOR);
        this.jaliceFrame.background.setColor(JaliceFrame.BACKGROUND_COLOR);
        this.jaliceFrame.renderTarget.setUpdateIsAutomatic(true);
        this.show_viewPanel();
    }

    public void assign_new_texturemap_to_the_painted_area() {
        Model model = this.find_touched_model();
        if (model == null) {
            return;
        }
        this.jaliceTeddy.undo.pushUndo_painting();
        int model_index = this.get_model_index(model);
        model.packedTexture.painted(this.painted_strokes, this.temporaryTextureImage, (Vector)this.permanent_uvs.elementAt(model_index), this.get_uvs(model), ToolPanel.current_brush == 5);
    }

    public void keyReleased(KeyEvent e) {
    }

    public void set_uv(Model model) {
        Vertex3d[] modelVertices = model.modelITA.getVertices();
        int i = 0;
        while (i < modelVertices.length) {
            Vertex3d v = modelVertices[i];
            Vector3 p = this.get_offscreen_coords(v, model.modelVehicle);
            v.textureCoordinate0.set(Painter.x_to_u(p.x), Painter.y_to_v(p.y));
            ++i;
        }
        model.modelITA.setVertices(modelVertices);
    }

    public void show_viewPanel() {
    }

    public void painting(Point p, Point prev_p) {
        Point a = Painter.pick_texture_bitmap_coords(this.pickedModel, prev_p);
        Point b = Painter.pick_texture_bitmap_coords(this.pickedModel, p);
        if (a == null || b == null) {
            return;
        }
        Graphics g = JaliceTeddy.jaliceFrame.renderTarget.getGraphics(this.pickedModel.modelTexture);
        g.setColor(BrushPanel.color);
        Graphics2.drawWideLine((Graphics)g, (int)a.x, (int)a.y, (int)b.x, (int)b.y, (double)BrushPanel.radius);
        g.dispose();
        prev_p.x = p.x;
        prev_p.y = p.y;
    }

    public static boolean front_facing(Point3d a, Point3d b, Point3d c) {
        Vector2d vec0 = new Vector2d(b.x - a.x, b.y - a.y);
        Vector2d vec1 = new Vector2d(c.x - a.x, c.y - a.y);
        return vec0.x * vec1.y - vec0.y * vec1.x < 0.0;
    }

    static Vector3 get_center(Vertex3d[] modelVertices) {
        Vector3 center = new Vector3();
        int i = 0;
        while (i < modelVertices.length) {
            Vertex3d v = modelVertices[i];
            center.add(new Vector3((Tuple3d)v.position));
            ++i;
        }
        center.multiply(1.0 / (double)modelVertices.length);
        return center;
    }

    public static double u_to_x(float u) {
        return (double)(u * 511.0f) + 0.5;
    }

    public static void set_uv_coords_front_back(Vertex3d[] modelVertices, int[] modelIndices) {
        Vertex3d[] v;
        double min_x = -1.0;
        double min_y = -1.0;
        double max_x = -1.0;
        double max_y = -1.0;
        int i = 0;
        while (i < modelVertices.length) {
            v = modelVertices[i].position;
            if (min_x == -1.0 || v.x < min_x) {
                min_x = v.x;
            }
            if (min_y == -1.0 || v.y < min_y) {
                min_y = v.y;
            }
            if (max_x == -1.0 || v.x > max_x) {
                max_x = v.x;
            }
            if (max_y == -1.0 || v.y > max_y) {
                max_y = v.y;
            }
            ++i;
        }
        i = 0;
        while (i < modelIndices.length / 3) {
            v = new Vertex3d[]{modelVertices[modelIndices[i * 3]], modelVertices[modelIndices[i * 3 + 1]], modelVertices[modelIndices[i * 3 + 2]]};
            boolean front_facing = Painter.front_facing(v[0].position, v[1].position, v[2].position);
            float u0 = 0.0f;
            if (!Painter.front_facing(v[0].position, v[1].position, v[2].position)) {
                u0 = 0.5f;
            }
            int j = 0;
            while (j < 3) {
                float x = (float)((v[j].position.x - min_x) / (max_x - min_x) * 0.5);
                float y = (float)((v[j].position.y - min_y) / (max_y - min_y));
                v[j].textureCoordinate0 = new TexCoord2f(u0 + x, y);
                ++j;
            }
            ++i;
        }
    }

    public void flush_strokes() {
        if (this.painted_strokes != null) {
            this.assign_new_texturemap_to_the_painted_area();
            this.painted_strokes = null;
        }
    }

    public void dunk_main(Point p) {
        PlaySound.play("bloop.wav");
        Visual pickedVisual = JaliceTeddy.jaliceTeddy.pickVisual(p.x, p.y);
        if (pickedVisual == null) {
            JaliceFrame.BACKGROUND_COLOR = new edu.cmu.cs.stage3.alice.scenegraph.Color(BrushPanel.color);
            this.jaliceFrame.background.setColor(JaliceFrame.BACKGROUND_COLOR);
            return;
        }
        this.jaliceTeddy.undo.pushUndo_painting();
        Model model = JaliceTeddy.jaliceTeddy.pickModel(pickedVisual);
        int model_index = this.get_model_index(model);
        model.dunk_color = BrushPanel.color;
        model.packedTexture.dunk(BrushPanel.color, (Vector)this.permanent_uvs.elementAt(model_index));
        this.recover_permanent_texturemap();
        this.render_temporary_texturemap();
        this.associate_temporary_texturemap();
    }

    public static double v_to_y(float v) {
        return 511.5 - (double)(v * 511.0f);
    }

    public static void set_uv_coords_spherical_seam(Vertex3d[] modelVertices, int[] modelIndices) {
        Vector3 center = Painter.get_center(modelVertices);
        int i = 0;
        while (i < modelIndices.length / 3) {
            Vertex3d a = modelVertices[modelIndices[i * 3]];
            Vertex3d b = modelVertices[modelIndices[i * 3 + 1]];
            Vertex3d c = modelVertices[modelIndices[i * 3 + 2]];
            Vector3 av = Vector3.subtract((Vector3d)new Vector3((Tuple3d)a.position), (Vector3d)center);
            Vector3 bv = Vector3.subtract((Vector3d)new Vector3((Tuple3d)b.position), (Vector3d)center);
            Vector3 cv = Vector3.subtract((Vector3d)new Vector3((Tuple3d)c.position), (Vector3d)center);
            if (!(av.x < 0.0) && (av.z * bv.z <= 0.0 || bv.z * cv.z <= 0.0 || cv.z * av.z <= 0.0)) {
                if ((double)a.textureCoordinate0.x < 0.5) {
                    a.textureCoordinate0.x = 1.0f;
                }
                if ((double)b.textureCoordinate0.x < 0.5) {
                    b.textureCoordinate0.x = 1.0f;
                }
                if ((double)c.textureCoordinate0.x < 0.5) {
                    c.textureCoordinate0.x = 1.0f;
                }
            }
            ++i;
        }
    }

    public Model find_touched_model() {
        Point p = (Point)((Stroke)this.painted_strokes.elementAt(0)).elementAt(0);
        return this.jaliceTeddy.pickModel(p.x, p.y);
    }

    public void start_painting_on_temporary_texture(Point p) {
        this.painted_stroke = new Stroke(BrushPanel.radius);
        this.painted_stroke.addElement(p);
        this.painting_on_temporary_texture(p, p);
    }

    public Point get_position_in_packedTexture(Model model, Point p) {
        PickInfo pickInfo = JaliceTeddy.jaliceFrame.renderTarget.pick(p.x, p.y, true, true);
        if (pickInfo.getCount() == 0) {
            return null;
        }
        Vector3d v = pickInfo.getLocalPosition(0);
        int index = pickInfo.getSubElement(0);
        int[] indices = model.modelITA.getIndices();
        Vector uvs = (Vector)this.permanent_uvs.elementAt(this.get_model_index(model));
        float[] a_uv = (float[])uvs.elementAt(indices[index * 3]);
        float[] b_uv = (float[])uvs.elementAt(indices[index * 3 + 1]);
        float[] c_uv = (float[])uvs.elementAt(indices[index * 3 + 2]);
        Vertex3d[] vertices = model.modelITA.getVertices();
        Vertex3d a = vertices[indices[index * 3]];
        Vertex3d b = vertices[indices[index * 3 + 1]];
        Vertex3d c = vertices[indices[index * 3 + 2]];
        Vector3 a0 = JaliceTeddy.jaliceFrame.local_coords_to_screen_coords(new Vector3((Tuple3d)a.position), (ReferenceFrame)model.modelVehicle);
        Vector3 b0 = JaliceTeddy.jaliceFrame.local_coords_to_screen_coords(new Vector3((Tuple3d)b.position), (ReferenceFrame)model.modelVehicle);
        Vector3 c0 = JaliceTeddy.jaliceFrame.local_coords_to_screen_coords(new Vector3((Tuple3d)c.position), (ReferenceFrame)model.modelVehicle);
        c0.z = 0.0;
        b0.z = 0.0;
        a0.z = 0.0;
        Vector3 vec0 = Vector3.subtract((Vector3d)b0, (Vector3d)a0);
        Vector3 vec1 = Vector3.subtract((Vector3d)c0, (Vector3d)a0);
        Vector3 vec = Vector3.subtract((Vector3d)new Vector3((double)p.x, (double)p.y, 0.0), (Vector3d)a0);
        double s = 0.0;
        double t = 0.0;
        try {
            double[][] A = new double[][]{{vec0.x, vec1.x}, {vec0.y, vec1.y}};
            double[] B = new double[]{vec.x, vec.y};
            double[] X = DoubleMatrix.solve((double[][])A, (double[])B);
            s = X[0];
            t = X[1];
        }
        catch (Exception e) {
            System.out.println("" + e);
        }
        double x = (double)a_uv[0] + (double)(b_uv[0] - a_uv[0]) * s + (double)(c_uv[0] - a_uv[0]) * t;
        double y = (double)a_uv[1] + (double)(b_uv[1] - a_uv[1]) * s + (double)(c_uv[1] - a_uv[1]) * t;
        return new Point((int)((double)this.pickedModel.packedTexture.size.width * x), (int)((double)this.pickedModel.packedTexture.size.height * (1.0 - y)));
    }

    class ViewPanel
    extends Panel {
        Panel panel;

        ViewPanel() {
            Painter.this.getClass();
            Frame frame = new Frame();
            frame.add(this);
            ((Component)frame).setSize(520, 546);
            frame.show();
        }

        public void paint(Graphics g) {
            g.drawImage(Painter.this.temporaryTextureImage, 0, 0, null);
        }

        public void update(Graphics g) {
            this.paint(g);
        }
    }
}

