/*
 * Decompiled with CFR 0.152.
 */
package ui;

import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.util.Vector;
import ui.JaliceTeddy;
import ui.Model;
import ui.Painter;

public class PackedTexture {
    Model model;
    public static final boolean SHOW_VIEWPANEL = false;
    Vector regions;
    Dimension size;
    ViewPanel viewPanel;

    public void assign_new_region(Rectangle source_bbox, Image source_image, int[] touched_vertices, Vector permanent_uvs, Vector temporary_uvs, int[] faces) {
        Rectangle bbox = this.find_open_space(source_bbox);
        while (bbox == null) {
            bbox = this.enlarge_texture(source_bbox, permanent_uvs);
        }
        Graphics g = this.model.modelTexture.getImage().getGraphics();
        g.drawImage(source_image, bbox.x, bbox.y, bbox.x + bbox.width, bbox.y + bbox.height, source_bbox.x, source_bbox.y, source_bbox.x + source_bbox.width, source_bbox.y + source_bbox.height, null);
        g.dispose();
        this.model.modelTexture.touchImage();
        this.regions.addElement(new Region(bbox, faces));
        int i = 0;
        while (i < touched_vertices.length) {
            float[] permanent_uv = (float[])permanent_uvs.elementAt(touched_vertices[i]);
            float[] temporary_uv = (float[])temporary_uvs.elementAt(touched_vertices[i]);
            permanent_uv[0] = this.x_to_u(Painter.u_to_x(temporary_uv[0]) - (double)source_bbox.x + (double)bbox.x);
            permanent_uv[1] = this.y_to_v(Painter.v_to_y(temporary_uv[1]) - (double)source_bbox.y + (double)bbox.y);
            ++i;
        }
    }

    public float x_to_u(double x) {
        return (float)((x + 0.5) / (double)this.size.width);
    }

    public PackedTexture(Model model) {
        this.model = model;
        this.size = new Dimension(model.modelTexture.getImage().getWidth(null), model.modelTexture.getImage().getHeight(null));
    }

    public float y_to_v(double y) {
        return (float)(((double)this.size.height - 0.5 - y) / (double)this.size.height);
    }

    public PackedTexture duplicate() {
        PackedTexture packedTexture = new PackedTexture(this.model);
        packedTexture.regions = new Vector();
        int i = 0;
        while (i < this.regions.size()) {
            packedTexture.regions.addElement(((Region)this.regions.elementAt(i)).duplicate());
            ++i;
        }
        return packedTexture;
    }

    public Rectangle enlarge_texture(Rectangle bbox, Vector permanent_uvs) {
        this.size = new Dimension(this.size.width * 2, this.size.height * 2);
        Image image = JaliceTeddy.jaliceFrame.awtComponent.createImage(this.size.width, this.size.height);
        Graphics g = image.getGraphics();
        g.setColor(this.model.dunk_color);
        g.fillRect(0, 0, this.size.width, this.size.height);
        g.drawImage(this.model.modelTexture.getImage(), 0, 0, null);
        g.dispose();
        this.model.modelTexture.setImage(image);
        int i = 0;
        while (i < permanent_uvs.size()) {
            float[] permanent_uv = (float[])permanent_uvs.elementAt(i);
            permanent_uv[0] = permanent_uv[0] / 2.0f;
            permanent_uv[1] = 1.0f - (1.0f - permanent_uv[1]) / 2.0f;
            ++i;
        }
        return this.find_open_space(bbox);
    }

    public Rectangle find_open_space(Rectangle bbox) {
        if (bbox.width > this.size.width || bbox.height > this.size.height) {
            return null;
        }
        Region last_region = (Region)this.regions.elementAt(this.regions.size() - 1);
        int x = last_region.bbox.x + last_region.bbox.width + 1;
        if (this.size.width < x + bbox.width) {
            x = 0;
        }
        int y = 0;
        int i = 0;
        while (i < this.regions.size()) {
            Region region = (Region)this.regions.elementAt(i);
            if (region.bbox.x <= x + bbox.width && region.bbox.x + region.bbox.width >= x) {
                y = Math.max(y, region.bbox.y + region.bbox.height);
            }
            ++i;
        }
        if (y + bbox.height > this.size.height) {
            return null;
        }
        return new Rectangle(x, y, bbox.width, bbox.height);
    }

    public void painted(Vector strokes, Image temporary_texture_image, Vector permanent_uvs, Vector temporary_uvs, boolean laser) {
        int[] faces = this.model.get_painted_faces(strokes, laser);
        int[] vertices = new int[faces.length * 3];
        int[] modelIndices = this.model.modelITA.getIndices();
        int i = 0;
        while (i < faces.length) {
            vertices[i * 3] = modelIndices[faces[i] * 3];
            vertices[i * 3 + 1] = modelIndices[faces[i] * 3 + 1];
            vertices[i * 3 + 2] = modelIndices[faces[i] * 3 + 2];
            ++i;
        }
        int min_x = -1;
        int min_y = -1;
        int max_x = -1;
        int max_y = -1;
        int i2 = 0;
        while (i2 < vertices.length) {
            float[] uv = (float[])temporary_uvs.elementAt(vertices[i2]);
            double x = Painter.u_to_x(uv[0]);
            double y = Painter.v_to_y(uv[1]);
            if (min_x == -1 || x < (double)min_x) {
                min_x = (int)x;
            }
            if (min_y == -1 || y < (double)min_y) {
                min_y = (int)y;
            }
            if (max_x == -1 || x > (double)max_x) {
                max_x = (int)x;
            }
            if (max_y == -1 || y > (double)max_y) {
                max_y = (int)y;
            }
            ++i2;
        }
        this.assign_new_region(new Rectangle(--min_x, --min_y, (max_x += 2) - min_x, (max_y += 2) - min_y), temporary_texture_image, vertices, permanent_uvs, temporary_uvs, faces);
        this.repaint_viewPanel();
    }

    public void repaint_viewPanel() {
    }

    public void reset_uvs() {
        Vertex3d[] modelVertices = this.model.modelITA.getVertices();
        int i = 0;
        while (i < modelVertices.length) {
            Vertex3d v = modelVertices[i];
            v.textureCoordinate0.set(0.5f, 0.5f);
            ++i;
        }
        this.model.modelITA.setVertices(modelVertices);
        int[] faces = new int[this.model.final_polyhedron.n_polygons];
        int i2 = 0;
        while (i2 < faces.length) {
            faces[i2] = i2;
            ++i2;
        }
        this.regions = new Vector();
        this.regions.addElement(new Region(new Rectangle(0, 0, 1, 1), faces));
    }

    public void dunk(Color color, Vector permanent_uvs) {
        this.size = new Dimension(1, 1);
        Image image = JaliceTeddy.jaliceFrame.awtComponent.createImage(this.size.width, this.size.height);
        Graphics g = image.getGraphics();
        g.setColor(color);
        g.fillRect(0, 0, 1, 1);
        g.dispose();
        this.model.modelTexture.setImage(image);
        int i = 0;
        while (i < permanent_uvs.size()) {
            float[] permanent_uv = (float[])permanent_uvs.elementAt(i);
            permanent_uv[0] = 0.5f;
            permanent_uv[1] = 0.5f;
            ++i;
        }
        int[] faces = new int[this.model.final_polyhedron.n_polygons];
        int i2 = 0;
        while (i2 < faces.length) {
            faces[i2] = i2;
            ++i2;
        }
        this.regions = new Vector();
        this.regions.addElement(new Region(new Rectangle(0, 0, 1, 1), faces));
        this.repaint_viewPanel();
    }

    public void set_region(int width, int height) {
        int[] faces = new int[this.model.modelITA.getIndexCount() / 3];
        int i = 0;
        while (i < faces.length) {
            faces[i] = i;
            ++i;
        }
        this.regions = new Vector();
        this.regions.addElement(new Region(new Rectangle(0, 0, width, height), faces));
    }

    class Region {
        Rectangle bbox;
        int[] faces;

        Region(Rectangle _bbox, int[] _faces) {
            PackedTexture.this.getClass();
            this.bbox = _bbox;
            this.faces = _faces;
        }

        Region duplicate() {
            return new Region((Rectangle)this.bbox.clone(), (int[])this.faces.clone());
        }
    }

    class ViewPanel
    extends Panel {
        Panel panel;
        Frame frame;

        ViewPanel() {
            PackedTexture.this.getClass();
            this.frame = new Frame();
            this.frame.add(this);
            ((Component)this.frame).setSize(PackedTexture.this.size.width + 8, PackedTexture.this.size.height + 34);
            ((Component)this.frame).setLocation(522, 0);
            this.frame.show();
        }

        public void paint(Graphics g) {
            ((Component)this.frame).setSize(PackedTexture.this.size.width + 8, PackedTexture.this.size.height + 34);
            this.frame.doLayout();
            g.drawImage(PackedTexture.this.model.modelTexture.getImage(), 0, 0, null);
            g.setColor(Color.black);
            int i = 0;
            while (i < PackedTexture.this.regions.size()) {
                Rectangle bbox = ((Region)PackedTexture.this.regions.elementAt((int)i)).bbox;
                g.drawRect(bbox.x, bbox.y, bbox.width, bbox.height);
                ++i;
            }
        }

        public void update(Graphics g) {
            this.paint(g);
        }
    }
}

