/*
 * Decompiled with CFR 0.152.
 */
package ui;

import edu.cmu.cs.stage3.math.Matrix44;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import ui.Model;

public class ObjFile {
    public static int setIDs(Model model, int id) {
        model.id = id++;
        int i = 0;
        while (i < model.childrenModels.size()) {
            id = ObjFile.setIDs((Model)model.childrenModels.elementAt(i), id);
            ++i;
        }
        return id;
    }

    public static int save_part_main(Model model, PrintWriter pw, int vertex_count) {
        pw.println("# id " + model.id);
        String childrenIDs = "";
        int i = 0;
        while (i < model.childrenModels.size()) {
            childrenIDs = childrenIDs + " " + ((Model)model.childrenModels.elementAt((int)i)).id;
            ++i;
        }
        pw.println("# children" + childrenIDs);
        Matrix44 matrix = model.modelVehicle.getTransformation(null);
        String matrixString = "";
        int i2 = 0;
        while (i2 < 4) {
            int j = 0;
            while (j < 4) {
                matrixString = matrixString + " " + matrix.getItem(i2, j);
                ++j;
            }
            ++i2;
        }
        pw.println("# transformable" + matrixString);
        pw.println("# vertices " + model.getVertexCount());
        pw.println("# triangles " + model.getTriangleCount());
        Vector vertices = model.getVertices();
        int i3 = 0;
        while (i3 < vertices.size()) {
            double[] xyz = (double[])vertices.elementAt(i3);
            pw.println("v " + xyz[0] + " " + xyz[1] + " " + xyz[2]);
            ++i3;
        }
        Vector indices = model.getIndices();
        int i4 = 0;
        while (i4 < indices.size()) {
            int[] index = (int[])indices.elementAt(i4);
            pw.println("f " + (index[0] + vertex_count) + " " + (index[1] + vertex_count) + " " + (index[2] + vertex_count));
            ++i4;
        }
        Vector seams = model.getSeams();
        String line = "#seam";
        int i5 = 0;
        while (i5 < seams.size()) {
            int[] index = (int[])seams.elementAt(i5);
            line = line + " " + index[0] + " " + index[1];
            ++i5;
        }
        pw.println(line);
        Vector sharps = model.getSharps();
        line = "#sharp";
        int i6 = 0;
        while (i6 < sharps.size()) {
            int[] index = (int[])sharps.elementAt(i6);
            line = line + " " + index[0] + " " + index[1];
            ++i6;
        }
        pw.println(line);
        return vertex_count + vertices.size();
    }

    public static Model load(String filename) {
        Model model = null;
        try {
            FileInputStream fis = new FileInputStream(filename);
            BufferedReader r = new BufferedReader(new InputStreamReader(fis));
            int[] vertex_count = new int[]{1};
            model = ObjFile.load_sub(r, null, vertex_count);
            r.close();
        }
        catch (IOException e) {
            System.out.println("Error in ObjFile.load()");
        }
        return model;
    }

    public static Model load_sub(BufferedReader r, Model parentModel, int[] vertex_count) {
        try {
            int i0;
            StringTokenizer st = new StringTokenizer(r.readLine());
            st.nextToken();
            st.nextToken();
            int id = new Integer(st.nextToken());
            st = new StringTokenizer(r.readLine());
            st.nextToken();
            st.nextToken();
            Vector<Integer> children = new Vector<Integer>();
            while (st.hasMoreTokens()) {
                children.addElement(new Integer(st.nextToken()));
            }
            st = new StringTokenizer(r.readLine());
            st.nextToken();
            st.nextToken();
            Matrix44 matrix = new Matrix44();
            int i = 0;
            while (i < 4) {
                int j = 0;
                while (j < 4) {
                    matrix.setItem(i, j, new Double(st.nextToken()).doubleValue());
                    ++j;
                }
                ++i;
            }
            st = new StringTokenizer(r.readLine());
            st.nextToken();
            st.nextToken();
            int n_vertices = new Integer(st.nextToken());
            st = new StringTokenizer(r.readLine());
            st.nextToken();
            st.nextToken();
            int n_triangles = new Integer(st.nextToken());
            Vector<double[]> vertices = new Vector<double[]>();
            int i2 = 0;
            while (i2 < n_vertices) {
                st = new StringTokenizer(r.readLine());
                st.nextToken();
                double x = new Double(st.nextToken());
                double y = new Double(st.nextToken());
                double z = new Double(st.nextToken());
                double[] xyz = new double[]{x, y, z};
                vertices.addElement(xyz);
                ++i2;
            }
            Vector<int[]> indices = new Vector<int[]>();
            int i3 = 0;
            while (i3 < n_triangles) {
                st = new StringTokenizer(r.readLine());
                st.nextToken();
                i0 = new Integer(st.nextToken()) - vertex_count[0];
                int i1 = new Integer(st.nextToken()) - vertex_count[0];
                int i22 = new Integer(st.nextToken()) - vertex_count[0];
                int[] index = new int[]{i0, i1, i22};
                indices.addElement(index);
                ++i3;
            }
            Vector<int[]> seams = new Vector<int[]>();
            st = new StringTokenizer(r.readLine());
            st.nextToken();
            while (st.hasMoreTokens()) {
                i0 = new Integer(st.nextToken());
                int i1 = new Integer(st.nextToken());
                int[] index = new int[]{i0, i1};
                seams.addElement(index);
            }
            Vector<int[]> sharps = new Vector<int[]>();
            st = new StringTokenizer(r.readLine());
            st.nextToken();
            while (st.hasMoreTokens()) {
                int i02 = new Integer(st.nextToken());
                int i1 = new Integer(st.nextToken());
                int[] index = new int[]{i02, i1};
                sharps.addElement(index);
            }
            Model model = new Model(matrix, vertices, indices, seams, sharps, parentModel);
            vertex_count[0] = vertex_count[0] + n_vertices;
            int i4 = 0;
            while (i4 < children.size()) {
                model.childrenModels.addElement(ObjFile.load_sub(r, model, vertex_count));
                ++i4;
            }
            return model;
        }
        catch (IOException e) {
            System.out.println("Error in ObjFile.load()");
            return null;
        }
    }

    public static void save(Model model, String filename) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            PrintWriter pw = new PrintWriter(bos);
            System.out.println("save");
            ObjFile.setIDs(model, 0);
            int vertex_count = 1;
            ObjFile.save_part(model, pw, vertex_count);
            pw.flush();
            pw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int save_part(Model model, PrintWriter pw, int vertex_count) {
        vertex_count = ObjFile.save_part_main(model, pw, vertex_count);
        int i = 0;
        while (i < model.childrenModels.size()) {
            vertex_count = ObjFile.save_part((Model)model.childrenModels.elementAt(i), pw, vertex_count);
            ++i;
        }
        return vertex_count;
    }
}

