/*
 * Decompiled with CFR 0.152.
 */
package ui;

import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.FillingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.OrthographicCamera;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.Scene;
import edu.cmu.cs.stage3.alice.scenegraph.ShadingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.TextureMap;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Vector3;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import teddy.ButterflySubdivision;
import teddy.CameraInterface;
import teddy.CleanStroke;
import teddy.Cut;
import teddy.Generate;
import teddy.Geometry2D;
import teddy.LoopSubdivision;
import teddy.PNsubdivision;
import teddy.Patch;
import teddy.Polygon2;
import teddy.Polyhedron;
import teddy.QuadraticSubdivision;
import teddy.Skin;
import teddy.SubdivMesh;
import teddy.SurfacePath;
import teddy.SurroundingSurfacePath;
import teddy.VariationalSubdivision;
import teddy.Vector2;
import teddy.Vertex;
import teddy.Vertex2D;
import ui.JaliceFrame;
import ui.JaliceTeddy;
import ui.MyThread;
import ui.PackedTexture;
import ui.Plane;
import ui.SliderCallback;
import ui.Stroke;
import ui.SurfaceLine;
import ui.Util;

public class Model
implements SliderCallback {
    public static final edu.cmu.cs.stage3.alice.scenegraph.Color BODY_COLOR = JaliceFrame.BODY_COLOR;
    public static final edu.cmu.cs.stage3.alice.scenegraph.Color ACTIVE_COLOR = JaliceFrame.ACTIVE_COLOR;
    public boolean AUTO_REMESH = true;
    SubdivMesh subdivMesh;
    int id;
    boolean symmetric = false;
    public Color dunk_color = Color.white;
    public PackedTexture packedTexture;
    Vector stroke;
    Model parentModel;
    Vector childrenModels = new Vector();
    double model_size = 1.2;
    int[][] model_data;
    Transformable modelVehicle;
    Visual modelVisual;
    Appearance modelAppearance;
    IndexedTriangleArray modelITA;
    TextureMap modelTexture;
    boolean deleted;
    Vector3 center;
    public Polyhedron final_polyhedron;
    public int slider_type;
    public static final int INIT = 0;
    public static final int POP = 1;
    Vertex2D pick_localPt_prev_v;
    Polygon2 pick_localPt_prev_polygon;
    SurfacePath surfacePath;
    SurfaceLine surfaceLine;
    Face[] faces;
    Vertex2D[] vertices2d;

    public void compute_vertices2d() {
        Vertex3d[] vertices = this.modelITA.getVertices();
        this.vertices2d = new Vertex2D[vertices.length];
        boolean[] vertex_is_painted = new boolean[vertices.length];
        int i = 0;
        while (i < vertices.length) {
            Vertex3d v = vertices[i];
            Vector3 p = JaliceTeddy.jaliceFrame.local_coords_to_screen_coords(new Vector3(v.position.x, v.position.y, v.position.z), (ReferenceFrame)this.modelVehicle);
            this.vertices2d[i] = new Vertex2D(p.x, p.y);
            ++i;
        }
    }

    public void setStyle() {
        if (JaliceTeddy.wireframe) {
            this.modelAppearance.setShadingStyle(ShadingStyle.NONE);
            this.modelAppearance.setFillingStyle(FillingStyle.WIREFRAME);
        } else {
            this.modelAppearance.setShadingStyle(ShadingStyle.SMOOTH);
            this.modelAppearance.setFillingStyle(FillingStyle.SOLID);
        }
    }

    private void start_animation() {
        System.out.println("start animation");
        JaliceTeddy.refine_thread = new MyThread(){
            {
                Model.this.getClass();
            }

            public void wait_for_swap() {
                JaliceTeddy.jaliceFrame.render_occurred = false;
                while (!JaliceTeddy.jaliceFrame.render_occurred) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }

            public synchronized void run() {
                JaliceTeddy.refine_step = 0;
                this.wait_for_swap();
                String[] operations = new String[]{"drift", "remesh", "drift"};
                JaliceTeddy.refine_step_max = operations.length + 1;
                int i = 0;
                while (i < operations.length) {
                    JaliceTeddy.refine_step = i + 1;
                    if (Model.this.deleted) break;
                    Model.this.refreshGeometry_without_refinement();
                    if (operations[i].equals("drift")) {
                        Model.this.subdivMesh.drift(5);
                    } else if (operations[i].equals("remesh")) {
                        Model.this.subdivMesh.remesh();
                    } else if (operations[i].equals("set")) {
                        Model.this.subdivMesh.update_skeleton_mesh(false);
                    }
                    ++i;
                }
                JaliceTeddy.refine_step = operations.length + 1;
                Model.this.refreshGeometry();
                JaliceTeddy.refine_thread = null;
                this.notifyAll();
            }
        };
        JaliceTeddy.refine_thread.start();
    }

    public void refreshGeometry_without_refinement() {
        this.updateGeometry(this.subdivMesh.skin_mesh, false);
    }

    public int getTriangleCount() {
        return this.subdivMesh.skin_mesh.n_polygons;
    }

    public void init_dunk_color(Color color) {
        this.dunk_color = color;
        Graphics g = this.modelTexture.getImage().getGraphics();
        g.setColor(color);
        g.fillRect(0, 0, 1, 1);
        g.dispose();
        this.modelTexture.touchImage();
    }

    public Vertex3d teddyVertex_to_jaliceVertex(Vertex v) {
        Vertex3d vertex = new Vertex3d(19);
        vertex.position.set(v.x, v.y, v.z);
        vertex.normal.set(v.normal.x, v.normal.y, v.normal.z);
        return vertex;
    }

    public Vertex3d teddyVertex_to_jaliceVertex(Vertex v, teddy.Vector3 normal) {
        Vertex3d vertex = new Vertex3d(19);
        vertex.position.set(v.x, v.y, v.z);
        vertex.normal.set(normal.x, normal.y, normal.z);
        return vertex;
    }

    public Vertex jaliceVertex_to_teddyVertex(Vertex3d v) {
        return new Vertex(v.position.x, v.position.y, v.position.z);
    }

    public void drift() {
        this.subdivMesh.drift(5);
        this.refreshGeometry();
    }

    public Vector screen_coords_to_model_coords(Vector stroke) {
        Vector<Vertex2D> list = new Vector<Vertex2D>();
        this.center = new Vector3();
        Plane plane = new Plane(new Vector3(0.0, 0.0, 0.0), new Vector3(0.0, 0.0, 1.0));
        int i = 0;
        while (i < stroke.size()) {
            Vertex2D p = (Vertex2D)stroke.elementAt(i);
            Vector3 pos = plane.project(p.point());
            this.center.add(pos);
            if (pos != null) {
                p.x = pos.x;
                p.y = pos.y;
                list.addElement(p);
            }
            ++i;
        }
        this.center.multiply(1.0 / (double)stroke.size());
        Vector2 centerVector = new Vector2(-this.center.x, -this.center.y);
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            ((Vertex2D)e.nextElement()).add_self(centerVector);
        }
        return list;
    }

    public Vector3[] pick_localPt_follow(Point p) {
        return this.pick_localPt(p, true);
    }

    public void cut(SurfacePath path) {
        TmpCamera camera = new TmpCamera();
        this.surfacePath = Cut.cut((Polyhedron)this.subdivMesh.skin_mesh, (SurfacePath)path, (boolean)false);
        this.subdivMesh = new SubdivMesh(this.subdivMesh.skin_mesh);
        this.init();
        if (this.surfacePath != null) {
            this.addSurfaceLine(this.surfacePath, SurfaceLine.GREEN);
        }
    }

    public int[] get_painted_faces(Vector strokes, boolean laser) {
        this.compute_vertices2d();
        Vector painted_faces = new Vector();
        int i = 0;
        while (i < strokes.size()) {
            Stroke stroke = (Stroke)strokes.elementAt(i);
            Util.appendVector(painted_faces, this.get_painted_faces_sub(stroke, false));
            if (laser) {
                Util.appendVector(painted_faces, this.get_painted_faces_sub(stroke, true));
            }
            ++i;
        }
        int[] result = new int[painted_faces.size()];
        int i2 = 0;
        while (i2 < painted_faces.size()) {
            result[i2] = ((Face)painted_faces.elementAt((int)i2)).index;
            ++i2;
        }
        return result;
    }

    public Vector3[] pick_localPt(Point p) {
        return this.pick_localPt(p, false);
    }

    public Vector3[] pick_localPt(Point p, boolean follow) {
        TmpCamera camera = new TmpCamera();
        SurfacePath surfacePath = new SurfacePath(this.subdivMesh.skin_mesh, (CameraInterface)camera);
        Vertex2D v = new Vertex2D(p);
        Object[] result = follow ? surfacePath.pick(v, this.pick_localPt_prev_v, this.pick_localPt_prev_polygon) : surfacePath.pick(p);
        if (result == null) {
            result = surfacePath.pick_nearest_point_on_edge(p);
        }
        Vertex vertex = (Vertex)result[0];
        teddy.Vector3 normal = ((Polygon2)result[1]).normal;
        this.pick_localPt_prev_polygon = (Polygon2)result[1];
        this.pick_localPt_prev_v = camera.local_coords_to_screen_coords(this.pick_localPt_prev_polygon.get_center());
        Vector3[] results = new Vector3[]{this.teddyVertex_to_jaliceVector3(vertex), this.teddyVector3_to_jaliceVector3(normal)};
        return results;
    }

    public void taubin() {
        this.subdivMesh.taubin();
        this.refreshGeometry();
    }

    public Vector get_painted_faces_sub(Stroke stroke, boolean back_side) {
        int face_index = this.pick_face((Point)stroke.elementAt(0), back_side);
        if (face_index == -1) {
            return new Vector();
        }
        Face face = this.faces[face_index];
        Vector<Face> painted_faces = new Vector<Face>();
        painted_faces.addElement(face);
        int i = 0;
        while (i < 3) {
            this.get_painted_faces_propagate(face.adjacent_faces[i], stroke, painted_faces, back_side);
            ++i;
        }
        return painted_faces;
    }

    public Vector3 teddyVector3_to_jaliceVector3(teddy.Vector3 v) {
        return new Vector3(v.x, v.y, v.z);
    }

    public Vertex jaliceVector3_to_teddyVector3(Vector3 v) {
        return new Vertex(v.x, v.y, v.z);
    }

    public SurfacePath getSurroundingSurfacePath(SurfacePath surfacePath) {
        return new SurroundingSurfacePath(this.subdivMesh.skin_mesh, surfacePath);
    }

    public void extrude(SurfacePath path, Vector stroke) {
        TmpCamera camera = new TmpCamera();
        stroke = CleanStroke.clean((Vector)stroke, (int)20, (int)50, (boolean)false);
        stroke.removeElementAt(0);
        stroke.removeElementAt(stroke.size() - 1);
        this.surfacePath = this.subdivMesh.extrude(path, stroke, (CameraInterface)camera);
        this.init();
        if (this.surfacePath != null) {
            this.addSurfaceLine(this.surfacePath, SurfaceLine.GREEN);
        }
    }

    public void addSurfaceLine(SurfacePath surfacePath, edu.cmu.cs.stage3.alice.scenegraph.Color color) {
        this.surfaceLine = new SurfaceLine(this, color);
        int i = 0;
        while (i < surfacePath.size()) {
            Vector3 normal = this.teddyVector3_to_jaliceVector3(surfacePath.getNormal(i));
            Vector3 pos = this.teddyVertex_to_jaliceVector3(surfacePath.getVertex(i));
            this.surfaceLine.addPoint(pos, normal);
            ++i;
        }
        if (surfacePath.loop) {
            Vector3 normal = this.teddyVector3_to_jaliceVector3(surfacePath.getNormal(0));
            Vector3 pos = this.teddyVertex_to_jaliceVector3(surfacePath.getVertex(0));
            this.surfaceLine.addPoint(pos, normal);
        }
        this.surfaceLine.lineVisual().setParent((Container)this.modelVehicle);
    }

    public void split_and_collapse() {
        this.refreshGeometry();
    }

    public SurfacePath getSurfacePath(Vector stroke, boolean loop) {
        stroke = CleanStroke.clean((Vector)stroke, (int)20, (int)50, (boolean)loop);
        TmpCamera camera = new TmpCamera();
        return SurfacePath.getSurfacePath((Polyhedron)this.subdivMesh.skin_mesh, (Vector)stroke, (CameraInterface)camera, (boolean)loop);
    }

    public Model copy() {
        Model model = new Model(null);
        model.parentModel = this.parentModel;
        model.childrenModels = Util.duplicateVector(this.childrenModels);
        model.subdivMesh = this.subdivMesh.copy();
        model.modelVehicle.setTransformation((Matrix4d)this.modelVehicle.getTransformation(null), null);
        return model;
    }

    public void updateGeometry_sharp(Polyhedron polyhedron) {
        Vertex3d[] modelVertices = new Vertex3d[polyhedron.n_polygons * 3];
        int[] modelIndices = new int[polyhedron.n_polygons * 3];
        int i = 0;
        while (i < polyhedron.n_polygons) {
            Patch patch = polyhedron.polygons[i].patch;
            int j = 0;
            while (j < 3) {
                Vertex v = polyhedron.polygons[i].get_vertex(j);
                teddy.Vector3 normal = v.get_sharp_normal(polyhedron.polygons[i]);
                modelVertices[i * 3 + j] = this.teddyVertex_to_jaliceVertex(v, normal);
                modelIndices[i * 3 + j] = i * 3 + j;
                ++j;
            }
            ++i;
        }
        this.modelITA.setVertices(modelVertices);
        this.modelITA.setIndices(modelIndices);
        this.compute_faces();
        this.packedTexture.reset_uvs();
    }

    public static Vector adjust_stroke_direction(Vector stroke) {
        double total_area = 0.0;
        Point prev = (Point)stroke.elementAt(stroke.size() - 1);
        int i = 0;
        while (i < stroke.size()) {
            Point next = (Point)stroke.elementAt(i);
            total_area += (double)((prev.y + next.y) * (next.x - prev.x));
            prev = next;
            ++i;
        }
        if (total_area < 0.0) {
            return Util.reverseVector(stroke);
        }
        return stroke;
    }

    public void init() {
        if (JaliceTeddy.auto_remesh && JaliceTeddy.animation) {
            this.setStyle();
            this.refreshGeometry_without_refinement();
            this.start_animation();
        } else {
            if (JaliceTeddy.auto_remesh) {
                this.subdivMesh.refine(true);
            }
            this.update();
        }
    }

    public void refreshGeometry() {
        this.updateGeometry(this.subdivMesh.skin_mesh, !JaliceTeddy.wireframe && JaliceTeddy.refinement);
    }

    public int getVertexCount() {
        return this.subdivMesh.skin_mesh.n_vertices;
    }

    public boolean face_is_painted(Face face, Stroke stroke) {
        Vertex2D a = this.vertices2d[face.vertices[0]];
        Vertex2D b = this.vertices2d[face.vertices[1]];
        Vertex2D c = this.vertices2d[face.vertices[2]];
        if (stroke.contains(a) || stroke.contains(b) || stroke.contains(c)) {
            return true;
        }
        return stroke.intersects(a, b) || stroke.intersects(b, c) || stroke.intersects(c, a);
    }

    public Vector getSeams() {
        return this.subdivMesh.skin_mesh.getSeams();
    }

    public boolean vertex_is_painted(Vertex3d v, Vector strokes) {
        Vector3 pp = JaliceTeddy.jaliceFrame.local_coords_to_screen_coords(new Vector3(v.position.x, v.position.y, v.position.z), (ReferenceFrame)this.modelVehicle);
        Point p = new Point((int)pp.x, (int)pp.y);
        int i = 0;
        while (i < strokes.size()) {
            Stroke stroke = (Stroke)strokes.elementAt(i);
            if (stroke.contains(p)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Model getRootModel() {
        if (this.parentModel == null) {
            return this;
        }
        return this.parentModel.getRootModel();
    }

    public Vertex jaliceVector3_to_teddyVertex(Vector3 v) {
        return new Vertex(v.x, v.y, v.z);
    }

    public void merge(Model child) {
        child.map_to_parent_coords();
        this.surfacePath = this.subdivMesh.merge(child.subdivMesh.skin_mesh, false);
        this.init();
        child.delete();
        if (this.surfacePath != null) {
            this.addSurfaceLine(this.surfacePath, SurfaceLine.GREEN);
        }
    }

    public void sliderCallback(double val) {
    }

    public void remesh() {
        this.subdivMesh.remesh();
        this.refreshGeometry();
    }

    public Vector getVertices() {
        return this.subdivMesh.skin_mesh.getVertices();
    }

    public Vector3[] pick_patch(Point p) {
        TmpCamera camera = new TmpCamera();
        SurfacePath surfacePath = new SurfacePath(this.subdivMesh.skin_mesh, (CameraInterface)camera);
        Vertex[] vertices = surfacePath.pick_quadratic_patch(p);
        Vector3[] coords = new Vector3[vertices.length];
        int i = 0;
        while (i < vertices.length) {
            coords[i] = this.teddyVertex_to_jaliceVector3(vertices[i]);
            ++i;
        }
        return coords;
    }

    public void update() {
        this.refreshGeometry();
        this.setStyle();
    }

    public void swap() {
        Skin.refine_mesh_connectivity((Polyhedron)this.subdivMesh.skin_mesh);
        this.refreshGeometry();
    }

    public void unsubdivide() {
        this.final_polyhedron = this.subdivMesh.skin_mesh.copy();
        this.updateGeometry_sharp(this.final_polyhedron);
    }

    public void set_original() {
        this.subdivMesh.set_skin_mesh_as_skeleton_mesh();
    }

    public Vector get_descendent_models() {
        Vector result = new Vector();
        result.addElement(this);
        int i = 0;
        while (i < this.childrenModels.size()) {
            result = Util.connectVector(result, ((Model)this.childrenModels.elementAt(i)).get_descendent_models());
            ++i;
        }
        return result;
    }

    public void updateGeometry(Polyhedron polyhedron, boolean refinement) {
        System.gc();
        if (refinement) {
            Polyhedron refined_polyhedron = polyhedron.copy();
            Skin.init_bodyPolygon_and_bodyVertex((Polyhedron)refined_polyhedron, (Polyhedron)polyhedron);
            QuadraticSubdivision.subdivide((Polyhedron)refined_polyhedron);
            polyhedron = refined_polyhedron;
        } else {
            polyhedron = polyhedron.copy();
        }
        this.final_polyhedron = polyhedron;
        this.updateGeometry_sharp(this.final_polyhedron);
        JaliceTeddy.jaliceFrame.repaint();
    }

    public void pop(SurfacePath surfacePath, Point p) {
        TmpCamera camera = new TmpCamera();
        if (surfacePath.inside(p, (CameraInterface)camera)) {
            this.subdivMesh.pop(surfacePath);
        } else {
            this.subdivMesh.pop(surfacePath);
        }
        this.refreshGeometry();
        this.slider_type = 1;
        JaliceTeddy.slider.activate(this);
        JaliceTeddy.slider.val = 0.5;
    }

    public Model getParentModel() {
        return this.parentModel;
    }

    Model() {
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[1] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -1;
        nArray2[1] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        nArray3[1] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[0] = -1;
        nArray4[1] = 1;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = 1;
        nArray5[1] = 1;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 1;
        nArray6[1] = -1;
        nArrayArray[5] = nArray6;
        this.model_data = nArrayArray;
        this.deleted = false;
        this.slider_type = 0;
    }

    Model(Vector _stroke, Scene scene) {
        this((Container)scene);
        Polyhedron polyhedron;
        _stroke = CleanStroke.clean((Vector)_stroke, (int)20, (int)100, (boolean)true);
        this.stroke = this.screen_coords_to_model_coords(_stroke);
        if (JaliceTeddy.symmetric_generation) {
            polyhedron = Generate.symmetric_generate((Vector)this.stroke, (double)0.85, (double)1.0);
            JaliceTeddy.symmetric_generation = false;
            this.symmetric = true;
        } else {
            polyhedron = JaliceTeddy.inflation_mode == 0 ? Generate.generate((Vector)this.stroke, (double)0.85, (double)1.0) : Generate.generate((Vector)this.stroke, (double)0.85, (double)0.1);
        }
        this.modelVehicle.setPosition((Vector3d)this.center, (ReferenceFrame)scene);
        this.subdivMesh = new SubdivMesh(polyhedron);
        this.init();
    }

    Model(Container parent) {
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[1] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -1;
        nArray2[1] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        nArray3[1] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[0] = -1;
        nArray4[1] = 1;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = 1;
        nArray5[1] = 1;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 1;
        nArray6[1] = -1;
        nArrayArray[5] = nArray6;
        this.model_data = nArrayArray;
        this.deleted = false;
        this.slider_type = 0;
        this.modelVehicle = new Transformable();
        this.modelVehicle.setParent(parent);
        this.modelVisual = new Visual();
        this.modelVisual.setParent((Container)this.modelVehicle);
        this.modelITA = new IndexedTriangleArray();
        this.modelVisual.setGeometry((Geometry)this.modelITA);
        this.modelAppearance = new Appearance();
        this.modelVisual.setFrontFacingAppearance(this.modelAppearance);
        this.modelTexture = new TextureMap();
        Image image = JaliceTeddy.jaliceFrame.awtComponent.createImage(1, 1);
        this.modelTexture.setImage(image);
        this.modelAppearance.setDiffuseColorMap(this.modelTexture);
        this.modelAppearance.setDiffuseColor(BODY_COLOR);
        this.modelAppearance.setFillingStyle(FillingStyle.WIREFRAME);
        this.modelAppearance.setShadingStyle(ShadingStyle.NONE);
        this.packedTexture = new PackedTexture(this);
    }

    Model(Polyhedron h, Model parentModel) {
        this((Container)parentModel.modelVehicle);
        this.parentModel = parentModel;
        parentModel.childrenModels.addElement(this);
        this.subdivMesh = new SubdivMesh(h);
        this.init();
    }

    Model(Model baseModel, Model parentModel) {
        this((Container)parentModel.modelVehicle);
        this.parentModel = parentModel;
        parentModel.childrenModels.addElement(this);
        this.subdivMesh = new SubdivMesh(baseModel.subdivMesh.skin_mesh.copy());
        this.update();
    }

    Model(Matrix44 matrix, Vector vertices, Vector indices, Vector seams, Vector sharps, Model parentModel) {
        this(null);
        this.modelVehicle.setTransformation((Matrix4d)matrix, null);
        if (parentModel != null) {
            this.modelVehicle.setParent((Container)parentModel.modelVehicle);
        }
        this.parentModel = parentModel;
        Polyhedron polyhedron = new Polyhedron(vertices, indices, seams, sharps);
        this.subdivMesh = new SubdivMesh(polyhedron);
        this.update();
    }

    public Vector3 pick_nearest_vertex(Point p) {
        TmpCamera camera = new TmpCamera();
        SurfacePath surfacePath = new SurfacePath(this.subdivMesh.skin_mesh, (CameraInterface)camera);
        return this.teddyVertex_to_jaliceVector3(surfacePath.pick_nearest_vertex(p));
    }

    public Vector getSharps() {
        return this.subdivMesh.skin_mesh.getSharps();
    }

    public void optimize() {
        this.subdivMesh.optimize_vertex();
        this.refreshGeometry();
    }

    public void map_to_parent_coords() {
        int i = 0;
        while (i < this.subdivMesh.skin_mesh.n_vertices) {
            Vertex v = this.subdivMesh.skin_mesh.vertices[i];
            Vector3 u = this.teddyVertex_to_jaliceVector3(v);
            u = JaliceTeddy.jaliceFrame.change_coords(u, (ReferenceFrame)this.modelVehicle, (ReferenceFrame)this.parentModel.modelVehicle);
            v.warp((teddy.Vector3)this.jaliceVector3_to_teddyVertex(u));
            ++i;
        }
        this.subdivMesh.skin_mesh.set_parameters();
        this.refreshGeometry();
        this.modelVehicle.setLocalTransformation((Matrix4d)Matrix44.IDENTITY);
    }

    public void crease(SurfacePath surfacePath) {
        this.subdivMesh.crease(surfacePath);
        if (JaliceTeddy.auto_remesh) {
            if (JaliceTeddy.animation) {
                this.start_animation();
            } else {
                this.subdivMesh.refine(false);
            }
        }
        this.update();
    }

    public Vector3 getNormal(int n) {
        return new Vector3(this.subdivMesh.skin_mesh.polygons[n].normal.x, this.subdivMesh.skin_mesh.polygons[n].normal.y, this.subdivMesh.skin_mesh.polygons[n].normal.z);
    }

    public void smooth() {
        this.subdivMesh.smooth(this.surfacePath);
        this.refreshGeometry();
    }

    public boolean back_facing(Face face) {
        Vertex2D a = this.vertices2d[face.vertices[0]];
        Vertex2D b = this.vertices2d[face.vertices[1]];
        Vertex2D c = this.vertices2d[face.vertices[2]];
        return Geometry2D.left_side((Vertex2D)a, (Vertex2D)b, (Vertex2D)c);
    }

    public boolean back_facing(int face_index) {
        Vertex2D a = this.vertices2d[face_index * 3];
        Vertex2D b = this.vertices2d[face_index * 3 + 1];
        Vertex2D c = this.vertices2d[face_index * 3 + 2];
        return Geometry2D.left_side((Vertex2D)a, (Vertex2D)b, (Vertex2D)c);
    }

    public void beautify() {
        this.subdivMesh.remesh();
        this.subdivMesh.drift(5);
        this.subdivMesh.set_skin_mesh_as_skeleton_mesh();
        this.subdivMesh.remesh();
        this.subdivMesh.drift(5);
        this.refreshGeometry();
    }

    public Vector pick_nearby_vertices(Point p) {
        TmpCamera camera = new TmpCamera();
        SurfacePath surfacePath = new SurfacePath(this.subdivMesh.skin_mesh, (CameraInterface)camera);
        Vector vs = surfacePath.pick_nearby_vertices(p);
        Vector<Vector3> result = new Vector<Vector3>();
        int i = 0;
        while (i < vs.size()) {
            Vertex v = (Vertex)vs.elementAt(i);
            result.addElement(this.teddyVertex_to_jaliceVector3(v));
            ++i;
        }
        return result;
    }

    public Vector getIndices() {
        return this.subdivMesh.skin_mesh.getIndices();
    }

    public void compute_faces() {
        int[] indices = this.modelITA.getIndices();
        this.faces = new Face[indices.length / 3];
        int i = 0;
        while (i < indices.length / 3) {
            this.faces[i] = new Face(i, indices[i * 3], indices[i * 3 + 1], indices[i * 3 + 2]);
            this.final_polyhedron.polygons[i].index = i;
            ++i;
        }
        i = 0;
        while (i < this.final_polyhedron.n_polygons) {
            Polygon2 face = this.final_polyhedron.polygons[i];
            int j = 0;
            while (j < 3) {
                if (!face.edges[j].sharp) {
                    Polygon2 f = face.edges[j].get_another_polygon(face);
                    this.faces[i].adjacent_faces[j] = this.faces[f.index];
                } else {
                    this.faces[i].adjacent_faces[j] = null;
                }
                ++j;
            }
            ++i;
        }
    }

    public int pick_face(Point p, boolean get_back_side) {
        int[] faces = this.modelITA.getIndices();
        int i = 0;
        while (i < faces.length / 3) {
            Vertex2D a = this.vertices2d[faces[i * 3]];
            Vertex2D b = this.vertices2d[faces[i * 3 + 1]];
            Vertex2D c = this.vertices2d[faces[i * 3 + 2]];
            if (!get_back_side ? !Geometry2D.left_side((Vertex2D)a, (Vertex2D)b, (Point)p) && !Geometry2D.left_side((Vertex2D)b, (Vertex2D)c, (Point)p) && !Geometry2D.left_side((Vertex2D)c, (Vertex2D)a, (Point)p) : Geometry2D.left_side((Vertex2D)a, (Vertex2D)b, (Point)p) && Geometry2D.left_side((Vertex2D)b, (Vertex2D)c, (Point)p) && Geometry2D.left_side((Vertex2D)c, (Vertex2D)a, (Point)p)) {
                return i;
            }
            ++i;
        }
        System.out.println("pick failed (Model.pick_face())");
        return -1;
    }

    public void delete() {
        if (this.deleted) {
            return;
        }
        this.deleted = true;
        if (this.modelVehicle != null) {
            this.modelVehicle.setParent(null);
        }
        JaliceTeddy.models.removeElement(this);
        if (this.parentModel != null) {
            this.parentModel.childrenModels.removeElement(this);
        }
        Vector _childrenModels = Util.duplicateVector(this.childrenModels);
        int i = 0;
        while (i < _childrenModels.size()) {
            ((Model)_childrenModels.elementAt(i)).delete();
            ++i;
        }
    }

    public void fillet() {
        this.subdivMesh.fillet(this.surfacePath);
        this.refreshGeometry();
    }

    public void get_painted_faces_propagate(Face face, Stroke stroke, Vector painted_faces, boolean back_side) {
        if (face == null) {
            return;
        }
        if (painted_faces.contains(face)) {
            return;
        }
        if (this.back_facing(face) == !back_side) {
            return;
        }
        if (!this.face_is_painted(face, stroke)) {
            return;
        }
        painted_faces.addElement(face);
        int i = 0;
        while (i < 3) {
            this.get_painted_faces_propagate(face.adjacent_faces[i], stroke, painted_faces, back_side);
            ++i;
        }
    }

    public Vector3 teddyVertex_to_jaliceVector3(Vertex v) {
        return new Vector3(v.x, v.y, v.z);
    }

    public void divide() {
        this.refreshGeometry();
    }

    public void subdivide() {
        QuadraticSubdivision.subdivide((Polyhedron)this.final_polyhedron);
        this.updateGeometry_sharp(this.final_polyhedron);
    }

    public void subdivide(String type) {
        if (type.equals("Quadratic")) {
            QuadraticSubdivision.subdivide((Polyhedron)this.final_polyhedron);
        } else if (type.equals("PNTriangle")) {
            this.final_polyhedron.set_normals();
            PNsubdivision.subdivide((Polyhedron)this.final_polyhedron);
        } else if (type.equals("Butterfly")) {
            ButterflySubdivision.subdivide((Polyhedron)this.final_polyhedron);
        } else if (type.equals("Loop")) {
            LoopSubdivision.subdivide((Polyhedron)this.final_polyhedron);
        } else if (type.equals("RadialBasis")) {
            VariationalSubdivision.subdivide((Polyhedron)this.final_polyhedron);
        }
        this.updateGeometry_sharp(this.final_polyhedron);
    }

    class TmpCamera
    implements CameraInterface {
        TmpCamera() {
            Model.this.getClass();
        }

        public Vertex get_camera_position() {
            return Model.this.jaliceVector3_to_teddyVertex(JaliceTeddy.jaliceFrame.cameraVehicle.getPosition((ReferenceFrame)Model.this.modelVehicle));
        }

        public teddy.Vector3 get_camera_lay(Vertex2D v) {
            if (JaliceTeddy.jaliceFrame.camera instanceof OrthographicCamera) {
                return Model.this.jaliceVector3_to_teddyVector3(JaliceTeddy.jaliceFrame.getCameraDirection((ReferenceFrame)Model.this.modelVehicle));
            }
            Vector3 vec = Vector3.subtract((Vector3d)JaliceTeddy.jaliceFrame.screen_coords_to_local_coords(v.x, v.y, (ReferenceFrame)Model.this.modelVehicle), (Vector3d)JaliceTeddy.jaliceFrame.cameraVehicle.getPosition((ReferenceFrame)Model.this.modelVehicle));
            vec.normalize();
            return Model.this.jaliceVector3_to_teddyVector3(vec);
        }

        public Vertex2D local_coords_to_screen_coords(Vertex v) {
            Vector3 p = JaliceTeddy.jaliceFrame.local_coords_to_screen_coords(Model.this.teddyVertex_to_jaliceVector3(v), (ReferenceFrame)Model.this.modelVehicle);
            return new Vertex2D(p.x, p.y);
        }

        public Vertex screen_coords_to_local_coords(Vertex2D v) {
            return Model.this.jaliceVector3_to_teddyVertex(JaliceTeddy.jaliceFrame.screen_coords_to_local_coords(v.x, v.y, (ReferenceFrame)Model.this.modelVehicle));
        }

        public boolean front_facing(Vertex _base, teddy.Vector3 _normal) {
            Vector3 base = Model.this.teddyVertex_to_jaliceVector3(_base);
            Vector3 normal = Model.this.teddyVector3_to_jaliceVector3(_normal);
            if (JaliceTeddy.jaliceFrame.camera instanceof OrthographicCamera) {
                return Vector3.dotProduct((Vector3d)normal, (Vector3d)JaliceTeddy.jaliceFrame.getCameraDirection((ReferenceFrame)Model.this.modelVehicle)) < 0.0;
            }
            Vector3 camera_to_base = Vector3.subtract((Vector3d)base, (Vector3d)JaliceTeddy.jaliceFrame.cameraVehicle.getPosition((ReferenceFrame)Model.this.modelVehicle));
            return Vector3.dotProduct((Vector3d)normal, (Vector3d)camera_to_base) < 0.0;
        }
    }

    class Face {
        int index;
        int[] vertices;
        Face[] adjacent_faces;

        Face(int i, int a, int b, int c) {
            Model.this.getClass();
            this.vertices = new int[3];
            this.adjacent_faces = new Face[3];
            this.index = i;
            this.vertices[0] = a;
            this.vertices[1] = b;
            this.vertices[2] = c;
        }
    }
}

