/*
 * Decompiled with CFR 0.152.
 */
package ui;

import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Vector3;
import java.util.Vector;
import javax.vecmath.Vector3d;
import ui.BrushPanel;
import ui.Model;
import ui.Util;

public class Mirror {
    public static Vector mirror(Model baseModel) {
        Model axisModel = baseModel.getParentModel();
        if (axisModel == null) {
            return null;
        }
        return Mirror.mirror_sub(baseModel, axisModel, axisModel);
    }

    public static Vector mirror_sub(Model baseModel, Model axisModel, Model parentModel) {
        Model newModel = new Model(baseModel, parentModel);
        newModel.init_dunk_color(BrushPanel.color);
        Vector3 center = baseModel.modelVehicle.getPosition((ReferenceFrame)axisModel.modelVehicle);
        if (axisModel.symmetric) {
            center.x = -center.x;
        } else {
            center.z = -center.z;
        }
        newModel.modelVehicle.setPosition((Vector3d)center, (ReferenceFrame)axisModel.modelVehicle);
        Matrix33 axes = baseModel.modelVehicle.getAxes((ReferenceFrame)axisModel.modelVehicle);
        Vector3 forward = axes.getRow(2);
        Vector3 up = axes.getRow(1);
        if (axisModel.symmetric) {
            forward.x = -forward.x;
            up.x = -up.x;
        } else {
            forward.z = -forward.z;
            up.z = -up.z;
        }
        forward.multiply(-1.0);
        newModel.modelVehicle.setOrientation((Vector3d)forward, (Vector3d)up, (ReferenceFrame)axisModel.modelVehicle);
        Vector models = new Vector();
        models.addElement(newModel);
        int i = 0;
        while (i < baseModel.childrenModels.size()) {
            models = Util.connectVector(models, Mirror.mirror_sub((Model)baseModel.childrenModels.elementAt(i), axisModel, newModel));
            ++i;
        }
        return models;
    }
}

