/*
 * Decompiled with CFR 0.152.
 */
package ui;

import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.alice.scenegraph.io.XML;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.PickInfo;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Vector3;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.vecmath.Vector3d;
import teddy.Graphics2;
import teddy.StrokeAnalyzer;
import teddy.SurfacePath;
import teddy.Vector2;
import ui.AsgFile;
import ui.BrushPanel;
import ui.EventHandler;
import ui.Extrusion;
import ui.JaliceFrame;
import ui.Mirror;
import ui.Model;
import ui.MyMenuBar;
import ui.MyThread;
import ui.ObjFile;
import ui.Painter;
import ui.Plane;
import ui.PlaySound;
import ui.ProgressBar;
import ui.Slider;
import ui.Stroke;
import ui.SurfaceLine;
import ui.ToolPanel;
import ui.Undo;
import ui.Util;
import ui.VrmlConv;

public class JaliceTeddy
implements EventHandler {
    public static boolean wireframe = false;
    public static boolean auto_remesh = true;
    public static boolean animation = true;
    public static boolean refinement = false;
    public static boolean expert_mode = false;
    public Color STROKE_COLOR = new Color(245, 35, 35);
    public Stroke stroke = new Stroke();
    boolean paint_string = true;
    public final int CENTER_R = 10;
    public Point center_p;
    Painter painter;
    boolean painting = false;
    public static MyThread refine_thread;
    public static int refine_step;
    public static int refine_step_max;
    public static Vector models;
    Point dunk_requested = null;
    public static int pickModel_along_stroke_index;
    public int TRASH_SIZE = 50;
    public Model targetModel;
    public int ongoing_operation;
    public final int POP = 1;
    public final int CUT = 2;
    public final int FILLET = 3;
    public static int inflation_mode;
    public static final int ROTUND = 0;
    public static final int PLATE = 1;
    Undo undo = new Undo(this);
    Vector3 drag_prev_normal;
    Visual pickedVisual;
    Transformable pickedVehicle;
    Model pickedModel;
    static int operation_status;
    final int NONE = 0;
    final int DRAWING = 1;
    final int ROTATING = 2;
    final int SLIDING = 3;
    final int DRAG_CENTER = 4;
    final int ZOOMING = 5;
    Point prev_p;
    public static boolean symmetric_generation;
    static boolean sharp_edge;
    public static Slider slider;
    public static JaliceTeddy jaliceTeddy;
    public static JaliceFrame jaliceFrame;
    public static String renderername;

    public void drag_center(Point p) {
        Model parent = this.pickedModel.parentModel;
        Vector3[] vs = parent.pick_localPt_follow(p);
        if (vs != null) {
            this.pickedModel.modelVehicle.setPosition((Vector3d)vs[0], (ReferenceFrame)parent.modelVehicle);
            Vector3 normal = vs[1];
            normal.normalize();
            if (this.drag_prev_normal != null) {
                Vector3 axis = Vector3.crossProduct((Vector3d)this.drag_prev_normal, (Vector3d)normal);
                if (Vector3.getLengthSquared((double)axis.x, (double)axis.y, (double)axis.z) == 0.0) {
                    return;
                }
                axis.normalize();
                Vector3 x0 = this.drag_prev_normal;
                Vector3 y0 = axis;
                Vector3 z0 = Vector3.crossProduct((Vector3d)x0, (Vector3d)y0);
                Vector3 x1 = normal;
                Vector3 y1 = axis;
                Vector3 z1 = Vector3.crossProduct((Vector3d)x1, (Vector3d)y1);
                z0.normalize();
                z1.normalize();
                Matrix33 axes = this.pickedModel.modelVehicle.getAxes((ReferenceFrame)parent.modelVehicle);
                Vector3 forward = axes.getRow(2);
                Vector3 up = axes.getRow(1);
                forward = JaliceTeddy.map(forward, x0, y0, z0, x1, y1, z1);
                up = JaliceTeddy.map(up, x0, y0, z0, x1, y1, z1);
                forward.normalize();
                up.normalize();
                this.pickedModel.modelVehicle.setOrientation((Vector3d)forward, (Vector3d)up, (ReferenceFrame)parent.modelVehicle);
            }
            this.drag_prev_normal = normal;
        }
    }

    public static Vector3 map(Vector3 vector, Vector3 x0, Vector3 y0, Vector3 z0, Vector3 x1, Vector3 y1, Vector3 z1) {
        double x = Vector3.dotProduct((Vector3d)vector, (Vector3d)x0);
        double y = Vector3.dotProduct((Vector3d)vector, (Vector3d)y0);
        double z = Vector3.dotProduct((Vector3d)vector, (Vector3d)z0);
        return Vector3.add((Vector3d)Vector3.add((Vector3d)Vector3.multiply((Vector3d)x1, (double)x), (Vector3d)Vector3.multiply((Vector3d)y1, (double)y)), (Vector3d)Vector3.multiply((Vector3d)z1, (double)z));
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (refine_thread != null && refine_thread.isAlive()) {
            refine_thread.setPriority(5);
        }
        if (slider.mouseReleased(mouseEvent.getPoint())) {
            return;
        }
        switch (operation_status) {
            case 4: {
                System.out.println("finish_drag_center");
                break;
            }
            case 1: {
                if ((mouseEvent.getModifiers() & 1) != 0) break;
                this.finishStroke();
                break;
            }
            case 2: 
            case 3: {
                if (this.pickedVisual != null) {
                    // empty if block
                } else {
                    break;
                }
            }
        }
        operation_status = 0;
        jaliceFrame.repaint();
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32) {
            this.style();
        } else if (e.getKeyCode() == 83) {
            sharp_edge = !sharp_edge;
            int i = 0;
            while (i < models.size()) {
                ((Model)models.elementAt(i)).refreshGeometry();
                ++i;
            }
        }
    }

    public void add_point(Point p) {
        if (this.stroke.loop) {
            return;
        }
        this.stroke.addElement(p);
        if (this.stroke.size() > 4) {
            Point q = (Point)this.stroke.elementAt(0);
            double length = StrokeAnalyzer.getLength_Points((Vector)this.stroke, (boolean)false);
            if (Math.min(length / 10.0, 30.0) > Vector2.distance((Point)p, (Point)q)) {
                PlaySound.play("piro.wav");
                this.stroke.loop = true;
            }
        }
    }

    public void refinement() {
        refinement = !refinement;
        System.out.println("refinement " + refinement);
    }

    public void mirror() {
        this.mirror(this.pickedModel);
    }

    public void mirror(Model model) {
        if (model.parentModel == null) {
            return;
        }
        PlaySound.play("pop.wav");
        this.pushUndo();
        Vector newModels = Mirror.mirror(model);
        if (newModels != null) {
            int i = 0;
            while (i < newModels.size()) {
                models.addElement((Model)newModels.elementAt(i));
                ++i;
            }
        }
        this.pickedModel = model.parentModel;
    }

    public void drift() {
        this.pickedModel.drift();
    }

    public void click(Point p) {
        block2: {
            block4: {
                block3: {
                    if (this.targetModel == null) break block2;
                    this.pickedModel = this.targetModel;
                    if (this.ongoing_operation != 1) break block3;
                    if (this.pickedModel.surfacePath.loop) {
                        this.pushUndo();
                        this.pickedModel.surfaceLine.delete();
                        this.pickedModel.pop(this.pickedModel.surfacePath, p);
                    } else {
                        this.pushUndo();
                        this.pickedModel.crease(this.pickedModel.surfacePath);
                        this.pickedModel.surfaceLine.delete();
                    }
                    this.ongoing_operation = 0;
                    this.targetModel = null;
                    break block2;
                }
                if (this.ongoing_operation != 2) break block4;
                this.pickedModel.surfaceLine.delete();
                this.cut(this.pickedModel);
                break block2;
            }
            if (this.ongoing_operation != 3) break block2;
            this.pickedModel.surfaceLine.delete();
            this.ongoing_operation = 0;
            this.targetModel = null;
        }
    }

    public void cut(Model pickedModel) {
        if (pickedModel.surfacePath == null) {
            return;
        }
        PlaySound.play("cut.wav");
        this.pushUndo();
        pickedModel.cut(pickedModel.surfacePath);
        if (!expert_mode) {
            pickedModel.surfaceLine.delete();
            pickedModel.surfaceLine = null;
        }
        if (pickedModel.surfaceLine != null) {
            this.ongoing_operation = 3;
        } else {
            this.ongoing_operation = 0;
            this.targetModel = null;
        }
    }

    public void auto_remesh() {
        auto_remesh = !auto_remesh;
        System.out.println("auto_remesh " + auto_remesh);
    }

    public void exportToAlice() {
        FileDialog fileDialog = new FileDialog((Frame)jaliceFrame, "Export to Alice", 1);
        fileDialog.setDirectory(".\\");
        fileDialog.setFile("*.asg");
        ((Component)fileDialog).setVisible(true);
        if (fileDialog.getFile() != null) {
            String filename = fileDialog.getDirectory() + fileDialog.getFile();
            this.exportToAlice(filename);
        }
        fileDialog.dispose();
    }

    public void exportToAlice(String filename) {
        if (this.painting) {
            this.painter.flush_strokes();
            this.painter.recover_permanent_texturemap();
        }
        try {
            FileOutputStream os = new FileOutputStream(filename);
            XML.store((edu.cmu.cs.stage3.alice.scenegraph.Component)((Model)JaliceTeddy.models.elementAt((int)0)).modelVehicle, (OutputStream)os);
            ((OutputStream)os).close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (this.painting) {
            this.painter.associate_temporary_texturemap();
        }
    }

    public void taubin() {
        this.pickedModel.taubin();
    }

    public void zooming(Point p, Point prev_p) {
        JaliceTeddy.jaliceFrame.scale *= Math.pow(1.02, prev_p.y - p.y);
        jaliceFrame.set_camera_parameters();
        prev_p.x = p.x;
        prev_p.y = p.y;
    }

    public void generate() {
        if (models.size() != 0) {
            return;
        }
        PlaySound.play("pop.wav");
        this.pushUndo();
        this.pickedModel = new Model(this.stroke, JaliceTeddy.jaliceFrame.scene);
        this.pickedModel.init_dunk_color(BrushPanel.color);
        this.clear_stroke();
        models.addElement(this.pickedModel);
        this.pickedModel.slider_type = 0;
        slider.activate(this.pickedModel);
        JaliceTeddy.slider.val = 1.0;
        this.targetModel = null;
        this.ongoing_operation = 0;
    }

    public void draw_cut_line(Model pickedModel) {
        SurfacePath surfacePath = pickedModel.getSurfacePath(this.stroke, false);
        if (surfacePath == null) {
            pickedModel.surfacePath = null;
            return;
        }
        surfacePath.loop = true;
        pickedModel.surfacePath = surfacePath;
        this.ongoing_operation = 2;
        this.targetModel = pickedModel;
        jaliceFrame.repaint();
    }

    public void extrude(Model model) {
        this.pushUndo();
        this.pickedModel.surfaceLine.delete();
        this.targetModel.extrude(this.pickedModel.surfacePath, this.stroke);
        this.clear_stroke();
        if (this.pickedModel.surfaceLine != null) {
            this.ongoing_operation = 3;
        } else {
            this.ongoing_operation = 0;
            this.targetModel = null;
        }
    }

    public void instant_extrude(Model model) {
        PlaySound.play("pop.wav");
        this.pushUndo();
        Model parentModel = model;
        this.pickedModel = Extrusion.instant_extrude(parentModel, this.stroke);
        models.addElement(this.pickedModel);
        this.clear_stroke();
        this.ongoing_operation = 0;
        this.targetModel = null;
    }

    public void rotate(Transformable pickedVehicle, Point p, Point prev_p) {
        Vector3 pos = pickedVehicle.getPosition((ReferenceFrame)JaliceTeddy.jaliceFrame.scene);
        pickedVehicle.setPosition((Vector3d)new Vector3(), (ReferenceFrame)JaliceTeddy.jaliceFrame.scene);
        pickedVehicle.rotate((Vector3d)Vector3.Y_AXIS, (double)(-(p.x - prev_p.x)) / 100.0, (ReferenceFrame)JaliceTeddy.jaliceFrame.scene);
        pickedVehicle.rotate((Vector3d)Vector3.X_AXIS, (double)(-(p.y - prev_p.y)) / 100.0, (ReferenceFrame)JaliceTeddy.jaliceFrame.scene);
        pickedVehicle.setPosition((Vector3d)pos, (ReferenceFrame)JaliceTeddy.jaliceFrame.scene);
        prev_p.x = p.x;
        prev_p.y = p.y;
    }

    public void keyTyped(KeyEvent e) {
    }

    public void start_drag_center(Point p) {
        Model parent = this.pickedModel.parentModel;
        Vector3[] vs = parent.pick_localPt(p);
        if (vs != null) {
            this.drag_prev_normal = vs[1];
            this.drag_prev_normal.normalize();
        } else {
            this.drag_prev_normal = null;
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void stop_painter() {
        ToolPanel.toolPanel.set_brush(0);
        this.painter.close();
        jaliceFrame.setEventHandler(this);
        this.painting = false;
        jaliceFrame.repaint();
        MyMenuBar.modeMenu.setEnabled(true);
        MyMenuBar.meshMenu.setEnabled(true);
    }

    public boolean start_painter() {
        this.pickedModel = null;
        if (models.size() == 0) {
            return false;
        }
        if (this.painter == null) {
            this.painter = new Painter(this);
        }
        jaliceFrame.setEventHandler(this.painter);
        this.painter.open();
        this.painting = true;
        jaliceFrame.repaint();
        MyMenuBar.modeMenu.setEnabled(false);
        MyMenuBar.meshMenu.setEnabled(false);
        return true;
    }

    public void set_refinement(boolean flag) {
        refinement = flag;
        int i = 0;
        while (i < models.size()) {
            Model model = (Model)models.elementAt(i);
            model.refreshGeometry();
            ++i;
        }
    }

    public void set_rotund() {
        inflation_mode = 0;
    }

    public Model pickModel(int x, int y) {
        Visual visual = this.pickVisual(x, y);
        if (visual == null) {
            return null;
        }
        int i = 0;
        while (i < models.size()) {
            if (((Model)JaliceTeddy.models.elementAt((int)i)).modelVisual == visual) {
                return (Model)models.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public void pushUndo() {
        this.undo.pushUndo_modeling();
    }

    public Model pickModel(Visual pickedVisual) {
        Model pickedModel = null;
        int i = 0;
        while (i < models.size()) {
            Model m = (Model)models.elementAt(i);
            if (m.modelVisual == pickedVisual) {
                pickedModel = m;
            }
            ++i;
        }
        return pickedModel;
    }

    public Model find_nearest_model(Vector3 pos) {
        double min = 1000.0;
        Model pickedModel = null;
        int i = 0;
        while (i < models.size()) {
            Model m = (Model)models.elementAt(i);
            double distance = Vector3.subtract((Vector3d)pos, (Vector3d)m.modelVehicle.getPosition((ReferenceFrame)JaliceTeddy.jaliceFrame.scene)).getLength();
            if (distance < min) {
                min = distance;
                pickedModel = m;
            }
            ++i;
        }
        return pickedModel;
    }

    public void init() {
        this.clear();
        this.set_style(wireframe);
        this.importFromAlice("test.asg");
    }

    public boolean is_right_button(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 4) != 0 || (mouseEvent.getModifiers() & 1) != 0;
    }

    public void merge(Model model0, Model model1) {
        Model childModel = null;
        Model parentModel = null;
        if (model1 == model0.parentModel) {
            childModel = model0;
            parentModel = model1;
        } else if (model0 == model1.parentModel) {
            childModel = model1;
            parentModel = model0;
        } else {
            return;
        }
        PlaySound.play("merge.wav");
        this.pushUndo();
        parentModel.merge(childModel);
        this.pickedModel = this.targetModel = parentModel;
        this.pickedModel.fillet();
        this.pickedModel.surfaceLine.delete();
        this.ongoing_operation = 0;
        this.targetModel = null;
    }

    public void saveVrml() {
        if (models.size() == 0) {
            System.out.println("no save data.");
            return;
        }
        if (this.painting) {
            this.painter.flush_strokes();
            this.painter.recover_permanent_texturemap();
        }
        FileDialog fileDialog = new FileDialog((Frame)jaliceFrame, "Save VRML", 1);
        fileDialog.setDirectory(".\\");
        fileDialog.setFile("*.wrl");
        ((Component)fileDialog).setVisible(true);
        if (fileDialog.getFile() != null) {
            VrmlConv.saveToVrml((Model)models.elementAt(0), fileDialog.getDirectory(), fileDialog.getFile());
        }
        fileDialog.dispose();
    }

    public void symmetric() {
        symmetric_generation = !symmetric_generation;
        System.out.println("symmetric_generation = " + symmetric_generation);
    }

    public void remesh() {
        this.pickedModel.remesh();
    }

    public void clear_stroke() {
        this.stroke = new Stroke();
    }

    public void finishStroke() {
        JaliceTeddy.wait_while_refining();
        jaliceFrame.lock();
        if (this.stroke.size() < 5) {
            this.click((Point)this.stroke.elementAt(0));
        } else if (this.ongoing_operation == 1 || this.ongoing_operation == 2) {
            this.pickedModel = this.targetModel;
            if (this.stroke.loop) {
                this.extrude_separate(this.pickedModel);
            } else {
                this.extrude(this.pickedModel);
            }
        } else if (this.ongoing_operation == 3) {
            this.pickedModel = this.targetModel;
            this.fillet(this.pickedModel);
            this.ongoing_operation = 0;
            this.targetModel = null;
        } else if (this.stroke.size() > 0) {
            Point p = (Point)this.stroke.elementAt(0);
            this.pickedModel = this.pickModel(p.x, p.y);
            if (this.stroke.loop) {
                this.pickedModel = this.pickModel_along_stroke();
                if (this.pickedModel == null) {
                    this.generate();
                } else {
                    this.instant_extrude(this.pickedModel);
                }
            } else if (this.pickedModel != null) {
                Point q = (Point)this.stroke.elementAt(this.stroke.size() - 1);
                if (this.trashbox().contains(q)) {
                    this.delete();
                } else {
                    Model endModel = this.pickModel(q.x, q.y);
                    if (this.pickedModel == endModel) {
                        if (this.stroke.loop) {
                            this.drawSurfaceLine(this.pickedModel);
                        }
                    } else if (endModel == null) {
                        this.mirror();
                    } else {
                        this.merge(this.pickedModel, endModel);
                    }
                }
            } else {
                this.pickedModel = this.pickModel_along_stroke();
                if (this.pickedModel != null) {
                    this.draw_cut_line(this.pickedModel);
                    this.cut(this.pickedModel);
                }
            }
        }
        this.clear_stroke();
        jaliceFrame.unlock();
    }

    public Model pickModel_along_stroke() {
        if (models.size() == 0) {
            return null;
        }
        int i = 1;
        while (i < this.stroke.size()) {
            Point p = (Point)this.stroke.elementAt(i);
            this.pickedModel = this.pickModel(p.x, p.y);
            if (this.pickedModel != null) {
                pickModel_along_stroke_index = i;
                return this.pickedModel;
            }
            ++i;
        }
        return null;
    }

    public String get_label() {
        switch (this.ongoing_operation) {
            case 0: {
                return "";
            }
            case 1: {
                return "EXTRUSION / SMOOTH";
            }
            case 2: {
                return "EXTRUSION / CUT";
            }
            case 3: {
                return "FILLET";
            }
        }
        return "";
    }

    public void undo() {
        if (!this.undoable()) {
            return;
        }
        if (this.painting) {
            this.painter.undo();
            return;
        }
        this.clear_stroke();
        this.undo.popUndo();
        jaliceFrame.repaint();
        this.pickedModel = null;
        this.ongoing_operation = 0;
        this.targetModel = null;
    }

    public void importFromAlice() {
        FileDialog fileDialog = new FileDialog((Frame)jaliceFrame, "Import from Alice", 0);
        fileDialog.setDirectory(".\\");
        fileDialog.setFile("*.asg");
        ((Component)fileDialog).setVisible(true);
        if (fileDialog.getFile() != null) {
            String filename = fileDialog.getDirectory() + fileDialog.getFile();
            this.importFromAlice(filename);
        }
        fileDialog.dispose();
    }

    public void paintOverlay(Graphics g) {
        if (this.painting) {
            this.painter.paintOverlay(g);
        }
        if (this.paint_string) {
            g.setColor(Color.white);
            g.setFont(new Font("Serif", 0, 50));
            g.drawString(this.get_label(), 20, 50);
        }
        g.setColor(this.STROKE_COLOR);
        int i = 0;
        while (i < this.stroke.size() - 1) {
            Point p0 = (Point)this.stroke.elementAt(i);
            Point p1 = (Point)this.stroke.elementAt(i + 1);
            Graphics2.drawWideLine((Graphics)g, (int)p0.x, (int)p0.y, (int)p1.x, (int)p1.y, (double)8.0);
            ++i;
        }
        if (this.stroke.size() > 0 && this.pickedModel != null && this.ongoing_operation == 0) {
            this.paint_trashbox(g);
        }
        if (this.stroke.loop) {
            Point p = (Point)this.stroke.elementAt(0);
            Point q = (Point)this.stroke.elementAt(this.stroke.size() - 1);
            g.setColor(this.STROKE_COLOR);
            Graphics2.drawWideLine((Graphics)g, (int)p.x, (int)p.y, (int)q.x, (int)q.y, (double)8.0);
        }
        if (this.pickedModel != null && this.pickedModel.parentModel != null) {
            Vector3 pos = this.pickedModel.modelVehicle.getPosition((ReferenceFrame)JaliceTeddy.jaliceFrame.scene);
            Vector3 screen = jaliceFrame.scene_coords_to_screen_coords(pos);
            this.center_p = new Point((int)screen.x, (int)screen.y);
            g.setColor(Color.red);
            g.fillOval(this.center_p.x - 10, this.center_p.y - 10, 20, 20);
        } else {
            this.center_p = null;
        }
        if (refine_thread != null && refine_thread.isAlive()) {
            ProgressBar.paint(g, refine_step_max, refine_step, JaliceTeddy.jaliceFrame.awtComponent.getSize());
        }
    }

    public void importFromAlice(String filename) {
        try {
            FileInputStream is = new FileInputStream(filename);
            edu.cmu.cs.stage3.alice.scenegraph.Component component = XML.load((InputStream)is);
            component.setParent((Container)JaliceTeddy.jaliceFrame.scene);
            this.clear();
            models = AsgFile.load(component);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("File not found");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public Rectangle trashbox() {
        Dimension size = JaliceTeddy.jaliceFrame.awtComponent.getSize();
        return new Rectangle((int)((double)size.width - (double)this.TRASH_SIZE * 1.2), (int)((double)size.height - (double)this.TRASH_SIZE * 1.2), this.TRASH_SIZE, this.TRASH_SIZE);
    }

    public void start_stroke(Point p) {
        this.clear_stroke();
        this.add_point(p);
        this.pickedModel = this.pickModel(p.x, p.y);
    }

    public void extrude_separate(Model model) {
        Model parentModel = this.targetModel;
        parentModel.surfaceLine.delete();
        this.pickedModel = Extrusion.extrude(parentModel, this.stroke);
        this.clear_stroke();
        parentModel.surfaceLine.delete();
        models.addElement(this.pickedModel);
        this.pickedModel.slider_type = 0;
        slider.activate(this.pickedModel);
        JaliceTeddy.slider.val = 1.0;
        this.ongoing_operation = 0;
        this.targetModel = null;
    }

    public void split() {
        this.pickedModel.split_and_collapse();
    }

    public void load() {
        FileDialog fileDialog = new FileDialog((Frame)jaliceFrame, "Load Model", 0);
        fileDialog.setDirectory(".\\");
        fileDialog.setFile("*.obj");
        ((Component)fileDialog).setVisible(true);
        if (fileDialog.getFile() != null) {
            String filename = fileDialog.getDirectory() + fileDialog.getFile();
            this.load(filename);
        }
        fileDialog.dispose();
    }

    public void load(String filename) {
        Model model = ObjFile.load(filename);
        model.modelVehicle.setParent((Container)JaliceTeddy.jaliceFrame.scene);
        Vector loaded_models = model.get_descendent_models();
        models = Util.connectVector(models, loaded_models);
    }

    public void unsubdivide() {
        this.pickedModel.unsubdivide();
    }

    public void set_expert(boolean flag) {
        expert_mode = flag;
    }

    public void save() {
        FileDialog fileDialog = new FileDialog((Frame)jaliceFrame, "Save Model", 1);
        fileDialog.setDirectory(".\\");
        fileDialog.setFile("*.obj");
        ((Component)fileDialog).setVisible(true);
        if (fileDialog.getFile() != null) {
            String filename = fileDialog.getDirectory() + fileDialog.getFile();
            ObjFile.save((Model)models.elementAt(0), filename);
        }
        fileDialog.dispose();
    }

    public void set_original() {
        this.pickedModel.set_original();
    }

    public void style() {
        this.set_style(!wireframe);
    }

    public boolean undoable() {
        return this.undo.undoable();
    }

    public void animation() {
        animation = !animation;
        System.out.println("animation " + animation);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Point p;
        if (refine_thread != null && refine_thread.isAlive()) {
            refine_thread.setPriority(1);
        }
        this.prev_p = p = mouseEvent.getPoint();
        if (slider.mousePressed(p)) {
            return;
        }
        operation_status = 0;
        if (this.center_p != null && Vector2.distance((Point)this.center_p, (Point)p) < 10.0) {
            operation_status = 4;
            this.start_drag_center(p);
            return;
        }
        if (p.x > JaliceTeddy.jaliceFrame.awtComponent.getSize().width - 20) {
            operation_status = 5;
            return;
        }
        if ((mouseEvent.getModifiers() & 4) != 0 || (mouseEvent.getModifiers() & 1) != 0) {
            this.pickedVisual = this.pickVisual(mouseEvent.getX(), mouseEvent.getY());
            if (this.pickedVisual != null) {
                operation_status = 2;
                this.pickedVehicle = (Transformable)this.pickedVisual.getParent();
                this.pickedModel = null;
                int i = 0;
                while (i < models.size()) {
                    Model m = (Model)models.elementAt(i);
                    if (m.modelVisual == this.pickedVisual) {
                        this.pickedModel = m;
                    }
                    ++i;
                }
            } else {
                operation_status = 3;
                Plane plane = new Plane(new Vector3(0.0, 0.0, 0.0), new Vector3(0.0, 0.0, 1.0));
                Vector3 pos = plane.project(mouseEvent.getPoint());
                double min = 1000.0;
                this.pickedModel = null;
                int i = 0;
                while (i < models.size()) {
                    Model m = (Model)models.elementAt(i);
                    double distance = Vector3.subtract((Vector3d)pos, (Vector3d)m.modelVehicle.getPosition((ReferenceFrame)JaliceTeddy.jaliceFrame.scene)).getLength();
                    if (distance < min) {
                        min = distance;
                        this.pickedModel = m;
                    }
                    ++i;
                }
                if (this.pickedModel != null) {
                    this.pickedModel = this.pickedModel.getRootModel();
                    this.pickedVehicle = this.pickedModel.modelVehicle;
                }
            }
        } else {
            slider.disactivate();
            operation_status = 1;
            this.clear_stroke();
            this.start_stroke(mouseEvent.getPoint());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point p = mouseEvent.getPoint();
        if (slider.mouseDragged(p)) {
            jaliceFrame.repaint();
            return;
        }
        switch (operation_status) {
            case 1: {
                this.add_point(mouseEvent.getPoint());
                this.paint_string = false;
                jaliceFrame.repaintOverlay();
                this.paint_string = true;
                break;
            }
            case 2: {
                this.rotate(this.pickedVehicle, p, this.prev_p);
                break;
            }
            case 5: {
                this.zooming(p, this.prev_p);
                break;
            }
            case 3: {
                this.slide(this.pickedVehicle, p, this.prev_p);
                break;
            }
            case 4: {
                this.drag_center(p);
                break;
            }
        }
    }

    public JaliceTeddy() {
        jaliceTeddy = this;
        slider = new Slider();
    }

    public void optimize() {
        this.pickedModel.optimize();
    }

    public void tick() {
        if (this.dunk_requested != null) {
            Painter.dunk(this.dunk_requested);
        }
        this.dunk_requested = null;
    }

    public void smooth() {
        this.pickedModel.smooth();
        this.pickedModel.surfaceLine.delete();
    }

    public static void wait_while_refining() {
        if (refine_thread != null) {
            refine_thread.wait_until_finish();
        }
    }

    static {
        refine_step = 0;
        refine_step_max = 0;
        models = new Vector();
        symmetric_generation = false;
        sharp_edge = true;
    }

    public void beautify() {
        if (this.pickedModel == null) {
            this.pickedModel = (Model)models.elementAt(0);
        }
        this.pickedModel.beautify();
    }

    public void clear() {
        slider.disactivate();
        refine_thread = null;
        if (this.painting) {
            this.stop_painter();
        }
        this.clear_stroke();
        Vector _models = Util.duplicateVector(models);
        int i = 0;
        while (i < _models.size()) {
            ((Model)_models.elementAt(i)).delete();
            ++i;
        }
        models = new Vector();
        this.pickedModel = null;
        this.ongoing_operation = 0;
        this.targetModel = null;
        JaliceTeddy.jaliceFrame.scale = 0.8;
        jaliceFrame.set_camera_parameters();
        jaliceFrame.repaint();
    }

    public void drawSurfaceLine(Model pickedModel) {
        Vector stroke = this.stroke;
        if (this.stroke.loop) {
            stroke = Model.adjust_stroke_direction(stroke);
        }
        SurfacePath surfacePath = pickedModel.getSurfacePath(stroke, this.stroke.loop);
        if (surfacePath.path == null) {
            return;
        }
        pickedModel.surfacePath = surfacePath;
        pickedModel.addSurfaceLine(surfacePath, SurfaceLine.RED);
        if (pickedModel.surfacePath.loop) {
            this.ongoing_operation = 1;
            this.targetModel = pickedModel;
        }
        JaliceTeddy.jaliceFrame.renderTarget.markDirty();
    }

    public void fillet(Model model) {
        model.fillet();
        this.pickedModel.surfaceLine.delete();
        this.ongoing_operation = 0;
        this.targetModel = null;
    }

    public void paint_trashbox(Graphics g) {
        g.setColor(Color.red);
        Rectangle bbox = this.trashbox();
        g.translate(bbox.x, bbox.y);
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, 50, 17);
        g.fillRect(3, 17, 44, 32);
        g.setColor(Color.black);
        g.drawRect(0, 0, 50, 17);
        g.drawRect(3, 17, 44, 32);
        g.drawRect(9, 17, 32, 32);
        g.drawRect(19, 17, 11, 32);
        g.translate(-bbox.x, -bbox.y);
    }

    public void delete() {
        PlaySound.play("delete.wav");
        this.pushUndo();
        slider.disactivate();
        if (this.pickedModel != null) {
            this.pickedModel.delete();
        }
        this.pickedModel = null;
        jaliceFrame.repaint();
    }

    public void set_plate() {
        inflation_mode = 1;
    }

    public void subdivide(String type) {
        this.pickedModel.subdivide(type);
    }

    public void subdivide() {
        this.pickedModel.subdivide();
    }

    public void divide() {
        this.pickedModel.divide();
    }

    public void slide(Transformable pickedVehicle, Point p, Point prev_p) {
        Plane plane = new Plane(new Vector3(0.0, 0.0, 0.0), new Vector3(0.0, 0.0, 1.0));
        Vector3 pos = plane.project(new Point(p.x, p.y));
        Vector3 prev_pos = plane.project(new Point(prev_p.x, prev_p.y));
        Vector3 vec = Vector3.subtract((Vector3d)pos, (Vector3d)prev_pos);
        pickedVehicle.translate((Vector3d)vec, (ReferenceFrame)JaliceTeddy.jaliceFrame.cameraVehicle);
        prev_p.x = p.x;
        prev_p.y = p.y;
    }

    public Visual pickVisual(int x, int y) {
        PickInfo pickInfo = JaliceTeddy.jaliceFrame.renderTarget.pick(x, y, true, true);
        if (pickInfo == null) {
            return null;
        }
        Visual[] visuals = pickInfo.getVisuals();
        if (visuals == null) {
            return null;
        }
        if (visuals.length == 0) {
            return null;
        }
        return visuals[0];
    }

    public void set_style(boolean _wireframe) {
        wireframe = _wireframe;
        jaliceFrame.lock();
        int i = 0;
        while (i < models.size()) {
            ((Model)models.elementAt(i)).setStyle();
            ++i;
        }
        jaliceFrame.unlock();
    }
}

