/*
 * Decompiled with CFR 0.152.
 */
package ui;

import edu.cmu.cs.stage3.alice.scenegraph.AmbientLight;
import edu.cmu.cs.stage3.alice.scenegraph.Background;
import edu.cmu.cs.stage3.alice.scenegraph.Camera;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.DirectionalLight;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.OrthographicCamera;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.Scene;
import edu.cmu.cs.stage3.alice.scenegraph.TextureMap;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.VertexGeometry;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.OnscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.PickInfo;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.RenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.RendererInfo;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.directx7renderer.Renderer;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.event.OnscreenRenderTargetEvent;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.event.OnscreenRenderTargetListener;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.event.RenderTargetEvent;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.event.RendererEvent;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.event.RendererListener;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Vector3;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import teddy.Vertex;
import ui.BrushPanel;
import ui.Buttons;
import ui.EventHandler;
import ui.JaliceTeddy;
import ui.MyMenuBar;
import ui.SyncEvent;
import ui.ToolPanel;
import ui.VisualPickInfo;

public class JaliceFrame
extends Frame
implements WindowListener,
OnscreenRenderTargetListener,
RendererListener,
ComponentListener,
MouseListener,
MouseMotionListener,
KeyListener {
    public static final Color SUN_COLOR = new Color(0.6431372549019608, 0.6431372549019608, 0.6431372549019608);
    public static final Color AMBIENT_COLOR = new Color(0.39215686274509803, 0.39215686274509803, 0.39215686274509803);
    public static final Color BODY_COLOR = Color.WHITE;
    public static final Color ACTIVE_COLOR = Color.WHITE;
    public static Color BACKGROUND_COLOR = new Color(0.2901960784313726, 0.49019607843137253, 0.8);
    public RendererInfo rendererInfo;
    public OnscreenRenderTarget renderTarget;
    public MouseListener mouseListener;
    public MouseMotionListener mouseMotionListener;
    public JaliceTeddy target;
    public Scene scene;
    public Transformable cameraVehicle;
    public Visual groundVisual;
    public Color pickedColor = null;
    public Visual pickedVisual = null;
    public double prevTime = System.currentTimeMillis();
    Background background;
    AmbientLight ambientLight;
    DirectionalLight sunLight;
    public double scale;
    public Camera camera;
    public boolean render_occurred = false;
    Vector button_events = new Vector();
    edu.cmu.cs.stage3.alice.scenegraph.renderer.Renderer renderer;
    public Buttons buttons;
    public BrushPanel brushPanel;
    public Component awtComponent;
    EventHandler current_eventHandler;
    Vector events = new Vector();
    public boolean zooming = false;

    public void initRenderer(Camera camera) {
        Class cls = this.rendererInfo.getRendererClass();
        this.renderer = null;
        try {
            this.renderer = (edu.cmu.cs.stage3.alice.scenegraph.renderer.Renderer)cls.newInstance();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
        }
        if (this.renderer != null) {
            this.renderTarget = this.renderer.createHeavyweightOnscreenRenderTarget();
            if (this.renderer instanceof Renderer) {
                this.renderTarget.setDisplayDevice(this.renderer.getDisplayDrivers()[0].getFirstDevice(false));
            }
            this.awtComponent = this.renderTarget.getAWTComponent();
            this.add("Center", this.awtComponent);
            this.setEventHandler(this.target);
            this.awtComponent.addMouseListener(this);
            this.awtComponent.addMouseMotionListener(this);
            this.awtComponent.addKeyListener(this);
            this.setMenuBar(new MyMenuBar(this.target));
            Panel panel = new Panel();
            panel.setLayout(new BorderLayout());
            BrushPanel brushPanel = new BrushPanel();
            panel.add("South", brushPanel);
            ToolPanel toolPanel = new ToolPanel(this.target);
            panel.add("Center", toolPanel);
            toolPanel.set_brush(0);
            this.add("South", panel);
            this.invalidate();
            this.doLayout();
            panel.doLayout();
            this.renderTarget.addCamera(camera);
            this.renderTarget.addOnscreenRenderTargetListener((OnscreenRenderTargetListener)this);
            this.renderTarget.getRenderer().addRendererListener((RendererListener)this);
        }
    }

    public void componentShown(ComponentEvent e) {
    }

    public Vector3 change_coords(Vector3 v, ReferenceFrame current, ReferenceFrame target) {
        Transformable dammy = new Transformable();
        dammy.setParent((Container)this.scene);
        dammy.setPosition((Vector3d)v, current);
        Vector3 w = dammy.getPosition(target);
        dammy.setParent(null);
        return w;
    }

    public void simulate(double currTime) {
        double dt = currTime - this.prevTime;
        if (dt > 0.0 && this.pickedVisual != null && this.pickedVisual != this.groundVisual) {
            Transformable trans = (Transformable)this.pickedVisual.getParent();
            trans.rotate((Vector3d)Vector3.Z_AXIS, dt, null);
        }
        this.prevTime = currTime;
    }

    public void componentResized(ComponentEvent e) {
        int width = this.getSize().width;
        int height = this.getSize().height;
        if (width > 520 || height > 651) {
            ((Component)this).setSize(Math.min(width, 520), Math.min(height, 651));
        }
        this.set_camera_parameters();
        this.events.addElement(e);
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void cleared(RenderTargetEvent renderTargetEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.events.addElement(mouseEvent);
    }

    public void keyPressed(KeyEvent e) {
        this.target.keyPressed(e);
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.exit(0);
    }

    public void repaintOverlay() {
        this.paint(this.renderTarget.getAWTComponent().getGraphics());
    }

    public TextureMap loadTextureMap(String dirname) {
        Toolkit toolkit = this.getToolkit();
        Image image = toolkit.getImage("samples/media/ground/texture.jpg");
        while (image.getWidth(this) == -1 && image.getWidth(this) == -1) {
            Thread.yield();
        }
        TextureMap textureMap = new TextureMap();
        textureMap.setImage(image);
        return textureMap;
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.camera = this.initSceneGraph();
        this.initRenderer(this.camera);
        this.target.init();
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Camera initSceneGraph() {
        this.scene = new Scene();
        this.cameraVehicle = new Transformable();
        this.cameraVehicle.setParent((Container)this.scene);
        OrthographicCamera camera = new OrthographicCamera();
        camera.setParent((Container)this.cameraVehicle);
        this.background = new Background();
        this.background.setColor(BACKGROUND_COLOR);
        this.scene.setBackground(this.background);
        this.ambientLight = new AmbientLight();
        this.ambientLight.setParent((Container)this.scene);
        this.ambientLight.setColor(AMBIENT_COLOR);
        Transformable sunVehicle = new Transformable();
        sunVehicle.setParent((Container)this.scene);
        this.sunLight = new DirectionalLight();
        this.sunLight.setColor(SUN_COLOR);
        this.sunLight.setParent((Container)sunVehicle);
        sunVehicle.setOrientation((Vector3d)new Vector3(0.0, 0.0, 1.0), (Vector3d)Vector3.Y_AXIS, null);
        this.cameraVehicle.setPosition((Vector3d)new Vector3(0.0, 0.0, -4.0), null);
        this.cameraVehicle.pointAt((ReferenceFrame)this.scene, (Vector3d)new Vector3(), (Vector3d)Vector3.Y_AXIS, (ReferenceFrame)this.scene);
        return camera;
    }

    public void setEventHandler(EventHandler eventHandler) {
        this.current_eventHandler = eventHandler;
    }

    public void unlock() {
        if (this.renderTarget != null) {
            this.renderTarget.setUpdateIsAutomatic(true);
        }
    }

    public IndexedTriangleArray loadIndexedTriangleArray(String dirname) {
        IndexedTriangleArray ita = new IndexedTriangleArray();
        try {
            FileInputStream is = new FileInputStream(new File(dirname + "/vertices.bin"));
            VertexGeometry.loadVertices((InputStream)is);
            ((InputStream)is).close();
            is = new FileInputStream(new File(dirname + "/indices.bin"));
            IndexedTriangleArray.loadIndices((InputStream)is);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return ita;
    }

    public VisualPickInfo visualPick(Visual visual, int x, int y) {
        PickInfo pickInfo = this.renderTarget.pick(x, y, true, true);
        Visual[] visuals = pickInfo.getVisuals();
        int i = 0;
        while (i < visuals.length) {
            System.out.print(" " + visuals[i]);
            ++i;
        }
        System.out.println("" + visual);
        if (visuals != null && visuals.length > 0) {
            int n = 0;
            while (visuals[n] != visual) {
                ++n;
            }
            int[] faces = pickInfo.getSubElements();
            Vector3 localPt = new Vector3((Tuple3d)pickInfo.getLocalPosition(n));
            return new VisualPickInfo(visual, localPt, faces[n]);
        }
        return null;
    }

    public void loadITA(IndexedTriangleArray ita, String dirname) {
        try {
            FileInputStream is = new FileInputStream(dirname + "/vertices.bin");
            VertexGeometry.loadVertices((InputStream)is);
            ((InputStream)is).close();
            is = new FileInputStream(dirname + "/indices.bin");
            IndexedTriangleArray.loadIndices((InputStream)is);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void idle(RendererEvent renderTargetEvent) {
        this.render_occurred = true;
        this.target.tick();
        this.process_events_in_queue();
        this.process_button_events_in_queue();
    }

    public void lock() {
        if (this.renderTarget != null) {
            this.renderTarget.setUpdateIsAutomatic(false);
        }
    }

    public void process_button_events_in_queue() {
        int i = 0;
        while (i < this.button_events.size()) {
            Object[] object = (Object[])this.button_events.elementAt(i);
            SyncEvent se = (SyncEvent)object[0];
            Object event = object[1];
            try {
                se.processEvent(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.button_events = new Vector();
    }

    public void rendered(RenderTargetEvent renderTargetEvent) {
        RenderTarget renderTarget = (RenderTarget)renderTargetEvent.getSource();
        this.paint(renderTarget.getOffscreenGraphics());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.events.addElement(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.events.addElement(mouseEvent);
    }

    public JaliceFrame(RendererInfo rendererInfo, JaliceTeddy target) {
        this.rendererInfo = rendererInfo;
        this.target = target;
        JaliceTeddy.jaliceFrame = this;
        this.setTitle("SmoothTeddy + Chameleon");
        this.addWindowListener(this);
        this.addComponentListener(this);
        this.setLayout(new BorderLayout());
        ((Component)this).setSize(new Dimension(520, 651));
        this.show();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void updated(OnscreenRenderTargetEvent renderTargetEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.getPoint().x > this.awtComponent.getSize().width - 20) {
            if (!this.zooming) {
                this.setCursor(ToolPanel.zoomCursor);
                this.zooming = true;
            }
        } else if (this.zooming) {
            this.setCursor(Cursor.getDefaultCursor());
            this.zooming = false;
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void paint(Graphics g) {
        this.target.paintOverlay(g);
        g.dispose();
    }

    public void repaint() {
        if (this.renderTarget != null) {
            this.renderTarget.markDirty();
        }
    }

    public Vector3 local_coords_to_screen_coords(Vector3 localPt, ReferenceFrame targetVehicle) {
        Vector3 cameraPt = targetVehicle.transformTo((Vector3d)localPt, (ReferenceFrame)this.cameraVehicle);
        return new Vector3((Tuple3d)this.renderTarget.transformFromCameraToViewport((Vector3d)cameraPt, this.camera));
    }

    public void process_events_in_queue() {
        EventHandler eventHandler = this.current_eventHandler;
        int i = 0;
        while (i < this.events.size()) {
            ComponentEvent event;
            Object _event = this.events.elementAt(i);
            if (_event instanceof MouseEvent) {
                event = (MouseEvent)_event;
                if (event.getID() == 501) {
                    eventHandler.mousePressed((MouseEvent)event);
                } else if (event.getID() == 506) {
                    if (i >= this.events.size() - 1 || ((MouseEvent)this.events.elementAt(i + 1)).getID() != 506) {
                        try {
                            eventHandler.mouseDragged((MouseEvent)event);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else if (event.getID() == 502) {
                    if (i > 0) {
                        Vector next_events = new Vector();
                        int j = i;
                        while (j < this.events.size()) {
                            next_events.addElement(this.events.elementAt(j));
                            ++j;
                        }
                        this.events = next_events;
                        return;
                    }
                    try {
                        eventHandler.mouseReleased((MouseEvent)event);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if (_event instanceof ComponentEvent) {
                event = (ComponentEvent)_event;
                if (event.getID() == 101) {
                    // empty if block
                }
                eventHandler.componentResized(event);
            }
            ++i;
        }
        this.events = new Vector();
    }

    public Vector3 scene_coords_to_screen_coords(Vector3 localPt) {
        return this.local_coords_to_screen_coords(localPt, (ReferenceFrame)this.scene);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void set_camera_parameters() {
        if (this.camera instanceof OrthographicCamera) {
            ((OrthographicCamera)this.camera).setPlane(Double.NaN, -this.scale, Double.NaN, this.scale);
        }
    }

    public Vector3 screen_coords_to_scene_coords(Point p) {
        return this.screen_coords_to_local_coords(p.x, p.y, (ReferenceFrame)this.scene);
    }

    public Vector3 screen_coords_to_local_coords(Point p, ReferenceFrame reference) {
        return this.screen_coords_to_local_coords(p.x, p.y, reference);
    }

    public Vector3 screen_coords_to_local_coords(double x, double y, ReferenceFrame reference) {
        if (reference == null) {
            reference = this.scene;
        }
        Vector3 viewportPt = new Vector3(x, y, 0.97);
        Vector3 cameraPt = new Vector3((Tuple3d)this.renderTarget.transformFromViewportToCamera((Vector3d)viewportPt, this.camera));
        return this.cameraVehicle.transformTo((Vector3d)cameraPt, reference);
    }

    public Vector3 screen_coords_to_local_coords(Vector3 viewportPt, ReferenceFrame reference) {
        if (reference == null) {
            reference = this.scene;
        }
        Vector3 cameraPt = new Vector3((Tuple3d)this.renderTarget.transformFromViewportToCamera((Vector3d)viewportPt, this.camera));
        return this.cameraVehicle.transformTo((Vector3d)cameraPt, reference);
    }

    public Vector3 getCameraPosition(ReferenceFrame reference) {
        return this.cameraVehicle.getPosition(reference);
    }

    public void enqueueEvent(SyncEvent se, Object event) {
        Object[] object = new Object[]{se, event};
        this.button_events.addElement(object);
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public Vertex jaliceVector3_to_teddyVertex(Vector3 v) {
        return new Vertex(v.x, v.z, v.y);
    }

    public Vector3 getCameraDirection(ReferenceFrame reference) {
        Matrix33 axes = this.cameraVehicle.getAxes(reference);
        return axes.getRow(2);
    }
}

