/*
 * Decompiled with CFR 0.152.
 */
package ui;

import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.math.Vector3;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;
import javax.vecmath.Vector3d;
import teddy.CleanStroke;
import teddy.Edge;
import teddy.Generate;
import teddy.Line;
import teddy.LinkedList;
import teddy.Polygon2;
import teddy.Polyhedron;
import teddy.SurfacePath;
import teddy.Vector2;
import teddy.Vertex;
import teddy.Vertex2D;
import ui.BrushPanel;
import ui.JaliceFrame;
import ui.JaliceTeddy;
import ui.Model;
import ui.Plane;
import ui.SurfaceLine;

public class Extrusion {
    static double get_thickness(SurfaceLine surfaceLine, Vector3 z_axis, Vector3 y_axis) {
        Vector3 x_axis = Vector3.crossProduct((Vector3d)y_axis, (Vector3d)z_axis);
        double min_z = 10000.0;
        double max_z = -10000.0;
        double min_x = 10000.0;
        double max_x = -10000.0;
        int i = 0;
        while (i < surfaceLine.size) {
            Vector3 v = surfaceLine.getPosition(i);
            double z = Vector3.dotProduct((Vector3d)z_axis, (Vector3d)v);
            double x = Vector3.dotProduct((Vector3d)x_axis, (Vector3d)v);
            if (z < min_z) {
                min_z = z;
            }
            if (z > max_z) {
                max_z = z;
            }
            if (x < min_x) {
                min_x = x;
            }
            if (x > max_x) {
                max_x = x;
            }
            ++i;
        }
        return (max_z - min_z) / (max_x - min_x);
    }

    public static Vector3 get_joint(Model model, Vector stroke) {
        Vector faces = Extrusion.get_enclosed_faces(model, stroke);
        Vertex center = new Vertex();
        teddy.Vector3 normal = new teddy.Vector3();
        int i = 0;
        while (i < faces.size()) {
            Polygon2 face = (Polygon2)faces.elementAt(i);
            normal.add_self(face.normal);
            int j = 0;
            while (j < 3) {
                Vertex v = face.get_vertex(j);
                center.add_self((teddy.Vector3)v);
                ++j;
            }
            ++i;
        }
        normal.multiple_self(1.0 / (double)faces.size());
        center.multiple_self(0.3333333333333333 / (double)faces.size());
        if (Extrusion.all_front_facing(model, faces)) {
            center = Extrusion.get_center(model, stroke);
        }
        center = Extrusion.get_intersection(faces, center, normal);
        return model.teddyVector3_to_jaliceVector3((teddy.Vector3)center);
    }

    public static boolean enclosed(Polygon2 face, Vector stroke, Model model) {
        int i = 0;
        while (i < 3) {
            Vertex v = face.get_vertex(i);
            if (Extrusion.enclosed(v, stroke, model)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean enclosed(Vertex vertex, Vector points, Model model) {
        Vector3 v = JaliceTeddy.jaliceFrame.local_coords_to_screen_coords(model.teddyVertex_to_jaliceVector3(vertex), (ReferenceFrame)model.modelVehicle);
        Point p = new Point((int)v.x, (int)v.y);
        Point q0 = (Point)points.elementAt(points.size() - 1);
        double angle = 0.0;
        int i = 0;
        while (i < points.size()) {
            Point q1 = (Point)points.elementAt(i);
            Vector2 v0 = new Vector2(p, q0);
            Vector2 v1 = new Vector2(p, q1);
            angle += v0.get_angle180(v1);
            q0 = q1;
            ++i;
        }
        return angle < -180.0 || angle > 180.0;
    }

    public static Model extrude(Model model, Vector stroke) {
        Vector3 y_axis;
        Vector3 z_axis;
        Vector3 base_center = model.surfaceLine.getCenter();
        Vector3 base_normal = model.surfaceLine.getNormal();
        Vector3 local_camera = JaliceTeddy.jaliceFrame.cameraVehicle.getPosition((ReferenceFrame)model.modelVehicle);
        Vector3 camera_to_center = Vector3.subtract((Vector3d)base_center, (Vector3d)local_camera);
        camera_to_center.normalize();
        Vector3 cross = Vector3.crossProduct((Vector3d)camera_to_center, (Vector3d)base_normal);
        Vector3 plane_normal = Vector3.crossProduct((Vector3d)cross, (Vector3d)base_normal);
        plane_normal.normalize();
        double inflation_ratio = 0.85;
        if (Vector3.dotProduct((Vector3d)camera_to_center, (Vector3d)base_normal) > -0.7) {
            z_axis = plane_normal;
            y_axis = base_normal;
        } else {
            z_axis = base_normal;
            y_axis = Vector3.multiply((Vector3d)plane_normal, (double)-1.0);
        }
        Plane plane = new Plane(base_center, z_axis, y_axis, (ReferenceFrame)model.modelVehicle);
        stroke = CleanStroke.clean((Vector)stroke, (int)20, (int)100);
        Vector projected_vertices = new Vector();
        Vector<Vertex2D> list = new Vector<Vertex2D>();
        int i = 0;
        while (i < stroke.size()) {
            Point p = ((Vertex2D)stroke.elementAt(i)).point();
            Vector3 pos = plane.project_coords(p);
            if (pos != null) {
                list.addElement(new Vertex2D(pos.x, pos.y));
            }
            ++i;
        }
        double max_height = 0.0;
        max_height = JaliceTeddy.inflation_mode == 0 ? 1.0 : 0.1;
        Polyhedron polyhedron = Generate.generate(list, (double)inflation_ratio, (double)max_height);
        Model newModel = new Model(polyhedron, model);
        newModel.modelVehicle.setPosition((Vector3d)base_center, (ReferenceFrame)model.modelVehicle);
        newModel.modelVehicle.setOrientation((Vector3d)z_axis, (Vector3d)y_axis, (ReferenceFrame)model.modelVehicle);
        newModel.stroke = list;
        return newModel;
    }

    public static Model instant_extrude(Model model, Vector stroke) {
        JaliceFrame jaliceFrame = JaliceTeddy.jaliceFrame;
        Vector3 joint = Extrusion.get_joint(model, stroke);
        joint = JaliceTeddy.jaliceFrame.change_coords(joint, (ReferenceFrame)model.modelVehicle, (ReferenceFrame)JaliceTeddy.jaliceFrame.scene);
        stroke = CleanStroke.clean((Vector)stroke, (int)20, (int)100, (boolean)true);
        Vector<Vertex2D> list = new Vector<Vertex2D>();
        Vector3 parent_center = model.modelVehicle.getPosition((ReferenceFrame)jaliceFrame.cameraVehicle);
        Vector3 camera_position = jaliceFrame.cameraVehicle.getPosition((ReferenceFrame)jaliceFrame.cameraVehicle);
        Vector3 to_camera = Vector3.subtract((Vector3d)parent_center, (Vector3d)camera_position);
        to_camera = Vector3.normalizeV((Vector3d)to_camera);
        Plane plane = new Plane(joint, Vector3.Z_AXIS, Vector3.Y_AXIS, (ReferenceFrame)jaliceFrame.cameraVehicle);
        int i = 0;
        while (i < stroke.size()) {
            Vertex2D p = (Vertex2D)stroke.elementAt(i);
            Vector3 pos = plane.project_coords(p.point());
            if (pos != null) {
                p.x = pos.x;
                p.y = pos.y;
                list.addElement(p);
            }
            ++i;
        }
        double max_height = 1.0;
        double inflation_ratio = 0.85;
        Polyhedron polyhedron = Generate.generate(list, (double)inflation_ratio, (double)max_height);
        Model newModel = new Model(polyhedron, model);
        newModel.init_dunk_color(BrushPanel.color);
        newModel.modelVehicle.setPosition((Vector3d)joint, (ReferenceFrame)jaliceFrame.scene);
        newModel.modelVehicle.setOrientation((Vector3d)Vector3.Z_AXIS, (Vector3d)Vector3.Y_AXIS, (ReferenceFrame)jaliceFrame.cameraVehicle);
        newModel.stroke = list;
        return newModel;
    }

    public static boolean all_front_facing(Model model, Vector faces) {
        int i = 0;
        while (i < faces.size()) {
            Polygon2 face = (Polygon2)faces.elementAt(i);
            if (model.back_facing(face.index)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Vector get_enclosed_faces(Model model, Vector stroke) {
        model.compute_vertices2d();
        Point p = (Point)stroke.elementAt(JaliceTeddy.pickModel_along_stroke_index);
        int index = model.pick_face(p, false);
        Polygon2 face = model.final_polyhedron.polygons[index];
        Vector faces = new Vector();
        Extrusion.get_enclosed_faces_sub(model, stroke, face, faces);
        return faces;
    }

    public static void get_enclosed_faces_sub(Model model, Vector stroke, Polygon2 face, Vector faces) {
        if (faces.contains(face)) {
            return;
        }
        faces.addElement(face);
        LinkedList edges = face.get_edges();
        Enumeration e = edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            Polygon2 f = edge.get_another_polygon(face);
            if (!Extrusion.enclosed(f, stroke, model)) continue;
            Extrusion.get_enclosed_faces_sub(model, stroke, f, faces);
        }
    }

    public static Vertex get_center(Model model, Vector points) {
        SurfacePath path = model.getSurfacePath(points, true);
        return path.getCenter();
    }

    public static Vertex get_intersection(Vector faces, Vertex center, teddy.Vector3 normal) {
        Line line = new Line(center, normal);
        int i = 0;
        while (i < faces.size()) {
            Polygon2 face = (Polygon2)faces.elementAt(i);
            Vertex p = line.get_intersection(face);
            if (p != null) {
                return p;
            }
            ++i;
        }
        return null;
    }
}

