/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import ui.BrushPanel;
import ui.PrimaryColorAxisCanvas;
import ui.SecondaryColorAxesCanvas;

public class ColorSelectorFrame
extends Frame {
    Choice secondaryChoice = new Choice();
    Choice primaryChoice = new Choice();
    SecondaryColorAxesCanvas secondaryColorAxesCanvas1 = new SecondaryColorAxesCanvas();
    PrimaryColorAxisCanvas primaryColorAxisCanvas1 = new PrimaryColorAxisCanvas();

    void secondaryColorAxesCanvas1_MouseDragged(MouseEvent event) {
        float x = (float)Math.max(Math.min((double)event.getX() / 180.0, 1.0), 0.0);
        float y = (float)Math.max(Math.min(1.0 - (double)event.getY() / 180.0, 1.0), 0.0);
        this.secondaryColorAxesCanvas1.setValueX(x);
        this.secondaryColorAxesCanvas1.setValueY(y);
        this.primaryColorAxisCanvas1.setSecondaryValues(x, y);
        this.updateBrushCanvas();
    }

    void secondaryColorAxesCanvas1_MousePressed(MouseEvent event) {
        this.secondaryColorAxesCanvas1_MouseDragged(event);
    }

    ColorSelectorFrame() {
        this.setResizable(false);
        this.setTitle("Color Selector");
        this.setLayout(null);
        ((Component)this).setBackground(Color.lightGray);
        this.setFont(new Font("Dialog", 0, 12));
        ((Component)this).setSize(246, 214);
        this.secondaryChoice.addItem("saturation - brightness");
        this.secondaryChoice.addItem("hue - brightness");
        this.secondaryChoice.addItem("hue - saturation");
        try {
            this.secondaryChoice.select(1);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        this.primaryChoice.addItem("hue");
        this.primaryChoice.addItem("saturation");
        this.primaryChoice.addItem("brightness");
        try {
            this.primaryChoice.select(1);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        this.add(this.secondaryColorAxesCanvas1);
        this.secondaryColorAxesCanvas1.setBounds(4, 30, 180, 180);
        this.add(this.primaryColorAxisCanvas1);
        this.primaryColorAxisCanvas1.setBounds(190, 18, 48, 203);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymMouseMotion aSymMouseMotion = new SymMouseMotion();
        SymMouse aSymMouse = new SymMouse();
        SymItem lSymItem = new SymItem();
        this.secondaryChoice.addItemListener(lSymItem);
        this.primaryChoice.addItemListener(lSymItem);
        this.secondaryColorAxesCanvas1.addMouseListener(aSymMouse);
        this.secondaryColorAxesCanvas1.addMouseMotionListener(aSymMouseMotion);
        this.primaryColorAxisCanvas1.addMouseListener(aSymMouse);
        this.primaryColorAxisCanvas1.addMouseMotionListener(aSymMouseMotion);
    }

    void secondaryChoice_ItemStateChanged(ItemEvent event) {
        this.updateState(this.secondaryChoice.getSelectedIndex());
    }

    void primaryColorAxisCanvas1_MouseDragged(MouseEvent event) {
        int y = event.getY() - 12;
        float value = 1.0f - (float)Math.max(Math.min((double)y / 180.0, 1.0), 0.0);
        this.primaryColorAxisCanvas1.setValue(value);
        this.updateBrushCanvas();
    }

    void primaryColorAxisCanvas1_MousePressed(MouseEvent event) {
        this.primaryColorAxisCanvas1_MouseDragged(event);
    }

    void secondaryColorAxesCanvas1_MouseReleased(MouseEvent event) {
        this.secondaryColorAxesCanvas1_MouseDragged(event);
    }

    void setColor(Color color) {
        if (color == null) {
            return;
        }
        float[] hsb = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
        switch (this.secondaryChoice.getSelectedIndex()) {
            case 0: {
                this.primaryColorAxisCanvas1.setValue(hsb[0]);
                this.primaryColorAxisCanvas1.setSecondaryValues(hsb[1], hsb[2]);
                this.secondaryColorAxesCanvas1.setValueX(hsb[1]);
                this.secondaryColorAxesCanvas1.setValueY(hsb[2]);
                this.secondaryColorAxesCanvas1.setPrimaryValue(hsb[0]);
                break;
            }
            case 1: {
                this.primaryColorAxisCanvas1.setValue(hsb[1]);
                this.primaryColorAxisCanvas1.setSecondaryValues(hsb[0], hsb[2]);
                this.secondaryColorAxesCanvas1.setValueX(hsb[0]);
                this.secondaryColorAxesCanvas1.setValueY(hsb[2]);
                this.secondaryColorAxesCanvas1.setPrimaryValue(hsb[1]);
                break;
            }
            case 2: {
                this.primaryColorAxisCanvas1.setValue(hsb[2]);
                this.primaryColorAxisCanvas1.setSecondaryValues(hsb[0], hsb[1]);
                this.secondaryColorAxesCanvas1.setValueX(hsb[0]);
                this.secondaryColorAxesCanvas1.setValueY(hsb[1]);
                this.secondaryColorAxesCanvas1.setPrimaryValue(hsb[2]);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void updateState(int v) {
        Color color = BrushPanel.color;
        this.secondaryColorAxesCanvas1.setState(v);
        this.primaryColorAxisCanvas1.setState(v);
        this.setColor(color);
        this.secondaryChoice.select(v);
        this.primaryChoice.select(v);
    }

    void primaryChoice_ItemStateChanged(ItemEvent event) {
        this.updateState(this.primaryChoice.getSelectedIndex());
    }

    void primaryColorAxisCanvas1_MouseReleased(MouseEvent event) {
        this.primaryColorAxisCanvas1_MouseDragged(event);
        this.secondaryColorAxesCanvas1.setPrimaryValue(this.primaryColorAxisCanvas1.getValue());
    }

    void updateBrushCanvas() {
        Color color;
        float brightness;
        float saturation;
        float hue;
        switch (this.primaryChoice.getSelectedIndex()) {
            case 0: {
                hue = this.primaryColorAxisCanvas1.getValue();
                saturation = this.secondaryColorAxesCanvas1.getValueX();
                brightness = this.secondaryColorAxesCanvas1.getValueY();
                break;
            }
            case 1: {
                hue = this.secondaryColorAxesCanvas1.getValueX();
                saturation = this.primaryColorAxisCanvas1.getValue();
                brightness = this.secondaryColorAxesCanvas1.getValueY();
                break;
            }
            case 2: {
                hue = this.secondaryColorAxesCanvas1.getValueX();
                saturation = this.secondaryColorAxesCanvas1.getValueY();
                brightness = this.primaryColorAxisCanvas1.getValue();
                break;
            }
            default: {
                return;
            }
        }
        BrushPanel.color = color = new Color(Color.HSBtoRGB(hue, saturation, brightness));
        BrushPanel.color_table[27] = color;
        BrushPanel.static_repaint();
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
            ColorSelectorFrame.this.getClass();
        }

        public void windowClosing(WindowEvent event) {
            ((Component)ColorSelectorFrame.this).setVisible(false);
        }

        public void windowIconified(WindowEvent e) {
            System.out.println("icon");
        }
    }

    class SymMouseMotion
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent event) {
            Object object = event.getSource();
            if (object == ColorSelectorFrame.this.secondaryColorAxesCanvas1) {
                ColorSelectorFrame.this.secondaryColorAxesCanvas1_MouseDragged(event);
            } else if (object == ColorSelectorFrame.this.primaryColorAxisCanvas1) {
                ColorSelectorFrame.this.primaryColorAxisCanvas1_MouseDragged(event);
            }
        }

        SymMouseMotion() {
            ColorSelectorFrame.this.getClass();
        }
    }

    class SymMouse
    extends MouseAdapter {
        public void mousePressed(MouseEvent event) {
            Object object = event.getSource();
            if (object == ColorSelectorFrame.this.secondaryColorAxesCanvas1) {
                ColorSelectorFrame.this.secondaryColorAxesCanvas1_MousePressed(event);
            } else if (object == ColorSelectorFrame.this.primaryColorAxisCanvas1) {
                ColorSelectorFrame.this.primaryColorAxisCanvas1_MousePressed(event);
            }
        }

        SymMouse() {
            ColorSelectorFrame.this.getClass();
        }

        public void mouseReleased(MouseEvent event) {
            Object object = event.getSource();
            if (object == ColorSelectorFrame.this.primaryColorAxisCanvas1) {
                ColorSelectorFrame.this.primaryColorAxisCanvas1_MouseReleased(event);
            } else if (object == ColorSelectorFrame.this.secondaryColorAxesCanvas1) {
                ColorSelectorFrame.this.secondaryColorAxesCanvas1_MouseReleased(event);
            }
        }
    }

    class SymItem
    implements ItemListener {
        SymItem() {
            ColorSelectorFrame.this.getClass();
        }

        public void itemStateChanged(ItemEvent event) {
            Object object = event.getSource();
            if (object == ColorSelectorFrame.this.secondaryChoice) {
                ColorSelectorFrame.this.secondaryChoice_ItemStateChanged(event);
            } else if (object == ColorSelectorFrame.this.primaryChoice) {
                ColorSelectorFrame.this.primaryChoice_ItemStateChanged(event);
            }
        }
    }
}

