/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import ui.ColorSelectorFrame;
import ui.JaliceTeddy;

public class BrushPanel
extends Panel
implements MouseListener,
MouseMotionListener {
    public static int radius = 10;
    public static Color color = Color.white;
    public boolean visible = false;
    Image image;
    static BrushPanel brushPanel;
    Image buffered_image;
    ColorSelectorFrame colorSelector;
    public static Color[] color_table;
    private boolean changing_radius;
    private int prev_x;

    public void paint_main(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, 52, 52);
        if (color == Color.white) {
            g.setColor(Color.black);
            g.drawOval(24 - radius, 26 - radius, radius * 2, radius * 2);
        } else {
            g.setColor(color);
            g.fillOval(24 - radius, 26 - radius, radius * 2, radius * 2);
        }
        g.drawImage(this.image, 0, 0, null);
        g.setColor(color_table[27]);
        g.fillRect(377, 29, 19, 19);
        super.paint(g);
    }

    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() == 2) {
            if (this.colorSelector == null) {
                this.colorSelector = new ColorSelectorFrame();
                Rectangle modelRect = JaliceTeddy.jaliceFrame.getBounds();
                ((Component)this.colorSelector).setLocation(modelRect.x + modelRect.width + 8, modelRect.y);
            }
            ((Component)this.colorSelector).setVisible(true);
        }
    }

    public void mousePressed(MouseEvent event) {
        int x = event.getX();
        this.changing_radius = x < 50;
        this.prev_x = x;
        if (x >= 50) {
            int y = event.getY();
            System.out.println("" + (y / 25 * 14 + (x - 50) / 25));
            this.set_color(color_table[y / 25 * 14 + (x - 50) / 25]);
        }
    }

    public void mouseDragged(MouseEvent event) {
        int x = event.getX();
        if (this.changing_radius) {
            if ((radius += x - this.prev_x) < 1) {
                radius = 1;
            } else if (radius > 30) {
                radius = 30;
            }
        }
        this.prev_x = x;
        this.repaint();
    }

    public BrushPanel() {
        brushPanel = this;
        this.image = this.loadImage("images\\colors.gif");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void mouseReleased(MouseEvent event) {
        Point p = event.getPoint();
        if (p.y < 0) {
            JaliceTeddy.jaliceTeddy.dunk_requested = this.brushCoordsToPanelCoords(p);
        }
    }

    public void mouseMoved(MouseEvent event) {
    }

    public static void static_repaint() {
        brushPanel.repaint();
    }

    public void paint(Graphics g) {
        if (this.buffered_image == null) {
            this.buffered_image = this.createImage(this.image.getWidth(null), this.image.getHeight(null));
        }
        Graphics bg = this.buffered_image.getGraphics();
        this.paint_main(bg);
        bg.dispose();
        g.drawImage(this.buffered_image, 0, 0, null);
        super.paint(g);
    }

    protected Image loadImage(String pathname) {
        Image image = this.getToolkit().getImage(pathname);
        if (image != null) {
            MediaTracker mt = new MediaTracker(this);
            try {
                mt.addImage(image, 0);
                mt.waitForAll();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        return image;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void set_color(Color color) {
        BrushPanel.color = color;
        this.repaint();
        if (this.colorSelector != null) {
            this.colorSelector.setColor(color);
        }
    }

    static {
        color_table = new Color[]{Color.black, new Color(128, 128, 128), new Color(128, 0, 0), new Color(128, 128, 0), new Color(0, 128, 0), new Color(0, 128, 128), new Color(0, 0, 128), new Color(128, 0, 128), new Color(128, 128, 64), new Color(0, 64, 64), new Color(0, 128, 255), new Color(0, 64, 128), new Color(64, 0, 255), new Color(128, 64, 0), Color.white, new Color(192, 192, 192), new Color(255, 0, 0), new Color(255, 255, 0), new Color(0, 255, 0), new Color(0, 255, 255), new Color(0, 0, 255), new Color(255, 0, 255), new Color(255, 255, 128), new Color(0, 255, 128), new Color(128, 255, 255), new Color(128, 128, 255), new Color(255, 0, 128), new Color(255, 128, 64)};
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 52);
    }

    public Point brushCoordsToPanelCoords(Point p) {
        Point panelPosition = this.getParent().getLocation();
        Point brushPosition = this.getLocation();
        Point jalicePanelPosition = JaliceTeddy.jaliceFrame.awtComponent.getLocation();
        return new Point(p.x + brushPosition.x + panelPosition.x - jalicePanelPosition.x, p.y + brushPosition.y + panelPosition.y - jalicePanelPosition.y);
    }
}

