/*
 * Decompiled with CFR 0.152.
 */
package ui;

import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.FillingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.ShadingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.math.Vector3;
import java.awt.Point;
import java.util.Vector;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import ui.Model;
import ui.Util;

public class Ball {
    Vector3 position;
    final double RADIUS = 0.02;
    Color COLOR = new Color(0.8, 0.1, 0.1, 1.0);
    public static Vector balls = new Vector();
    Transformable ballVehicle;
    Visual ballVisual;
    Appearance ballAppearance;
    Transformable scene;
    public static IndexedTriangleArray ballITA;

    Ball(Vector3 pos) {
        this.position = pos;
    }

    public IndexedTriangleArray createITA(double radius) {
        ballITA = new IndexedTriangleArray();
        Vector3d center = new Vector3d(0.0, 0.0, 0.0);
        Vector3d nv = new Vector3d(0.0, 0.0, 0.0);
        Vertex3d[] ballVertices = new Vertex3d[26];
        int n = 0;
        int y = 0;
        while (y < 5) {
            double yangle = Math.PI * 2 * (double)y / 8.0;
            double yradius = radius * Math.cos(yangle);
            double xradius = radius * Math.sin(yangle);
            if (y == 0 || y == 4) {
                int i = n++;
                ballVertices[i] = new Vertex3d(19);
                Vector3d v = new Vector3d(0.0, yradius, 0.0);
                ballVertices[i].position.set((Tuple3d)v);
                nv.sub((Tuple3d)v, (Tuple3d)center);
                nv.normalize();
                ballVertices[i].normal.set((Tuple3d)nv);
            } else {
                int x = 0;
                while (x < 8) {
                    double xangle = Math.PI * 2 * (double)x / 8.0;
                    int i = n++;
                    ballVertices[i] = new Vertex3d(19);
                    Vector3d v = new Vector3d(xradius * Math.cos(xangle), yradius, xradius * Math.sin(xangle));
                    ballVertices[i].position.set((Tuple3d)v);
                    nv.sub((Tuple3d)v, (Tuple3d)center);
                    nv.normalize();
                    ballVertices[i].normal.set((Tuple3d)nv);
                    ++x;
                }
            }
            ++y;
        }
        int[] ballIndices = new int[144];
        n = 0;
        int x = 0;
        while (x < 8) {
            ballIndices[n++] = 17 + x;
            ballIndices[n++] = 17 + Util.mod(x + 1, 8);
            ballIndices[n++] = 25;
            ballIndices[n++] = 1 + x;
            ballIndices[n++] = 0;
            ballIndices[n++] = 1 + Util.mod(x + 1, 8);
            ++x;
        }
        int y2 = 0;
        while (y2 < 2) {
            int x2 = 0;
            while (x2 < 8) {
                ballIndices[n++] = 1 + y2 * 8 + x2;
                ballIndices[n++] = 1 + y2 * 8 + Util.mod(x2 + 1, 8);
                ballIndices[n++] = 1 + y2 * 8 + x2 + 8;
                ballIndices[n++] = 1 + y2 * 8 + x2 + 8;
                ballIndices[n++] = 1 + y2 * 8 + Util.mod(x2 + 1, 8);
                ballIndices[n++] = 1 + y2 * 8 + Util.mod(x2 + 1, 8) + 8;
                ++x2;
            }
            ++y2;
        }
        ballITA.setVertices(ballVertices);
        ballITA.setIndices(ballIndices);
        return ballITA;
    }

    public void removeFromScenegraph() {
        if (this.ballVehicle != null) {
            this.ballVehicle.setParent(null);
        }
    }

    public static void delete_balls() {
        int i = 0;
        while (i < balls.size()) {
            Ball ball = (Ball)balls.elementAt(i);
            ball.delete();
            ++i;
        }
        balls = new Vector();
    }

    public void setGeometry(double radius) {
        if (ballITA == null) {
            ballITA = this.createITA(radius);
        }
        this.ballVisual.setGeometry((Geometry)ballITA);
        this.ballAppearance.setDiffuseColor(this.COLOR);
    }

    public Transformable getVehicle() {
        return this.ballVehicle;
    }

    public void addToScenegraph(Transformable parent) {
        this.scene = parent;
        if (this.ballVehicle == null) {
            this.createBallVisual(this.position);
            this.ballVehicle = new Transformable();
            this.ballVisual.setParent((Container)this.ballVehicle);
        }
        this.ballVehicle.setParent((Container)parent);
        this.ballVehicle.setPosition((Vector3d)this.position, (ReferenceFrame)parent);
    }

    public static void click(Point p, Model pickedModel) {
        Ball.delete_balls();
        Vector vs = pickedModel.pick_nearby_vertices(p);
        int i = 0;
        while (i < vs.size()) {
            Vector3 v = (Vector3)vs.elementAt(i);
            Ball ball = new Ball(v);
            ball.addToScenegraph(pickedModel.modelVehicle);
            balls.addElement(ball);
            ++i;
        }
    }

    public void delete() {
        this.ballVehicle.setParent(null);
    }

    public void createBallVisual(Vector3 pos) {
        this.ballVisual = new Visual();
        this.ballAppearance = new Appearance();
        this.ballVisual.setFrontFacingAppearance(this.ballAppearance);
        this.ballAppearance.setFillingStyle(FillingStyle.SOLID);
        this.ballAppearance.setShadingStyle(ShadingStyle.SMOOTH);
        this.setGeometry(0.02);
    }
}

