/*
 * Decompiled with CFR 0.152.
 */
package ui;

import edu.cmu.cs.stage3.alice.scenegraph.Component;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import java.util.Vector;
import teddy.Polyhedron;
import teddy.SubdivMesh;
import ui.Model;
import ui.PackedTexture;

public class AsgFile {
    public static void set_subdivMesh(Model model) {
        Vertex3d[] modelVertices = model.modelITA.getVertices();
        int[] modelIndices = model.modelITA.getIndices();
        int[] vertex_map = new int[modelVertices.length];
        Vector<double[]> vertices = new Vector<double[]>();
        int i = 0;
        while (i < modelVertices.length) {
            double x = modelVertices[i].position.x;
            double y = modelVertices[i].position.y;
            double z = modelVertices[i].position.z;
            double[] xyz = new double[]{x, y, z};
            vertex_map[i] = AsgFile.get_corresponding_vertex(vertices, xyz);
            if (vertex_map[i] == -1) {
                vertices.addElement(xyz);
                vertex_map[i] = vertices.size() - 1;
            }
            ++i;
        }
        Vector<int[]> indices = new Vector<int[]>();
        int i2 = 0;
        while (i2 < modelIndices.length / 3) {
            int i0 = modelIndices[i2 * 3];
            int i1 = modelIndices[i2 * 3 + 1];
            int i22 = modelIndices[i2 * 3 + 2];
            i0 = vertex_map[i0];
            i1 = vertex_map[i1];
            i22 = vertex_map[i22];
            int[] index = new int[]{i0, i1, i22};
            indices.addElement(index);
            ++i2;
        }
        Vector seams = new Vector();
        Vector sharps = new Vector();
        Polyhedron polyhedron = new Polyhedron(vertices, indices, seams, sharps);
        model.subdivMesh = new SubdivMesh(polyhedron);
        model.final_polyhedron = polyhedron;
        model.compute_faces();
    }

    public static Model create_model(Transformable vehicle) {
        Model model = new Model();
        model.modelVehicle = vehicle;
        model.modelVisual = AsgFile.getVisual(vehicle);
        model.modelITA = (IndexedTriangleArray)model.modelVisual.getGeometry();
        model.modelAppearance = model.modelVisual.getFrontFacingAppearance();
        model.modelTexture = model.modelAppearance.getDiffuseColorMap();
        model.packedTexture = new PackedTexture(model);
        model.packedTexture.set_region(model.modelTexture.getImage().getWidth(null), model.modelTexture.getImage().getHeight(null));
        AsgFile.set_subdivMesh(model);
        int i = 0;
        while (i < vehicle.getChildCount()) {
            Component component = vehicle.getChildAt(i);
            if (component instanceof Transformable) {
                Transformable child_vehicle = (Transformable)component;
                Model child_model = AsgFile.create_model(child_vehicle);
                model.childrenModels.addElement(child_model);
                child_model.parentModel = model;
            }
            ++i;
        }
        return model;
    }

    public static Visual getVisual(Transformable vehicle) {
        int i = 0;
        while (i < vehicle.getChildCount()) {
            Component component = vehicle.getChildAt(i);
            if (component instanceof Visual) {
                return (Visual)component;
            }
            ++i;
        }
        return null;
    }

    public static Vector load(Component component) {
        Vector models = new Vector();
        Transformable vehicle = (Transformable)component;
        Model model = AsgFile.create_model(vehicle);
        return model.get_descendent_models();
    }

    public static int get_corresponding_vertex(Vector vertices, double[] xyz) {
        int i = 0;
        while (i < vertices.size()) {
            double[] v = (double[])vertices.elementAt(i);
            if (v[0] == xyz[0] && v[1] == xyz[1] && v[2] == xyz[2]) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

