/*
 * Decompiled with CFR 0.152.
 */
package render;

import render.Geometry;
import render.Material;
import render.Matrix;
import render.Noise;
import render.Vec;

public class Renderer {
    private String notice = "Copyright 2001 Ken Perlin. All rights reserved.";
    public static boolean tableMode = true;
    public int lod = 1;
    public boolean showMesh = false;
    public boolean updateTransparency = true;
    int count = 0;
    static double[] anis = new double[]{0.0, 0.0, 0.0};
    double[][] inverseCamera = new double[4][4];
    private int[][] t;
    private double FL = 10.0;
    private double FOV = 1.0;
    private Geometry world;
    private int W;
    private int H;
    private double theta = 0.0;
    private double phi = 0.0;
    private int[] pix;
    private int bgColor = Renderer.pack(0, 0, 0);
    private final int zHuge = Integer.MIN_VALUE;
    private int TOP = -1;
    private int BOTTOM;
    private int LEFT;
    private int RIGHT;
    private int[] zbuffer = null;
    private double[][] camera = new double[4][4];
    private double[][] camtmp = new double[4][4];
    private double[][] matrix = new double[4][4];
    private int nt = 0;
    private Geometry[] tS = null;
    private boolean renderT = false;
    private double[] normal = new double[3];
    private double[] ti = new double[6];
    private double[][] normat = new double[4][4];
    private double transparency;
    private final int NB = 14;
    private int[] a;
    private int[] b;
    private int[] c = new int[6];
    private int[] d;
    private double[] refl = new double[3];
    private final int UNRENDERED = 1234567;
    private int nLights = 0;
    private double[][] light = new double[20][6];
    private boolean dragging = false;
    public boolean isHeadsUp = false;
    private boolean isOutline = false;
    private int threshold = 256;
    private int black = Renderer.pack(0, 0, 0);
    private int white = Renderer.pack(255, 255, 255);

    public int[] init(int W, int H) {
        this.nLights = 0;
        this.world = new Geometry();
        this.W = W;
        this.H = H;
        Matrix.identity(this.camera);
        this.pix = new int[W * H];
        return this.pix;
    }

    public void setDragging(boolean tf) {
        this.dragging = tf;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public synchronized void setCamera(double theta, double phi) {
        Matrix.identity(this.camera);
        this.changeCamera(theta, phi);
    }

    public void headsUp(boolean tf) {
        this.isHeadsUp = tf;
    }

    public void setFL(double value) {
        this.FL = value;
    }

    public void setFOV(double value) {
        this.FOV = value;
    }

    public Geometry getWorld() {
        return this.world;
    }

    public void setBgColor(double r, double g, double b) {
        this.bgColor = Renderer.pack(this.f2i(r), this.f2i(g), this.f2i(b));
    }

    public void addLight(double x, double y, double z, double r, double g, double b) {
        this.placeLight(this.nLights, x, y, z);
        this.colorLight(this.nLights, r, g, b);
        ++this.nLights;
    }

    public void placeLight(int i, double x, double y, double z) {
        double s = Math.sqrt(x * x + y * y + z * z);
        this.light[i][0] = x / s;
        this.light[i][1] = y / s;
        this.light[i][2] = z / s;
    }

    public void colorLight(int i, double r, double g, double b) {
        this.light[this.nLights][3] = r;
        this.light[this.nLights][4] = g;
        this.light[this.nLights][5] = b;
    }

    public synchronized void rotateView(double t, double p) {
        this.theta += t;
        this.phi += p;
    }

    public double[][] getCamera() {
        return this.camera;
    }

    public void setCamera(double[][] m) {
        Matrix.copy(m, this.camera);
        Matrix.invert(this.camera, this.inverseCamera);
        Renderer.anis[0] = this.camera[0][0];
        Renderer.anis[1] = this.camera[1][0];
        Renderer.anis[2] = this.camera[2][0];
        Vec.normalize((double[])anis);
    }

    public void npr() {
        if (this.isOutline) {
            for (int y = Math.max(1, this.TOP); y < Math.min(this.BOTTOM, this.H - 1); ++y) {
                for (int x = Math.max(1, this.LEFT); x < Math.min(this.RIGHT, this.W - 1); ++x) {
                    int dz2;
                    int i = this.xy2i(x, y);
                    int zn = this.zbuffer[i - 1];
                    int z0 = this.zbuffer[i];
                    int zp = this.zbuffer[i + 1];
                    int dz1 = Math.abs(z0 - zn);
                    this.pix[i] = dz1 > 20 * (dz2 = Math.abs(zp - z0)) || dz2 > 20 * dz1 ? this.black : (this.edge(this.pix[i], this.pix[i + 1]) + this.edge(this.pix[i], this.pix[i + this.W]) > this.threshold ? this.black : this.white);
                }
            }
        }
    }

    public synchronized void render() {
        this.computeCamera();
        Renderer.anis[0] = this.camera[0][0];
        Renderer.anis[1] = this.camera[1][0];
        Renderer.anis[2] = this.camera[2][0];
        Vec.normalize((double[])anis);
        Matrix.invert(this.camera, this.inverseCamera);
        this.clearScreen();
        this.renderWorld();
        if (this.isOutline) {
            for (int y = Math.max(1, this.TOP); y < Math.min(this.BOTTOM, this.H - 1); ++y) {
                for (int x = Math.max(1, this.LEFT); x < Math.min(this.RIGHT, this.W - 1); ++x) {
                    int dz2;
                    int i = this.xy2i(x, y);
                    int zn = this.zbuffer[i - 1];
                    int z0 = this.zbuffer[i];
                    int zp = this.zbuffer[i + 1];
                    int dz1 = Math.abs(z0 - zn);
                    this.pix[i] = dz1 > 20 * (dz2 = Math.abs(zp - z0)) || dz2 > 20 * dz1 ? this.black : (this.edge(this.pix[i], this.pix[i + 1]) + this.edge(this.pix[i], this.pix[i + this.W]) > this.threshold ? this.black : this.white);
                }
            }
        }
        ++this.count;
    }

    public void outline(double t) {
        boolean bl = this.isOutline = t > 0.0;
        if (this.isOutline) {
            this.threshold = (int)((double)256 * t * t);
        }
    }

    private int edge(int p, int q) {
        int dr = Renderer.getR(p) - Renderer.getR(q);
        int dg = Renderer.getG(p) - Renderer.getG(q);
        int db = Renderer.getB(p) - Renderer.getB(q);
        return dr * dr + dg * dg + db * db;
    }

    public void refresh() {
        this.LEFT = 0;
        this.TOP = 0;
        this.RIGHT = this.W;
        this.BOTTOM = this.H;
    }

    private int xy2i(int x, int y) {
        return y * this.W + x;
    }

    private int f2i(double t) {
        return (int)((double)255 * t) & 0xFF;
    }

    private static int pack(int r, int g, int b) {
        return r << 16 | g << 8 | b | 0xFF000000;
    }

    private static void unpack(int[] rgb, int packed) {
        rgb[0] = packed >> 16 & 0xFF;
        rgb[1] = packed >> 8 & 0xFF;
        rgb[2] = packed & 0xFF;
    }

    private static int getR(int packed) {
        return packed >> 16 & 0xFF;
    }

    private static int getG(int packed) {
        return packed >> 8 & 0xFF;
    }

    private static int getB(int packed) {
        return packed & 0xFF;
    }

    private void fill(int x, int y, int w, int h, int packed) {
        for (int Y = y; Y < y + h; ++Y) {
            int i = this.xy2i(x, Y);
            for (int X = x; X < x + w; ++X) {
                this.pix[i++] = packed;
            }
        }
    }

    public void clearScreen() {
        if (this.TOP == -1) {
            this.LEFT = 0;
            this.RIGHT = this.W - 1;
            this.TOP = 0;
            this.BOTTOM = this.H - 1;
        }
        this.LEFT = Math.max(this.LEFT, 0);
        this.RIGHT = Math.min(this.RIGHT, this.W - 1);
        this.TOP = Math.max(this.TOP, 0);
        this.BOTTOM = Math.min(this.BOTTOM, this.H - 1);
        this.fill(this.LEFT, this.TOP, 1 + this.RIGHT - this.LEFT, 1 + this.BOTTOM - this.TOP, this.isOutline ? this.white : this.bgColor);
        if (this.zbuffer == null) {
            this.zbuffer = new int[this.W * this.H];
        }
        for (int y = this.TOP; y <= this.BOTTOM; ++y) {
            int i = this.xy2i(this.LEFT, y);
            for (int x = this.LEFT; x <= this.RIGHT; ++x) {
                this.zbuffer[i++] = Integer.MIN_VALUE;
            }
        }
        this.LEFT = this.W + 1;
        this.RIGHT = -1;
        this.TOP = this.H + 1;
        this.BOTTOM = -1;
    }

    private synchronized void computeCamera() {
        if (this.theta == 0.0 && this.phi == 0.0) {
            return;
        }
        this.changeCamera(this.theta, this.phi);
        this.phi = 0.0;
        this.theta = 0.0;
    }

    private synchronized void changeCamera(double theta, double phi) {
        Matrix.identity(this.camtmp);
        Matrix.rotateY(this.camtmp, theta);
        Matrix.postMultiply(this.camera, this.camtmp);
        Matrix.identity(this.camtmp);
        Matrix.rotateX(this.camtmp, phi);
        Matrix.postMultiply(this.camera, this.camtmp);
        if (this.isHeadsUp) {
            Matrix.identity(this.camtmp);
            Matrix.rotateZ(this.camtmp, 0.3 * Math.atan2(this.camera[0][1], this.camera[1][1]));
            Matrix.postMultiply(this.camera, this.camtmp);
        }
    }

    private void renderWorld() {
        if (this.updateTransparency) {
            this.tS = new Geometry[this.countT(this.world)];
        }
        this.nt = 0;
        this.renderT = false;
        Matrix.copy(this.world.matrix, this.world.globalMatrix);
        this.render(this.world, this.camera);
        this.renderT = true;
        for (int i = 0; i < this.nt; ++i) {
            this.renderGeometry(this.tS[i]);
        }
    }

    private double transparencyOf(Geometry s) {
        return s.material == null ? 0.0 : s.material.transparency;
    }

    private int countT(Geometry s) {
        int n;
        int n2 = n = this.transparencyOf(s) == 0.0 ? 0 : 1;
        if (s.child != null) {
            for (int i = 0; i < s.child.length && s.child[i] != null; ++i) {
                n += this.countT(s.child[i]);
            }
        }
        return n;
    }

    private void render(Geometry s, double[][] camera) {
        if (s.child != null) {
            double[][] cam = new double[4][4];
            Matrix.copy(camera, cam);
            double[][] mat = new double[4][4];
            Matrix.copy(s.globalMatrix, mat);
            for (int i = 0; i < s.child.length && s.child[i] != null; ++i) {
                Matrix.copy(mat, s.child[i].globalMatrix);
                Matrix.preMultiply(s.child[i].globalMatrix, s.child[i].matrix);
                this.render(s.child[i], cam);
            }
        } else if (s.faces != null && s.vertices != null) {
            this.renderGeometry(s);
        }
    }

    public void renderGeometry(Geometry s) {
        Matrix.copy(s.globalMatrix, this.matrix);
        Matrix.postMultiply(this.matrix, this.camera);
        if (!this.renderT && this.transparencyOf(s) != 0.0) {
            this.tS[this.nt++] = s;
            return;
        }
        if (this.t == null || this.t.length < s.vertices.length) {
            this.t = new int[s.vertices.length][6];
        }
        Matrix.copy(this.matrix, this.normat);
        for (int j = 0; j < 3; ++j) {
            int i;
            double r = 0.0;
            for (i = 0; i < 3; ++i) {
                r += this.normat[i][j] * this.normat[i][j];
            }
            for (i = 0; i < 3; ++i) {
                double[] dArray = this.normat[i];
                int n = j;
                dArray[n] = dArray[n] / r;
            }
        }
        this.transparency = this.transparencyOf(s);
        boolean i = false;
        int m = s.meshRowSize;
        if (m >= 0) {
            s.computeMeshNormals();
        }
        s.modified = false;
        if (this.lod > 1 && m >= 40) {
            int I;
            int J;
            int M = m + 1;
            int N = s.vertices.length / M;
            for (J = 0; J <= N; ++J) {
                for (I = 0; I <= M; ++I) {
                    int k = Math.min(J, N - 1) * M + Math.min(I, M - 1);
                    this.transformVertex(this.matrix, s.vertices[k], k);
                    this.t[k][3] = 1234567;
                }
            }
            for (J = 0; J <= N - 1 - this.lod; J += this.lod) {
                for (I = 0; I <= M - 1 - this.lod; I += this.lod) {
                    int a = J * M + I;
                    int b = J * M + I + this.lod;
                    int c = (J + this.lod) * M + I;
                    int d = (J + this.lod) * M + I + this.lod;
                    if (b % M >= M - this.lod) {
                        b = (b / M + 1) * M - 1;
                    }
                    if (d % M >= M - this.lod) {
                        d = (d / M + 1) * M - 1;
                    }
                    if (c >= M * (N - this.lod)) {
                        c = M * (N - 1) + c % M;
                    }
                    if (d >= M * (N - this.lod)) {
                        d = M * (N - 1) + d % M;
                    }
                    this.fillTriangle(s, a, b, c);
                    this.fillTriangle(s, b, d, c);
                }
            }
        } else {
            for (int k = 0; k < s.vertices.length; ++k) {
                this.transformVertex(this.matrix, s.vertices[k], k);
                this.t[k][3] = 1234567;
            }
            for (int j = 0; j < s.faces.length; ++j) {
                int[] f = s.faces[j];
                for (int k = 1; k < f.length - 1; ++k) {
                    this.fillTriangle(s, f[0], f[k], f[k + 1]);
                }
            }
        }
    }

    private void transformVertex(double[][] matrix, double[] v, int i) {
        this.xf(matrix, v[0], v[1], v[2], 1.0, this.ti);
        this.ti[0] = (double)(this.W / 2) + (double)this.W * this.ti[0] / (this.FL - this.ti[2]) / this.FOV;
        this.ti[1] = (double)(this.H / 2) - (double)this.W * this.ti[1] / (this.FL - this.ti[2]) / this.FOV;
        this.ti[2] = (double)1000 * this.ti[2];
        for (int j = 0; j < 3; ++j) {
            this.t[i][j] = (int)this.ti[j] << 14;
        }
    }

    private void renderVertex(Geometry s, int i) {
        int j;
        if (this.t[i][3] != 1234567) {
            return;
        }
        double[] v = s.vertices[i];
        double[] nn = this.normal;
        this.xf(this.normat, v[3], v[4], v[5], 0.0, nn);
        Vec.normalize((double[])nn);
        for (j = 0; j < 3; ++j) {
            this.ti[j + 3] = nn[j];
        }
        this.renderVertex(this.ti, s.material);
        for (j = 3; j < 6; ++j) {
            this.t[i][j] = (int)this.ti[j] << 14;
        }
    }

    private void fillTriangle(Geometry s, int iA, int iB, int iC) {
        int y0;
        int[] A = this.t[iA];
        int[] B = this.t[iB];
        int[] C = this.t[iC];
        if (this.backfacing(A, B, C) || this.same(A, B) || this.same(B, C)) {
            return;
        }
        this.renderVertex(s, iA);
        this.renderVertex(s, iB);
        this.renderVertex(s, iC);
        int n = A[1] < B[1] ? (A[1] < C[1] ? 0 : 2) : (y0 = B[1] < C[1] ? 1 : 2);
        int y2 = A[1] > B[1] ? (A[1] > C[1] ? 0 : 2) : (B[1] > C[1] ? 1 : 2);
        int y1 = 3 - (y0 + y2);
        if (y0 == y2) {
            return;
        }
        int[] nArray = y0 == 0 ? A : (this.a = y0 == 1 ? B : C);
        int[] nArray2 = y1 == 0 ? A : (this.b = y1 == 1 ? B : C);
        this.d = y2 == 0 ? A : (y2 == 1 ? B : C);
        this.LEFT = Math.min(this.LEFT, Math.min(Math.min(A[0], B[0]), C[0]) >> 14);
        this.RIGHT = Math.max(this.RIGHT, Math.max(Math.max(A[0], B[0]), C[0]) >> 14);
        this.TOP = Math.min(this.TOP, Math.min(Math.min(A[1], B[1]), C[1]) >> 14);
        this.BOTTOM = Math.max(this.BOTTOM, Math.max(Math.max(A[1], B[1]), C[1]) >> 14);
        double t = (double)(this.b[1] - this.a[1]) / (double)(this.d[1] - this.a[1]);
        for (int i = 0; i < 6; ++i) {
            this.c[i] = (int)((double)this.a[i] + t * (double)(this.d[i] - this.a[i]));
        }
        if (y1 == (y0 + 1) % 3 == this.c[0] > this.b[0]) {
            if (this.b[0] < this.c[0]) {
                this.fillTrapezoid(this.a, this.a, this.b, this.c);
                this.fillTrapezoid(this.b, this.c, this.d, this.d);
            }
            if (this.b[0] > this.c[0]) {
                this.fillTrapezoid(this.a, this.a, this.c, this.b);
                this.fillTrapezoid(this.c, this.b, this.d, this.d);
            }
        }
    }

    private boolean same(int[] A, int[] B) {
        return this.same(A[0], B[0]) && this.same(A[1], B[1]) && this.same(A[2], B[2]);
    }

    private boolean same(int A, int B) {
        return Math.abs(A - B) < 64;
    }

    private boolean backfacing(int[] A, int[] B, int[] C) {
        return this.areaUnder(A, B) + this.areaUnder(B, C) + this.areaUnder(C, A) < 0;
    }

    private int areaUnder(int[] A, int[] B) {
        return (B[0] - A[0] >> 14) * (B[1] + A[1] >> 14);
    }

    private void fillTrapezoid(int[] A, int[] B, int[] C, int[] D) {
        int[] zb = this.zbuffer;
        int[] px = this.pix;
        int yLo = A[1] >> 14;
        int yHi = C[1] >> 14;
        if (yHi < 0 || yLo >= this.H) {
            return;
        }
        int deltaY = yHi - yLo;
        if (deltaY <= 0) {
            return;
        }
        int xL = A[0];
        int zL = A[2];
        int rL = A[3];
        int gL = A[4];
        int bL = A[5];
        int dxL = (C[0] - A[0]) / deltaY;
        int dzL = (C[2] - A[2]) / deltaY;
        int drL = (C[3] - A[3]) / deltaY;
        int dgL = (C[4] - A[4]) / deltaY;
        int dbL = (C[5] - A[5]) / deltaY;
        int xR = B[0];
        int zR = B[2];
        int rR = B[3];
        int gR = B[4];
        int bR = B[5];
        int dxR = (D[0] - B[0]) / deltaY;
        int dzR = (D[2] - B[2]) / deltaY;
        int drR = (D[3] - B[3]) / deltaY;
        int dgR = (D[4] - B[4]) / deltaY;
        int dbR = (D[5] - B[5]) / deltaY;
        int dz = 0;
        int dr = 0;
        int dg = 0;
        int db = 0;
        boolean isOpaque = this.transparency == 0.0;
        int opacity = (int)((1.0 - Math.abs(this.transparency)) * (double)16384);
        if (yLo < 0) {
            xL -= dxL * yLo;
            zL -= dzL * yLo;
            rL -= drL * yLo;
            gL -= dgL * yLo;
            bL -= dbL * yLo;
            xR -= dxR * yLo;
            zR -= dzR * yLo;
            rR -= drR * yLo;
            gR -= dgR * yLo;
            bR -= dbR * yLo;
            yLo = 0;
        }
        yHi = Math.min(yHi, this.H);
        for (int y = yLo; y < yHi; ++y) {
            int ixL = xL >> 14;
            int ixR = xR >> 14;
            int deltaX = ixR - ixL;
            int z = zL;
            int r = rL;
            int g = gL;
            int b = bL;
            if (deltaX > 0) {
                dz = (zR - zL) / deltaX;
                dr = (rR - rL) / deltaX;
                dg = (gR - gL) / deltaX;
                db = (bR - bL) / deltaX;
            }
            if (ixL < 0) {
                z -= dz * ixL;
                r -= dr * ixL;
                g -= dg * ixL;
                b -= db * ixL;
                ixL = 0;
            }
            ixR = Math.min(ixR, this.W);
            int i = this.xy2i(ixL, y);
            int op = opacity;
            for (int ix = ixL; ix < ixR; ++ix) {
                if (z > zb[i]) {
                    if (isOpaque) {
                        px[i] = Renderer.pack(r >> 14, g >> 14, b >> 14);
                    } else {
                        int packed = px[i];
                        int r0 = packed >> 16 & 0xFF;
                        int g0 = packed >> 8 & 0xFF;
                        int b0 = packed & 0xFF;
                        op = opacity;
                        px[i] = Renderer.pack(r0 + (op * ((r >> 14) - r0) >> 14), g0 + (op * ((g >> 14) - g0) >> 14), b0 + (op * ((b >> 14) - b0) >> 14));
                    }
                    if (this.showMesh && (ix == ixL || ix == ixR - 1)) {
                        px[i] = Renderer.pack(0, 0, 0);
                    }
                    zb[i] = z;
                }
                z += dz;
                r += dr;
                g += dg;
                b += db;
                ++i;
            }
            xL += dxL;
            zL += dzL;
            rL += drL;
            gL += dgL;
            bL += dbL;
            xR += dxR;
            zR += dzR;
            rR += drR;
            gR += dgR;
            bR += dbR;
        }
    }

    private void xf(double[][] m, double x, double y, double z, double w, double[] v) {
        if (w == 0.0) {
            for (int j = 0; j < 3; ++j) {
                v[j] = m[j][0] * x + m[j][1] * y + m[j][2] * z;
            }
        } else {
            for (int j = 0; j < 3; ++j) {
                v[j] = m[j][0] * x + m[j][1] * y + m[j][2] * z + m[j][3];
            }
        }
    }

    public void renderVertex(int i, Material m) {
        if (!tableMode || !m.tableMode) {
            return;
        }
        int izx = i >> m.resP;
        int iz = izx >> m.resP;
        int ix = izx & m.res - 1;
        int iy = i & m.res - 1;
        int n = 1 << m.resP - 1;
        double x = (double)(ix - n) / (double)(n - 1);
        double y = -((double)(iy - n)) / (double)(n - 1);
        double z = (double)(iz == 0 ? 1 : -1) * Math.sqrt(1.0 - x * x - y * y);
        double[] v = new double[]{0.0, 0.0, 0.0, x, y, z};
        this.renderVertex(ix, iy, iz, x, y, z, v, m);
    }

    public void renderVertex(double[] v, Material m) {
        if (m == null) {
            v[5] = 0.0;
            v[4] = 0.0;
            v[3] = 0.0;
            return;
        }
        double x = v[3];
        double y = v[4];
        double z = v[5];
        int ix = 0;
        int iy = 0;
        int iz = 0;
        if (m.anisotropic) {
            double[] a2 = new double[]{x, y, z};
            double[] a3 = new double[]{0.0, 0.0, 0.0};
            Vec.cross((double[])anis, (double[])a2, (double[])a3);
            Vec.normalize((double[])a3);
            x = a3[0];
            y = a3[1];
            z = a3[2];
        }
        if (tableMode && m.tableMode) {
            int n = 1 << m.resP - 1;
            ix = n + (int)(x * (double)(n - 1));
            iy = n - (int)(y * (double)(n - 1));
            iz = z > 0.0 ? 0 : 1;
            int packed = m.getTable(ix, iy, iz);
            if (packed != 0) {
                v[3] = packed >> 16 & 0xFF;
                v[4] = packed >> 8 & 0xFF;
                v[5] = packed & 0xFF;
                return;
            }
            x = (double)(ix - n) / (double)(n - 1);
            y = -((double)(iy - n)) / (double)(n - 1);
            z = (double)(iz == 0 ? 1 : -1) * Math.sqrt(1.0 - x * x - y * y);
        }
        this.renderVertex(ix, iy, iz, x, y, z, v, m);
    }

    private void renderVertex(int ix, int iy, int iz, double x, double y, double z, double[] v, Material m) {
        block9: {
            if (m == null) {
                return;
            }
            double rD = 0.0;
            double gD = 0.0;
            double bD = 0.0;
            double rS = 0.0;
            double gS = 0.0;
            double bS = 0.0;
            double[] C = m.color;
            double[] G = m.glow;
            boolean isShiny = C[3] != 0.0 || C[4] != 0.0 || C[5] != 0.0;
            boolean isGlowing = G[0] != 0.0 || G[1] != 0.0 || G[2] != 0.0;
            for (int i = 0; i < this.nLights; ++i) {
                double[] L = this.light[i];
                double t = L[0] * x + L[1] * y + L[2] * z;
                if (m.anisotropic) {
                    t = Math.sqrt(1.0 - t * t);
                }
                t = Math.max(0.0, t);
                if (m.noiseA != 0.0) {
                    t *= Renderer.noiseTexture(m, x, y, z);
                }
                rD += L[3] * t;
                gD += L[4] * t;
                bD += L[5] * t;
                if (!isShiny) continue;
                if (m.anisotropic) {
                    double[] a1 = new double[]{L[0], L[1], L[2] + (double)2};
                    Vec.normalize((double[])a1);
                    double[] a2 = new double[]{x, y, z};
                    t = Vec.dot((double[])a1, (double[])a2);
                    t = Math.sqrt(1.0 - t * t);
                    double dp = L[0] * v[3] + L[1] * v[4] + L[2] * v[5];
                    t = Math.max(0.0, dp * t);
                } else {
                    t = Renderer.computeFastHilite(x, y, z, L);
                }
                if (!(t > 0.0)) continue;
                t = Math.pow(t, C[6]);
                if (m.noiseA != 0.0) {
                    double d = (double)2 * (x * v[3] + y * v[4] + z * v[5]);
                    double rx = d * v[3] - x;
                    double ry = d * v[4] - y;
                    double rz = d * v[5] - z;
                    t *= Renderer.noiseTexture(m, rx, ry, rz);
                }
                rS += L[3] * t;
                gS += L[4] * t;
                bS += L[5] * t;
            }
            double red = rD * C[0];
            double grn = gD * C[1];
            double blu = bD * C[2];
            if (isShiny) {
                red += rS * C[3];
                grn += gS * C[4];
                blu += bS * C[5];
            }
            if (isGlowing) {
                red += G[0];
                grn += G[1];
                blu += G[2];
            }
            v[3] = Math.max(0.0, Math.min(255.0, (double)255 * red));
            v[4] = Math.max(0.0, Math.min(255.0, (double)255 * grn));
            v[5] = Math.max(0.0, Math.min(255.0, (double)255 * blu));
            if (!tableMode || !m.tableMode) break block9;
            m.setTable(ix, iy, iz, Renderer.pack((int)v[3], (int)v[4], (int)v[5]));
        }
    }

    private static double noiseTexture(Material m, double x, double y, double z) {
        if (m.noiseA != 0.0) {
            return 1.0 + m.noiseA * Noise.noise((double)(m.noiseF * x), (double)(m.noiseF * y), (double)(m.noiseF * z));
        }
        return 1.0;
    }

    private static double computeHilite(double x, double y, double z, double nx, double ny, double nz, double[] L) {
        double d = (double)2 * (x * nx + y * ny + z * nz);
        double rx = d * nx - x;
        double ry = d * ny - y;
        double rz = d * nz - z;
        return L[0] * rx + L[1] * ry + L[2] * rz;
    }

    private static double computeFastHilite(double nx, double ny, double nz, double[] L) {
        return (double)2 * nz * (L[0] * nx + L[1] * ny + L[2] * nz) - L[2];
    }
}

