/*
 * Decompiled with CFR 0.152.
 */
package render;

public class Matrix {
    public static double[][] tmp = new double[4][4];
    private static double[][] mat = new double[4][4];

    public static void identity(double[][] matrix) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                matrix[i][j] = i == j ? 1 : 0;
            }
        }
    }

    public static void copy(double[][] src, double[][] dst) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                dst[i][j] = src[i][j];
            }
        }
    }

    public static void preMultiply(double[][] dst, double[][] b) {
        Matrix.copy(dst, tmp);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                dst[i][j] = 0.0;
                for (int k = 0; k < 4; ++k) {
                    double[] dArray = dst[i];
                    int n = j;
                    dArray[n] = dArray[n] + tmp[i][k] * b[k][j];
                }
            }
        }
    }

    public static void postMultiply(double[][] dst, double[][] b) {
        Matrix.copy(dst, tmp);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                dst[i][j] = 0.0;
                for (int k = 0; k < 4; ++k) {
                    double[] dArray = dst[i];
                    int n = j;
                    dArray[n] = dArray[n] + b[i][k] * tmp[k][j];
                }
            }
        }
    }

    public static void translate(double[][] m, double x, double y, double z) {
        Matrix.makeTranslationMatrix(mat, x, y, z);
        Matrix.preMultiply(m, mat);
    }

    public static void rotateX(double[][] m, double theta) {
        Matrix.makeRotationMatrix(mat, 1, 2, theta);
        Matrix.preMultiply(m, mat);
    }

    public static void rotateY(double[][] m, double theta) {
        Matrix.makeRotationMatrix(mat, 2, 0, theta);
        Matrix.preMultiply(m, mat);
    }

    public static void rotateZ(double[][] m, double theta) {
        Matrix.makeRotationMatrix(mat, 0, 1, theta);
        Matrix.preMultiply(m, mat);
    }

    public static void scale(double[][] m, double x, double y, double z) {
        Matrix.makeScaleMatrix(mat, x, y, z);
        Matrix.preMultiply(m, mat);
    }

    public static void invert(double[][] src, double[][] dst) {
        int i;
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int j = 0; j < 3; ++j) {
                int i0 = (i2 + 1) % 3;
                int i1 = (i2 + 2) % 3;
                int j0 = (j + 1) % 3;
                int j1 = (j + 2) % 3;
                dst[j][i2] = src[i0][j0] * src[i1][j1] - src[i0][j1] * src[i1][j0];
            }
        }
        double determinant = src[0][0] * dst[0][0] + src[1][0] * dst[0][1] + src[2][0] * dst[0][2];
        for (i = 0; i < 3; ++i) {
            int j = 0;
            while (j < 3) {
                double[] dArray = dst[i];
                int n = j++;
                dArray[n] = dArray[n] / determinant;
            }
        }
        for (i = 0; i < 3; ++i) {
            dst[i][3] = -dst[i][0] * src[0][3] - dst[i][1] * src[1][3] - dst[i][2] * src[2][3];
        }
    }

    public static String toString(double[][] m) {
        String s = "{";
        for (int i = 0; i < 4; ++i) {
            s = String.valueOf(String.valueOf(s)).concat("{");
            for (int j = 0; j < 4; ++j) {
                int n = (int)((double)100 * m[i][j]);
                s = String.valueOf(String.valueOf(s)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf((double)n / 100.0)).concat(String.valueOf(String.valueOf(j == 3 ? "" : ","))))));
            }
            s = String.valueOf(String.valueOf(s)).concat(String.valueOf(String.valueOf("}".concat(String.valueOf(String.valueOf(i == 3 ? "" : ","))))));
        }
        return String.valueOf(String.valueOf(s)).concat("}");
    }

    private static void makeTranslationMatrix(double[][] m, double x, double y, double z) {
        Matrix.identity(m);
        m[0][3] = x;
        m[1][3] = y;
        m[2][3] = z;
    }

    private static void makeRotationMatrix(double[][] m, int i, int j, double theta) {
        Matrix.identity(m);
        double d = Math.cos(theta);
        m[j][j] = d;
        m[i][i] = d;
        m[i][j] = -Math.sin(theta);
        m[j][i] = -m[i][j];
    }

    private static void makeScaleMatrix(double[][] m, double x, double y, double z) {
        Matrix.identity(m);
        double[] dArray = m[0];
        dArray[0] = dArray[0] * x;
        double[] dArray2 = m[1];
        dArray2[1] = dArray2[1] * y;
        double[] dArray3 = m[2];
        dArray3[2] = dArray3[2] * z;
    }
}

