/*
 * Decompiled with CFR 0.152.
 */
package render;

public class Material
implements Runnable {
    private String notice = "Copyright 2001 Ken Perlin. All rights reserved.";
    public boolean tableMode = true;
    public boolean startedBackgroundCaching = false;
    public int resP;
    public int res;
    public int[] table = new int[2 * this.res * this.res];
    public boolean anisotropic = false;
    public double noiseF = 1.0;
    public double noiseA = 0.0;
    boolean isInit = this.init();
    public double[] color = new double[]{1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0};
    public double transparency = 0.0;
    public double[] glow = new double[]{0.0, 0.0, 0.0};
    private Thread t = null;
    private boolean finishedBackgroundCaching = false;

    boolean init() {
        this.initTable(7);
        this.start();
        return true;
    }

    public int getTable(int ix, int iy, int iz) {
        if (!this.tableMode || iz < 0 || iz > 1 || ix < 0 || ix >= this.res || iy < 0 || iy >= this.res) {
            return 0;
        }
        return this.table[this.tableIndex(ix, iy, iz)];
    }

    public void setTable(int ix, int iy, int iz, int p) {
        if (!this.tableMode) {
            return;
        }
        this.startedBackgroundCaching = true;
        if (iz < 0 || iz > 1 || ix < 0 || ix >= this.res || iy < 0 || iy >= this.res) {
            return;
        }
        this.table[this.tableIndex((int)ix, (int)iy, (int)iz)] = p;
    }

    public void initTable(int p) {
        if (!this.tableMode) {
            return;
        }
        this.startedBackgroundCaching = false;
        this.resP = p;
        this.res = 1 << this.resP;
        this.table = new int[2 * this.res * this.res];
        for (int iz = 0; iz < 2; ++iz) {
            for (int ix = 0; ix < this.res; ++ix) {
                for (int iy = 0; iy < this.res; ++iy) {
                    this.table[this.tableIndex((int)ix, (int)iy, (int)iz)] = 0;
                }
            }
        }
    }

    public int countTable() {
        int n = 0;
        for (int iz = 0; iz < 2; ++iz) {
            for (int ix = 0; ix < this.res; ++ix) {
                for (int iy = 0; iy < this.res; ++iy) {
                    if (this.table[this.tableIndex(ix, iy, iz)] == 0) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    private int tableIndex(int ix, int iy, int iz) {
        return (iz << this.resP | ix) << this.resP | iy;
    }

    public Material setColor(double[] c) {
        for (int i = 0; i < c.length; ++i) {
            this.color[i] = c[i];
        }
        return this;
    }

    public Material setColor(double r, double g, double b) {
        this.color[0] = r;
        this.color[1] = g;
        this.color[2] = b;
        return this;
    }

    public Material setColor(double r, double g, double b, double sr, double sg, double sb, double p) {
        this.color[0] = r;
        this.color[1] = g;
        this.color[2] = b;
        this.color[3] = sr;
        this.color[4] = sg;
        this.color[5] = sb;
        this.color[6] = p;
        return this;
    }

    public Material setTransparency(double t) {
        this.transparency = t;
        return this;
    }

    public Material setGlow(double[] g) {
        for (int i = 0; i < 3; ++i) {
            this.glow[i] = g[i];
        }
        return this;
    }

    public Material setGlow(double r, double g, double b) {
        this.glow[0] = r;
        this.glow[1] = g;
        this.glow[2] = b;
        return this;
    }

    public void start() {
        if (this.t == null) {
            this.t = new Thread(this);
            this.t.start();
        }
    }

    public void stop() {
        if (this.t != null) {
            this.t.stop();
            this.t = null;
        }
    }

    public void run() {
        while (!this.finishedBackgroundCaching) {
            try {
                if (this.tableMode && this.startedBackgroundCaching) {
                    int i;
                    int c = 0;
                    for (i = 0; i < this.table.length && (this.table[i] != 0 || c++ <= 300); ++i) {
                    }
                    this.finishedBackgroundCaching = i == this.table.length;
                }
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.stop();
    }
}

