/*
 * Decompiled with CFR 0.152.
 */
package render;

import render.Material;
import render.Matrix;
import render.Noise;
import render.Vec;

public class Geometry {
    private String notice = "Copyright 2001 Ken Perlin. All rights reserved.";
    public Material material;
    public Geometry[] child;
    public Geometry refGeometry;
    public double[] color = new double[]{1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0};
    public double[][] matrix = new double[4][4];
    public double[][] globalMatrix = new double[4][4];
    public double[][] refMatrix = new double[4][4];
    public int[][] faces;
    public double[][] vertices;
    public double[][] refVertices;
    public double transparency = 0.0;
    public double[] glow = new double[]{0.0, 0.0, 0.0};
    public int meshRowSize = -1;
    public boolean computedMeshNormals = false;
    public static double[][] mat = new double[4][4];
    public boolean modified = false;
    public static double pullWeight = 1.0;
    public static int pullMask = -1;
    private static int[][] cubeFaces = new int[][]{{0, 1, 2, 3}, {4, 5, 6, 7}, {8, 9, 10, 11}, {12, 13, 14, 15}, {16, 17, 18, 19}, {20, 21, 22, 23}};
    private static double N = -1.0;
    private static double P = 1.0;
    private static double[][] cubeVertices = new double[][]{{N, N, N, N, 0.0, 0.0}, {N, N, P, N, 0.0, 0.0}, {N, P, P, N, 0.0, 0.0}, {N, P, N, N, 0.0, 0.0}, {P, N, N, P, 0.0, 0.0}, {P, P, N, P, 0.0, 0.0}, {P, P, P, P, 0.0, 0.0}, {P, N, P, P, 0.0, 0.0}, {N, N, N, 0.0, N, 0.0}, {P, N, N, 0.0, N, 0.0}, {P, N, P, 0.0, N, 0.0}, {N, N, P, 0.0, N, 0.0}, {N, P, N, 0.0, P, 0.0}, {N, P, P, 0.0, P, 0.0}, {P, P, P, 0.0, P, 0.0}, {P, P, N, 0.0, P, 0.0}, {N, N, N, 0.0, 0.0, N}, {N, P, N, 0.0, 0.0, N}, {P, P, N, 0.0, 0.0, N}, {P, N, N, 0.0, 0.0, N}, {N, N, P, 0.0, 0.0, P}, {P, N, P, 0.0, 0.0, P}, {P, P, P, 0.0, 0.0, P}, {N, P, P, 0.0, 0.0, P}};
    private static int[][] bezeledCubeFaces = new int[][]{{0, 1, 2, 3}, {4, 5, 6, 7}, {8, 9, 10, 11}, {12, 13, 14, 15}, {16, 17, 18, 19}, {20, 21, 22, 23}, {8, 11, 1, 0}, {20, 23, 2, 1}, {13, 12, 3, 2}, {17, 16, 0, 3}, {16, 19, 9, 8}, {11, 10, 21, 20}, {23, 22, 14, 13}, {12, 15, 18, 17}, {4, 7, 10, 9}, {7, 6, 22, 21}, {6, 5, 15, 14}, {5, 4, 19, 18}, {16, 8, 0}, {11, 20, 1}, {23, 13, 2}, {12, 17, 3}, {9, 19, 4}, {21, 10, 7}, {14, 22, 6}, {18, 15, 5}};
    private static double n = -0.9;
    private static double p = 0.9;
    private static double[][] bezeledCubeVertices = new double[][]{{N, n, n, N, 0.0, 0.0}, {N, n, p, N, 0.0, 0.0}, {N, p, p, N, 0.0, 0.0}, {N, p, n, N, 0.0, 0.0}, {P, n, n, P, 0.0, 0.0}, {P, p, n, P, 0.0, 0.0}, {P, p, p, P, 0.0, 0.0}, {P, n, p, P, 0.0, 0.0}, {n, N, n, 0.0, N, 0.0}, {p, N, n, 0.0, N, 0.0}, {p, N, p, 0.0, N, 0.0}, {n, N, p, 0.0, N, 0.0}, {n, P, n, 0.0, P, 0.0}, {n, P, p, 0.0, P, 0.0}, {p, P, p, 0.0, P, 0.0}, {p, P, n, 0.0, P, 0.0}, {n, n, N, 0.0, 0.0, N}, {n, p, N, 0.0, 0.0, N}, {p, p, N, 0.0, 0.0, N}, {p, n, N, 0.0, 0.0, N}, {n, n, P, 0.0, 0.0, P}, {p, n, P, 0.0, 0.0, P}, {p, p, P, 0.0, 0.0, P}, {n, p, P, 0.0, 0.0, P}};
    private double[][] m = new double[4][4];
    private int _m;
    private int _n;
    final double UNDEFINED = 0.001234;
    double[][] vCache;
    private double[] A = new double[]{0.0, 0.0, 0.0};
    private double[] B = new double[]{0.0, 0.0, 0.0};
    private double[][] inverseOldRelMatrix = new double[4][4];
    private static final int D = 1000;
    private static double[] dropoff;
    private static boolean initDropoff;
    private double[][][] mstack = new double[10][4][4];
    private int top = 0;

    public Geometry() {
        Matrix.identity(this.matrix);
        Matrix.identity(this.globalMatrix);
        Matrix.identity(this.m());
    }

    public void setRefGeometry(Geometry s) {
        this.refGeometry = s;
    }

    public Geometry add() {
        Geometry s = this.add(new Geometry());
        s.material = this.material;
        return s;
    }

    public Geometry add(Geometry s) {
        if (this.child == null) {
            this.child = new Geometry[16];
        } else if (this.child[this.child.length - 1] != null) {
            Geometry[] c = this.child;
            this.child = new Geometry[2 * c.length];
            for (int i = 0; i < c.length; ++i) {
                this.child[i] = c[i];
            }
        }
        for (int i = 0; i < this.child.length; ++i) {
            if (this.child[i] != null) continue;
            this.child[i] = s;
            break;
        }
        return s;
    }

    public Geometry delete(Geometry s) {
        if (this.child != null) {
            for (int i = 0; i < this.child.length; ++i) {
                if (this.child[i] != s) continue;
                this.delete(i);
                break;
            }
        }
        return this;
    }

    public Geometry delete(int n) {
        if (this.child != null && n >= 0 && n < this.child.length) {
            while (n < this.child.length - 1 && this.child[n + 1] != null) {
                this.child[n] = this.child[n + 1];
                ++n;
            }
            this.child[n] = null;
        }
        return this;
    }

    public Geometry setMaterial(Material m) {
        this.material = m;
        if (this.child != null) {
            for (int i = 0; i < this.child.length; ++i) {
                if (this.child[i] == null) continue;
                this.child[i].setMaterial(m);
            }
        }
        return this;
    }

    public void setMatrix(double[][] m) {
        Matrix.copy(m, this.matrix);
    }

    public double[][] copyVertices(double[][] src) {
        return this.copyVertices(src, new double[src.length][6]);
    }

    public double[][] copyVertices(double[][] src, double[][] dst) {
        for (int i = 0; i < src.length; ++i) {
            for (int j = 0; j < 6; ++j) {
                dst[i][j] = src[i][j];
            }
        }
        return dst;
    }

    public void setVertex(int i, double x, double y, double z, double nx, double ny, double nz) {
        Geometry.setVertex(this.vertices[i], x, y, z, nx, ny, nz);
    }

    public static void setVertex(double[] v, double x, double y, double z, double nx, double ny, double nz) {
        v[0] = x;
        v[1] = y;
        v[2] = z;
        v[3] = nx;
        v[4] = ny;
        v[5] = nz;
    }

    public Geometry cube() {
        this.faces = cubeFaces;
        this.vertices = cubeVertices;
        return this;
    }

    public Geometry bezeledCube(double r) {
        this.faces = bezeledCubeFaces;
        this.vertices = this.copyVertices(bezeledCubeVertices);
        for (int i = 0; i < this.vertices.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (this.vertices[i][j] == n) {
                    this.vertices[i][j] = r - 1.0;
                }
                if (this.vertices[i][j] != p) continue;
                this.vertices[i][j] = 1.0 - r;
            }
        }
        return this;
    }

    public Geometry polygon(double[] X, double[] Y) {
        int k = X.length;
        this.faces = new int[1][k];
        this.vertices = new double[k][6];
        for (int i = 0; i < k; ++i) {
            this.faces[0][i] = i;
            this.setVertex(i, X[i], Y[i], 0.0, 0.0, 0.0, 1.0);
        }
        return this;
    }

    public Geometry disk(int k) {
        this.faces = new int[k][3];
        this.vertices = new double[k + 1][6];
        for (int i = 0; i < k; ++i) {
            this.faces[i][0] = i;
            this.faces[i][1] = (i + 1) % k;
            this.faces[i][2] = k;
            double theta = Math.PI * 2 * (double)i / (double)k;
            this.setVertex(i, Math.cos(theta), Math.sin(theta), 0.0, 0.0, 0.0, 1.0);
        }
        this.setVertex(k, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        return this;
    }

    public Geometry cylinder(int k) {
        this.child = null;
        this.add().tube(k);
        this.add().disk(k);
        this.add().disk(k);
        Matrix.identity(this.m);
        Matrix.scale(this.m, 1.0, -1.0, -1.0);
        Matrix.translate(this.m, 0.0, 0.0, 1.0);
        this.child[1].setMatrix(this.m);
        Matrix.identity(this.m);
        Matrix.translate(this.m, 0.0, 0.0, 1.0);
        this.child[2].setMatrix(this.m);
        return this;
    }

    public Geometry pill(int k, double len, double bulge) {
        return this.pill(k, len, bulge, 1.0);
    }

    public Geometry pill(int k, double len, double bulge, double taper) {
        this.child = null;
        this.add().tube(k, taper);
        this.add().globe(k, k / 2, 0.0, 1.0, 0.0, 0.5);
        this.add().globe(k, k / 2, 0.0, 1.0, 0.5, 1.0);
        Matrix.identity(this.m);
        Matrix.scale(this.m, 1.0, 1.0, len);
        this.child[0].setMatrix(this.m);
        Matrix.identity(this.m);
        Matrix.translate(this.m, 0.0, 0.0, -len);
        Matrix.scale(this.m, 1.0, 1.0, bulge);
        this.child[1].setMatrix(this.m);
        Matrix.identity(this.m);
        Matrix.translate(this.m, 0.0, 0.0, len);
        Matrix.scale(this.m, taper, taper, bulge);
        this.child[2].setMatrix(this.m);
        return this;
    }

    public Geometry ball(int n) {
        this.child = null;
        block7: for (int i = 0; i < 6; ++i) {
            Geometry s = this.add().newBallFace(n);
            switch (i) {
                case 1: {
                    Matrix.rotateX(s.matrix, 1.5707963267948966);
                    continue block7;
                }
                case 2: {
                    Matrix.rotateX(s.matrix, Math.PI);
                    continue block7;
                }
                case 3: {
                    Matrix.rotateX(s.matrix, -1.5707963267948966);
                    continue block7;
                }
                case 4: {
                    Matrix.rotateY(s.matrix, 1.5707963267948966);
                    continue block7;
                }
                case 5: {
                    Matrix.rotateY(s.matrix, -1.5707963267948966);
                }
            }
        }
        return this;
    }

    private Geometry newBallFace(int n) {
        this.newRectangularMesh(n, n);
        int N = 0;
        for (int j = 0; j <= n; ++j) {
            for (int i = 0; i <= n; ++i) {
                double x = Math.tan(0.7853981633974483 * (double)(j - n / 2) / (double)(n / 2));
                double y = Math.tan(0.7853981633974483 * (double)(i - n / 2) / (double)(n / 2));
                double r = Math.sqrt(x * x + y * y + 1.0);
                double z = (double)-1 / r;
                this.setVertex(N++, x /= r, y /= r, z, x, y, z);
            }
        }
        this.computedMeshNormals = true;
        return this;
    }

    public Geometry globe(int m, int n) {
        return this.globe(m, n, 0.0, 1.0, 0.0, 1.0);
    }

    public Geometry globe(int m, int n, double uLo, double uHi, double vLo, double vHi) {
        this.newRectangularMesh(m, n);
        int N = 0;
        for (int j = 0; j <= n; ++j) {
            for (int i = 0; i <= m; ++i) {
                double u = uLo + (double)i * (uHi - uLo) / (double)m;
                double v = vLo + (double)j * (vHi - vLo) / (double)n;
                double theta = (double)2 * u * Math.PI;
                double phi = (v - 0.5) * Math.PI;
                double x = Math.cos(phi) * Math.cos(theta);
                double y = Math.cos(phi) * Math.sin(theta);
                double z = Math.sin(phi);
                this.setVertex(N++, x, y, z, x, y, z);
            }
        }
        this.computedMeshNormals = true;
        return this;
    }

    public Geometry tube(int k) {
        double[][] path = new double[][]{{0.0, 0.0, -1.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 1.0, 0.0, 0.0}};
        return this.wire(k, path, 1.0);
    }

    public Geometry wire(int m, int n, double[][] key, double r) {
        return this.wire(m, Geometry.makePath(n, key), r);
    }

    public Geometry wire(int m, double[][] path, double r) {
        return this.extrusion(Geometry.makeCircle(m, r), path);
    }

    public Geometry extrusion(double[][] O, double[][] P) {
        int m = O.length - 1;
        int n = P.length - 1;
        this.newRectangularMesh(m, n);
        double[] U = new double[3];
        double[] V = new double[3];
        double[] W = new double[3];
        boolean loop = this.same(P[0], P[n]);
        int N = 0;
        for (int j = 0; j <= n; ++j) {
            for (int k = 0; k < 3; ++k) {
                U[k] = P[j][k + 3];
                W[k] = j == n ? (loop ? P[1][k] - P[0][k] : P[n][k] - P[n - 1][k]) : P[j + 1][k] - P[j][k];
            }
            double radius = Vec.norm((double[])U);
            this.computeCrossVectors(W, U, V);
            for (int i = 0; i <= m; ++i) {
                double x = O[i][0];
                double y = O[i][1];
                double z = O[i][2];
                for (int k = 0; k < 3; ++k) {
                    this.vertices[N][k] = P[j][k] + radius * (x * U[k] - y * V[k] + z * W[k]);
                }
                ++N;
            }
            double ux = U[0];
            double uy = U[1];
            double d = U[2];
        }
        if (loop) {
            for (int i = 0; i <= m; ++i) {
                for (int k = 0; k < 3; ++k) {
                    this.vertices[this.indx((int)m, (int)n, (int)i, (int)n)][k] = this.vertices[this.indx(m, n, i, 0)][k];
                }
            }
        }
        return this;
    }

    public void computeCrossVectors(double[] W, double[] U, double[] V) {
        Vec.normalize((double[])W);
        Vec.normalize((double[])U);
        Vec.cross((double[])W, (double[])U, (double[])V);
        Vec.normalize((double[])V);
        Vec.cross((double[])V, (double[])W, (double[])U);
        Vec.normalize((double[])U);
    }

    private double[] V(int i, int j) {
        return this.vertices[this.indx(this._m, this._n, i, j)];
    }

    public void computeMeshNormals() {
        if (this.computedMeshNormals) {
            return;
        }
        if (this.meshRowSize < 0) {
            return;
        }
        int m = this.meshRowSize;
        int n = this.vertices.length / (m + 1) - 1;
        this._m = m;
        this._n = n;
        double[] nn = new double[3];
        double[] A = new double[3];
        double[] B = new double[3];
        boolean loopI = this.same(this.vertices[this.indx(m, n, 0, 0)], this.vertices[this.indx(m, n, m, 0)]);
        boolean loopJ = this.same(this.vertices[this.indx(m, n, 0, 0)], this.vertices[this.indx(m, n, 0, n)]);
        int N = 0;
        for (int j = 0; j <= n; ++j) {
            for (int i = 0; i <= m; ++i) {
                int k;
                if (i == 0) {
                    for (k = 0; k < 3; ++k) {
                        A[k] = 1.5 * (this.V(i + 1, j)[k] - this.V(i, j)[k]) - 0.5 * (this.V(i + 2, j)[k] - this.V(i + 1, j)[k]);
                    }
                } else if (i == m) {
                    for (k = 0; k < 3; ++k) {
                        A[k] = 1.5 * (this.V(i, j)[k] - this.V(i - 1, j)[k]) - 0.5 * (this.V(i - 1, j)[k] - this.V(i - 2, j)[k]);
                    }
                } else {
                    for (k = 0; k < 3; ++k) {
                        A[k] = 0.5 * (this.V(i + 1, j)[k] - this.V(i - 1, j)[k]);
                    }
                }
                if (j == 0) {
                    for (k = 0; k < 3; ++k) {
                        B[k] = 1.5 * (this.V(i, j + 1)[k] - this.V(i, j)[k]) - 0.5 * (this.V(i, j + 2)[k] - this.V(i, j + 1)[k]);
                    }
                } else if (j == n) {
                    for (k = 0; k < 3; ++k) {
                        B[k] = 1.5 * (this.V(i, j)[k] - this.V(i, j - 1)[k]) - 0.5 * (this.V(i, j - 1)[k] - this.V(i, j - 2)[k]);
                    }
                } else {
                    for (k = 0; k < 3; ++k) {
                        B[k] = 0.5 * (this.V(i, j + 1)[k] - this.V(i, j - 1)[k]);
                    }
                }
                Vec.cross((double[])B, (double[])A, (double[])nn);
                Vec.normalize((double[])nn);
                for (k = 0; k < 3; ++k) {
                    this.vertices[N][k + 3] = nn[k];
                }
                ++N;
            }
        }
        this.computedMeshNormals = true;
    }

    private int indx(int m, int n, int i, int j) {
        return j * (m + 1) + i;
    }

    public Geometry tube(int m, double taper) {
        double[] T = new double[]{-1.0, 1.0};
        double[] C = new double[]{1.0, taper};
        return this.latheGen(m, T, C, false);
    }

    public Geometry lathe(int m, int n, double[] Z, double[] R) {
        double[] T = new double[n + 1];
        double[] C = new double[n + 1];
        Geometry.makeCurve(Z, R, T, C);
        return this.latheGen(m, T, C, true);
    }

    public Geometry latheGen(int m, double[] T, double[] C, boolean round) {
        int n = T.length - 1;
        this.newRectangularMesh(m, n);
        for (int i = 0; i <= n; ++i) {
            for (int j = 0; j <= m; ++j) {
                double theta = Math.PI * 2 * (double)j / (double)m;
                double x = Math.cos(theta);
                double y = Math.sin(theta);
                double z = T[i];
                double r = C[i];
                double sign = T[0] < T[n] ? 1 : -1;
                double dr = round ? (i == 0 ? -sign : (i == n ? sign : (C[i + 1] - C[i - 1]) / ((double)2 * r))) : (C[1] - C[0]) / r;
                double[] nn = new double[]{r * x, r * y, dr};
                Vec.normalize((double[])nn);
                this.setVertex(i * (m + 1) + j, r * x, r * y, z, nn[0], nn[1], nn[2]);
            }
        }
        this.computedMeshNormals = true;
        return this;
    }

    private void newRectangularMesh(int m, int n) {
        this.meshRowSize = m;
        this.faces = new int[m * n][4];
        for (int k = 0; k < n; ++k) {
            for (int j = 0; j < m; ++j) {
                int v;
                int f = k * m + j;
                this.faces[f][0] = v = k * (m + 1) + j;
                this.faces[f][1] = v + 1;
                this.faces[f][2] = v + m + 1 + 1;
                this.faces[f][3] = v + m + 1;
            }
        }
        this.vertices = new double[(m + 1) * (n + 1)][6];
        this.computedMeshNormals = false;
    }

    public static double[][] makePath(int n, double[][] key) {
        double[][] P = new double[n + 1][6];
        for (int i = 0; i <= n; ++i) {
            double t = (double)i / ((double)n + 0.001);
            double f = t * (double)(key.length - 1);
            int k = (int)f;
            for (int j = 0; j < 3; ++j) {
                P[i][j] = Geometry.hermite(0.0, 1.0, key[k][j], key[k + 1][j], key[k][3 + j], key[k + 1][3 + j], f % 1.0);
            }
        }
        return P;
    }

    public static double[][] makeCircle(int n, double radius) {
        double[][] P = new double[n + 1][6];
        for (int i = 0; i <= n; ++i) {
            double theta = Math.PI * 2 * (double)i / (double)n;
            double cos = Math.cos(theta);
            double sin = Math.sin(theta);
            P[i][0] = radius * cos;
            P[i][1] = radius * sin;
            P[i][2] = 0.0;
            P[i][3] = cos;
            P[i][4] = sin;
            P[i][5] = 0.0;
        }
        return P;
    }

    public static double[][] makeRectangle(double w, double h) {
        double[][] P = new double[8][6];
        Geometry.setVertex(P[0], -w, -h, 0.0, -1.0, 0.0, 0.0);
        Geometry.setVertex(P[1], -w, h, 0.0, -1.0, 0.0, 0.0);
        Geometry.setVertex(P[2], -w, h, 0.0, 0.0, 1.0, 0.0);
        Geometry.setVertex(P[3], w, h, 0.0, 0.0, 1.0, 0.0);
        Geometry.setVertex(P[4], w, h, 0.0, 1.0, 0.0, 0.0);
        Geometry.setVertex(P[5], w, -h, 0.0, 1.0, 0.0, 0.0);
        Geometry.setVertex(P[6], w, -h, 0.0, 0.0, -1.0, 0.0);
        Geometry.setVertex(P[7], -w, -h, 0.0, 0.0, -1.0, 0.0);
        return P;
    }

    public static void makeCurve(double[] X, double[] Y, double[] T, double[] C) {
        double[] S = new double[X.length];
        int n = X.length;
        for (int i = 1; i < n - 1; ++i) {
            S[i] = Y[i] >= Y[i - 1] == Y[i] >= Y[i + 1] ? 0.0 : ((Y[i + 1] - Y[i]) * (X[i] - X[i - 1]) + (Y[i] - Y[i - 1]) * (X[i + 1] - X[i])) / ((X[i + 1] - X[i - 1]) * (X[i + 1] - X[i - 1]));
        }
        S[0] = (double)2 * (Y[1] - Y[0]) / (X[1] - X[0]) - S[1];
        S[n - 1] = (double)2 * (Y[n - 1] - Y[n - 2]) / (X[n - 1] - X[n - 2]) - S[n - 2];
        int k = C.length;
        for (int j = 0; j < k; ++j) {
            int i;
            double t = (double)j / ((double)k - 0.99);
            double x = X[0] + t * (X[n - 1] - X[0]);
            for (i = 0; !(i >= n - 1 || x >= X[i] && x < X[i + 1]); ++i) {
            }
            T[j] = x;
            C[j] = Geometry.hermite(X[i], X[i + 1], Y[i], Y[i + 1], S[i], S[i + 1], x);
        }
    }

    private static double hermite(double x0, double x1, double y0, double y1, double s0, double s1, double x) {
        double t = (x - x0) / (x1 - x0);
        double s = 1.0 - t;
        return y0 * s * s * ((double)3 - (double)2 * s) + s0 * (1.0 - s) * s * s - s1 * (1.0 - t) * t * t + y1 * t * t * ((double)3 - (double)2 * t);
    }

    private boolean same(double[] a, double[] b) {
        return Math.abs(a[0] - b[0]) < 0.01 && Math.abs(a[1] - b[1]) < 0.01 && Math.abs(a[2] - b[2]) < 0.01;
    }

    public void superquadric(double p, double h) {
        this.superquadric(this.globalMatrix, p, h);
    }

    public void superquadric(double[][] mat, double p, double h) {
        if (this.child != null) {
            for (int i = 0; i < this.child.length; ++i) {
                if (this.child[i] == null) continue;
                double[][] tmp = new double[4][4];
                Matrix.copy(mat, tmp);
                Matrix.preMultiply(tmp, this.child[i].matrix);
                this.child[i].superquadric(tmp, p, h);
            }
            return;
        }
        double[][] v = this.vertices;
        double[] w = new double[3];
        double[][] inv = new double[4][4];
        Matrix.invert(mat, inv);
        for (int k = 0; k < v.length; ++k) {
            this.transform(v[k], mat, w);
            double x = Math.abs(w[0]);
            double y = Math.abs(w[1]);
            double z = Math.abs(w[2]);
            double t = Math.pow(Math.pow(x, p) + Math.pow(y, p) + Math.pow(z, p), 1.0 / p);
            w[0] = w[0] / t;
            w[1] = w[1] / t;
            w[2] = w[2] / t;
            if (h > 0.0) {
                t = Math.pow(w[0] * w[0] + w[1] * w[1] + w[2] * w[2], h);
                w[0] = w[0] * t;
                w[1] = w[1] * t;
                w[2] = w[2] * t;
            }
            this.transform(w, inv, v[k]);
        }
        this.computedMeshNormals = false;
    }

    public void addNoise(double freq, double ampl) {
        this.addNoise(this.globalMatrix, freq, ampl);
    }

    public void addNoise(double[][] mat, double freq, double ampl) {
        if (this.child != null) {
            for (int i = 0; i < this.child.length; ++i) {
                if (this.child[i] == null) continue;
                double[][] tmp = new double[4][4];
                Matrix.copy(mat, tmp);
                Matrix.preMultiply(tmp, this.child[i].matrix);
                this.child[i].addNoise(tmp, freq, ampl);
            }
            return;
        }
        double[][] v = this.vertices;
        double[] w = new double[3];
        double[] vn = new double[3];
        double[] wn = new double[3];
        double[][] inv = new double[4][4];
        double[][] matn = new double[4][4];
        Matrix.copy(mat, matn);
        matn[2][3] = 0.0;
        matn[1][3] = 0.0;
        matn[0][3] = 0.0;
        Matrix.invert(mat, inv);
        for (int k = 0; k < v.length; ++k) {
            this.transform(v[k], mat, w);
            for (int j = 0; j < 3; ++j) {
                vn[j] = v[k][3 + j];
            }
            this.transform(vn, matn, wn);
            double x = freq * w[0];
            double y = freq * w[1];
            double z = freq * w[2] + (double)100;
            double t = ampl * Noise.noise((double)x, (double)y, (double)z);
            for (int j = 0; j < 3; ++j) {
                int n = j;
                w[n] = w[n] + t * wn[j];
            }
            this.transform(w, inv, v[k]);
        }
        this.computedMeshNormals = false;
    }

    public void sew(Geometry s, int a, int b) {
        this.sew(s, a, b, null);
    }

    public void sew(Geometry s, int a, int b, double[][] m) {
        int j2;
        int am = this.meshRowSize;
        int an = this.vertices.length / (am + 1) - 1;
        int bm = s.meshRowSize;
        int bn = s.vertices.length / (bm + 1) - 1;
        int j1 = a == 0 ? 0 : an * (am + 1);
        int n = j2 = b == 0 ? 0 : bn * (bm + 1);
        if (am >= bm) {
            for (int i = 0; i <= am; ++i) {
                this.sewVertex(this.vertices[j1 + i], m, s.vertices[j2 + i * bm / am]);
            }
        } else {
            for (int i = 0; i <= bm; ++i) {
                this.sewVertex(this.vertices[j1 + i * am / bm], m, s.vertices[j2 + i]);
            }
        }
    }

    private void sewVertex(double[] v1, double[][] m, double[] v2) {
        if (m != null) {
            this.transformVertex(v1, m, v2);
        } else {
            this.copyVertex(v1, v2);
        }
    }

    public void copyVertex(double[] src, double[] dst) {
        for (int j = 0; j < dst.length; ++j) {
            dst[j] = src[j];
        }
    }

    void transformVertex(double[] src, double[][] m, double[] dst) {
        for (int i = 0; i < 3; ++i) {
            dst[i] = src[0] * m[i][0] + src[1] * m[i][1] + src[2] * m[i][2] + m[i][3];
        }
        dst[3] = src[3];
        dst[4] = src[4];
        dst[5] = src[5];
    }

    public int pull(double[][] m, double x0, double x1, double x2, double y0, double y1, double y2, double z0, double z1, double z2) {
        double[][] tmp1 = new double[4][4];
        Matrix.identity(tmp1);
        double[][] tmp2 = new double[4][4];
        Matrix.invert(this.globalMatrix, tmp2);
        Matrix.preMultiply(tmp2, m);
        return this.pull(tmp1, tmp2, x0, x1, x2, y0, y1, y2, z0, z1, z2);
    }

    public int pull(double[][] oldRelMatrix, double[][] newRelMatrix, double x0, double x1, double x2, double y0, double y1, double y2, double z0, double z1, double z2) {
        int mask = 0;
        if (this.child != null) {
            double[] v = new double[3];
            for (int i = 0; i < this.child.length; ++i) {
                if (this.child[i] == null) continue;
                double[][] tmp1 = new double[4][4];
                Matrix.copy(oldRelMatrix, tmp1);
                Matrix.preMultiply(tmp1, this.child[i].matrix);
                double[][] tmp2 = new double[4][4];
                Matrix.copy(newRelMatrix, tmp2);
                Matrix.preMultiply(tmp2, this.child[i].matrix);
                if ((pullMask & 1 << i) == 0 || this.child[i].pull(tmp1, tmp2, x0, x1, x2, y0, y1, y2, z0, z1, z2) == 0) continue;
                mask |= 1 << i;
            }
            return mask;
        }
        if (this.refVertices == null) {
            this.refVertices = this.copyVertices(this.vertices);
            this.vCache = new double[this.vertices.length][3];
        }
        if (!this.modified) {
            this.copyVertices(this.refVertices, this.vertices);
            for (int i = 0; i < this.vCache.length; ++i) {
                this.vCache[i][0] = 0.001234;
            }
            this.modified = true;
        }
        Matrix.invert(oldRelMatrix, this.inverseOldRelMatrix);
        boolean pulled = false;
        for (int i = 0; i < this.vertices.length; ++i) {
            double f;
            double d;
            double d2;
            double d3;
            double[] v = this.vertices[i];
            double[] w = this.vCache[i];
            if (w[0] == 0.001234) {
                this.transform(v, oldRelMatrix, w);
            }
            double fx = this.lump(w[0], x0, x1, x2);
            if (d3 >= 1.0) continue;
            double fy = this.lump(w[1], y0, y1, y2);
            if (d2 >= 1.0) continue;
            double fz = this.lump(w[2], z0, z1, z2);
            if (d >= 1.0) continue;
            pulled = true;
            if (fx < 0.0) {
                fx = 0.0;
            }
            if (fy < 0.0) {
                fy = 0.0;
            }
            if (fz < 0.0) {
                fz = 0.0;
            }
            if (!((f = fx * fx + fy * fy + fz * fz) < 1.0)) continue;
            if (f == 0.0) {
                this.transform(v, newRelMatrix, w);
            } else {
                this.transform(v, newRelMatrix, this.B);
                f = dropoff[(int)((double)1000 * f)] * pullWeight;
                w[0] = w[0] + f * (this.B[0] - w[0]);
                w[1] = w[1] + f * (this.B[1] - w[1]);
                w[2] = w[2] + f * (this.B[2] - w[2]);
            }
            this.transform(w, this.inverseOldRelMatrix, v);
        }
        if (pulled) {
            this.computedMeshNormals = false;
        }
        return pulled ? 1 : 0;
    }

    private static boolean computeDropoff() {
        for (int i = 0; i < 1000; ++i) {
            double f = (double)i / (double)1000;
            Geometry.dropoff[i] = 0.5 + 0.5 * Math.cos(Math.PI * Math.sqrt(f));
        }
        return true;
    }

    private double lump(double t, double a, double b, double c) {
        if (a == c) {
            return 0.0;
        }
        t = a == b || t < b && c < b || t > b && c > b ? (t - b) / (c - b) : (t - b) / (a - b);
        return t >= 1.0 ? 1.0 : t;
    }

    void transform(double[] src, double[][] m, double[] dst) {
        dst[0] = m[0][0] * src[0] + m[0][1] * src[1] + m[0][2] * src[2] + m[0][3];
        dst[1] = m[1][0] * src[0] + m[1][1] * src[1] + m[1][2] * src[2] + m[1][3];
        dst[2] = m[2][0] * src[0] + m[2][1] * src[1] + m[2][2] * src[2] + m[2][3];
    }

    public void identity() {
        Matrix.identity(this.m());
    }

    public double[][] m() {
        return this.mstack[this.top];
    }

    public void pop() {
        --this.top;
    }

    public void push() {
        Matrix.copy(this.m(), this.mstack[this.top + 1]);
        ++this.top;
    }

    public void rotateX(double t) {
        Matrix.rotateX(this.m(), t);
    }

    public void rotateY(double t) {
        Matrix.rotateY(this.m(), t);
    }

    public void rotateZ(double t) {
        Matrix.rotateZ(this.m(), t);
    }

    public void scale(double x, double y, double z) {
        Matrix.scale(this.m(), x, y, z);
    }

    public void transform() {
        this.setMatrix(this.m());
    }

    public void transform(Geometry s) {
        s.setMatrix(this.m());
    }

    public void translate(double x, double y, double z) {
        Matrix.translate(this.m(), x, y, z);
    }

    static {
        D = 1000;
        dropoff = new double[1000];
        initDropoff = Geometry.computeDropoff();
    }
}

