/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.perlinrenderer;

import edu.cmu.cs.stage3.alice.scenegraph.Background;
import edu.cmu.cs.stage3.alice.scenegraph.Camera;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.Component;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.OrthographicCamera;
import edu.cmu.cs.stage3.alice.scenegraph.PerspectiveCamera;
import edu.cmu.cs.stage3.alice.scenegraph.Scene;
import edu.cmu.cs.stage3.alice.scenegraph.SymmetricPerspectiveCamera;
import edu.cmu.cs.stage3.alice.scenegraph.TextureMap;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.AbstractRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.AbstractRenderer;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.DisplayDevice;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.DisplayDriver;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.PickInfo;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.perlinrenderer.Renderer;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Vector3;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.vecmath.Matrix4d;
import render.Material;
import render.Matrix;

public abstract class RenderTarget
extends AbstractRenderTarget {
    private boolean m_updateIsRequired = true;
    private DisplayDriver m_displayDriver = null;
    private DisplayDevice m_displayDevice = null;
    protected int[] pix;
    protected int W;
    protected int H;
    private render.Renderer m_perlinRenderer = new render.Renderer();
    private double m_silhouetteThickness = 0.0;

    protected void onNewPixels() {
    }

    protected void markSizeDirty() {
        this.markDirty();
    }

    protected void commitIfNecessary() {
        if (this.pix == null) {
            Dimension size = this.getSize();
            if (size.width > 0 && size.height > 0) {
                this.pix = this.m_perlinRenderer.init(size.width, size.height);
                this.W = size.width;
                this.H = size.height;
                this.onNewPixels();
                this.m_perlinRenderer.outline(10.0);
                Material m = new Material();
                this.m_perlinRenderer.getWorld().setMaterial(m);
            }
        }
    }

    RenderTarget(Renderer renderer) {
        super((AbstractRenderer)renderer);
    }

    public void markDirty() {
        this.m_updateIsRequired = true;
    }

    public boolean updateIsRequired() {
        return this.m_updateIsRequired;
    }

    public Matrix4d getProjectionMatrix(Camera camera) {
        return null;
    }

    public double[] getActualPlane(OrthographicCamera sgOrthographicCamera) {
        return null;
    }

    public double[] getActualPlane(PerspectiveCamera sgPerspectiveCamera) {
        return null;
    }

    public double getActualHorizontalViewingAngle(SymmetricPerspectiveCamera sgSymmetricPerspectiveCamera) {
        return Double.NaN;
    }

    public double getActualVerticalViewingAngle(SymmetricPerspectiveCamera sgSymmetricPerspectiveCamera) {
        double vva = sgSymmetricPerspectiveCamera.getVerticalViewingAngle();
        if (Double.isNaN(vva)) {
            return 0.5;
        }
        return vva;
    }

    public Rectangle getActualViewport(Camera sgCamera) {
        return new Rectangle(this.getSize());
    }

    public Rectangle getViewport(Camera sgCamera) {
        return null;
    }

    public void setViewport(Camera sgCamera, Rectangle viewport) {
    }

    public boolean isLetterboxedAsOpposedToDistorted(Camera sgCamera) {
        return true;
    }

    public void setIsLetterboxedAsOpposedToDistorted(Camera sgCamera, boolean isLetterboxedAsOpposedToDistorted) {
    }

    public Image getOffscreenImage() {
        return null;
    }

    public Graphics getGraphics(TextureMap textureMap) {
        return null;
    }

    public void copyOffscreenImageToTextureMap(TextureMap textureMap) {
    }

    private void convert(Matrix4d m, double[][] matrix) {
        matrix[0][0] = m.m00;
        matrix[0][1] = m.m10;
        matrix[0][2] = -m.m20;
        matrix[0][3] = m.m30;
        matrix[1][0] = m.m01;
        matrix[1][1] = m.m11;
        matrix[1][2] = -m.m21;
        matrix[1][3] = m.m31;
        matrix[2][0] = -m.m02;
        matrix[2][1] = -m.m12;
        matrix[2][2] = m.m22;
        matrix[2][3] = -m.m32;
        matrix[3][0] = m.m03;
        matrix[3][1] = m.m13;
        matrix[3][2] = -m.m23;
        matrix[3][3] = m.m33;
    }

    private void setViewTransformation(Matrix4d view) {
        Matrix44 m44 = new Matrix44(view);
        Matrix33 m33 = m44.getAxes();
        Vector3 forward = m33.getRow(2);
        double yaw = -Math.atan2(forward.z, forward.x);
        double pitch = -Math.asin(forward.y);
        this.m_perlinRenderer.setCamera(yaw, pitch);
    }

    private void setModelTransformation(Matrix4d model) {
        double[][] matrix = new double[4][4];
        this.convert(model, matrix);
        render.Geometry g = this.m_perlinRenderer.getWorld();
        Matrix.copy(matrix, g.globalMatrix);
    }

    private void clear(Background background, Rectangle viewport) {
        Color color = background.getColor();
        this.m_perlinRenderer.refresh();
        this.m_perlinRenderer.setBgColor(color.red, color.green, color.blue);
        this.m_perlinRenderer.clearScreen();
    }

    private void setup(Camera camera) {
        if (camera instanceof SymmetricPerspectiveCamera) {
            double theta = this.getActualVerticalViewingAngle((SymmetricPerspectiveCamera)camera);
            double fov = (double)2 * Math.atan(theta * 0.5);
            this.m_perlinRenderer.setFOV(fov);
        }
        this.m_perlinRenderer.setFOV(1.2);
        this.setViewTransformation(camera.getAbsoluteTransformation());
    }

    private void setup(Container root) {
    }

    private void render(IndexedTriangleArray ita) {
        render.Geometry g = this.m_perlinRenderer.getWorld();
        int[] indices = ita.getIndices();
        g.faces = new int[indices.length / 3][3];
        int k = 0;
        for (int i = 0; i < g.faces.length; ++i) {
            g.faces[i][2] = indices[k++];
            g.faces[i][1] = indices[k++];
            g.faces[i][0] = indices[k++];
        }
        Vertex3d[] vertices = ita.getVertices();
        g.vertices = new double[vertices.length][6];
        for (int i = 0; i < vertices.length; ++i) {
            Vertex3d v = vertices[i];
            g.setVertex(i, v.position.x, v.position.y, -v.position.z, v.normal.x, v.normal.y, -v.normal.z);
        }
        this.m_perlinRenderer.renderGeometry(g);
    }

    private void render(Component component) {
        Visual visual;
        if (component instanceof Container) {
            Container container = (Container)component;
            Component[] children = container.getChildren();
            for (int i = 0; i < children.length; ++i) {
                this.render(children[i]);
            }
        } else if (component instanceof Visual && (visual = (Visual)component).getIsShowing()) {
            this.setModelTransformation(visual.getAbsoluteTransformation());
            Geometry geometry = visual.getGeometry();
            if (geometry instanceof IndexedTriangleArray) {
                IndexedTriangleArray ita = (IndexedTriangleArray)geometry;
                this.render(ita);
            }
        }
    }

    public void clearAndRenderOffscreen() {
        this.commitIfNecessary();
        if (this.pix != null) {
            Camera[] cameras = this.getCameras();
            for (int i = 0; i < cameras.length; ++i) {
                Camera camera = cameras[i];
                Background background = camera.getBackground();
                Container root = camera.getRoot();
                if (root instanceof Scene) {
                    Scene scene = (Scene)root;
                    background = scene.getBackground();
                }
                this.clear(background, this.getActualViewport(camera));
                this.setup(camera);
                this.setup(root);
                this.render((Component)root);
                this.m_perlinRenderer.npr();
            }
        }
    }

    public void renderOnEdgeTrianglesAsLines(OrthographicCamera orthographicCamera) {
    }

    public boolean rendersOnEdgeTrianglesAsLines(OrthographicCamera orthographicCamera) {
        return false;
    }

    public void setRendersOnEdgeTrianglesAsLines(OrthographicCamera orthographicCamera, boolean rendersOnEdgeTrianglesAsLines) {
    }

    public Graphics getOffscreenGraphics() {
        return null;
    }

    public PickInfo pick(int x, int y, boolean isSubElementRequired, boolean isOnlyFrontMostRequired) {
        return null;
    }

    public DisplayDriver getDisplayDriver() {
        return this.m_displayDriver;
    }

    public DisplayDevice getDisplayDevice() {
        return this.m_displayDevice;
    }

    public void setDisplayDriver(DisplayDriver displayDriver) {
        if (this.m_displayDriver != displayDriver) {
            this.m_displayDriver = displayDriver;
        }
    }

    public void setDisplayDevice(DisplayDevice displayDevice) {
        if (this.m_displayDevice != displayDevice) {
            this.m_displayDevice = displayDevice;
        }
    }

    public void setSilhouetteThickness(double silhouetteThickness) {
        this.m_silhouetteThickness = silhouetteThickness;
    }

    public double getSilhouetteThickness() {
        return this.m_silhouetteThickness;
    }
}

