/*
 * Decompiled with CFR 0.152.
 */
package squirrel;

import edu.cmu.cs.stage3.math.Vector3;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.vecmath.Vector3d;
import squirrel.CreateMovie;
import squirrel.EventHandler;
import squirrel.Locomotion;
import squirrel.MyMenuBar;
import squirrel.Squirrel;
import squirrel.TimeControlPanel;
import squirrel.TimeControlPanelInterface;
import squirrel.Trajectory;

public class TrajectoryEventHandler
extends EventHandler
implements TimeControlPanelInterface {
    Trajectory trajectory;
    TimeControlPanel timeControlPanel;
    Menu movieMenu;
    boolean recording;
    Vector3 prev_position;
    double prev_prev_speed;
    double prev_speed;
    Vector speeds = new Vector();
    CreateMovie createMovie = null;

    public void hide_all() {
        this.squirrel.spatialKeyframing.hide_keyBalls();
        this.squirrel.cursor.hide();
        this.squirrel.getModel().base.hide();
        this.squirrel.ground.hide();
    }

    public void disactivate() {
        this.timeControlPanel.close();
        this.removeListenders();
        Squirrel.jaliceFrame.remove(this.timeControlPanel);
        this.squirrel.tickListeners.removeElement(this.timeControlPanel);
        MyMenuBar.myMenuBar.remove(MyMenuBar.myMenuBar.movieMenu);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        if (this.recording) {
            this.timeControlPanel.edit_status = 1;
            this.timeControlPanel.reset_timer();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
    }

    public void start_recording() {
        this.timeControlPanel.time = 0;
        this.trajectory.keyPoints = new Vector();
        this.recording = true;
        this.timeControlPanel.edit_status = 3;
        this.init_speed();
    }

    public void stop_recording() {
        this.recording = false;
    }

    public void tick_recording(int time) {
        Vector3 position = this.squirrel.cursor.getPosition();
        this.trajectory.add_keyPoint(time, position);
    }

    public TrajectoryEventHandler(Squirrel squirrel) {
        super(squirrel);
        this.trajectory = squirrel.trajectory;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        if (this.recording) {
            this.timeControlPanel.stop_record();
        }
    }

    public void init_speed() {
        this.prev_position = null;
        this.prev_prev_speed = -1.0;
        this.prev_speed = -1.0;
        this.speeds = new Vector();
    }

    public void paint(Graphics g) {
        int i = 0;
        while (i < this.speeds.size()) {
            double speed = (Double)this.speeds.elementAt(i);
            g.fillRect(10, i * 10, (int)(speed * 1000.0), 9);
            ++i;
        }
    }

    public void activate() {
        this.addListenders();
        this.timeControlPanel = new TimeControlPanel(this);
        this.timeControlPanel.end_time = this.trajectory.get_end_time();
        Squirrel.jaliceFrame.add("South", this.timeControlPanel);
        Squirrel.jaliceFrame.doLayout();
        this.timeControlPanel.repaint();
        this.squirrel.tickListeners.addElement(this.timeControlPanel);
        MyMenuBar.myMenuBar.add(MyMenuBar.myMenuBar.movieMenu);
    }

    public void create_movie() {
        if (this.createMovie == null) {
            this.createMovie = new CreateMovie();
        }
        this.createMovie.show();
    }

    public void show_all() {
        this.squirrel.spatialKeyframing.show_keyBalls();
        this.squirrel.cursor.show();
        this.squirrel.getModel().base.show();
        this.squirrel.ground.show();
    }

    public void start_playing() {
        this.timeControlPanel.time = 0;
        Locomotion.prev_vecs = new Vector();
        this.squirrel.getModel().base.baseVehicle.setPosition((Vector3d)Locomotion.last_drag_location, null);
        this.hide_all();
    }

    public void stop_playing() {
        this.show_all();
    }

    public void tick_playing(int time) {
        if (this.trajectory.keyPoints == null) {
            return;
        }
        this.squirrel.cursor.setPosition(this.trajectory.get_position(time));
        Locomotion.moving = true;
        this.squirrel.update_pose_based_on_cursor();
        Locomotion.moving = false;
    }
}

