/*
 * Decompiled with CFR 0.152.
 */
package squirrel;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import squirrel.TickListener;
import squirrel.TimeControlPanelInterface;

public class TimeControlPanel
extends Panel
implements MouseListener,
MouseMotionListener,
ComponentListener,
TickListener {
    TimeControlPanelInterface target;
    public int height = 40;
    public int time = 0;
    public int max_time = 10000;
    public int end_time = 0;
    public Rectangle rail;
    public Rectangle knob;
    public Rectangle play_button;
    public Rectangle record_button;
    public Rectangle pause_button;
    int width = 0;
    int y_offset;
    int edit_status = 2;
    public static final int PLAY = 0;
    public static final int RECORD = 1;
    public static final int PLAY_PAUSE = 2;
    public static final int RECORD_PAUSE = 3;
    long start_time;
    long prev_time = System.currentTimeMillis();
    int prev_x;
    int prev_y;
    int mouse_status;
    final int KNOB = 1;
    final int NULL = 0;
    final int RAIL = 2;
    Image buffered_image = null;

    public void reset_timer() {
        this.time = 0;
        this.prev_time = System.currentTimeMillis();
    }

    public void componentShown(ComponentEvent e) {
    }

    public void close() {
    }

    public void pause_play() {
        this.edit_status = 2;
        this.target.stop_playing();
    }

    public void drag_knob(int x, int y) {
        int dif_x = x - this.prev_x;
        int dif_time = dif_x * this.max_time / this.rail.width;
        this.time += dif_time;
        if (this.time <= 0) {
            this.time = 0;
        }
        if (this.time >= this.max_time) {
            this.time = this.max_time;
        }
        this.prev_x = x;
        this.prev_y = y;
        this.target.tick_playing(this.time);
    }

    public void paint_main(Graphics g) {
        if (this.width == 0) {
            this.create_widgets();
        }
        g.setColor(Color.gray);
        g.fill3DRect(this.rail.x, this.rail.y, this.rail.width, this.rail.height, false);
        this.knob.x = this.rail.width * this.time / this.max_time + (this.rail.x - 10);
        if (this.edit_status == 0 || this.edit_status == 2) {
            g.setColor(Color.green);
        } else if (this.edit_status == 1 || this.edit_status == 3) {
            g.setColor(Color.red);
        }
        g.fill3DRect(this.knob.x, this.knob.y, this.knob.width, this.knob.height, true);
        g.setColor(Color.gray);
        g.fill3DRect(this.record_button.x, this.record_button.y, this.record_button.width, this.record_button.height, true);
        g.setColor(Color.red);
        g.fillOval(this.record_button.x + this.record_button.width / 2 - 10, this.record_button.y + this.record_button.height / 2 - 10, 20, 20);
        g.setColor(Color.gray);
        g.fill3DRect(this.play_button.x, this.play_button.y, this.play_button.width, this.play_button.height, true);
        Polygon s = new Polygon();
        s.addPoint(this.play_button.x + 5, this.play_button.y + 5);
        s.addPoint(this.play_button.x + 5, this.play_button.y + this.play_button.height - 5);
        s.addPoint(this.play_button.x + this.play_button.width - 5, this.play_button.y + this.play_button.height / 2);
        g.setColor(Color.green);
        g.fillPolygon(s);
        g.setColor(Color.gray);
        g.fill3DRect(this.pause_button.x, this.pause_button.y, this.pause_button.width, this.pause_button.height, true);
        g.setColor(Color.black);
        g.fillRect(this.pause_button.x + 10, this.pause_button.y + 5, 7, this.pause_button.height - 10);
        g.fillRect(this.pause_button.x + this.pause_button.width - 17, this.pause_button.y + 5, 7, this.pause_button.height - 10);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int x = mouseEvent.getX();
        int y = mouseEvent.getY();
        this.mouse_status = 0;
        if (this.play_button.contains(x, y)) {
            this.play_button_pressed();
        } else if (this.record_button.contains(x, y)) {
            this.record_button_pressed();
        } else if (this.pause_button.contains(x, y)) {
            this.pause_button_pressed();
        } else if (this.knob.contains(x, y)) {
            this.mouse_status = 1;
        } else if (this.rail.contains(x, y)) {
            this.click_rail(x, y);
            this.mouse_status = 1;
            this.edit_status = 2;
        }
        this.prev_x = x;
        this.prev_y = y;
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int x = mouseEvent.getX();
        int y = mouseEvent.getY();
        switch (this.mouse_status) {
            case 1: {
                this.drag_knob(x, y);
                break;
            }
        }
        this.repaint();
    }

    public void componentResized(ComponentEvent e) {
        this.create_widgets();
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int x = mouseEvent.getX();
        int y = mouseEvent.getY();
        switch (this.mouse_status) {
            default: 
        }
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    TimeControlPanel(TimeControlPanelInterface target) {
        this.target = target;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addComponentListener(this);
    }

    public void start_record() {
        this.edit_status = 1;
        this.target.start_recording();
        this.prev_time = System.currentTimeMillis();
        this.start_time = System.currentTimeMillis();
    }

    public void stop_record() {
        this.edit_status = 2;
        this.target.stop_recording();
        this.repaint();
    }

    public void paint(Graphics g) {
        if (this.buffered_image == null) {
            this.buffered_image = this.createImage(this.getSize().width, this.getSize().height);
        }
        Graphics bg = this.buffered_image.getGraphics();
        bg.clearRect(0, 0, this.getSize().width, this.getSize().height);
        this.paint_main(bg);
        bg.dispose();
        g.drawImage(this.buffered_image, 0, 0, this);
    }

    public void tick() {
        if (this.edit_status == 2 || this.edit_status == 3) {
            return;
        }
        long current_time = System.currentTimeMillis();
        this.time += (int)(current_time - this.prev_time);
        this.prev_time = current_time;
        if (this.edit_status == 0) {
            if (this.time >= this.end_time) {
                this.time = 0;
            }
            this.target.tick_playing(this.time);
        } else if (this.edit_status == 1) {
            this.end_time = this.time;
            this.target.tick_recording(this.time);
        }
        this.repaint();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void play_button_pressed() {
        if (this.edit_status == 2 || this.edit_status == 1) {
            if (this.time > this.max_time) {
                this.time = 0;
            }
            this.start_play();
        }
    }

    public int tick_from_outside_during_recording() {
        this.end_time = this.time = (int)(System.currentTimeMillis() - this.start_time);
        this.repaint();
        return this.time;
    }

    public Dimension getPreferredSize() {
        Container parent = this.getParent();
        int width = 1 - parent.getInsets().right - parent.getInsets().left;
        return new Dimension(width, this.height);
    }

    public void start_play() {
        if (this.time >= this.end_time) {
            this.time = 0;
        }
        this.edit_status = 0;
        this.prev_time = System.currentTimeMillis();
        this.target.start_playing();
    }

    public void create_widgets() {
        Container parent = this.getParent();
        this.width = parent.getSize().width - parent.getInsets().right - parent.getInsets().left;
        this.y_offset = 0;
        int w = 40;
        this.rail = new Rectangle(10, this.y_offset + this.height / 2 - 6, this.width - 20 - w * 3, 12);
        this.knob = new Rectangle(this.rail.x - 10, this.y_offset + this.height / 2 - 15, 20, 30);
        this.record_button = new Rectangle(this.width - w * 3, this.y_offset + 5, w, this.height - 10);
        this.play_button = new Rectangle(this.width - w * 2, this.y_offset + 5, w, this.height - 10);
        this.pause_button = new Rectangle(this.width - w * 1, this.y_offset + 5, w, this.height - 10);
    }

    public void doLayout() {
        super.doLayout();
        this.buffered_image = null;
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void record_button_pressed() {
        this.start_record();
    }

    public void pause_button_pressed() {
        if (this.edit_status == 2) {
            this.start_play();
        } else if (this.edit_status == 0) {
            this.pause_play();
        } else if (this.edit_status == 1) {
            this.stop_record();
        }
    }

    public void click_rail(int x, int y) {
        this.time = (x - this.rail.x) * this.max_time / this.rail.width;
        this.target.tick_playing(this.time);
    }
}

