/*
 * Decompiled with CFR 0.152.
 */
package squirrel;

import edu.cmu.cs.stage3.math.CatmullRomCubic;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Quaternion;
import edu.cmu.cs.stage3.math.Vector3;
import java.awt.Frame;
import java.util.Vector;

public class TemporalKeyframing {
    Vector keys = new Vector();

    public void set(double time, Matrix44[] parameters) {
        int i = 0;
        while (i < this.keys.size()) {
            Key key = (Key)this.keys.elementAt(i);
            if (key.time > time) {
                this.keys.insertElementAt(new Key(time, parameters), i);
                return;
            }
            ++i;
        }
        this.keys.addElement(new Key(time, parameters));
    }

    public Matrix44[] get(double time) {
        if (this.keys.size() == 0) {
            return null;
        }
        int n0 = -1;
        int n1 = -1;
        int i = 0;
        while (i < this.keys.size()) {
            Key key = (Key)this.keys.elementAt(i);
            if (key.time > time) {
                n1 = i;
                n0 = i - 1;
                break;
            }
            ++i;
        }
        if (n1 == 0) {
            return ((Key)this.keys.elementAt((int)0)).parameters;
        }
        if (n1 == -1) {
            return ((Key)this.keys.elementAt((int)(this.keys.size() - 1))).parameters;
        }
        Key key0 = (Key)this.keys.elementAt(Math.max(n0 - 1, 0));
        Key key1 = (Key)this.keys.elementAt(n0);
        Key key2 = (Key)this.keys.elementAt(n1);
        Key key3 = (Key)this.keys.elementAt(Math.min(n1 + 1, this.keys.size() - 1));
        double t = (time - key1.time) / (key2.time - key1.time);
        Matrix44[] p0 = key0.parameters;
        Matrix44[] p1 = key1.parameters;
        Matrix44[] p2 = key2.parameters;
        Matrix44[] p3 = key3.parameters;
        Matrix44[] parameters = new Matrix44[p0.length];
        int i2 = 0;
        while (i2 < p0.length) {
            Matrix44 a = p0[i2];
            Matrix44 b = p1[i2];
            Matrix44 c = p2[i2];
            Matrix44 d = p3[i2];
            parameters[i2] = TemporalKeyframing.spline_interpolate(a, b, c, d, t);
            ++i2;
        }
        return parameters;
    }

    private static Matrix44 spline_interpolate(Matrix44 a, Matrix44 b, Matrix44 c, Matrix44 d, double t) {
        CatmullRomCubic xCubic = new CatmullRomCubic(a.m30, b.m30, c.m30, d.m30);
        CatmullRomCubic yCubic = new CatmullRomCubic(a.m31, b.m31, c.m31, d.m31);
        CatmullRomCubic zCubic = new CatmullRomCubic(a.m32, b.m32, c.m32, d.m32);
        Quaternion quaternions0 = b.getAxes().getQuaternion();
        Quaternion quaternions1 = c.getAxes().getQuaternion();
        Quaternion q = Quaternion.interpolate((Quaternion)quaternions0, (Quaternion)quaternions1, (double)t);
        Vector3 p = new Vector3(xCubic.evaluate(t), yCubic.evaluate(t), zCubic.evaluate(t));
        return new Matrix44(q, p);
    }

    public static TemporalKeyframing load(Frame frame) {
        return null;
    }

    class Key {
        double time;
        Matrix44[] parameters;

        Key(double time, Matrix44[] parameters) {
            TemporalKeyframing.this.getClass();
            this.time = time;
            this.parameters = parameters;
        }
    }
}

