/*
 * Decompiled with CFR 0.152.
 */
package squirrel;

import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.alice.scenegraph.io.XML;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.RendererInfo;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Vector3;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Vector3d;
import squirrel.AnchorBall;
import squirrel.AsgImport;
import squirrel.Ball;
import squirrel.BallShadow;
import squirrel.Base;
import squirrel.CursorBall;
import squirrel.EventHandler;
import squirrel.Filter;
import squirrel.Ground;
import squirrel.InverseKinematics;
import squirrel.JaliceFrame;
import squirrel.KeyBall;
import squirrel.Knot;
import squirrel.LockBall;
import squirrel.Locomotion;
import squirrel.MirrorBall;
import squirrel.Model;
import squirrel.ObjFile;
import squirrel.ParallelFilter;
import squirrel.Part;
import squirrel.Plane;
import squirrel.RadialBasisFunctionXYZ;
import squirrel.Ring;
import squirrel.SpatialKeyframing;
import squirrel.SpatialKeyframingEventHandler;
import squirrel.TemporalKeyframing;
import squirrel.TemporalKeyframingEventHandler;
import squirrel.TickListener;
import squirrel.Trajectory;
import squirrel.TrajectoryEventHandler;
import squirrel.Util;

public class Squirrel {
    public boolean with_orientation = false;
    public static String data_directory = "..\\data\\";
    boolean show_trash_bin = false;
    public static Rectangle trash_bin = null;
    public int TRASH_SIZE = 50;
    public static Vector models = new Vector();
    public static Matrix44[] initial_parameters;
    public CursorBall cursor = null;
    CursorBall draggedCursor = null;
    BallShadow draggedCursorBase = null;
    public Part lockedPart;
    public Vector3 lockedPosition;
    public LockBall lockBall;
    Ball IK_handle;
    Part IK_part;
    MirrorBall mirrorBall;
    KeyBall selectedKeyBall = null;
    public Transformable attachedCursor = new Transformable();
    Filter filter;
    public Hashtable visual_list;
    public TemporalKeyframing temporalKeyframing = new TemporalKeyframing();
    public SpatialKeyframing spatialKeyframing = new SpatialKeyframing();
    public Trajectory trajectory = new Trajectory();
    Vector tickListeners = new Vector();
    Ground ground;
    Base draggedBase;
    Ring ring;
    EventHandler eventHandler;
    public static JaliceFrame jaliceFrame;
    public static Squirrel squirrel;
    public static String renderername;

    public void test() {
    }

    public void rotate_base(Point p, Point prev_p) {
        double angle = (double)(-(p.x - prev_p.x)) / 100.0;
        this.draggedBase.baseVehicle.rotate((Vector3d)Vector3.Y_AXIS, angle, (ReferenceFrame)this.draggedBase.baseVehicle);
    }

    public void initialize() {
        this.ground = new Ground((Container)Squirrel.jaliceFrame.scene);
        this.ring = new Ring();
        String dir = System.getProperty("user.dir");
        this.load(dir + "\\data\\teddy.obj");
        this.eventHandler = System.getProperty("java.vendor").startsWith("Microsoft") ? new EventHandler(this) : new SpatialKeyframingEventHandler(this);
        this.eventHandler.activate();
    }

    public void undo() {
    }

    public Matrix44[] get_parameters(Knot p) {
        return this.spatialKeyframing.get_parameters(p);
    }

    public void rotate_ring_locked(double angle) {
        LockBall.swap_parent(this.ring.part.partVehicle, this.ring.part.temporary_parent_vehicle, this.ring.part.get_model());
        Vector3 axis = this.ring.ringVehicle.getOrientation(null)[0];
        this.ring.part.partVehicle.rotate((Vector3d)Vector3.Z_AXIS, -angle, (ReferenceFrame)this.ring.ringVehicle);
        this.ring.ringVehicle.rotate((Vector3d)Vector3.Z_AXIS, -angle, (ReferenceFrame)this.ring.ringVehicle);
        LockBall.restore_hierarchy(this.ring.part.get_model());
    }

    public void switch_temporalKeyframing(TemporalKeyframing new_temporalKeyframing) {
        this.temporalKeyframing = new_temporalKeyframing;
    }

    public void set_IK() {
        if (this.IK_handle != null) {
            this.IK_handle.delete();
            this.IK_handle = null;
            return;
        }
        this.IK_handle = new Ball();
        this.IK_handle.init_no_shadow(this.lockedPart.partVehicle, edu.cmu.cs.stage3.alice.scenegraph.Color.RED, 0.03);
        this.IK_handle.setPosition(this.lockedPosition, (ReferenceFrame)this.lockedPart.partVehicle);
        this.IK_handle.attached_part = this.lockedPart;
    }

    public void perform_IK() {
        if (this.IK_handle == null) {
            return;
        }
        if (this.lockBall != null) {
            this.perform_IK_locked();
            return;
        }
        Model model = (Model)models.elementAt(0);
        Transformable base = model.rootPart.partVehicle;
        Transformable terminal = this.IK_handle.ballVehicle;
        Vector3 target_position = this.cursor.getPosition((ReferenceFrame)base);
        InverseKinematics.adjust(target_position, terminal, base);
    }

    public void paintOverlay(Graphics g) {
        if (this.eventHandler != null && this.eventHandler.operation_status == this.eventHandler.DRAG_KEYBALL) {
            this.paint_trashbox(g);
        }
    }

    public Rectangle trash_box() {
        if (trash_bin == null) {
            Dimension size = Squirrel.jaliceFrame.awtComponent.getSize();
            trash_bin = new Rectangle((int)((double)size.width - (double)this.TRASH_SIZE * 1.2), (int)((double)this.TRASH_SIZE * 0.2), this.TRASH_SIZE, this.TRASH_SIZE);
        }
        return trash_bin;
    }

    public SpatialKeyframing load_keys() {
        this.init();
        SpatialKeyframing new_spatialKeyframing = SpatialKeyframing.load(jaliceFrame);
        if (new_spatialKeyframing != null) {
            this.switch_spatialKeyframing(new_spatialKeyframing);
            this.register_spatialKeyframing(this.spatialKeyframing);
            return this.spatialKeyframing;
        }
        return null;
    }

    public static void main(String[] args) {
        renderername = args.length > 0 ? args[0] : "edu.cmu.cs.stage3.alice.scenegraph.renderer.directx7renderer.RendererInfo";
        try {
            Class<?> cls = Class.forName(renderername);
            RendererInfo rendererInfo = (RendererInfo)cls.newInstance();
            squirrel = new Squirrel();
            new JaliceFrame(rendererInfo, squirrel);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void load() {
        FileDialog fileDialog = new FileDialog((Frame)jaliceFrame, "SLoad Part", 0);
        fileDialog.setDirectory(data_directory);
        fileDialog.setFile("*.obj");
        ((Component)fileDialog).setVisible(true);
        if (fileDialog.getFile() != null) {
            String filename = fileDialog.getDirectory() + fileDialog.getFile();
            this.load(filename);
        }
        fileDialog.dispose();
    }

    public void load(String filename) {
        System.out.println("" + filename);
        this.set_new_model(new Model(ObjFile.load(filename)));
    }

    public void mirror() {
        Model model = this.lockedPart.get_model();
        this.mirrorBall = new MirrorBall(this.lockedPosition, this.lockedPart);
        this.visual_list.put(this.mirrorBall.ballVisual, this.mirrorBall);
    }

    public void updateAttachedCursor() {
        if (this.attachedCursor.getParent() != null) {
            Vector3 prev_position = this.cursor.ballVehicle.getPosition((ReferenceFrame)Squirrel.jaliceFrame.scene);
            this.cursor.setPosition(Vector3.ZERO, (ReferenceFrame)this.attachedCursor);
            if (Vector3.subtract((Vector3d)prev_position, (Vector3d)this.cursor.ballVehicle.getPosition((ReferenceFrame)Squirrel.jaliceFrame.scene)).getLength() > 1.0E-4) {
                this.selectedKeyBall = null;
            }
        }
    }

    public void update_pose_based_on_cursor() {
        Matrix44[] parameters = this.get_parameters(this.cursor.getKnot());
        if (parameters != null) {
            this.cursor.model.set_parameters(parameters);
        }
        if (this.lockBall != null) {
            this.lockBall.pull_back();
        }
        Locomotion.update();
    }

    public void importASG() {
        FileDialog fileDialog = new FileDialog((Frame)jaliceFrame, "Import from Alice", 0);
        fileDialog.setDirectory(data_directory);
        fileDialog.setFile("*.asg");
        ((Component)fileDialog).setVisible(true);
        if (fileDialog.getFile() != null) {
            String filename = fileDialog.getDirectory() + fileDialog.getFile();
            try {
                FileInputStream is = new FileInputStream(filename);
                edu.cmu.cs.stage3.alice.scenegraph.Component component = XML.load((InputStream)is);
                this.set_new_model(new Model(AsgImport.create_part_tree(null, (Transformable)component)));
                ((InputStream)is).close();
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        fileDialog.dispose();
    }

    public void save() {
        FileDialog fileDialog = new FileDialog((Frame)jaliceFrame, "Save Part", 1);
        fileDialog.setDirectory(data_directory);
        fileDialog.setFile("*.obj");
        ((Component)fileDialog).setVisible(true);
        if (fileDialog.getFile() != null) {
            String filename = fileDialog.getDirectory() + fileDialog.getFile();
            ObjFile.save(((Model)Squirrel.models.elementAt((int)0)).rootPart, filename);
        }
        fileDialog.dispose();
    }

    public void drag_filter(Point p, Point prev_p) {
        this.filter.prepare_for_warp_cursor(this.cursor);
        Vector3 pos = this.cursor.getPosition((ReferenceFrame)this.ground.groundVehicle);
        Vector3 goal = this.ground_slide(p, prev_p, this.getModel().base.baseVehicle);
        this.getModel().base.baseVehicle.setPosition((Vector3d)goal, (ReferenceFrame)Squirrel.jaliceFrame.scene);
        this.cursor.setPosition(pos, (ReferenceFrame)this.ground.groundVehicle);
        this.cursor.setPosition(this.filter.warp(this.cursor.getPosition()));
        this.cursor.ballShadow.updatePosition();
        this.update_pose_based_on_cursor();
    }

    public void unlock() {
        if (this.lockBall != null) {
            this.lockBall.delete();
        }
        Model model = this.lockBall.part.get_model();
        Vector parts = model.get_parts();
        int i = 0;
        while (i < parts.size()) {
            ((Part)parts.elementAt((int)i)).temporary_parent_vehicle = null;
            ++i;
        }
        this.lockBall = null;
    }

    public void rotate_ring(Point p, Point prev_p) {
        Vector3 center = jaliceFrame.scene_coords_to_screen_coords(this.ring.ringVehicle.getPosition((ReferenceFrame)Squirrel.jaliceFrame.scene));
        center.z = 0.0;
        Vector3 pos = new Vector3((double)p.x, (double)p.y, 0.0);
        Vector3 vec = Vector3.subtract((Vector3d)pos, (Vector3d)center);
        Vector3 prev_pos = new Vector3((double)prev_p.x, (double)prev_p.y, 0.0);
        Vector3 prev_vec = Vector3.subtract((Vector3d)prev_pos, (Vector3d)center);
        double angle = Util.signedAngleRadian(prev_vec, vec, Vector3.Z_AXIS);
        if (this.ring.part.temporary_parent_vehicle != null) {
            this.rotate_ring_locked(angle);
        } else {
            Vector3 axis = this.ring.ringVehicle.getOrientation(null)[0];
            this.ring.part.partVehicle.rotate((Vector3d)Vector3.Z_AXIS, -angle, (ReferenceFrame)this.ring.ringVehicle);
            this.ring.ringVehicle.rotate((Vector3d)Vector3.Z_AXIS, -angle, (ReferenceFrame)this.ring.ringVehicle);
        }
        this.updateAttachedCursor();
        prev_p = p;
    }

    public void switch_spatialKeyframing(SpatialKeyframing new_spatialKeyframing) {
        int i = 0;
        while (i < this.spatialKeyframing.keyBalls.size()) {
            KeyBall keyBall = (KeyBall)this.spatialKeyframing.keyBalls.elementAt(i);
            keyBall.hide();
            this.visual_list.remove(keyBall.ballVisual);
            ++i;
        }
        this.spatialKeyframing = new_spatialKeyframing;
        this.register_spatialKeyframing(this.spatialKeyframing);
    }

    public void switch_trajectory(Trajectory new_trajectory) {
        this.trajectory = new_trajectory;
    }

    public void setCursor(Base base) {
        this.cursor = new CursorBall(base.baseVehicle, base.model);
        this.cursor.setPosition(new Vector3(0.0, 0.5, -0.5));
        if (this.with_orientation) {
            this.cursor.init_ghost();
        }
    }

    public void setAttachedCursor(Transformable parent, Vector3 position) {
        this.attachedCursor.setParent((Container)parent);
        this.attachedCursor.setPosition((Vector3d)position, (ReferenceFrame)parent);
    }

    public void switch_mode(String mode) {
        this.eventHandler.disactivate();
        if (mode.equals("spatial keyframing")) {
            this.eventHandler = new SpatialKeyframingEventHandler(this);
        } else if (mode.equals("temporal keyframing")) {
            this.eventHandler = new TemporalKeyframingEventHandler(this);
        } else if (mode.equals("recording")) {
            this.eventHandler = new TrajectoryEventHandler(this);
        }
        this.eventHandler.activate();
    }

    public void drag_lockBall(Point p, Point prev_p) {
        Vector3 cursor_position = this.cursor.ballVehicle.getPosition((ReferenceFrame)this.ground.groundVehicle);
        Model model = this.lockedPart.get_model();
        Base base = model.base;
        Vector3 goal = this.screen_slide(p, prev_p, base.baseVehicle);
        base.baseVehicle.setPosition((Vector3d)goal, (ReferenceFrame)Squirrel.jaliceFrame.scene);
        this.lockBall.ballShadow.updatePosition();
        int i = 0;
        while (i < this.spatialKeyframing.keyBalls.size()) {
            KeyBall keyBall = (KeyBall)this.spatialKeyframing.keyBalls.elementAt(i);
            keyBall.ballShadow.updatePosition();
            ++i;
        }
        this.cursor.ballVehicle.setPosition((Vector3d)cursor_position, (ReferenceFrame)this.ground.groundVehicle);
    }

    public void setCursorPosition(Vector3 position, Visual visual, boolean right_button) {
        Transformable vehicle = (Transformable)visual.getParent();
        this.cursor.setPosition(position, (ReferenceFrame)vehicle);
        this.cursor.ballShadow.updatePosition();
        Object pickedObject = this.visual_list.get(visual);
        if (pickedObject instanceof Part) {
            this.lockedPosition = position;
            this.lockedPart = (Part)pickedObject;
            this.setAttachedCursor(vehicle, position);
        }
        if (right_button) {
            this.update_pose_based_on_cursor();
        }
    }

    public void lock() {
        Part parent;
        if (this.lockBall != null) {
            this.unlock();
            return;
        }
        Model model = this.lockedPart.get_model();
        Base base = model.base;
        this.lockBall = new LockBall(base.baseVehicle, this.lockedPart);
        this.lockBall.lock(this.lockedPosition);
        this.visual_list.put(this.lockBall.ballVisual, this.lockBall);
        Part child = this.lockedPart;
        while ((parent = child.parentPart) != null) {
            parent.temporary_parent_vehicle = child.partVehicle;
            parent.temporary_parent = child;
            child = parent;
        }
        this.lockedPart.temporary_parent_vehicle = this.lockBall.ballVehicle;
    }

    public void register_spatialKeyframing(SpatialKeyframing spatialKeyframing) {
        Vector keyBalls = spatialKeyframing.keyBalls;
        int i = 0;
        while (i < keyBalls.size()) {
            KeyBall keyBall = (KeyBall)keyBalls.elementAt(i);
            keyBall.show();
            this.visual_list.put(keyBall.ballVisual, keyBall);
            this.visual_list.put(keyBall.ballShadow.shadowVisual, keyBall.ballShadow);
            ++i;
        }
        this.update_keyFraming();
    }

    public void rotate(Point p, Point prev_p, Transformable vehicle) {
        Vector3 pos = vehicle.getPosition((ReferenceFrame)Squirrel.jaliceFrame.scene);
        vehicle.rotate((Vector3d)Vector3.Y_AXIS, (double)(-(p.x - prev_p.x)) / 100.0, (ReferenceFrame)Squirrel.jaliceFrame.cameraVehicle);
        vehicle.rotate((Vector3d)Vector3.X_AXIS, (double)(-(p.y - prev_p.y)) / 100.0, (ReferenceFrame)Squirrel.jaliceFrame.cameraVehicle);
        vehicle.setPosition((Vector3d)pos, (ReferenceFrame)Squirrel.jaliceFrame.scene);
    }

    public void rotate(Point p, Point prev_p, Part part) {
        if (part.temporary_parent_vehicle == null) {
            this.rotate(p, prev_p, part.partVehicle);
        } else {
            LockBall.rotate_locked(p, prev_p, part);
        }
        this.updateAttachedCursor();
    }

    public Vector3 screen_slide(Point p, Point prev_p, Transformable vehicle) {
        Vector3 base = vehicle.getPosition((ReferenceFrame)Squirrel.jaliceFrame.scene);
        Vector3 normal = Squirrel.jaliceFrame.cameraVehicle.getOrientation((ReferenceFrame)Squirrel.jaliceFrame.scene)[0];
        if (this.ground.current_camera != 3) {
            normal.y = 0.0;
        }
        normal.normalize();
        Plane plane = new Plane(base, normal);
        Vector3 pos = plane.project(p);
        Vector3 prev_pos = plane.project(prev_p);
        Vector3 vec = Vector3.subtract((Vector3d)pos, (Vector3d)prev_pos);
        return Vector3.add((Vector3d)base, (Vector3d)vec);
    }

    public void repaint() {
        jaliceFrame.repaint();
    }

    public Squirrel() {
        squirrel = this;
    }

    public void set_filter() {
        if (this.filter == null) {
            this.spatialKeyframing.filter = this.filter = new ParallelFilter(this.getModel().base.baseVehicle);
        } else {
            this.filter.delete();
            this.filter = null;
            this.spatialKeyframing.filter = null;
        }
        this.update_keyFraming();
        this.register_visual_list();
    }

    public void tick() {
        int i = 0;
        while (i < this.tickListeners.size()) {
            ((TickListener)this.tickListeners.elementAt(i)).tick();
            ++i;
        }
    }

    public void register_visual_list() {
        this.visual_list = new Hashtable();
        int i = 0;
        while (i < this.ground.tileVisuals.size()) {
            this.visual_list.put(this.ground.tileVisuals.elementAt(i), this.ground);
            ++i;
        }
        this.visual_list.put(this.ring.ringVisual, this.ring);
        int j = 0;
        while (j < models.size()) {
            Model model = (Model)models.elementAt(j);
            Vector parts = model.get_parts();
            int i2 = 0;
            while (i2 < parts.size()) {
                Part part = (Part)parts.elementAt(i2);
                this.visual_list.put(part.partVisual, part);
                ++i2;
            }
            Base base = model.base;
            this.visual_list.put(base.baseVisual, base);
            ++j;
        }
        this.visual_list.put(this.cursor.ballVisual, this.cursor);
        this.visual_list.put(this.cursor.ballShadow.shadowVisual, this.cursor.ballShadow);
        if (this.with_orientation) {
            this.visual_list.put(this.cursor.ghost.ballVisual, this.cursor.ghost);
        }
        if (this.filter != null) {
            this.visual_list.put(this.filter.filterVisual, this.filter);
        }
        i = 0;
        while (i < Locomotion.anchors.size()) {
            AnchorBall anchor = (AnchorBall)Locomotion.anchors.elementAt(i);
            this.visual_list.put(anchor.ballVisual, anchor);
            ++i;
        }
    }

    public void exportXML() {
        FileDialog fileDialog = new FileDialog((Frame)jaliceFrame, "Export XML", 1);
        fileDialog.setDirectory(data_directory);
        fileDialog.setFile("*.xml");
        ((Component)fileDialog).setVisible(true);
        if (fileDialog.getFile() != null) {
            String filename = fileDialog.getDirectory() + fileDialog.getFile();
            ((Model)models.elementAt(0)).export_xml(filename);
        }
        fileDialog.dispose();
    }

    public void update_keyFraming() {
        this.spatialKeyframing.compute();
    }

    public void releaseAttachedCursor() {
        this.attachedCursor.setParent(null);
    }

    public void set_option(String label) {
        if (label.equals("r")) {
            RadialBasisFunctionXYZ.type = 0;
        } else if (label.equals("r3")) {
            RadialBasisFunctionXYZ.type = 1;
        }
        this.update_keyFraming();
    }

    public void save_keys() {
        this.spatialKeyframing.save(jaliceFrame);
    }

    public void init() {
        if (this.lockBall != null) {
            this.unlock();
        }
        this.spatialKeyframing.initKeyBalls();
        Locomotion.clear_anchors();
        this.getModel().set_parameters(initial_parameters);
        this.cursor.setPosition(new Vector3(0.0, 0.5, -0.5));
        this.register_visual_list();
        this.update_keyFraming();
    }

    public void perform_IK_locked() {
        Model model = (Model)models.elementAt(0);
        this.lockBall.swap_parents_forIK(this.IK_handle, model);
        Transformable terminal = this.IK_handle.ballVehicle;
        Transformable base = this.lockBall.ballVehicle;
        Vector3 target_position = this.cursor.getPosition((ReferenceFrame)base);
        InverseKinematics.adjust(target_position, terminal, base);
        this.lockBall.restore_hierarchy_forIK(this.IK_handle, model);
    }

    public void paint_trashbox(Graphics g) {
        g.setColor(Color.red);
        Rectangle bbox = this.trash_box();
        g.translate(bbox.x, bbox.y);
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, 50, 17);
        g.fillRect(3, 17, 44, 32);
        g.setColor(Color.black);
        g.drawRect(0, 0, 50, 17);
        g.drawRect(3, 17, 44, 32);
        g.drawRect(9, 17, 32, 32);
        g.drawRect(19, 17, 11, 32);
        g.translate(-bbox.x, -bbox.y);
    }

    public void set_new_model(Model model) {
        if (models.size() > 0) {
            ((Model)models.elementAt(0)).delete();
        }
        models = new Vector();
        models.addElement(model);
        this.setCursor(model.base);
        this.register_visual_list();
        initial_parameters = model.get_parameters();
    }

    public void camera() {
        this.ground.switch_camera();
    }

    public Vector3 ground_slide(Point p, Point prev_p, Transformable vehicle) {
        Vector3 pos = this.ground.groundPlane.project(p);
        Vector3 prev_pos = this.ground.groundPlane.project(prev_p);
        Vector3 vec = Vector3.subtract((Vector3d)pos, (Vector3d)prev_pos);
        vec.y = 0.0;
        Vector3 current_position = vehicle.getPosition((ReferenceFrame)this.ground.groundVehicle);
        Vector3 target_position = Vector3.add((Vector3d)current_position, (Vector3d)vec);
        return jaliceFrame.change_coords(target_position, (ReferenceFrame)this.ground.groundVehicle, (ReferenceFrame)Squirrel.jaliceFrame.scene);
    }

    public Model getModel() {
        return (Model)models.elementAt(0);
    }

    public Vector3 screen_project(Point p, Transformable vehicle) {
        Vector3 base = vehicle.getPosition((ReferenceFrame)Squirrel.jaliceFrame.scene);
        Vector3 normal = Squirrel.jaliceFrame.cameraVehicle.getOrientation((ReferenceFrame)Squirrel.jaliceFrame.scene)[0];
        if (this.ground.current_camera != 3) {
            normal.y = 0.0;
        }
        normal.normalize();
        Plane plane = new Plane(base, normal);
        Vector3 pos = plane.project(p);
        return pos;
    }
}

