/*
 * Decompiled with CFR 0.152.
 */
package squirrel;

import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Quaternion;
import edu.cmu.cs.stage3.math.Vector3;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import squirrel.Filter;
import squirrel.KeyBall;
import squirrel.Knot;
import squirrel.Model;
import squirrel.RadialBasisFunction;
import squirrel.RadialBasisFunctionXYZ;
import squirrel.Squirrel;

public class SpatialKeyframing {
    public static boolean USE_QUATERNION = false;
    Vector keyBalls = new Vector();
    Filter filter;
    FunctionSet[] functionSets;

    public void set(Vector keys) {
        int key_size = keys.size();
        int joint_size = ((Matrix44[])((Object[])keys.elementAt(0))[1]).length;
        Knot[] knots = new Knot[key_size];
        Matrix44[][] parameters = new Matrix44[joint_size][key_size];
        int i = 0;
        while (i < key_size) {
            Object[] pair = (Object[])keys.elementAt(i);
            knots[i] = (Knot)((Object)pair[0]);
            Matrix44[] key_parameters = (Matrix44[])pair[1];
            int j = 0;
            while (j < joint_size) {
                parameters[j][i] = key_parameters[j];
                ++j;
            }
            ++i;
        }
        this.set_fuctionSets(knots, parameters);
    }

    public Matrix44[] get_parameters(Knot pos) {
        if (this.filter != null) {
            return this.filter.get_parameters(pos, this);
        }
        return this.get_parameters_main(pos);
    }

    public void hide_keyBalls() {
        int i = 0;
        while (i < this.keyBalls.size()) {
            ((KeyBall)this.keyBalls.elementAt(i)).hide();
            ++i;
        }
    }

    public static void save_matrix(Matrix44 matrix, PrintWriter pw) {
        String matrixString = "";
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                matrixString = matrixString + " " + matrix.getItem(i, j);
                ++j;
            }
            ++i;
        }
        pw.println("" + matrixString);
    }

    public void set_fuctionSets(Knot[] knots, Matrix44[][] parameters) {
        int joint_size = parameters.length;
        this.functionSets = new FunctionSet[joint_size];
        int i = 0;
        while (i < joint_size) {
            this.functionSets[i] = new FunctionSet(knots, parameters[i]);
            ++i;
        }
    }

    public static SpatialKeyframing load(Frame frame) {
        SpatialKeyframing spatialKeyframing = null;
        FileDialog fileDialog = new FileDialog(frame, "Load Part", 0);
        fileDialog.setDirectory(Squirrel.data_directory);
        fileDialog.setFile("*.key");
        ((Component)fileDialog).setVisible(true);
        if (fileDialog.getFile() != null) {
            String filename = fileDialog.getDirectory() + fileDialog.getFile();
            spatialKeyframing = new SpatialKeyframing();
            spatialKeyframing.load_KeyBalls(filename);
        }
        fileDialog.dispose();
        return spatialKeyframing;
    }

    public void initKeyBalls() {
        int i = 0;
        while (i < this.keyBalls.size()) {
            ((KeyBall)this.keyBalls.elementAt(i)).delete();
            ++i;
        }
        this.keyBalls = new Vector();
    }

    public void load_KeyBalls(String filename) {
        try {
            FileInputStream fis = new FileInputStream(filename);
            BufferedReader r = new BufferedReader(new InputStreamReader(fis));
            this.keyBalls = this.load_KeyBalls(r);
            r.close();
        }
        catch (IOException e) {
            System.out.println("Error in ObjFile.load()");
        }
    }

    public Vector load_KeyBalls(BufferedReader r) {
        try {
            StringTokenizer st = new StringTokenizer(r.readLine());
            st.nextToken();
            int ball_count = new Integer(st.nextToken());
            st = new StringTokenizer(r.readLine());
            st.nextToken();
            int model_count = new Integer(st.nextToken());
            Vector<KeyBall> keyBalls = new Vector<KeyBall>();
            int i = 0;
            while (i < ball_count) {
                keyBalls.addElement(this.load_KeyBall(r, model_count));
                ++i;
            }
            return keyBalls;
        }
        catch (IOException e) {
            System.out.println("Error in ObjFile.load()");
            return null;
        }
    }

    public void save(Frame frame) {
        FileDialog fileDialog = new FileDialog(frame, "Save Part", 1);
        fileDialog.setDirectory(Squirrel.data_directory);
        fileDialog.setFile("*.key");
        ((Component)fileDialog).setVisible(true);
        if (fileDialog.getFile() != null) {
            String filename = fileDialog.getDirectory() + fileDialog.getFile();
            this.save_KeyBalls(filename);
        }
        fileDialog.dispose();
    }

    public KeyBall load_KeyBall(BufferedReader r, int model_count) {
        try {
            StringTokenizer st = new StringTokenizer(r.readLine());
            Vector3 v = new Vector3();
            v.x = new Double(st.nextToken());
            v.y = new Double(st.nextToken());
            v.z = new Double(st.nextToken());
            Matrix44[] parameters = new Matrix44[model_count];
            int n = 0;
            while (n < model_count) {
                st = new StringTokenizer(r.readLine());
                Matrix44 matrix = new Matrix44();
                int i = 0;
                while (i < 4) {
                    int j = 0;
                    while (j < 4) {
                        matrix.setItem(i, j, new Double(st.nextToken()).doubleValue());
                        ++j;
                    }
                    ++i;
                }
                parameters[n] = matrix;
                ++n;
            }
            KeyBall keyBall = new KeyBall(this);
            keyBall.setPosition(v);
            keyBall.parameters = parameters;
            return keyBall;
        }
        catch (IOException e) {
            System.out.println("Error in ObjFile.load()");
            return null;
        }
    }

    public void compute() {
        if (this.filter != null) {
            this.filter.update_keyFraming(this);
            return;
        }
        if (this.keyBalls.size() == 0) {
            this.functionSets = null;
            return;
        }
        Vector<Object[]> keys = new Vector<Object[]>();
        int i = 0;
        while (i < this.keyBalls.size()) {
            KeyBall keyBall = (KeyBall)this.keyBalls.elementAt(i);
            Object[] pair = new Object[]{keyBall.getKnot(), keyBall.parameters};
            keys.addElement(pair);
            ++i;
        }
        this.set(keys);
    }

    public Matrix44[] get_parameters_main(Knot pos) {
        if (this.functionSets == null) {
            return null;
        }
        int size = this.functionSets.length;
        Matrix44[] parameters = new Matrix44[size];
        int i = 0;
        while (i < size) {
            parameters[i] = this.functionSets[i].get_parameter(pos);
            ++i;
        }
        return parameters;
    }

    public void show_keyBalls() {
        int i = 0;
        while (i < this.keyBalls.size()) {
            ((KeyBall)this.keyBalls.elementAt(i)).show();
            ++i;
        }
    }

    public void save_KeyBalls(String filename) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            PrintWriter pw = new PrintWriter(bos);
            this.save_KeyBalls(pw);
            pw.flush();
            pw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void save_KeyBalls(PrintWriter pw) {
        pw.println("balls " + this.keyBalls.size());
        pw.println("models " + ((KeyBall)this.keyBalls.elementAt((int)0)).parameters.length);
        int i = 0;
        while (i < this.keyBalls.size()) {
            KeyBall keyBall = (KeyBall)this.keyBalls.elementAt(i);
            Vector3 v = keyBall.getPosition(null);
            pw.println("" + v.x + " " + v.y + " " + v.z);
            int j = 0;
            while (j < keyBall.parameters.length) {
                SpatialKeyframing.save_matrix(keyBall.parameters[j], pw);
                ++j;
            }
            ++i;
        }
    }

    public Model get_model() {
        return Squirrel.squirrel.getModel();
    }

    class FunctionSet {
        RadialBasisFunctionXYZ function_p;
        RadialBasisFunctionXYZ function_x_axis;
        RadialBasisFunctionXYZ function_y_axis;
        RadialBasisFunctionXYZ function_z_axis;
        RadialBasisFunction qx;
        RadialBasisFunction qy;
        RadialBasisFunction qz;
        RadialBasisFunction qw;

        public Matrix33 normalize(Vector3 x, Vector3 y, Vector3 z) {
            double xw = x.getLength();
            double yw = y.getLength();
            double zw = z.getLength();
            x.normalize();
            y.normalize();
            z.normalize();
            int i = 0;
            while (i < 10) {
                double r = Vector3.dotProduct((Vector3d)x, (Vector3d)y) * Vector3.dotProduct((Vector3d)x, (Vector3d)y) + Vector3.dotProduct((Vector3d)y, (Vector3d)z) * Vector3.dotProduct((Vector3d)y, (Vector3d)z) + Vector3.dotProduct((Vector3d)z, (Vector3d)x) * Vector3.dotProduct((Vector3d)z, (Vector3d)x);
                if (r < 1.0E-6) break;
                Vector3 x1 = Vector3.crossProduct((Vector3d)y, (Vector3d)z);
                x1.normalize();
                Vector3 y1 = Vector3.crossProduct((Vector3d)z, (Vector3d)x);
                y1.normalize();
                Vector3 z1 = Vector3.crossProduct((Vector3d)x, (Vector3d)y);
                z1.normalize();
                x = Vector3.add((Vector3d)x, (Vector3d)x1);
                x.normalize();
                y = Vector3.add((Vector3d)y, (Vector3d)y1);
                y.normalize();
                z = Vector3.add((Vector3d)z, (Vector3d)z1);
                z.normalize();
                ++i;
            }
            return new Matrix33(x, y, z);
        }

        FunctionSet(Knot[] knots, Matrix44[] parameters) {
            SpatialKeyframing.this.getClass();
            int size = knots.length;
            Vector3[] ps = new Vector3[size];
            Vector3[] xs = new Vector3[size];
            Vector3[] ys = new Vector3[size];
            Vector3[] zs = new Vector3[size];
            int i = 0;
            while (i < size) {
                Matrix44 parameter = parameters[i];
                ps[i] = parameter.getPosition();
                xs[i] = parameter.getAxes().getRow(0);
                ys[i] = parameter.getAxes().getRow(1);
                zs[i] = parameter.getAxes().getRow(2);
                ++i;
            }
            this.function_p = new RadialBasisFunctionXYZ(knots, ps);
            this.function_x_axis = new RadialBasisFunctionXYZ(knots, xs);
            this.function_y_axis = new RadialBasisFunctionXYZ(knots, ys);
            this.function_z_axis = new RadialBasisFunctionXYZ(knots, zs);
            if (USE_QUATERNION) {
                double[] qxs = new double[size];
                double[] qys = new double[size];
                double[] qzs = new double[size];
                double[] qws = new double[size];
                int i2 = 0;
                while (i2 < size) {
                    Matrix44 parameter = parameters[i2];
                    Quaternion q = parameter.getAxes().getQuaternion();
                    qxs[i2] = q.x;
                    qys[i2] = q.y;
                    qzs[i2] = q.z;
                    qws[i2] = q.w;
                    ++i2;
                }
                this.qx = new RadialBasisFunction(knots, qxs);
                this.qy = new RadialBasisFunction(knots, qys);
                this.qz = new RadialBasisFunction(knots, qzs);
                this.qw = new RadialBasisFunction(knots, qws);
            }
        }

        Matrix44 get_parameter(Knot pos) {
            Vector3 p = this.function_p.get(pos);
            if (USE_QUATERNION) {
                Quaternion q = new Quaternion(this.qx.get(pos), this.qy.get(pos), this.qz.get(pos), this.qw.get(pos));
                q.normalize();
                return new Matrix44(q, p);
            }
            Vector3 x = this.function_x_axis.get(pos);
            Vector3 y = this.function_y_axis.get(pos);
            Vector3 z = this.function_z_axis.get(pos);
            Matrix33 axes = this.normalize(x, y, z);
            return new Matrix44((Matrix3d)axes, p);
        }
    }
}

