/*
 * Decompiled with CFR 0.152.
 */
package squirrel;

import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.FillingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.Scene;
import edu.cmu.cs.stage3.alice.scenegraph.ShadingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.math.Vector3;
import javax.vecmath.Vector3d;
import squirrel.Part;
import squirrel.Squirrel;
import squirrel.Util;

public class Ring {
    final Color RING_COLOR = new Color(0.8, 0.2, 0.2);
    final double size = 0.3;
    final double size2 = 0.02;
    Part part;
    Transformable ringVehicle;
    Visual ringVisual;
    IndexedTriangleArray ringITA;
    Appearance ringAppearance;
    Scene parent;

    public void set(Part part) {
        this.show();
        this.setPosition(part);
    }

    Ring() {
        this.parent = Squirrel.jaliceFrame.scene;
        this.ringVehicle = new Transformable();
        this.ringVisual = new Visual();
        this.ringVisual.setParent((Container)this.ringVehicle);
        this.ringITA = new IndexedTriangleArray();
        this.ringVisual.setGeometry((Geometry)this.ringITA);
        this.setGeometry();
        this.ringAppearance = new Appearance();
        this.ringVisual.setFrontFacingAppearance(this.ringAppearance);
        this.ringAppearance.setDiffuseColor(this.RING_COLOR);
        this.ringAppearance.setFillingStyle(FillingStyle.SOLID);
        this.ringAppearance.setShadingStyle(ShadingStyle.SMOOTH);
    }

    public void hide() {
        this.ringVehicle.setParent(null);
    }

    public void setGeometry() {
        int n = 12;
        int m = 8;
        Vertex3d[] ringVertices = new Vertex3d[m * n];
        int k = 0;
        int i = 0;
        while (i < n) {
            double cx = Math.cos(Math.PI * 2 * (double)i / (double)n);
            double cy = Math.sin(Math.PI * 2 * (double)i / (double)n);
            int j = 0;
            while (j < m) {
                double dr = Math.cos(Math.PI * 2 * (double)j / (double)m) * 0.02;
                double dz = -Math.sin(Math.PI * 2 * (double)j / (double)m) * 0.02;
                double dx = cx * dr;
                double dy = cy * dr;
                Vector3 pos = new Vector3(cx * 0.3 + dx, cy * 0.3 + dy, dz);
                Vector3 normal = new Vector3(dx, dy, dz);
                normal.normalize();
                ringVertices[k++] = Util.getVertex3d(pos, normal);
                ++j;
            }
            ++i;
        }
        int[] ringIndices = new int[n * m * 2 * 3];
        k = 0;
        int i2 = 0;
        while (i2 < n) {
            int n0 = i2;
            int n1 = Util.mod(i2 + 1, n);
            int j = 0;
            while (j < m) {
                int m0 = j;
                int m1 = Util.mod(j + 1, m);
                ringIndices[k++] = n0 * m + m0;
                ringIndices[k++] = n0 * m + m1;
                ringIndices[k++] = n1 * m + m0;
                ringIndices[k++] = n1 * m + m1;
                ringIndices[k++] = n1 * m + m0;
                ringIndices[k++] = n0 * m + m1;
                ++j;
            }
            ++i2;
        }
        this.ringITA.setVertices(ringVertices);
        this.ringITA.setIndices(ringIndices);
    }

    public void show() {
        this.ringVehicle.setParent((Container)this.parent);
    }

    public void setPosition(Part part) {
        this.part = part;
        Vector3 pos = part.partVehicle.getPosition((ReferenceFrame)this.parent);
        if (part.temporary_parent_vehicle != null) {
            pos = part.temporary_parent_vehicle.getPosition((ReferenceFrame)this.parent);
        }
        this.ringVehicle.setPosition((Vector3d)pos, (ReferenceFrame)this.parent);
        Vector3[] cameraOrientation = Squirrel.jaliceFrame.cameraVehicle.getOrientation((ReferenceFrame)this.parent);
        this.ringVehicle.setOrientation((Vector3d)cameraOrientation[0], (Vector3d)cameraOrientation[1], (ReferenceFrame)this.parent);
    }
}

