/*
 * Decompiled with CFR 0.152.
 */
package squirrel;

import VisualNumerics.math.DoubleMatrix;
import VisualNumerics.math.DoubleSVD;
import edu.cmu.cs.stage3.math.Vector3;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import squirrel.Knot;

public class RadialBasisFunctionXYZ {
    public Knot[] knots;
    public Vector3[] values;
    public Vector3[] d;
    public Vector3[] p;
    public int size;
    public int dim;
    Vector3[] axis;
    public static int type;
    public static final int R = 0;
    public static final int R3 = 1;
    double C = 1.0;

    public Knot map(Knot v) {
        if (this.dim == 1) {
            return new Knot(Vector3.dotProduct((Vector3d)this.axis[0], (Vector3d)v), 0.0, 0.0);
        }
        if (this.dim == 2) {
            return new Knot(Vector3.dotProduct((Vector3d)this.axis[0], (Vector3d)v), Vector3.dotProduct((Vector3d)this.axis[1], (Vector3d)v), 0.0);
        }
        return v;
    }

    public void set(Knot[] knots, Vector3[] values) {
        this.values = (Vector3[])values.clone();
        this.knots = (Knot[])knots.clone();
        this.calculate();
    }

    public Vector3 get(Knot v) {
        if (this.size == 0) {
            return null;
        }
        if (this.size == 1) {
            return this.values[0];
        }
        v = this.map(v);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double m = 0.0;
        int i = 0;
        while (i < this.size) {
            m = this.phai(v, this.knots[i]);
            x += this.d[i].x * m;
            y += this.d[i].y * m;
            z += this.d[i].z * m;
            ++i;
        }
        return new Vector3(x += this.p[0].x + this.p[1].x * ((Tuple3d)v).x + this.p[2].x * ((Tuple3d)v).y + this.p[3].x * ((Tuple3d)v).z, y += this.p[0].y + this.p[1].y * ((Tuple3d)v).x + this.p[2].y * ((Tuple3d)v).y + this.p[3].y * ((Tuple3d)v).z, z += this.p[0].z + this.p[1].z * ((Tuple3d)v).x + this.p[2].z * ((Tuple3d)v).y + this.p[3].z * ((Tuple3d)v).z);
    }

    RadialBasisFunctionXYZ() {
    }

    RadialBasisFunctionXYZ(Knot[] knots, Vector3[] values) {
        this.set(knots, values);
    }

    public double spline(double r, double dilation) {
        if ((r /= dilation) > 1.0) {
            return 0.0;
        }
        return 2.0 * r * r * r - 3.0 * r * r + 1.0;
    }

    public void calculate() {
        int i;
        this.size = this.knots.length;
        if (this.size == 1) {
            this.p = this.values;
            return;
        }
        this.p = new Vector3[this.size];
        double[] vx = new double[this.values.length];
        double[] vy = new double[this.values.length];
        double[] vz = new double[this.values.length];
        int i2 = 0;
        while (i2 < this.size) {
            vx[i2] = this.values[i2].x;
            vy[i2] = this.values[i2].y;
            vz[i2] = this.values[i2].z;
            ++i2;
        }
        Vector3 center = new Vector3();
        int i3 = 0;
        while (i3 < this.size) {
            center = Vector3.add((Vector3d)center, (Vector3d)this.knots[i3]);
            ++i3;
        }
        center.multiply(1.0 / (double)this.size);
        double[][] M = new double[3][3];
        int i4 = 0;
        while (i4 < this.size) {
            double[] dArray = M[0];
            dArray[0] = dArray[0] + (((Tuple3d)this.knots[i4]).x - center.x) * (((Tuple3d)this.knots[i4]).x - center.x);
            double[] dArray2 = M[1];
            dArray2[1] = dArray2[1] + (((Tuple3d)this.knots[i4]).y - center.y) * (((Tuple3d)this.knots[i4]).y - center.y);
            double[] dArray3 = M[2];
            dArray3[2] = dArray3[2] + (((Tuple3d)this.knots[i4]).z - center.z) * (((Tuple3d)this.knots[i4]).z - center.z);
            double[] dArray4 = M[0];
            dArray4[1] = dArray4[1] + (((Tuple3d)this.knots[i4]).x - center.x) * (((Tuple3d)this.knots[i4]).y - center.y);
            double[] dArray5 = M[0];
            dArray5[2] = dArray5[2] + (((Tuple3d)this.knots[i4]).x - center.x) * (((Tuple3d)this.knots[i4]).z - center.z);
            double[] dArray6 = M[1];
            dArray6[2] = dArray6[2] + (((Tuple3d)this.knots[i4]).y - center.y) * (((Tuple3d)this.knots[i4]).z - center.z);
            ++i4;
        }
        M[1][0] = M[0][1];
        M[2][0] = M[0][2];
        M[2][1] = M[1][2];
        DoubleSVD svd = new DoubleSVD(M);
        double[] S = svd.S();
        double[][] V = svd.V();
        this.axis = new Vector3[3];
        this.axis[0] = new Vector3(V[0][0], V[1][0], V[2][0]);
        this.axis[1] = new Vector3(V[0][1], V[1][1], V[2][1]);
        this.axis[2] = new Vector3(V[0][2], V[1][2], V[2][2]);
        double threshold = 0.01;
        this.dim = Math.abs(S[1]) < threshold && Math.abs(S[2]) < threshold ? 1 : (Math.abs(S[2]) < threshold ? 2 : 3);
        if (this.dim == 1 || this.dim == 2) {
            int i5 = 0;
            while (i5 < this.size) {
                this.knots[i5] = this.map(this.knots[i5]);
                ++i5;
            }
        }
        double[][] matrix = new double[this.size + 1 + this.dim][this.size + 1 + this.dim];
        int j = 0;
        while (j < this.size) {
            i = j;
            while (i < this.size) {
                matrix[i][j] = this.phai(this.knots[i], this.knots[j]);
                ++i;
            }
            matrix[this.size][j] = 1.0;
            if (this.dim >= 1) {
                matrix[this.size + 1][j] = ((Tuple3d)this.knots[j]).x;
            }
            if (this.dim >= 2) {
                matrix[this.size + 2][j] = ((Tuple3d)this.knots[j]).y;
            }
            if (this.dim >= 3) {
                matrix[this.size + 3][j] = ((Tuple3d)this.knots[j]).z;
            }
            ++j;
        }
        j = 0;
        while (j < this.size + 1 + this.dim) {
            i = j + 1;
            while (i < this.size + 1 + this.dim) {
                matrix[j][i] = matrix[i][j];
                ++i;
            }
            ++j;
        }
        double[] dp_x = this.calculate_sub(matrix, vx);
        double[] dp_y = this.calculate_sub(matrix, vy);
        double[] dp_z = this.calculate_sub(matrix, vz);
        this.d = new Vector3[this.size];
        int i6 = 0;
        while (i6 < this.size) {
            this.d[i6] = new Vector3(dp_x[i6], dp_y[i6], dp_z[i6]);
            ++i6;
        }
        this.p = new Vector3[4];
        this.p[0] = new Vector3(dp_x[this.size], dp_y[this.size], dp_z[this.size]);
        this.p[1] = this.dim >= 1 ? new Vector3(dp_x[this.size + 1], dp_y[this.size + 1], dp_z[this.size + 1]) : new Vector3();
        this.p[2] = this.dim >= 2 ? new Vector3(dp_x[this.size + 2], dp_y[this.size + 2], dp_z[this.size + 2]) : new Vector3();
        this.p[3] = this.dim >= 3 ? new Vector3(dp_x[this.size + 3], dp_y[this.size + 3], dp_z[this.size + 3]) : new Vector3();
    }

    public double phai(Knot v0, Knot v1) {
        double r = Knot.distance(v0, v1);
        switch (type) {
            case 0: {
                return r;
            }
            case 1: {
                return r * r * r;
            }
        }
        return 0.0;
    }

    public double[] calculate_sub_spline(double[][] matrix, double[] values) {
        double[] array2 = null;
        try {
            array2 = DoubleMatrix.solve((double[][])matrix, (double[])values);
        }
        catch (Exception e) {
            System.out.println("Solve failed! " + e);
        }
        return array2;
    }

    public double[] calculate_sub(double[][] matrix, double[] values) {
        double[] array = new double[this.size + 1 + this.dim];
        int i = 0;
        while (i < this.size) {
            array[i] = values[i];
            ++i;
        }
        double[] array2 = null;
        try {
            array2 = DoubleMatrix.solve((double[][])matrix, (double[])array);
        }
        catch (Exception e) {
            System.out.println("Solve failed! " + e);
        }
        return array2;
    }
}

