/*
 * Decompiled with CFR 0.152.
 */
package squirrel;

import VisualNumerics.math.DoubleMatrix;
import edu.cmu.cs.stage3.math.Vector3;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import squirrel.Knot;

public class RadialBasisFunction {
    public Knot[] knots;
    public double[] values;
    public double[] d;
    public double[] p;
    public int size;
    public Vector3 vec0;
    public Vector3 vec1;
    double C = 1.0E-4;

    public void set(Knot[] knots, double[] values) {
        this.knots = knots;
        this.values = values;
        this.calculate(knots, values);
    }

    public double get(Knot v) {
        if (this.size == 0) {
            return 0.0;
        }
        switch (this.size) {
            case 1: {
                return this.p[0];
            }
            case 2: {
                return this.p[0] + Vector3.dotProduct((Vector3d)v, (Vector3d)this.vec0) * this.p[1];
            }
            case 3: {
                return this.p[0] + Vector3.dotProduct((Vector3d)v, (Vector3d)this.vec0) * this.p[1] + Vector3.dotProduct((Vector3d)v, (Vector3d)this.vec1) * this.p[2];
            }
            case 4: {
                return this.p[0] + this.p[1] * ((Tuple3d)v).x + this.p[2] * ((Tuple3d)v).y + this.p[3] * ((Tuple3d)v).z;
            }
        }
        double sum = 0.0;
        int i = 0;
        while (i < this.size) {
            sum += this.d[i] * this.phai(v, this.knots[i]);
            ++i;
        }
        sum += this.p[0];
        sum += this.p[1] * ((Tuple3d)v).x;
        sum += this.p[2] * ((Tuple3d)v).y;
        return sum += this.p[3] * ((Tuple3d)v).z;
    }

    RadialBasisFunction() {
        this.size = 0;
    }

    RadialBasisFunction(Knot[] knots, double[] values) {
        this.set(knots, values);
    }

    public void calculate(Knot[] knots, double[] values) {
        int i;
        this.size = knots.length;
        if (this.size == 1) {
            this.p = values;
            return;
        }
        if (this.size == 2) {
            this.vec0 = Vector3.subtract((Vector3d)knots[1], (Vector3d)knots[0]);
            double[][] matrix = new double[][]{{1.0, Vector3.dotProduct((Vector3d)knots[0], (Vector3d)this.vec0)}, {1.0, Vector3.dotProduct((Vector3d)knots[1], (Vector3d)this.vec0)}};
            try {
                this.p = DoubleMatrix.solve((double[][])matrix, (double[])values);
            }
            catch (Exception e) {
                System.out.println("Solve failed! " + e);
            }
            return;
        }
        if (this.size == 3) {
            this.vec0 = Vector3.subtract((Vector3d)knots[1], (Vector3d)knots[0]);
            this.vec1 = Vector3.subtract((Vector3d)knots[2], (Vector3d)knots[0]);
            double[][] matrix = new double[][]{{1.0, Vector3.dotProduct((Vector3d)knots[0], (Vector3d)this.vec0), Vector3.dotProduct((Vector3d)knots[0], (Vector3d)this.vec1)}, {1.0, Vector3.dotProduct((Vector3d)knots[1], (Vector3d)this.vec0), Vector3.dotProduct((Vector3d)knots[1], (Vector3d)this.vec1)}, {1.0, Vector3.dotProduct((Vector3d)knots[2], (Vector3d)this.vec0), Vector3.dotProduct((Vector3d)knots[2], (Vector3d)this.vec1)}};
            try {
                this.p = DoubleMatrix.solve((double[][])matrix, (double[])values);
            }
            catch (Exception e) {
                System.out.println("Solve failed! " + e);
            }
            return;
        }
        if (this.size == 4) {
            double[][] matrix = new double[][]{{1.0, ((Tuple3d)knots[0]).x, ((Tuple3d)knots[0]).y, ((Tuple3d)knots[0]).z}, {1.0, ((Tuple3d)knots[1]).x, ((Tuple3d)knots[1]).y, ((Tuple3d)knots[1]).z}, {1.0, ((Tuple3d)knots[2]).x, ((Tuple3d)knots[2]).y, ((Tuple3d)knots[2]).z}, {1.0, ((Tuple3d)knots[3]).x, ((Tuple3d)knots[3]).y, ((Tuple3d)knots[3]).z}};
            try {
                this.p = DoubleMatrix.solve((double[][])matrix, (double[])values);
            }
            catch (Exception e) {
                System.out.println("Solve failed! " + e);
            }
            return;
        }
        double[][] matrix = new double[this.size + 4][this.size + 4];
        int j = 0;
        while (j < this.size) {
            i = j;
            while (i < this.size) {
                matrix[i][j] = this.phai(knots[i], knots[j]);
                ++i;
            }
            matrix[this.size][j] = 1.0;
            matrix[this.size + 1][j] = ((Tuple3d)knots[j]).x;
            matrix[this.size + 2][j] = ((Tuple3d)knots[j]).y;
            matrix[this.size + 3][j] = ((Tuple3d)knots[j]).z;
            ++j;
        }
        j = 0;
        while (j < this.size + 4) {
            i = j + 1;
            while (i < this.size + 4) {
                matrix[j][i] = matrix[i][j];
                ++i;
            }
            ++j;
        }
        double[] array = new double[this.size + 4];
        i = 0;
        while (i < this.size) {
            array[i] = values[i];
            ++i;
        }
        double[] array2 = new double[this.size + 4];
        try {
            array2 = DoubleMatrix.solve((double[][])matrix, (double[])array);
        }
        catch (Exception e) {
            System.out.println("Solve failed! " + e);
        }
        this.d = new double[this.size];
        int i2 = 0;
        while (i2 < this.size) {
            this.d[i2] = array2[i2];
            ++i2;
        }
        this.p = new double[4];
        this.p[0] = array2[this.size];
        this.p[1] = array2[this.size + 1];
        this.p[2] = array2[this.size + 2];
        this.p[3] = array2[this.size + 3];
    }

    public double phai(Knot v0, Knot v1) {
        double d = Knot.distance(v0, v1);
        return d;
    }
}

