/*
 * Decompiled with CFR 0.152.
 */
package squirrel;

import edu.cmu.cs.stage3.alice.scenegraph.OrthographicCamera;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.math.Vector3;
import java.awt.Point;
import javax.vecmath.Vector3d;
import squirrel.Squirrel;

public class Plane {
    Vector3 base;
    Vector3 normal;
    ReferenceFrame reference;
    Vector3 x_axis;
    Vector3 y_axis;

    public Vector3 project_coords(Point p) {
        Vector3 pos = this.project(p);
        pos = Vector3.subtract((Vector3d)pos, (Vector3d)this.base);
        double x = Vector3.dotProduct((Vector3d)this.x_axis, (Vector3d)pos);
        double y = Vector3.dotProduct((Vector3d)this.y_axis, (Vector3d)pos);
        return new Vector3(x, y, 0.0);
    }

    Plane(Vector3 base, Vector3 normal) {
        this.base = base;
        this.normal = normal;
        this.reference = null;
    }

    Plane(Vector3 base, Vector3 normal, ReferenceFrame reference) {
        this.base = base;
        this.normal = normal;
        this.reference = reference;
    }

    Plane(Vector3 base, Vector3 normal, Vector3 up_vec, ReferenceFrame reference) {
        this.base = base;
        this.normal = normal;
        this.reference = reference;
        this.x_axis = Vector3.crossProduct((Vector3d)up_vec, (Vector3d)normal);
        this.y_axis = up_vec;
    }

    public Vector3 project(Point p) {
        if (Squirrel.jaliceFrame.camera instanceof OrthographicCamera) {
            return this.project_parallel(p);
        }
        Vector3 cameraPt = Squirrel.jaliceFrame.cameraVehicle.getPosition(this.reference);
        Vector3 screenPt = Squirrel.jaliceFrame.screen_coords_to_local_coords(p, this.reference);
        Vector3 cameraToBase = Vector3.subtract((Vector3d)this.base, (Vector3d)cameraPt);
        Vector3 cameraToScreen = Vector3.subtract((Vector3d)screenPt, (Vector3d)cameraPt);
        double t = Vector3.dotProduct((Vector3d)cameraToBase, (Vector3d)this.normal) / Vector3.dotProduct((Vector3d)cameraToScreen, (Vector3d)this.normal);
        Vector3 result = Vector3.add((Vector3d)cameraPt, (Vector3d)Vector3.multiply((Vector3d)cameraToScreen, (double)t));
        return result;
    }

    public Vector3 project_parallel(Point p) {
        Vector3 cameraDirection = Squirrel.jaliceFrame.getCameraDirection(this.reference);
        Vector3 screenPt = Squirrel.jaliceFrame.screen_coords_to_local_coords(p, this.reference);
        Vector3 screenToBase = Vector3.subtract((Vector3d)this.base, (Vector3d)screenPt);
        double t = Vector3.dotProduct((Vector3d)screenToBase, (Vector3d)this.normal) / Vector3.dotProduct((Vector3d)cameraDirection, (Vector3d)this.normal);
        Vector3 result = Vector3.add((Vector3d)screenPt, (Vector3d)Vector3.multiply((Vector3d)cameraDirection, (double)t));
        return result;
    }
}

