/*
 * Decompiled with CFR 0.152.
 */
package squirrel;

import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Vector3;
import java.util.Vector;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import squirrel.CursorBall;
import squirrel.Filter;
import squirrel.KeyBall;
import squirrel.Knot;
import squirrel.SpatialKeyframing;
import squirrel.Util;

public class ParallelFilter
extends Filter {
    double RADIUS = 0.03;
    public double WIDTH = 0.2;
    public double DEPTH = 0.2;
    Color COLOR = new Color(0.4, 0.4, 0.4, 1.0);
    Vector3 prev_pos;
    public double[][] xy = new double[][]{{1.0, 1.0}, {1.0, -1.0}, {-1.0, 1.0}, {-1.0, -1.0}};

    public Vector3 pickFilter(Vector3 p) {
        return this.warp(p);
    }

    public Matrix44[] get_parameters(Vector3 p, SpatialKeyframing keyFraming) {
        if (keyFraming == null) {
            return null;
        }
        if (p.x < 0.0) {
            p.x = -this.WIDTH;
            p.z += 2.0 * this.DEPTH;
        } else {
            p.x = -this.WIDTH;
        }
        p.z = -this.DEPTH + Util.double_mod(p.z + this.DEPTH, this.DEPTH * 4.0);
        return keyFraming.get_parameters_main(new Knot(p));
    }

    ParallelFilter(Transformable parent) {
        this.init(parent, this.COLOR, this.RADIUS);
        this.setGeometry(this.RADIUS);
    }

    public void update_keyFraming(SpatialKeyframing keyFraming) {
        Vector keyBalls = keyFraming.keyBalls;
        if (keyBalls.size() == 0) {
            keyFraming.functionSets = null;
            return;
        }
        Vector<Object[]> keys = new Vector<Object[]>();
        int i = 0;
        while (i < keyBalls.size()) {
            KeyBall keyBall = (KeyBall)keyBalls.elementAt(i);
            Vector3 p = keyBall.getPosition();
            if (p.x < 0.0) {
                p.z += 2.0 * this.DEPTH;
            }
            p.x = this.WIDTH;
            Object[] pair = new Object[]{new Knot(p.x, p.y, p.z), keyBall.parameters};
            keys.addElement(pair);
            Object[] pair0 = new Object[]{new Knot(p.x, p.y, p.z - this.DEPTH * 4.0), keyBall.parameters};
            keys.addElement(pair0);
            Object[] pair1 = new Object[]{new Knot(p.x, p.y, p.z + this.DEPTH * 4.0), keyBall.parameters};
            keys.addElement(pair1);
            ++i;
        }
        keyFraming.set(keys);
    }

    public void setGeometry(double radius) {
        int[] center_index = new int[]{32, 33, 34, 35};
        Vector3 vec0 = new Vector3(1.0, 0.0, 0.0);
        Vector3 vec1 = new Vector3(0.0, 1.0, 0.0);
        Vertex3d[] filterVertices = new Vertex3d[36];
        int j = 0;
        while (j < 4) {
            Vector3 c = new Vector3(this.xy[j][0] * this.WIDTH, 0.0, this.xy[j][1] * this.DEPTH);
            filterVertices[32 + j] = Util.getVertex3d(c, new Vector3(0.0, 0.0, (double)(-1 + 2 * Util.mod(j, 2))));
            int i = 0;
            while (i < 8) {
                double angle = Math.PI * 2 * (double)i / 8.0;
                Vector3 normal = Vector3.add((Vector3d)Vector3.multiply((Vector3d)vec0, (double)(this.RADIUS * Math.cos(angle))), (Vector3d)Vector3.multiply((Vector3d)vec1, (double)(this.RADIUS * Math.sin(angle))));
                Vector3 p = Vector3.add((Vector3d)c, (Vector3d)normal);
                normal.normalize();
                filterVertices[j * 8 + i] = Util.getVertex3d(p, normal);
                ++i;
            }
            ++j;
        }
        int[] filterIndices = new int[192];
        int n = 0;
        int j2 = 0;
        while (j2 < 2) {
            int i = 0;
            while (i < 8) {
                filterIndices[n++] = this.getIndex(j2 * 2, i);
                filterIndices[n++] = this.getIndex(j2 * 2 + 1, i);
                filterIndices[n++] = this.getIndex(j2 * 2, i + 1);
                filterIndices[n++] = this.getIndex(j2 * 2, i + 1);
                filterIndices[n++] = this.getIndex(j2 * 2 + 1, i);
                filterIndices[n++] = this.getIndex(j2 * 2 + 1, i + 1);
                ++i;
            }
            ++j2;
        }
        j2 = 0;
        while (j2 < 2) {
            int i = 0;
            while (i < 8) {
                filterIndices[n++] = center_index[j2 * 2];
                filterIndices[n++] = this.getIndex(j2 * 2, i);
                filterIndices[n++] = this.getIndex(j2 * 2, i + 1);
                filterIndices[n++] = center_index[j2 * 2 + 1];
                filterIndices[n++] = this.getIndex(j2 * 2 + 1, i + 1);
                filterIndices[n++] = this.getIndex(j2 * 2 + 1, i);
                ++i;
            }
            ++j2;
        }
        this.filterITA.setVertices(filterVertices);
        this.filterITA.setIndices(filterIndices);
    }

    public void prepare_for_warp_cursor(CursorBall cursor) {
        this.prev_pos = cursor.getPosition((ReferenceFrame)this.parent);
    }

    public Vector3 warp(Vector3 p) {
        p = new Vector3((Tuple3d)p);
        p.y = 0.0;
        if (p.z > this.DEPTH + 0.001) {
            p.z -= 2.0 * this.DEPTH;
            p.x = -p.x;
        } else if (p.z < -this.DEPTH - 0.001) {
            p.z += 2.0 * this.DEPTH;
            p.x = -p.x;
        }
        p.x = p.x > 0.0 ? this.WIDTH : -this.WIDTH;
        return p;
    }

    public int getIndex(int j, int i) {
        return Util.mod(j, 4) * 8 + Util.mod(i, 8);
    }
}

