/*
 * Decompiled with CFR 0.152.
 */
package squirrel;

import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Vector3;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import squirrel.Part;
import squirrel.Util;

public class ObjFile {
    public static int setIDs(Part part, int id) {
        part.id = id++;
        int i = 0;
        while (i < part.childrenParts.size()) {
            id = ObjFile.setIDs((Part)part.childrenParts.elementAt(i), id);
            ++i;
        }
        return id;
    }

    public static int save_part_main(Part part, PrintWriter pw, int vertex_count) {
        pw.println("# id " + part.id);
        String childrenIDs = "";
        int i = 0;
        while (i < part.childrenParts.size()) {
            childrenIDs = childrenIDs + " " + ((Part)part.childrenParts.elementAt((int)i)).id;
            ++i;
        }
        pw.println("# children" + childrenIDs);
        Matrix44 matrix = part.partVehicle.getTransformation(null);
        String matrixString = "";
        int i2 = 0;
        while (i2 < 4) {
            int j = 0;
            while (j < 4) {
                matrixString = matrixString + " " + matrix.getItem(i2, j);
                ++j;
            }
            ++i2;
        }
        pw.println("# transformable" + matrixString);
        pw.println("# vertices " + part.partITA.getVertexCount());
        pw.println("# triangles " + part.partITA.getTriangleCount());
        Vertex3d[] vertices = part.partITA.getVertices();
        int i3 = 0;
        while (i3 < vertices.length) {
            Point3d v = vertices[i3].position;
            pw.println("v " + v.x + " " + v.y + " " + v.z);
            ++i3;
        }
        int[] indices = part.partITA.getIndices();
        int i4 = 0;
        while (i4 < indices.length) {
            int v0 = indices[i4] + vertex_count;
            int v1 = indices[i4 + 1] + vertex_count;
            int v2 = indices[i4 + 2] + vertex_count;
            pw.println("f " + v0 + " " + v1 + " " + v2);
            i4 += 3;
        }
        pw.println("#seam");
        pw.println("#sharp");
        return vertex_count + vertices.length;
    }

    public static Part load(String filename) {
        Part part = null;
        try {
            FileInputStream fis = new FileInputStream(filename);
            BufferedReader r = new BufferedReader(new InputStreamReader(fis));
            int[] vertex_count = new int[]{1};
            part = ObjFile.load_sub(r, null, vertex_count);
            r.close();
        }
        catch (IOException e) {
            System.out.println("Error in ObjFile.load()");
        }
        return part;
    }

    public static Part load_sub(BufferedReader r, Part parentPart, int[] vertex_count) {
        try {
            StringTokenizer st = new StringTokenizer(r.readLine());
            st.nextToken();
            st.nextToken();
            int id = new Integer(st.nextToken());
            st = new StringTokenizer(r.readLine());
            st.nextToken();
            st.nextToken();
            Vector<Integer> children = new Vector<Integer>();
            while (st.hasMoreTokens()) {
                children.addElement(new Integer(st.nextToken()));
            }
            st = new StringTokenizer(r.readLine());
            st.nextToken();
            st.nextToken();
            Matrix44 matrix = new Matrix44();
            int i = 0;
            while (i < 4) {
                int j = 0;
                while (j < 4) {
                    matrix.setItem(i, j, new Double(st.nextToken()).doubleValue());
                    ++j;
                }
                ++i;
            }
            st = new StringTokenizer(r.readLine());
            st.nextToken();
            st.nextToken();
            int n_vertices = new Integer(st.nextToken());
            st = new StringTokenizer(r.readLine());
            st.nextToken();
            st.nextToken();
            int n_triangles = new Integer(st.nextToken());
            Vertex3d[] vertices = new Vertex3d[n_vertices];
            int i2 = 0;
            while (i2 < n_vertices) {
                st = new StringTokenizer(r.readLine());
                st.nextToken();
                Vector3 v = new Vector3();
                v.x = new Double(st.nextToken());
                v.y = new Double(st.nextToken());
                v.z = new Double(st.nextToken());
                vertices[i2] = Util.getVertex3d(v, new Vector3());
                ++i2;
            }
            int[] indices = new int[n_triangles * 3];
            int i3 = 0;
            while (i3 < n_triangles) {
                st = new StringTokenizer(r.readLine());
                st.nextToken();
                indices[i3 * 3] = new Integer(st.nextToken()) - vertex_count[0];
                indices[i3 * 3 + 1] = new Integer(st.nextToken()) - vertex_count[0];
                indices[i3 * 3 + 2] = new Integer(st.nextToken()) - vertex_count[0];
                ++i3;
            }
            r.readLine();
            r.readLine();
            ObjFile.set_vertex_normals(vertices, indices);
            Part part = new Part(matrix, vertices, indices, parentPart);
            vertex_count[0] = vertex_count[0] + n_vertices;
            int i4 = 0;
            while (i4 < children.size()) {
                part.childrenParts.addElement(ObjFile.load_sub(r, part, vertex_count));
                ++i4;
            }
            return part;
        }
        catch (IOException e) {
            System.out.println("Error in ObjFile.load()");
            return null;
        }
    }

    public static void save(Part part, String filename) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            PrintWriter pw = new PrintWriter(bos);
            System.out.println("save");
            ObjFile.setIDs(part, 0);
            int vertex_count = 1;
            ObjFile.save_part(part, pw, vertex_count);
            pw.flush();
            pw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void set_vertex_normals(Vertex3d[] vertices, int[] indices) {
        int n_faces = indices.length / 3;
        int n_vertices = vertices.length;
        Vector3[] vertex_normals = new Vector3[n_vertices];
        int i = 0;
        while (i < n_vertices) {
            vertex_normals[i] = new Vector3();
            ++i;
        }
        i = 0;
        while (i < n_faces) {
            Vector3 v0 = Util.Point3dtoVector3(vertices[indices[i * 3]].position);
            Vector3 v1 = Util.Point3dtoVector3(vertices[indices[i * 3 + 1]].position);
            Vector3 v2 = Util.Point3dtoVector3(vertices[indices[i * 3 + 2]].position);
            Vector3 normal = Vector3.crossProduct((Vector3d)Vector3.subtract((Vector3d)v1, (Vector3d)v0), (Vector3d)Vector3.subtract((Vector3d)v2, (Vector3d)v0));
            vertex_normals[indices[i * 3]].add(normal);
            vertex_normals[indices[i * 3 + 1]].add(normal);
            vertex_normals[indices[i * 3 + 2]].add(normal);
            ++i;
        }
        i = 0;
        while (i < n_vertices) {
            vertices[i].normal.set((Tuple3d)Util.Vector3toVector3d(Vector3.normalizeV((Vector3d)vertex_normals[i])));
            ++i;
        }
    }

    public static int save_part(Part part, PrintWriter pw, int vertex_count) {
        vertex_count = ObjFile.save_part_main(part, pw, vertex_count);
        int i = 0;
        while (i < part.childrenParts.size()) {
            vertex_count = ObjFile.save_part((Part)part.childrenParts.elementAt(i), pw, vertex_count);
            ++i;
        }
        return vertex_count;
    }
}

