/*
 * Decompiled with CFR 0.152.
 */
package squirrel;

import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import squirrel.Locomotion;
import squirrel.SpatialKeyframing;
import squirrel.Squirrel;
import squirrel.TrajectoryEventHandler;

public class MyMenuBar
extends MenuBar
implements ActionListener {
    Squirrel target;
    static MyMenuBar myMenuBar;
    Menu movieMenu = new Menu();

    MyMenuBar(Squirrel target) {
        this.target = target;
        myMenuBar = this;
        Menu fileMenu = new Menu();
        fileMenu.setLabel("File");
        fileMenu.add(new MyMenuItem("open"));
        fileMenu.add(new MyMenuItem("importASG"));
        fileMenu.add(new MyMenuItem("exit"));
        this.add(fileMenu);
        Menu keyMenu = new Menu();
        keyMenu.setLabel("Keys");
        keyMenu.add(new MyMenuItem("load"));
        keyMenu.add(new MyMenuItem("save"));
        this.add(keyMenu);
        Menu modeMenu = new Menu();
        modeMenu.setLabel("Mode");
        modeMenu.add(new MyMenuItem("spatial keyframing"));
        modeMenu.add(new MyMenuItem("recording"));
        this.add(modeMenu);
        this.movieMenu = new Menu();
        this.movieMenu.setLabel("Movie");
        this.movieMenu.add(new MyMenuItem("create_movie"));
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() instanceof MyMenuItem) {
            String label = ((MyMenuItem)event.getSource()).getLabel();
            if (label.equals("init")) {
                this.target.init();
            } else if (label.equals("open")) {
                this.target.load();
            } else if (label.equals("store")) {
                this.target.save();
            } else if (label.equals("exportXML")) {
                this.target.exportXML();
            } else if (label.equals("importASG")) {
                this.target.importASG();
            } else if (label.equals("load")) {
                this.target.load_keys();
            } else if (label.equals("save")) {
                this.target.save_keys();
            } else if (label.equals("r")) {
                this.target.set_option(label);
            } else if (label.equals("r3")) {
                this.target.set_option(label);
            } else if (label.equals("axis")) {
                SpatialKeyframing.USE_QUATERNION = false;
            } else if (label.equals("quaternion")) {
                SpatialKeyframing.USE_QUATERNION = true;
            } else if (label.equals("filter")) {
                this.target.set_filter();
            } else if (label.equals("exit")) {
                System.exit(0);
            } else if (label.equals("character") || label.equals("spatial keyframing") || label.equals("temporal keyframing") || label.equals("recording")) {
                this.target.switch_mode(label);
            } else if (label.equals("create_movie")) {
                if (this.target.eventHandler instanceof TrajectoryEventHandler) {
                    ((TrajectoryEventHandler)this.target.eventHandler).create_movie();
                }
            } else if (label.equals("moving")) {
                boolean bl = Locomotion.MOVING_ENABLED = !Locomotion.MOVING_ENABLED;
                if (this.target.eventHandler instanceof TrajectoryEventHandler) {
                    ((TrajectoryEventHandler)this.target.eventHandler).create_movie();
                }
            } else if (label.equals("show anchor")) {
                Locomotion.show_anchor();
            }
        }
    }

    class MyMenuItem
    extends MenuItem {
        MyMenuItem(String label) {
            MyMenuBar.this.getClass();
            this.setLabel(label);
            this.addActionListener(myMenuBar);
        }
    }
}

