/*
 * Decompiled with CFR 0.152.
 */
package squirrel;

import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.math.Vector3;
import java.util.Vector;
import javax.vecmath.Vector3d;
import squirrel.AnchorBall;
import squirrel.Squirrel;
import squirrel.Util;

public class Locomotion {
    public static boolean moving = false;
    public static boolean MOVING_ENABLED = false;
    static Vector3 prev_pos;
    static AnchorBall prev;
    static Vector prev_vecs;
    public static Vector3 last_drag_location;
    static Vector anchors;
    public static boolean SHOW_ANCHOR;

    public static void update() {
        if (anchors.size() == 0) {
            return;
        }
        Vector3 min = new Vector3(0.0, 0.0, 0.0);
        AnchorBall lowest = null;
        int i = 0;
        while (i < anchors.size()) {
            AnchorBall anchorBall = (AnchorBall)anchors.elementAt(i);
            Vector3 pos = Squirrel.jaliceFrame.change_coords(anchorBall.position, (ReferenceFrame)anchorBall.parent, (ReferenceFrame)Squirrel.squirrel.getModel().base.baseVehicle);
            if (pos.y < min.y) {
                min = pos;
                lowest = anchorBall;
            }
            ++i;
        }
        Vector3 new_pos = min;
        if (lowest != null && prev == lowest) {
            Vector3 vec = Vector3.subtract((Vector3d)new_pos, (Vector3d)prev_pos);
            vec.y = 0.0;
            vec.x = 0.0;
            Locomotion.slide_ground(vec);
            prev_vecs.addElement(vec);
        } else if (lowest == null && prev_vecs.size() > 0) {
            Vector3 prev_vec = new Vector3();
            int i2 = 0;
            while (i2 < prev_vecs.size()) {
                prev_vec = Vector3.add((Vector3d)prev_vec, (Vector3d)((Vector3)prev_vecs.elementAt(i2)));
                ++i2;
            }
            prev_vec = Vector3.multiply((Vector3d)prev_vec, (double)(1.0 / (double)prev_vecs.size()));
            Locomotion.slide_ground(prev_vec);
        }
        prev_pos = new_pos;
        prev = lowest;
    }

    public static void anchor(Squirrel squirrel) {
        if (squirrel.lockedPart == null) {
            return;
        }
        AnchorBall anchorBall = new AnchorBall(squirrel.lockedPart.partVehicle, squirrel.lockedPosition);
        anchors.addElement(anchorBall);
    }

    public static void anchor(Transformable partVehicle, Vector3 position) {
        AnchorBall anchorBall = new AnchorBall(partVehicle, position);
        anchors.addElement(anchorBall);
        Squirrel.squirrel.visual_list.put(anchorBall.ballVisual, anchorBall);
    }

    static {
        prev_vecs = new Vector();
        last_drag_location = new Vector3();
        anchors = new Vector();
        SHOW_ANCHOR = true;
    }

    public static void show_anchor() {
        SHOW_ANCHOR = !SHOW_ANCHOR;
        int i = 0;
        while (i < anchors.size()) {
            AnchorBall anchor = (AnchorBall)anchors.elementAt(i);
            if (SHOW_ANCHOR) {
                anchor.show();
            } else {
                anchor.hide();
            }
            ++i;
        }
        Squirrel.squirrel.repaint();
    }

    public static void slide_ground(Vector3 vec) {
        if (moving && MOVING_ENABLED) {
            vec = Vector3.multiply((Vector3d)vec, (double)-1.0);
            Squirrel.squirrel.getModel().base.baseVehicle.setPosition((Vector3d)vec, (ReferenceFrame)Squirrel.squirrel.getModel().base.baseVehicle);
            return;
        }
        Vector3 pos = Squirrel.squirrel.ground.tileVehicle.getPosition((ReferenceFrame)Squirrel.squirrel.getModel().base.baseVehicle);
        pos = Vector3.add((Vector3d)pos, (Vector3d)vec);
        Squirrel.squirrel.ground.tileVehicle.setPosition((Vector3d)pos, (ReferenceFrame)Squirrel.squirrel.getModel().base.baseVehicle);
        pos = Squirrel.squirrel.ground.tileVehicle.getPosition(null);
        pos.x = Util.double_mod(pos.x + 2.0, 4.0) - 2.0;
        pos.z = Util.double_mod(pos.z + 2.0, 4.0) - 2.0;
        Squirrel.squirrel.ground.tileVehicle.setPosition((Vector3d)pos, null);
    }

    public static void clear_anchors() {
        int i = 0;
        while (i < anchors.size()) {
            AnchorBall anchor = (AnchorBall)anchors.elementAt(i);
            anchor.delete();
            ++i;
        }
        anchors = new Vector();
    }

    public static void remove_anchor(AnchorBall anchor) {
        anchors.remove(anchor);
        anchor.delete();
    }
}

