/*
 * Decompiled with CFR 0.152.
 */
package squirrel;

import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Vector3;
import javax.vecmath.Vector3d;
import squirrel.Ball;
import squirrel.Knot;
import squirrel.SpatialKeyframing;

public class KeyBall
extends Ball {
    double KEYBALL_RADIUS = 0.04;
    Color KEYBALL_COLOR = new Color(0.8, 0.8, 0.2, 1.0);
    SpatialKeyframing spatialKeyframing;
    Transformable attachedParent;
    Vector3 orientation;
    Matrix44[] parameters;
    Ball ghost;

    public KeyBall(SpatialKeyframing spatialKeyframing) {
        this.spatialKeyframing = spatialKeyframing;
        Transformable parent = spatialKeyframing.get_model().base.baseVehicle;
        this.init(parent, this.KEYBALL_COLOR, this.KEYBALL_RADIUS);
    }

    public void update_ghost() {
        if (this.ghost == null) {
            return;
        }
        this.ghost.setPosition(Vector3.add((Vector3d)this.getPosition(), (Vector3d)Vector3.multiply((Vector3d)this.orientation, (double)0.07)), (ReferenceFrame)this.parent);
    }

    public void setPosition(Vector3 pos) {
        super.setPosition(pos);
        this.update_ghost();
    }

    public void setPosition(Vector3 pos, ReferenceFrame reference) {
        super.setPosition(pos, reference);
        this.update_ghost();
    }

    public Knot getKnot() {
        if (this.ghost == null) {
            return new Knot(this.getPosition(), null);
        }
        return new Knot(this.getPosition(), this.orientation);
    }

    public void set_ghost() {
        this.ghost = new Ball(this.parent, 0.03, new Color(0.4, 0.4, 0.1, 1.0));
        this.update_ghost();
    }

    public void delete() {
        super.delete();
        if (this.ghost != null) {
            this.ghost.delete();
        }
    }
}

