/*
 * Decompiled with CFR 0.152.
 */
package squirrel;

import edu.cmu.cs.stage3.alice.scenegraph.AmbientLight;
import edu.cmu.cs.stage3.alice.scenegraph.Background;
import edu.cmu.cs.stage3.alice.scenegraph.Camera;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.DirectionalLight;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.OrthographicCamera;
import edu.cmu.cs.stage3.alice.scenegraph.PerspectiveCamera;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.Scene;
import edu.cmu.cs.stage3.alice.scenegraph.TextureMap;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.VertexGeometry;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.OnscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.PickInfo;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.RenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.Renderer;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.RendererInfo;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.event.OnscreenRenderTargetEvent;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.event.OnscreenRenderTargetListener;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.event.RenderTargetEvent;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.event.RendererEvent;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.event.RendererListener;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Vector3;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import squirrel.MyMenuBar;
import squirrel.Squirrel;
import squirrel.VisualPickInfo;

public class JaliceFrame
extends Frame
implements WindowListener,
OnscreenRenderTargetListener,
RendererListener,
ComponentListener {
    final int WIDTH = 640;
    final int HEIGHT = 600;
    public final Color GROUND_COLOR = new Color(0.55, 0.93, 0.55);
    public static final Color BACKGROUND_COLOR = new Color(0.2, 0.2, 0.75);
    public static final Color SUN_COLOR = new Color(0.996078431372549, 0.9215686274509803, 0.8666666666666667);
    public static final Color AMBIENT_COLOR = new Color(0.8156862745098039, 0.5450980392156862, 0.3803921568627451);
    public RendererInfo rendererInfo;
    public OnscreenRenderTarget renderTarget;
    public MouseListener mouseListener;
    public MouseMotionListener mouseMotionListener;
    public Squirrel target;
    public Scene scene;
    public Transformable cameraVehicle;
    public Visual groundVisual;
    public Color pickedColor = null;
    public Visual pickedVisual = null;
    public double prevTime = System.currentTimeMillis();
    public double scale = 0.009;
    public Camera camera;
    Renderer renderer;
    public Component awtComponent;

    public void initRenderer(Camera camera) {
        Class cls = this.rendererInfo.getRendererClass();
        this.renderer = null;
        try {
            this.renderer = (Renderer)cls.newInstance();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
        }
        if (this.renderer != null) {
            this.renderTarget = this.renderer.createOnscreenRenderTarget();
            this.awtComponent = this.renderTarget.getAWTComponent();
            this.add("Center", this.awtComponent);
            this.setMenuBar(new MyMenuBar(this.target));
            this.invalidate();
            this.doLayout();
            this.renderTarget.addCamera(camera);
            this.renderTarget.addOnscreenRenderTargetListener((OnscreenRenderTargetListener)this);
            this.renderTarget.getRenderer().addRendererListener((RendererListener)this);
        }
    }

    public void componentShown(ComponentEvent e) {
    }

    public Vector3 change_coords(Vector3 v, ReferenceFrame current, ReferenceFrame target) {
        Transformable dammy = new Transformable();
        dammy.setParent((Container)this.scene);
        dammy.setPosition((Vector3d)v, current);
        Vector3 w = dammy.getPosition(target);
        dammy.setParent(null);
        return w;
    }

    public void simulate(double currTime) {
        double dt = currTime - this.prevTime;
        if (dt > 0.0 && this.pickedVisual != null && this.pickedVisual != this.groundVisual) {
            Transformable trans = (Transformable)this.pickedVisual.getParent();
            trans.rotate((Vector3d)Vector3.Z_AXIS, dt, null);
        }
        this.prevTime = currTime;
    }

    public void componentResized(ComponentEvent e) {
        this.set_camera_parameters();
        Squirrel.trash_bin = null;
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void cleared(RenderTargetEvent renderTargetEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.exit(0);
    }

    public TextureMap loadTextureMap(String dirname) {
        Toolkit toolkit = this.getToolkit();
        Image image = toolkit.getImage("samples/media/ground/texture.jpg");
        while (image.getWidth(this) == -1 && image.getWidth(this) == -1) {
            Thread.yield();
        }
        TextureMap textureMap = new TextureMap();
        textureMap.setImage(image);
        return textureMap;
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.set_camera_parameters();
    }

    public Camera initSceneGraph() {
        this.scene = new Scene();
        this.cameraVehicle = new Transformable();
        this.cameraVehicle.setParent((Container)this.scene);
        PerspectiveCamera camera = new PerspectiveCamera();
        camera.setPlane(Double.NaN, -this.scale, Double.NaN, this.scale);
        camera.setParent((Container)this.cameraVehicle);
        Background background = new Background();
        background.setColor(BACKGROUND_COLOR);
        this.scene.setBackground(background);
        AmbientLight ambientLight = new AmbientLight();
        ambientLight.setParent((Container)this.scene);
        ambientLight.setColor(AMBIENT_COLOR);
        Transformable sunVehicle = new Transformable();
        sunVehicle.setParent((Container)this.cameraVehicle);
        DirectionalLight sunLight = new DirectionalLight();
        sunLight.setColor(SUN_COLOR);
        sunLight.setParent((Container)sunVehicle);
        sunVehicle.setOrientation((Vector3d)new Vector3(-1.0, -1.0, 1.0), (Vector3d)Vector3.Y_AXIS, (ReferenceFrame)this.scene);
        this.cameraVehicle.setPosition((Vector3d)new Vector3(0.0, 1.0, -10.0), null);
        this.cameraVehicle.pointAt((ReferenceFrame)this.scene, (Vector3d)new Vector3(), (Vector3d)Vector3.Y_AXIS, (ReferenceFrame)this.scene);
        return camera;
    }

    public VisualPickInfo visualPick(Visual visual, int x, int y) {
        PickInfo pickInfo = this.renderTarget.pick(x, y, true, true);
        Visual[] visuals = pickInfo.getVisuals();
        if (visuals != null && visuals.length > 0) {
            int n = 0;
            while (visuals[n] != visual) {
                ++n;
            }
            int[] faces = pickInfo.getSubElements();
            Vector3 localPt = new Vector3((Tuple3d)pickInfo.getLocalPosition(n));
            return new VisualPickInfo(visual, localPt, faces[n]);
        }
        return null;
    }

    public IndexedTriangleArray loadIndexedTriangleArray(String dirname) {
        IndexedTriangleArray ita = new IndexedTriangleArray();
        try {
            FileInputStream is = new FileInputStream(new File(dirname + "/vertices.bin"));
            VertexGeometry.loadVertices((InputStream)is);
            ((InputStream)is).close();
            is = new FileInputStream(new File(dirname + "/indices.bin"));
            IndexedTriangleArray.loadIndices((InputStream)is);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return ita;
    }

    public void loadITA(IndexedTriangleArray ita, String dirname) {
        try {
            FileInputStream is = new FileInputStream(dirname + "/vertices.bin");
            VertexGeometry.loadVertices((InputStream)is);
            ((InputStream)is).close();
            is = new FileInputStream(dirname + "/indices.bin");
            IndexedTriangleArray.loadIndices((InputStream)is);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void idle(RendererEvent renderTargetEvent) {
        this.target.tick();
    }

    public void rendered(RenderTargetEvent renderTargetEvent) {
        RenderTarget renderTarget = (RenderTarget)renderTargetEvent.getSource();
        Graphics g = renderTarget.getOffscreenGraphics();
        this.target.paintOverlay(g);
        g.dispose();
    }

    public JaliceFrame(Squirrel target) {
        this((RendererInfo)new edu.cmu.cs.stage3.alice.scenegraph.renderer.directx7renderer.RendererInfo(), target);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void updated(OnscreenRenderTargetEvent renderTargetEvent) {
    }

    public JaliceFrame(RendererInfo rendererInfo, Squirrel target) {
        super("Squirrel: Spatial Keyframing Demonstration Software");
        this.rendererInfo = rendererInfo;
        this.target = target;
        Squirrel.jaliceFrame = this;
        this.addWindowListener(this);
        this.addComponentListener(this);
        this.setLayout(new BorderLayout());
        ((Component)this).setSize(new Dimension(640, 600));
        this.camera = this.initSceneGraph();
        this.initRenderer(this.camera);
        target.initialize();
        this.show();
    }

    public void repaint() {
        if (this.renderTarget != null) {
            this.renderTarget.markDirty();
        }
    }

    public Vector3 local_coords_to_screen_coords(Vector3 localPt, ReferenceFrame targetVehicle) {
        Vector3 cameraPt = targetVehicle.transformTo((Vector3d)localPt, (ReferenceFrame)this.cameraVehicle);
        return new Vector3((Tuple3d)this.renderTarget.transformFromCameraToViewport((Vector3d)cameraPt, this.camera));
    }

    public Vector3 scene_coords_to_screen_coords(Vector3 localPt) {
        return this.local_coords_to_screen_coords(localPt, (ReferenceFrame)this.scene);
    }

    public Vector3 screen_coords_to_scene_coords(Point p) {
        return this.screen_coords_to_local_coords(p.x, p.y, (ReferenceFrame)this.scene);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public Vector3 screen_coords_to_local_coords(Point p, ReferenceFrame reference) {
        return this.screen_coords_to_local_coords(p.x, p.y, reference);
    }

    public void set_camera_parameters() {
        if (this.camera == null) {
            return;
        }
        if (this.camera instanceof OrthographicCamera) {
            ((OrthographicCamera)this.camera).setPlane(Double.NaN, -this.scale, Double.NaN, this.scale);
        } else {
            ((PerspectiveCamera)this.camera).setPlane(Double.NaN, -this.scale, Double.NaN, this.scale);
        }
    }

    public Vector3 screen_coords_to_local_coords(double x, double y, ReferenceFrame reference) {
        if (reference == null) {
            reference = this.scene;
        }
        Vector3 viewportPt = new Vector3(x, y, 0.97);
        Vector3 cameraPt = new Vector3((Tuple3d)this.renderTarget.transformFromViewportToCamera((Vector3d)viewportPt, this.camera));
        return this.cameraVehicle.transformTo((Vector3d)cameraPt, reference);
    }

    public Vector3 getCameraPosition(ReferenceFrame reference) {
        return this.cameraVehicle.getPosition(reference);
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public Vector3 getCameraDirection(ReferenceFrame reference) {
        Matrix33 axes = this.cameraVehicle.getAxes(reference);
        return axes.getRow(2);
    }
}

