/*
 * Decompiled with CFR 0.152.
 */
package squirrel;

import VisualNumerics.math.DoubleMatrix;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Vector3;
import java.util.Vector;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;

public class InverseKinematics {
    public static double MIN_ERROR = 0.01;

    public static double[][] inverse(double[][] M) {
        double[][] result = null;
        try {
            result = DoubleMatrix.inverse((double[][])M);
        }
        catch (Exception e) {
            System.out.println("" + e);
        }
        return result;
    }

    public static void adjust_main(Vector3 target, Transformable terminal, Transformable base) {
        Vector3 prev_position = terminal.getPosition((ReferenceFrame)base);
        Vector3 diff = Vector3.subtract((Vector3d)target, (Vector3d)prev_position);
        int n = 0;
        Transformable node = terminal;
        do {
            node = (Transformable)node.getParent();
            ++n;
        } while (node != base);
        Matrix44[] T = new Matrix44[n + 1];
        Transformable[] nodes = new Transformable[n + 1];
        node = terminal;
        int i = 0;
        while (i < n) {
            nodes[n - i] = node;
            T[n - i] = node.getTransformation((ReferenceFrame)base);
            node = (Transformable)node.getParent();
            ++i;
        }
        nodes[0] = base;
        Vector3[] ax = new Vector3[n + 1];
        Vector3[] ay = new Vector3[n + 1];
        Vector3[] az = new Vector3[n + 1];
        Vector3[] P = new Vector3[n + 1];
        int i2 = 1;
        while (i2 < n + 1) {
            ax[i2] = new Vector3(T[i2].getItem(0, 0), T[i2].getItem(0, 1), T[i2].getItem(0, 2));
            ay[i2] = new Vector3(T[i2].getItem(1, 0), T[i2].getItem(1, 1), T[i2].getItem(1, 2));
            az[i2] = new Vector3(T[i2].getItem(2, 0), T[i2].getItem(2, 1), T[i2].getItem(2, 2));
            P[i2] = new Vector3(T[i2].getItem(3, 0), T[i2].getItem(3, 1), T[i2].getItem(3, 2));
            ++i2;
        }
        Vector3[] bx = new Vector3[n + 1];
        Vector3[] by = new Vector3[n + 1];
        Vector3[] bz = new Vector3[n + 1];
        int i3 = 1;
        while (i3 < n) {
            bx[i3] = Vector3.crossProduct((Vector3d)ax[i3], (Vector3d)Vector3.subtract((Vector3d)P[n], (Vector3d)P[i3]));
            by[i3] = Vector3.crossProduct((Vector3d)ay[i3], (Vector3d)Vector3.subtract((Vector3d)P[n], (Vector3d)P[i3]));
            bz[i3] = Vector3.crossProduct((Vector3d)az[i3], (Vector3d)Vector3.subtract((Vector3d)P[n], (Vector3d)P[i3]));
            ++i3;
        }
        double[][] J = new double[3][(n - 1) * 3];
        int i4 = 1;
        while (i4 < n) {
            J[0][(i4 - 1) * 3] = bx[i4].getItem(0);
            J[1][(i4 - 1) * 3] = bx[i4].getItem(1);
            J[2][(i4 - 1) * 3] = bx[i4].getItem(2);
            J[0][(i4 - 1) * 3 + 1] = by[i4].getItem(0);
            J[1][(i4 - 1) * 3 + 1] = by[i4].getItem(1);
            J[2][(i4 - 1) * 3 + 1] = by[i4].getItem(2);
            J[0][(i4 - 1) * 3 + 2] = bz[i4].getItem(0);
            J[1][(i4 - 1) * 3 + 2] = bz[i4].getItem(1);
            J[2][(i4 - 1) * 3 + 2] = bz[i4].getItem(2);
            ++i4;
        }
        double[] dX = diff.getArray();
        double[][] Jt = DoubleMatrix.transpose((double[][])J);
        double[][] Ji = DoubleMatrix.multiply((double[][])Jt, (double[][])InverseKinematics.inverse(DoubleMatrix.multiply((double[][])J, (double[][])Jt)));
        double[] theta = DoubleMatrix.multiply((double[][])Ji, (double[])dX);
        int i5 = 1;
        while (i5 < n) {
            nodes[i5].rotate((Vector3d)Vector3.X_AXIS, theta[3 * (i5 - 1)], null);
            nodes[i5].rotate((Vector3d)Vector3.Y_AXIS, theta[3 * (i5 - 1) + 1], null);
            nodes[i5].rotate((Vector3d)Vector3.Z_AXIS, theta[3 * (i5 - 1) + 2], null);
            ++i5;
        }
    }

    public static Vector get_pose(Transformable terminal, Transformable base) {
        Vector<Matrix44> pose = new Vector<Matrix44>();
        Transformable node = terminal;
        do {
            pose.addElement(node.getTransformation(null));
        } while ((node = (Transformable)node.getParent()) != base);
        return pose;
    }

    public static void set_pose(Vector pose, Transformable terminal, Transformable base) {
        Transformable node = terminal;
        int i = 0;
        while (i < pose.size()) {
            node.setTransformation((Matrix4d)((Matrix44)pose.elementAt(i)), null);
            node = (Transformable)node.getParent();
            ++i;
        }
    }

    public static void adjust(Vector3 goal_position, Transformable terminal, Transformable base) {
        Vector3 original_position = terminal.getPosition((ReferenceFrame)base);
        double original_distance = Vector3.subtract((Vector3d)original_position, (Vector3d)goal_position).getLength();
        if (original_distance < MIN_ERROR) {
            return;
        }
        InverseKinematics.adjust_main(goal_position, terminal, base);
        Vector3 new_position = terminal.getPosition((ReferenceFrame)base);
        double d = Vector3.subtract((Vector3d)goal_position, (Vector3d)new_position).getLength();
        if (d < original_distance) {
            InverseKinematics.adjust(goal_position, terminal, base);
        }
    }
}

